/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.syssupport.win32.fileobserver;

import com.highqsoft.fwk.FwkException;
import com.highqsoft.util.FilePollerEvent;
import com.highqsoft.util.FilePollerListenerInterface;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class FileObserver
implements Runnable {
    public static final String LIBRARY_NAME = "FwkFileObserver";
    public static final int FILE_NOTIFY_CHANGE_FILE_NAME = 1;
    public static final int FILE_NOTIFY_CHANGE_DIR_NAME = 2;
    public static final int FILE_NOTIFY_CHANGE_ATTRIBUTES = 4;
    public static final int FILE_NOTIFY_CHANGE_SIZE = 8;
    public static final int FILE_NOTIFY_CHANGE_LAST_WRITE = 16;
    public static final int FILE_NOTIFY_CHANGE_LAST_ACCESS = 32;
    public static final int FILE_NOTIFY_CHANGE_CREATION = 64;
    public static final int FILE_NOTIFY_CHANGE_SECURITY = 256;
    protected static boolean libLoaded;
    protected int nativeContext;
    protected boolean watchSubTree;
    protected int flags;
    protected int timeout;
    protected String[] observables;
    protected Thread thread;
    protected Object arrLock;
    protected Object listenerLock;
    protected EventListenerList listeners;

    public static native int getFilenameFlag();

    public static native int getDirectoryFlag();

    public static native int getAttributeFlag();

    public static native int getSizeFlag();

    public static native int getLastWriteFlag();

    public static native int getLastAccessFlag();

    public static native int getCreationFlag();

    public static native int getSecurityFlag();

    public static native int getMaxCount();

    native boolean initialize();

    public native void release();

    public native String[] startObservation(Thread var1);

    public FileObserver() {
        if (FileObserver.isLibraryLoaded()) {
            this.thread = null;
            this.nativeContext = 0;
            this.watchSubTree = false;
            this.arrLock = new Object();
            this.listenerLock = new Object();
            this.listeners = new EventListenerList();
            this.timeout = 10000;
            if (!this.initialize()) {
                throw new FwkException(-1073676289, "$RCSfile: FileObserver.java,v $", "$Revision: 1.13 $", "AH 2001-09-14 13:54", null, "Unable to initialize object.", null);
            }
            int size = FileObserver.getMaxCount();
            if (size < 1) {
                size = 1024;
            }
        } else {
            throw new FwkException(-1073676289, "$RCSfile: FileObserver.java,v $", "$Revision: 1.13 $", "AH 2001-09-14 13:54", null, "Cannot load library FwkFileObserver.", null);
        }
        this.observables = new String[1024];
    }

    protected void finalize() throws Throwable {
        this.stop();
        this.release();
    }

    public static int getAllFlags() {
        return FileObserver.getFilenameFlag() | FileObserver.getDirectoryFlag() | FileObserver.getAttributeFlag() | FileObserver.getSizeFlag() | FileObserver.getLastWriteFlag() | FileObserver.getLastAccessFlag() | FileObserver.getCreationFlag() | FileObserver.getSecurityFlag();
    }

    public static boolean isLibraryLoaded() {
        return libLoaded;
    }

    public void setWatchSubTree(boolean flag) {
        if (this.watchSubTree != flag) {
            this.watchSubTree = flag;
        }
    }

    public boolean getWatchSubTree() {
        return this.watchSubTree;
    }

    public void setFlags(int flags) {
        if (this.flags != flags) {
            this.flags = flags;
        }
    }

    public int getFlags() {
        return this.flags;
    }

    public void setTimeout(int timeout) {
        if (this.timeout != (timeout = Math.abs(timeout))) {
            this.timeout = timeout;
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(int index, String observable) {
        int ret = -1;
        Object object = this.arrLock;
        synchronized (object) {
            if (index < 0) {
                int size = this.observables.length;
                boolean stop = false;
                for (index = 0; index < size && !stop; ++index) {
                    stop = this.observables[index] == null || this.observables[index].length() == 0;
                }
                --index;
            }
            this.observables[index] = observable.replace('/', '\\');
            ret = index;
        }
        return ret;
    }

    public int add(String observable) {
        return this.add(-1, observable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(int index) {
        Object object = this.arrLock;
        synchronized (object) {
            return this.observables[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String remove(int index) {
        Object object = this.arrLock;
        synchronized (object) {
            String ret = this.get(index);
            if (ret != null && ret.length() != 0) {
                String[] tmp = new String[this.observables.length];
                if (index == 0) {
                    System.arraycopy(this.observables, 1, tmp, 0, this.observables.length - 1);
                } else if (index < this.observables.length - 1) {
                    System.arraycopy(this.observables, 0, tmp, 0, index);
                    System.arraycopy(this.observables, index + 1, tmp, index, this.observables.length - index - 1);
                } else {
                    System.arraycopy(this.observables, 0, tmp, 0, this.observables.length - 1);
                }
                this.observables = tmp;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileObserverListener(FilePollerListenerInterface listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.listeners.add(FilePollerListenerInterface.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileObserverListener(FilePollerListenerInterface listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.listeners.remove(FilePollerListenerInterface.class, listener);
        }
    }

    public int size() {
        return this.observables.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireIndexEvent(int index) {
        Object object = this.listenerLock;
        synchronized (object) {
            EventListener[] l = this.listeners.getListeners(FilePollerListenerInterface.class);
            FireThread fire = new FireThread(l, this.get(index));
            Thread t = new Thread(fire);
            t.start();
        }
    }

    public void run() {
        if (this.thread != null) {
            this.startObservation(this.thread);
        } else {
            this.startObservation(Thread.currentThread());
        }
    }

    public synchronized void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.setPriority(10);
            this.thread.start();
        }
        this.notifyAll();
    }

    public void stop() {
        if (this.thread != null) {
            Thread t = this.thread;
            this.thread = null;
            t.interrupt();
        }
        this.thread = null;
        System.gc();
    }

    public Thread getThread() {
        return this.thread;
    }

    public boolean isStopped() {
        return this.thread == null;
    }

    public static void main(String[] args) {
        if (FileObserver.isLibraryLoaded()) {
            System.out.println("Library FwkFileObserver is loaded. ");
            System.out.println("All flags " + Integer.toString(FileObserver.getAllFlags(), 2));
            System.out.println("maximum number of observables: " + FileObserver.getMaxCount());
        } else {
            System.out.println("Library FwkFileObserver was not loaded.");
        }
        FileObserver observer = new FileObserver();
        observer.setFlags(8);
        observer.add("z:/");
        observer.setWatchSubTree(true);
        observer.add("z:/junk.txt");
        observer.addFileObserverListener(new FilePollerListenerInterface(){

            public void fileChange(FilePollerEvent event) {
                System.out.println(event + " " + event.getType() + " " + event.getPath());
                System.out.println(event);
            }
        });
        observer.start();
    }

    static {
        try {
            System.loadLibrary(LIBRARY_NAME);
            libLoaded = true;
        }
        catch (Throwable t) {
            libLoaded = false;
        }
    }

    public class FireThread
    implements Runnable {
        EventListener[] listeners;
        String path;

        public FireThread(EventListener[] listeners, String path) {
            this.listeners = listeners;
            this.path = path;
        }

        public void run() {
            if (this.listeners != null) {
                int size = this.listeners.length;
                for (int i = 0; i < size; ++i) {
                    FilePollerListenerInterface listener = (FilePollerListenerInterface)this.listeners[i];
                    try {
                        FilePollerEvent ev = new FilePollerEvent(this, FileObserver.this.getFlags(), 0L, this.path);
                        listener.fileChange(ev);
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }
}

