/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkSortedArray;
import com.highqsoft.fwk.FwkThread;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.util.FilePollerEvent;
import com.highqsoft.util.FilePollerListenerInterface;
import java.io.File;
import java.io.FileFilter;
import java.util.Date;

public class FilePoller
extends FwkThread {
    public static final String version = "$Revision: 1.3 $";
    protected FileFilter filter;
    protected File dir;
    protected FwkSortedArray elems;
    protected FwkArray listeners;

    public String getVersion() {
        return version;
    }

    private FilePoller() {
    }

    public FilePoller(String directory, String filter) {
        if (directory == null) {
            directory = ".";
        }
        if (filter == null) {
            filter = "*";
        }
        this.dir = new File(directory);
        this.filter = new FilePollerFilter(this.dir.getAbsolutePath() + "/" + filter);
        this.elems = new FwkSortedArray();
        this.listeners = new FwkArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.dir != null && this.dir.isDirectory()) {
            try {
                while (true) {
                    File[] file_arr = this.dir.listFiles(this.filter);
                    FwkSortedArray v = new FwkSortedArray();
                    FwkSortedArray deleted = new FwkSortedArray();
                    FwkSortedArray fwkSortedArray = this.elems;
                    synchronized (fwkSortedArray) {
                        int i;
                        FilePollerElement fpe;
                        for (int i2 = file_arr.length - 1; i2 >= 0; --i2) {
                            fpe = new FilePollerElement(file_arr[i2]);
                            v.add(fpe);
                            if (this.elems.find(fpe) != -1) continue;
                            deleted.add(fpe);
                        }
                        int size = this.elems.size();
                        for (i = 0; i < size; ++i) {
                            fpe = (FilePollerElement)this.elems.get(i);
                            if (v.find(fpe) != -1) continue;
                            this.fireEvent(0, fpe.modified, fpe.getPath());
                        }
                        size = deleted.size();
                        for (i = 0; i < size; ++i) {
                            fpe = (FilePollerElement)deleted.get(i);
                            this.fireEvent(1, fpe.modified, fpe.getPath());
                        }
                    }
                    this.elems = v;
                    Thread.sleep(1000L);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fireEvent(int type, long modified, String path) {
        FwkArray fwkArray = this.listeners;
        synchronized (fwkArray) {
            if (this.listeners == null || this.listeners.size() == 0) {
                return;
            }
            FilePollerEvent event = new FilePollerEvent(this, type, modified, path);
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                try {
                    ((FilePollerListenerInterface)this.listeners.get(i)).fileChange(event);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addFilePollerListener(FilePollerListenerInterface listener) {
        FwkArray fwkArray = this.listeners;
        synchronized (fwkArray) {
            this.listeners.remove(listener);
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized FwkArrayInterface getFilePollerListeners() {
        FwkArray fwkArray = this.listeners;
        synchronized (fwkArray) {
            FwkArray ret = new FwkArray();
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                ret.add(this.listeners.get(i));
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilePollerListener(FilePollerListenerInterface listener) {
        FwkArray fwkArray = this.listeners;
        synchronized (fwkArray) {
            this.listeners.remove(listener);
        }
    }

    public static void main(String[] args) {
        FilePoller fp = new FilePoller("d:/Puma/Asf/Communication", null);
        fp.addFilePollerListener(new FilePollerListenerInterface(){

            public void fileChange(FilePollerEvent event) {
                System.out.println(event);
            }
        });
        fp.start();
    }

    public class FilePollerElement
    implements Comparable {
        protected long modified;
        protected String path;

        private FilePollerElement() {
        }

        public FilePollerElement(File file) {
            this.modified = file.lastModified();
            this.path = file.getAbsolutePath();
        }

        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }

        public String toString() {
            return "" + new Date(this.modified) + " " + this.path;
        }

        public String getPath() {
            return this.path;
        }

        public long getModified() {
            return this.modified;
        }
    }

    public class FilePollerFilter
    implements FileFilter {
        String path;

        private FilePollerFilter() {
        }

        public FilePollerFilter(File filter) {
            if (filter == null) {
                filter = new File(".", "*");
            }
            this.path = filter.getAbsolutePath();
        }

        public FilePollerFilter(String filter) {
            if (filter == null) {
                filter = "./*";
            }
            this.path = new File(filter).getAbsolutePath();
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return false;
            }
            return Pattern.match(f.getAbsolutePath(), this.path, false);
        }
    }
}

