/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util;

import com.highqsoft.util.FontSelectorDialogBox;
import com.highqsoft.util.FontTracker;
import com.highqsoft.util.PropertyBundle;
import com.highqsoft.util.ResourceComponentFactoryable;
import com.highqsoft.util.plaf.FontSelectorUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontSelector
extends JComponent
implements ListSelectionListener,
ChangeListener,
ItemListener,
AdjustmentListener,
ResourceComponentFactoryable {
    public static final String SELECTEDFONT_PROPERTY = "SelectedFont";
    private static final String uiClassID = "FontSelectorUI";
    private JComboBox family;
    private JComboBox sizes;
    private JCheckBox italic;
    private JCheckBox bold;
    private JComponent preview;
    private static String[] fSizes = new String[]{"8", "9", "10", "11", "12", "13", "14", "16", "18", "20", "24", "28", "32", "36", "48", "72"};
    private String previewString = null;
    private boolean noUpdate = false;
    private String keySuffix = "FontSelector";
    static PropertyBundle resources;
    protected Font initialFont;
    protected Font selectedFont;
    protected static final Font defaultFont;
    protected static final String[] fontList;

    public static Font showDialog(Component component, Font initialFont, PropertyBundle resources, String keySuffix, boolean noBorder) {
        FontSelector pane = new FontSelector(initialFont, resources, keySuffix, noBorder);
        FontTracker ok = new FontTracker(pane);
        JDialog dialog = FontSelector.createDialog(component, resources, true, pane, ok, null);
        dialog.addWindowListener(new FontSelectorDialogBox.Closer());
        dialog.addComponentListener(new FontSelectorDialogBox.DisposeOnClose());
        dialog.setVisible(true);
        return ok.getFont();
    }

    public static JDialog createDialog(Component c, PropertyBundle resources, boolean modal, FontSelector dialogPane, ActionListener okListener, ActionListener cancelListener) {
        return new FontSelectorDialogBox(c, resources, modal, dialogPane, okListener, cancelListener);
    }

    public FontSelector() {
        this(defaultFont, null, null, false);
    }

    public FontSelector(Font font, PropertyBundle resources, String keySuffix, boolean noBorder) {
        if (keySuffix != null) {
            this.keySuffix = keySuffix;
        }
        if (FontSelector.resources == null) {
            try {
                FontSelector.resources = PropertyBundle.getBundle("com.highqsoft.util.FontSelector", this, Locale.getDefault());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.previewString = this.getResource(resources, "Text.Sample_Text");
        this.initialFont = new Font(font.getName(), font.getStyle(), font.getSize());
        this.setSelectedFont(this.initialFont);
        this.setLayout(new GridLayout(2, 1));
        JPanel tp = new JPanel();
        if (!noBorder) {
            tp.setBorder(BorderFactory.createTitledBorder(this.getResource(resources, "Text.Font_Title")));
        }
        tp.setLayout(new FlowLayout(1));
        if (fontList != null) {
            int size;
            int i = size = fontList.length;
            while (--i >= 1) {
                for (int j = 1; j <= i; ++j) {
                    String s1 = fontList[j - 1];
                    String s2 = fontList[j];
                    if (s1.compareTo(s2) <= 0) continue;
                    FontSelector.fontList[j - 1] = s2;
                    FontSelector.fontList[j] = s1;
                }
            }
            int currentIndex = 0;
            String initialFamily = this.initialFont.getFamily();
            this.family = new JComboBox();
            for (int i2 = 0; i2 < size; ++i2) {
                this.family.addItem(fontList[i2]);
                if (fontList[i2].compareTo(initialFamily) != 0) continue;
                currentIndex = i2;
            }
            this.family.getAccessibleContext().setAccessibleName("Fontfamily");
            this.family.getAccessibleContext().setAccessibleDescription("Select the font family");
            this.family.setSelectedIndex(currentIndex);
            this.family.addItemListener(this);
            tp.add(this.family);
            currentIndex = 0;
            String initialFontSize = "" + this.initialFont.getSize();
            this.sizes = new JComboBox();
            this.sizes.setEditable(true);
            size = fSizes.length;
            for (int i3 = 0; i3 < size; ++i3) {
                this.sizes.addItem(fSizes[i3]);
                if (fSizes[i3].compareTo(initialFontSize) != 0) continue;
                currentIndex = i3;
            }
            this.sizes.getAccessibleContext().setAccessibleName("Fontsize");
            this.sizes.getAccessibleContext().setAccessibleDescription("Select the font size");
            this.sizes.setSelectedIndex(currentIndex);
            this.sizes.addItemListener(this);
            tp.add(this.sizes);
            this.bold = new JCheckBox(this.getResource(resources, "Text.Bold"));
            this.bold.setSelected(this.initialFont.isBold());
            this.bold.addChangeListener(this);
            tp.add(this.bold);
            this.italic = new JCheckBox(this.getResource(resources, "Text.Italic"));
            this.italic.setSelected(this.initialFont.isItalic());
            this.italic.addChangeListener(this);
            tp.add(this.italic);
            this.preview = new JComponent(){
                int ascent;

                public void paint(Graphics g) {
                    g.setFont(this.getFont());
                    if (FontSelector.this.previewString == null) {
                        g.drawString(this.getFont().getFontName(), 0, this.ascent);
                    } else {
                        g.drawString(FontSelector.this.previewString, 0, this.ascent);
                    }
                }

                public Dimension getPreferredSize() {
                    Integer maxSize = new Integer(fSizes[fSizes.length - 1]);
                    this.ascent = maxSize * 3 / 4;
                    return new Dimension(maxSize, maxSize);
                }

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.preview.setFont(this.selectedFont);
            JPanel prevP = new JPanel();
            prevP.setBorder(BorderFactory.createTitledBorder(this.getResource(resources, "Text.Sample")));
            prevP.setLayout(new GridLayout(1, 1));
            prevP.add(this.preview);
            this.add(tp);
            this.add(prevP);
        }
    }

    public FontSelectorUI getUI() {
        return (FontSelectorUI)this.ui;
    }

    public void setUI(FontSelectorUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((FontSelectorUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String getLocalKey(String key) {
        int i = key.indexOf(".");
        if (i != -1) {
            return key.substring(i + 1, key.length());
        }
        return key;
    }

    public String getResource(PropertyBundle resources, String key) {
        if (resources == null) {
            if (FontSelector.resources == null) {
                return key;
            }
            return FontSelector.resources.getStringValue(key);
        }
        try {
            return resources.getString(this.keySuffix + '.' + key);
        }
        catch (Throwable t) {
            if (FontSelector.resources != null) {
                return FontSelector.resources.getStringValue(key);
            }
            return this.keySuffix + '.' + key;
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (!this.noUpdate) {
            this.recalc();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.noUpdate) {
            this.recalc();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (!this.noUpdate) {
            this.recalc();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.noUpdate) {
            this.recalc();
        }
    }

    private void recalc() {
        if (this.italic != null) {
            String s;
            int style = 0;
            if (this.italic.isSelected()) {
                style |= 2;
            }
            if (this.bold.isSelected()) {
                style |= 1;
            }
            Integer size = (s = (String)this.sizes.getSelectedItem()).length() == 0 ? new Integer(this.selectedFont.getSize()) : new Integer(s);
            s = (String)this.family.getSelectedItem();
            if (s.length() == 0) {
                s = this.selectedFont.getFamily();
            }
            this.setSelectedFont(new Font(s, style, size));
            this.preview.setFont(this.getSelectedFont());
            this.preview.repaint();
        }
    }

    public String toString() {
        return this.selectedFont.toString();
    }

    public Font getSelectedFont() {
        return new Font(this.selectedFont.getName(), this.selectedFont.getStyle(), this.selectedFont.getSize());
    }

    public void setSelectedFont(Font font) {
        this.setSelectedFont(font.getName(), font.getStyle(), font.getSize());
    }

    public void setSelectedFont(String n, int sy, int sz) {
        if (this.italic != null) {
            this.noUpdate = true;
            this.italic.setSelected((sy & 2) != 0);
            this.bold.setSelected((sy & 1) != 0);
            this.family.setSelectedItem(n);
            this.sizes.setSelectedItem("" + sz);
            this.noUpdate = false;
        }
        Font oldFont = this.selectedFont;
        this.selectedFont = new Font(n, sy, sz);
        this.firePropertyChange(SELECTEDFONT_PROPERTY, oldFont, this.selectedFont);
        if (this.preview != null) {
            this.preview.setFont(this.getSelectedFont());
            this.preview.repaint();
        }
    }

    public void setInitialFont(Font font) {
        this.initialFont = new Font(font.getName(), font.getStyle(), font.getSize());
    }

    public void setInitialFont(String n, int sy, int sz) {
        this.setInitialFont(new Font(n, sy, sz));
    }

    public Font getInitialFont() {
        return new Font(this.initialFont.getName(), this.initialFont.getStyle(), this.initialFont.getSize());
    }

    public void setPreviewString(String s) {
        this.previewString = s;
    }

    public void addMenuItem(String itemKey, JMenuItem menuItem) {
    }

    public Action getAction(String cmdKey) {
        return null;
    }

    public PropertyChangeListener createActionChangeListener(JMenuItem menuItem) {
        return null;
    }

    static {
        fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(Locale.getDefault());
        defaultFont = new Font(fontList[0], 1, 12);
    }
}

