/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util;

import com.highqsoft.fwk.FwkApplication;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkFrame;
import com.highqsoft.fwk.FwkPanel;
import com.highqsoft.fwk.command.FwkExitCommand;
import com.highqsoft.fwk.factory.FwkDescriptionFactory;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkPanelInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class GarbageCollector
extends FwkApplication {
    public static final String version = "$Revision: 1.4 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    JTextArea jTextArea = null;
    protected int timeInterval;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return FwkDescriptionFactory.getDescriptor(GarbageCollector.class, descriptor);
    }

    public GarbageCollector() {
        this.setDescriptor(GarbageCollector.getDescriptor());
        this.setEternal(true);
        this.setTimeInterval(1000);
        this.register();
    }

    public void run() {
        long time = System.currentTimeMillis();
        boolean stop = false;
        while (!stop) {
            try {
                if (this.jTextArea != null) {
                    time = System.currentTimeMillis();
                    this.jTextArea.append("Starting garbage collection at " + new Date() + " ... ");
                    this.jTextArea.revalidate();
                }
                System.gc();
                if (this.jTextArea != null) {
                    this.jTextArea.append("done (needed time " + (System.currentTimeMillis() - time) + ").\n");
                    this.jTextArea.repaint();
                }
                Thread.sleep(this.getTimeInterval());
            }
            catch (Throwable t) {
                stop = true;
            }
        }
    }

    public FwkCommandInterface[] getCommands() {
        if (!this.commandsAvailable()) {
            super.getCommands(this);
            FwkCommand parent = new FwkCommand(this);
            parent.setTextKey("Quasar.Text.File");
            parent.setCommandName("File");
            this.addCommand(0, parent);
            FwkExitCommand cmd1 = new FwkExitCommand(this);
            parent.addCommand(cmd1);
        }
        return super.getCommands();
    }

    public synchronized void setTimeInterval(int interval) {
        if (this.timeInterval != interval) {
            int old = this.timeInterval;
            this.fireVetoableChange("TimeInterface", old, interval);
            this.timeInterval = interval;
            this.firePropertyChange("TimeInterface", old, interval);
        }
    }

    public int getTimeInterval() {
        return this.timeInterval;
    }

    public FwkPanelInterface getPanel() {
        if (this.panel == null) {
            this.panel = new FwkPanel();
            ((JPanel)((Object)this.panel)).setPreferredSize(new Dimension(800, 100));
            ((JPanel)((Object)this.panel)).setLayout(new BorderLayout());
            this.jTextArea = new JTextArea(20, 10);
            this.jTextArea.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(this.jTextArea);
            ((JPanel)((Object)this.panel)).add((Component)jScrollPane, "Center");
        }
        return this.panel;
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        FwkFrame fwkFrame = new FwkFrame(descriptor.getName());
        fwkFrame.start();
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("The periodic garbage collector");
        descriptor.setTitleName("GarbageCollector.Text.Title");
        descriptor.setName(GarbageCollector.class.getName());
        descriptor.setIconKey("Icon.GarbageCollector");
        descriptor.setCreationDate("$Date: 2007/06/12 09:10:15 $", null);
    }
}

