/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util;

import com.highqsoft.util.LineStyleSelectorDialogBox;
import com.highqsoft.util.LineStyleTracker;
import com.highqsoft.util.PenStroke;
import com.highqsoft.util.PropertyBundle;
import com.highqsoft.util.ResourceComponentFactoryable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LineStyleSelector
extends JComponent
implements ListSelectionListener,
ChangeListener,
ItemListener,
AdjustmentListener,
ResourceComponentFactoryable {
    public static final String SELECTEDLINESTYLE_PROPERTY = "SelectedLineStyle";
    private static final int offImageWidth = 100;
    private static final int offImageHeight = 20;
    private static final int maximumRowCount = 6;
    private static final int sliderMin = 1;
    private static final int sliderMax = 3;
    private static final float widthFactor = 1.0f;
    protected static final int maxLineStyle = 6;
    protected static final Vector basicLineStyle = new Vector(6);
    private String keySuffix = "LineStyleSelector";
    private PenStroke initialStroke;
    private PenStroke selectedStroke;
    private int initialIndex = -1;
    private Vector penStrokes;
    private JComboBox styles;
    private JSlider lineWidth;
    private JComponent preview;
    LineStyleComboBoxModel lscbm;
    static PropertyBundle resources;

    public static PenStroke showDialog(Component component, PenStroke initialStyle, Vector penStrokes, PropertyBundle resources, String propertySuffix, boolean noBorder) {
        LineStyleSelector pane = new LineStyleSelector(initialStyle, penStrokes, resources, propertySuffix, noBorder);
        LineStyleTracker ok = new LineStyleTracker(pane);
        JDialog dialog = LineStyleSelector.createDialog(component, resources, true, pane, ok, null);
        dialog.addWindowListener(new LineStyleSelectorDialogBox.Closer());
        dialog.addComponentListener(new LineStyleSelectorDialogBox.DisposeOnClose());
        dialog.setVisible(true);
        return ok.getStroke();
    }

    public static JDialog createDialog(Component c, PropertyBundle resources, boolean modal, LineStyleSelector dialogPane, ActionListener okListener, ActionListener cancelListener) {
        return new LineStyleSelectorDialogBox(c, resources, modal, dialogPane, okListener, cancelListener);
    }

    public static int getMaxStrokeIndex() {
        return basicLineStyle.size() - 1;
    }

    public static int getStrokeIndex(PenStroke initialStroke) {
        int initialIndex = -1;
        int size = basicLineStyle.size();
        for (int i = size - 1; i > 0 && initialIndex == -1; --i) {
            if (!((PenStroke)basicLineStyle.elementAt(i)).equals(initialStroke)) continue;
            initialIndex = i;
        }
        if (initialIndex == -1) {
            initialIndex = 0;
        }
        return initialIndex;
    }

    public static PenStroke getStrokeAt(int index) {
        if (index < 0) {
            return null;
        }
        int idx = index % basicLineStyle.size();
        return (PenStroke)((PenStroke)basicLineStyle.elementAt(idx)).clone();
    }

    public static Vector getLineStyleVector() {
        Vector<Object> ret = new Vector<Object>(6);
        for (int i = 0; i < 6; ++i) {
            PenStroke initial = (PenStroke)basicLineStyle.elementAt(i);
            ret.add(initial.clone());
        }
        return ret;
    }

    public LineStyleSelector() {
        this(null, null, null, null, false);
    }

    public LineStyleSelector(PenStroke initial, Vector pStrokes, PropertyBundle resources, String keySuffix, boolean noBorder) {
        if (keySuffix != null) {
            this.keySuffix = keySuffix;
        }
        if (LineStyleSelector.resources == null) {
            try {
                LineStyleSelector.resources = PropertyBundle.getBundle("com.highqsoft.util.LineStyleSelector", this, Locale.getDefault());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (initial != null) {
            this.initialStroke = initial;
            this.selectedStroke = (PenStroke)initial.clone();
        } else {
            this.initialStroke = null;
            this.selectedStroke = new PenStroke();
        }
        this.penStrokes = pStrokes != null ? pStrokes : LineStyleSelector.getLineStyleVector();
        this.setLayout(new GridLayout(2, 1));
        if (!noBorder) {
            this.setBorder(BorderFactory.createTitledBorder(this.getResource(resources, "Text.Linestyle_Title")));
        }
        JPanel settings = new JPanel();
        settings.setLayout(new GridLayout(1, 2));
        this.add(settings);
        JPanel tp = new JPanel();
        tp.setBorder(BorderFactory.createTitledBorder(this.getResource(resources, "Text.Linetype_Title")));
        tp.setLayout(new FlowLayout(1));
        if (this.penStrokes != null) {
            this.lscbm = new LineStyleComboBoxModel(this.penStrokes.size());
            this.styles = new JComboBox(this.lscbm);
            this.styles.setRenderer(new LineStyleCellRenderer(this.styles));
            int size = this.penStrokes.size();
            for (int i = size - 1; i > 0 && this.initialIndex == -1; --i) {
                PenStroke elm = (PenStroke)this.penStrokes.elementAt(i);
                if (!elm.getDashArray().equals(this.initialStroke.getDashArray())) continue;
                this.initialIndex = i;
            }
            if (this.initialIndex == -1) {
                this.initialIndex = 0;
            }
            this.styles.setMaximumRowCount(6);
            this.styles.getAccessibleContext().setAccessibleName("LineStyle ComboBox");
            this.styles.getAccessibleContext().setAccessibleDescription("ComboBox to select the linestyle");
            this.styles.addItemListener(this);
            tp.add(this.styles);
            settings.add(tp);
            tp = new JPanel();
            tp.setLayout(new BoxLayout(tp, 1));
            tp.setBorder(new TitledBorder(this.getResource(resources, "Text.LineWidth")));
            this.lineWidth = new JSlider(1, 3, 1);
            this.lineWidth.putClientProperty("JSlider.isFilled", Boolean.TRUE);
            this.lineWidth.setPaintTicks(true);
            this.lineWidth.setMajorTickSpacing(1);
            this.lineWidth.setPaintLabels(true);
            this.lineWidth.setSnapToTicks(true);
            this.lineWidth.setValue(Math.round(this.selectedStroke.getLineWidth()));
            this.lineWidth.getAccessibleContext().setAccessibleName("LineStyle Slider");
            this.lineWidth.getAccessibleContext().setAccessibleDescription("A slider to set the line width of a stroke.");
            this.lineWidth.addChangeListener(new LineStyleWidthListener(null));
            tp.add(Box.createRigidArea(new Dimension(1, 5)));
            tp.add(this.lineWidth);
            tp.add(Box.createRigidArea(new Dimension(1, 5)));
            settings.add(tp);
            this.preview = new JComponent(){

                public void paint(Graphics gr) {
                    Dimension d = this.getSize();
                    Graphics2D g = (Graphics2D)gr.create();
                    Line2D.Float lin = new Line2D.Float((float)d.width * 0.1f, (float)d.height * 0.5f, (float)d.width * 0.9f, (float)d.height * 0.5f);
                    g.setStroke(LineStyleSelector.this.selectedStroke);
                    g.draw(lin);
                    g.dispose();
                }
            };
            this.preview.setSize(settings.getSize());
            JPanel prevP = new JPanel();
            prevP.setBorder(BorderFactory.createTitledBorder(this.getResource(resources, "Text.Sample")));
            prevP.setLayout(new GridLayout(1, 1));
            prevP.add(this.preview);
            this.add(prevP);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.penStrokes != null) {
            this.lscbm.createImages(this.penStrokes);
        }
        if (this.initialIndex != -1) {
            this.styles.setSelectedIndex(this.initialIndex);
        }
    }

    public void resetLineStyle() {
        if (this.initialIndex != -1) {
            this.styles.setSelectedIndex(this.initialIndex);
        }
        if (this.lineWidth != null) {
            this.lineWidth.setValue(Math.round(this.selectedStroke.getLineWidth()));
        }
        this.recalc();
    }

    public String getResource(PropertyBundle resources, String key) {
        if (resources == null) {
            if (LineStyleSelector.resources == null) {
                return key;
            }
            return LineStyleSelector.resources.getStringValue(key);
        }
        try {
            return resources.getString(this.keySuffix + '.' + key);
        }
        catch (Throwable t) {
            if (LineStyleSelector.resources != null) {
                return LineStyleSelector.resources.getStringValue(key);
            }
            return this.keySuffix + '.' + key;
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.recalc();
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.recalc();
    }

    public void itemStateChanged(ItemEvent e) {
        JComboBox cb = (JComboBox)e.getSource();
        PenStroke ps = (PenStroke)this.penStrokes.elementAt(cb.getSelectedIndex());
        this.setSelectedStroke(new PenStroke(this.selectedStroke.getLineWidth(), this.selectedStroke.getEndCap(), this.selectedStroke.getLineJoin(), this.selectedStroke.getMiterLimit(), ps.getDashArray(), this.selectedStroke.getDashPhase()));
        this.recalc();
    }

    public void valueChanged(ListSelectionEvent e) {
        this.recalc();
    }

    private void recalc() {
        this.preview.repaint();
    }

    public String toString() {
        return this.selectedStroke.toString();
    }

    public PenStroke getSelectedStroke() {
        return (PenStroke)this.selectedStroke.clone();
    }

    public void setSelectedStroke(PenStroke sel) {
        PenStroke oldStroke = this.selectedStroke;
        this.selectedStroke = (PenStroke)sel.clone();
        this.firePropertyChange(SELECTEDLINESTYLE_PROPERTY, oldStroke, this.selectedStroke);
    }

    public PenStroke getInitialStroke() {
        return new PenStroke(this.initialStroke.getLineWidth(), this.initialStroke.getEndCap(), this.initialStroke.getLineJoin(), this.initialStroke.getMiterLimit(), this.initialStroke.getDashArray(), this.initialStroke.getDashPhase());
    }

    public void addMenuItem(String itemKey, JMenuItem menuItem) {
    }

    public Action getAction(String cmdKey) {
        return null;
    }

    public PropertyChangeListener createActionChangeListener(JMenuItem menuItem) {
        return null;
    }

    static {
        basicLineStyle.add(0, new PenStroke());
        float[] dash = new float[]{1.0f, 3.0f};
        PenStroke ps = new PenStroke();
        ps.setDashArray(dash);
        basicLineStyle.add(1, ps);
        dash = new float[]{1.0f, 3.0f, 7.0f, 3.0f};
        ps = new PenStroke();
        ps.setDashArray(dash);
        basicLineStyle.add(2, ps);
        dash = new float[]{1.0f, 3.0f, 1.0f, 3.0f, 7.0f, 3.0f};
        ps = new PenStroke();
        ps.setDashArray(dash);
        basicLineStyle.add(3, ps);
        dash = new float[]{7.0f, 5.0f, 7.0f, 5.0f};
        ps = new PenStroke();
        ps.setDashArray(dash);
        basicLineStyle.add(4, ps);
        dash = new float[]{7.0f, 2.0f, 7.0f, 2.0f};
        ps = new PenStroke();
        ps.setDashArray(dash);
        basicLineStyle.add(5, ps);
    }

    class LineStyleCellRenderer
    extends JLabel
    implements ListCellRenderer {
        JComboBox combobox;

        public LineStyleCellRenderer(JComboBox x) {
            this.combobox = x;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Hashtable h = (Hashtable)value;
            if (UIManager.getLookAndFeel().getName().equals("CDE/Motif")) {
                if (index == -1) {
                    this.setOpaque(false);
                } else {
                    this.setOpaque(true);
                }
            } else {
                this.setOpaque(true);
            }
            if (value == null) {
                this.setText("");
                this.setIcon(null);
            } else if (isSelected) {
                this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                this.setIcon((ImageIcon)h.get("selectedImage"));
            } else {
                this.setIcon((ImageIcon)h.get("image"));
                this.setBackground(UIManager.getColor("ComboBox.background"));
                this.setForeground(UIManager.getColor("ComboBox.foreground"));
            }
            return this;
        }
    }

    class LineStyleComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Object currentValue;
        ImageIcon[] images;
        ImageIcon[] images_down;
        Hashtable[] cache;
        int size;

        public LineStyleComboBoxModel(int size) {
            this.size = size;
            this.images = new ImageIcon[size];
            this.images_down = new ImageIcon[size];
            this.cache = new Hashtable[size];
        }

        private void createImages(Vector penStrokes) {
            for (int i = 0; i < this.size; ++i) {
                Image img = LineStyleSelector.this.createImage(100, 20);
                this.images[i] = new ImageIcon(img);
                Graphics2D g = (Graphics2D)this.images[i].getImage().getGraphics();
                g.setColor(UIManager.getColor("ComboBox.background"));
                g.fillRect(0, 0, 99, 19);
                g.setColor(UIManager.getColor("ComboBox.foreground"));
                g.setColor(Color.black);
                g.setStroke((Stroke)penStrokes.elementAt(i));
                g.drawLine(10, 10, 90, 10);
                img = LineStyleSelector.this.createImage(100, 20);
                this.images_down[i] = new ImageIcon(img);
                g = (Graphics2D)this.images_down[i].getImage().getGraphics();
                g.setColor(UIManager.getColor("ComboBox.selectionBackground"));
                g.fillRect(0, 0, 99, 19);
                g.setColor(Color.black);
                g.setStroke((Stroke)penStrokes.elementAt(i));
                g.drawLine(10, 10, 90, 10);
            }
        }

        public void setSelectedItem(Object anObject) {
            this.currentValue = anObject;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.currentValue;
        }

        public int getSize() {
            return this.size;
        }

        public Object getElementAt(int index) {
            Hashtable<String, ImageIcon> result;
            if (this.cache[index] != null) {
                return this.cache[index];
            }
            int idx = index % this.size;
            if (LineStyleSelector.this.isDisplayable()) {
                result = new Hashtable<String, ImageIcon>();
                if (this.images[idx] == null) {
                    result = null;
                } else {
                    result.put("image", this.images[idx]);
                    result.put("selectedImage", this.images_down[idx]);
                }
            } else {
                result = null;
            }
            this.cache[index] = result;
            return result;
        }
    }

    class LineStyleWidthListener
    implements ChangeListener {
        JLabel tf;

        public LineStyleWidthListener(JLabel f) {
            this.tf = f;
        }

        public void stateChanged(ChangeEvent e) {
            JSlider s1 = (JSlider)e.getSource();
            LineStyleSelector.this.setSelectedStroke(new PenStroke((float)s1.getValue() * 1.0f, LineStyleSelector.this.selectedStroke.getEndCap(), LineStyleSelector.this.selectedStroke.getLineJoin(), LineStyleSelector.this.selectedStroke.getMiterLimit(), LineStyleSelector.this.selectedStroke.getDashArray(), LineStyleSelector.this.selectedStroke.getDashPhase()));
            LineStyleSelector.this.recalc();
            if (this.tf != null) {
                this.tf.setText("Slider Value: " + s1.getValue());
            }
        }
    }
}

