/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util;

import com.highqsoft.util.PropManager;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

class MessageBoxDialog
extends JDialog {
    private MessageBoxDialog() {
    }

    public MessageBoxDialog(Component owner, String mes, String type) {
        super(JOptionPane.getFrameForComponent(owner), true);
        if (mes == null) {
            mes = "";
        }
        this.setTitle(PropManager.getString("MessageBox." + type + ".Title"));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JTextArea textArea = new JTextArea(mes, mes.length() / 40 + 1, 20);
        textArea.setEditable(false);
        textArea.setBackground(this.getBackground());
        MsgCanvas canvas = new MsgCanvas(type);
        JButton ok = new JButton(PropManager.getString("MessageBox.Text.OK"));
        ok.addActionListener(new CancelAction());
        this.getContentPane().setLayout(gbl);
        gbc.weightx = 0.0;
        gbc.fill = 2;
        gbc.ipadx = 10;
        gbc.ipady = 10;
        this.addComponent(canvas, gbl, gbc);
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.ipadx = 10;
        gbc.ipady = 10;
        this.addComponent(textArea, gbl, gbc);
        gbc.weightx = 0.0;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.fill = 0;
        this.addComponent(ok, gbl, gbc);
        this.pack();
        Frame f = JOptionPane.getFrameForComponent(this);
        f.setIconImage(canvas.getImage());
    }

    private void addComponent(Component comp, GridBagLayout gbl, GridBagConstraints gbc) {
        gbl.setConstraints(comp, gbc);
        this.getContentPane().add(comp);
    }

    static class DisposeOnClose
    extends ComponentAdapter
    implements Serializable {
        DisposeOnClose() {
        }

        public void componentHidden(ComponentEvent e) {
            Window w = (Window)e.getComponent();
            w.dispose();
        }
    }

    static class Closer
    extends WindowAdapter
    implements Serializable {
        Closer() {
        }

        public void windowClosing(WindowEvent e) {
            Window w = e.getWindow();
            w.setVisible(false);
        }
    }

    private class MsgCanvas
    extends Canvas {
        ImageIcon imgIcon;

        public MsgCanvas(String type) {
            this.imgIcon = new ImageIcon(PropManager.getString("MessageBox." + type + ".Image"));
            this.setBounds(new Rectangle(0, 0, this.imgIcon.getIconWidth(), this.imgIcon.getIconHeight()));
        }

        public void paint(Graphics g) {
            g.drawImage(this.imgIcon.getImage(), 0, 0, this);
        }

        public Image getImage() {
            return this.imgIcon.getImage();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        public void actionPerformed(ActionEvent e) {
            MessageBoxDialog.this.setVisible(false);
        }
    }
}

