/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util;

import com.highqsoft.util.PropDefaults;
import java.util.Enumeration;

class MultiPropDefaults
extends PropDefaults {
    private PropDefaults[] tables;

    public MultiPropDefaults(PropDefaults[] defaults) {
        this.tables = defaults;
    }

    public MultiPropDefaults() {
        this.tables = new PropDefaults[0];
    }

    public Object get(Object key) {
        Object value;
        if (key instanceof String && (value = System.getProperty((String)key)) != null) {
            return value;
        }
        value = super.get(key);
        if (value != null) {
            return value;
        }
        for (int i = 0; i < this.tables.length; ++i) {
            PropDefaults table = this.tables[i];
            Object object = value = table != null ? table.get(key) : null;
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public int size() {
        int n = super.size();
        for (int i = 0; i < this.tables.length; ++i) {
            PropDefaults table = this.tables[i];
            n += table != null ? table.size() : 0;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Enumeration keys() {
        Enumeration[] enums = new Enumeration[1 + this.tables.length];
        enums[0] = super.keys();
        for (int i = 0; i < this.tables.length; ++i) {
            PropDefaults table = this.tables[i];
            if (table == null) continue;
            enums[i + 1] = table.keys();
        }
        return new MultiPropDefaultsEnumerator(enums);
    }

    public Enumeration elements() {
        Enumeration[] enums = new Enumeration[1 + this.tables.length];
        enums[0] = super.elements();
        for (int i = 0; i < this.tables.length; ++i) {
            PropDefaults table = this.tables[i];
            if (table == null) continue;
            enums[i + 1] = table.elements();
        }
        return new MultiPropDefaultsEnumerator(enums);
    }

    public Object remove(Object key) {
        Object value = super.remove(key);
        if (value != null) {
            return value;
        }
        for (int i = 0; i < this.tables.length; ++i) {
            PropDefaults table = this.tables[i];
            Object object = value = table != null ? table.remove(key) : null;
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public void clear() {
        super.clear();
        for (int i = 0; i < this.tables.length; ++i) {
            PropDefaults table = this.tables[i];
            if (table == null) continue;
            table.clear();
        }
    }

    private static class MultiPropDefaultsEnumerator
    implements Enumeration {
        Enumeration[] enums;
        int n = 0;

        MultiPropDefaultsEnumerator(Enumeration[] enums) {
            this.enums = enums;
        }

        public boolean hasMoreElements() {
            for (int i = this.n; i < this.enums.length; ++i) {
                Enumeration e = this.enums[i];
                if (e == null || !e.hasMoreElements()) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            while (this.n < this.enums.length) {
                Enumeration e = this.enums[this.n];
                if (e != null && e.hasMoreElements()) {
                    return e.nextElement();
                }
                ++this.n;
            }
            return null;
        }
    }
}

