/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util;

import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Parse {
    private Parse() {
    }

    public static int intString(String s) {
        String str = s.trim().toUpperCase();
        boolean signed = str.startsWith("-");
        if (signed) {
            str = str.substring(1);
        }
        try {
            if (str.startsWith("0X")) {
                return Integer.parseInt((signed ? "-" : "") + str.substring(2), 16);
            }
            if (str.startsWith("$")) {
                return Integer.parseInt((signed ? "-" : "") + str.substring(1), 16);
            }
            if (str.startsWith("#")) {
                return Integer.parseInt((signed ? "-" : "") + str.substring(1), 2);
            }
            if (str.startsWith("\\u")) {
                return Integer.parseInt((signed ? "-" : "") + str.substring(2), 8);
            }
            if (str.startsWith("\\")) {
                return Integer.parseInt((signed ? "-" : "") + str.substring(2), 8);
            }
            return Integer.parseInt((signed ? "-" : "") + str);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static long longString(String s) {
        String str = s.trim().toUpperCase();
        boolean signed = str.startsWith("-");
        if (signed) {
            str = str.substring(1);
        }
        try {
            if (str.startsWith("0X")) {
                return Long.parseLong((signed ? "-" : "") + str.substring(2), 16);
            }
            if (str.startsWith("$")) {
                return Long.parseLong((signed ? "-" : "") + str.substring(1), 16);
            }
            if (str.startsWith("#")) {
                return Long.parseLong((signed ? "-" : "") + str.substring(1), 2);
            }
            if (str.startsWith("\\u")) {
                return Long.parseLong((signed ? "-" : "") + str.substring(2), 8);
            }
            if (str.startsWith("\\")) {
                return Long.parseLong((signed ? "-" : "") + str.substring(2), 8);
            }
            return Long.parseLong((signed ? "-" : "") + str);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static Font fontString(String s) {
        Hashtable<String, String> ht = new Hashtable<String, String>(3);
        StringTokenizer ts = new StringTokenizer(s, "[]");
        if (ts.hasMoreTokens()) {
            if (ts.nextToken().toUpperCase().indexOf("FONT") == -1) {
                return null;
            }
        } else {
            return null;
        }
        if (ts.hasMoreTokens()) {
            ts = new StringTokenizer(ts.nextToken(), "=,");
            while (ts.hasMoreTokens()) {
                String key = ts.nextToken().toUpperCase();
                if (!ts.hasMoreTokens()) continue;
                ht.put(key.trim(), ts.nextToken().trim());
            }
        } else {
            return null;
        }
        String name = (String)ht.get("NAME");
        String size = (String)ht.get("SIZE");
        String style = (String)ht.get("STYLE");
        if (name == null || size == null || style == null) {
            return null;
        }
        int fontSize = Parse.intString(size);
        if (fontSize == 0) {
            return null;
        }
        int fontStyle = 0;
        if ((style = style.toUpperCase()).indexOf("BOLD") != -1) {
            fontStyle |= 1;
        }
        if (style.indexOf("ITALIC") != -1) {
            fontStyle |= 2;
        }
        return new Font(name, fontStyle, fontSize);
    }

    public static Color colorString(String s) {
        Hashtable<String, String> ht = new Hashtable<String, String>(3);
        StringTokenizer ts = new StringTokenizer(s, "[]");
        if (ts.hasMoreTokens()) {
            if (ts.nextToken().toUpperCase().indexOf("COLOR") == -1) {
                return null;
            }
        } else {
            return null;
        }
        if (ts.hasMoreTokens()) {
            ts = new StringTokenizer(ts.nextToken(), "=,");
            while (ts.hasMoreTokens()) {
                String key = ts.nextToken().toUpperCase();
                if (!ts.hasMoreTokens()) continue;
                ht.put(key.trim(), ts.nextToken().trim());
            }
        } else {
            return null;
        }
        String r = (String)ht.get("R");
        String g = (String)ht.get("G");
        String b = (String)ht.get("B");
        if (r == null || g == null || b == null) {
            return null;
        }
        return new Color(Parse.intString(r), Parse.intString(g), Parse.intString(b));
    }
}

