/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util;

import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import sun.dc.path.FastPathProducer;
import sun.dc.path.PathConsumer;
import sun.dc.path.PathException;
import sun.dc.pr.PathDasher;
import sun.dc.pr.PathStroker;

public class PenStroke
implements Stroke {
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    float width;
    int join;
    int cap;
    float miterlimit;
    float[] dash;
    float dash_phase;
    private static final int[] RasterizerCaps = new int[]{30, 10, 20};
    private static final int[] RasterizerCorners = new int[]{50, 10, 40};

    public PenStroke(float width, int cap, int join, float miterlimit, float[] dash, float dash_phase) {
        if (width < 0.0f) {
            throw new IllegalArgumentException("negative width");
        }
        if (cap != 0 && cap != 1 && cap != 2) {
            throw new IllegalArgumentException("illegal end cap value");
        }
        if (join == 0) {
            if (miterlimit < 0.0f) {
                throw new IllegalArgumentException("negative miter limit");
            }
        } else if (join != 1 && join != 2) {
            throw new IllegalArgumentException("illegal line join value");
        }
        if (dash != null) {
            if (dash_phase < 0.0f) {
                throw new IllegalArgumentException("negative dash phase");
            }
            boolean allzero = true;
            for (int i = 0; i < dash.length; ++i) {
                float d = dash[i];
                if ((double)d > 0.0) {
                    allzero = false;
                    continue;
                }
                if (!((double)d < 0.0)) continue;
                throw new IllegalArgumentException("negative dash length");
            }
            if (allzero) {
                throw new IllegalArgumentException("dash lengths all zero");
            }
        }
        this.width = width;
        this.cap = cap;
        this.join = join;
        this.miterlimit = miterlimit;
        this.dash = dash;
        this.dash_phase = dash_phase;
    }

    public PenStroke(float width, int cap, int join, float miterlimit) {
        this(width, cap, join, miterlimit, null, 0.0f);
    }

    public PenStroke(float width, int cap, int join) {
        this(width, cap, join, 10.0f, null, 0.0f);
    }

    public PenStroke(float width) {
        this(width, 2, 0, 10.0f, null, 0.0f);
    }

    public PenStroke() {
        this(1.0f, 2, 0, 10.0f, null, 0.0f);
    }

    public Object clone() {
        return new PenStroke(this.width, this.cap, this.join, this.miterlimit, this.dash, this.dash_phase);
    }

    private String getParamStr() {
        return "LineWidth: " + this.width + ", " + "EndCap: " + this.cap + ", " + "LineJoin: " + this.join + ", " + "MiterLimit: " + this.miterlimit + ", " + "DashPhase: " + this.dash_phase;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.getParamStr() + "]";
    }

    public Shape createStrokedShape(Shape s) {
        PathStroker consumer;
        FillAdapter filler = new FillAdapter();
        PathStroker stroker = new PathStroker((PathConsumer)filler);
        stroker.setPenDiameter(this.width);
        stroker.setPenT4(null);
        stroker.setCaps(RasterizerCaps[this.cap]);
        stroker.setCorners(RasterizerCorners[this.join], this.miterlimit);
        if (this.dash != null) {
            PathDasher dasher = new PathDasher((PathConsumer)stroker);
            dasher.setDash(this.dash, this.dash_phase);
            dasher.setDashT4(null);
            consumer = dasher;
        } else {
            consumer = stroker;
        }
        PathIterator pi = s.getPathIterator(null);
        try {
            consumer.beginPath();
            boolean pathClosed = false;
            float mx = 0.0f;
            float my = 0.0f;
            float[] point = new float[6];
            while (!pi.isDone()) {
                int type = pi.currentSegment(point);
                if (pathClosed) {
                    pathClosed = false;
                    if (type != 0) {
                        consumer.beginSubpath(mx, my);
                    }
                }
                switch (type) {
                    case 0: {
                        mx = point[0];
                        my = point[1];
                        consumer.beginSubpath(point[0], point[1]);
                        break;
                    }
                    case 1: {
                        consumer.appendLine(point[0], point[1]);
                        break;
                    }
                    case 2: {
                        consumer.appendQuadratic(point[0], point[1], point[2], point[3]);
                        break;
                    }
                    case 3: {
                        consumer.appendCubic(point[0], point[1], point[2], point[3], point[4], point[5]);
                        break;
                    }
                    case 4: {
                        consumer.closedSubpath();
                        pathClosed = true;
                    }
                }
                pi.next();
            }
            consumer.endPath();
        }
        catch (PathException e) {
            throw new InternalError("Unable to Stroke shape (" + e.getMessage() + ")");
        }
        return filler.getShape();
    }

    public float getLineWidth() {
        return this.width;
    }

    public void setLineWidth(float width) {
        if (width < 0.0f) {
            throw new IllegalArgumentException("negative width");
        }
        this.width = width;
    }

    public int getEndCap() {
        return this.cap;
    }

    public void setEndCap(int cap) {
        if (cap != 0 && cap != 1 && cap != 2) {
            throw new IllegalArgumentException("illegal end cap value");
        }
        this.cap = cap;
    }

    public int getLineJoin() {
        return this.join;
    }

    public void setLineJoin(int join) {
        if (join == 0) {
            if (this.miterlimit < 0.0f) {
                throw new IllegalArgumentException("negative miter limit");
            }
        } else if (join != 1 && join != 2) {
            throw new IllegalArgumentException("illegal line join value");
        }
        this.join = join;
    }

    public float getMiterLimit() {
        return this.miterlimit;
    }

    public void setMiterLimit(float miterlimit) {
        this.miterlimit = miterlimit;
    }

    public float[] getDashArray() {
        if (this.dash == null) {
            return null;
        }
        float[] ret = new float[this.dash.length];
        System.arraycopy(this.dash, 0, ret, 0, this.dash.length);
        return ret;
    }

    public void setDashArray(float[] dash) {
        if (dash != null) {
            if (this.dash_phase < 0.0f) {
                throw new IllegalArgumentException("negative dash phase");
            }
            boolean allzero = true;
            for (int i = 0; i < dash.length; ++i) {
                float d = dash[i];
                if ((double)d > 0.0) {
                    allzero = false;
                    continue;
                }
                if (!((double)d < 0.0)) continue;
                throw new IllegalArgumentException("negative dash length");
            }
            if (allzero) {
                throw new IllegalArgumentException("dash lengths all zero");
            }
        }
        if (dash == null) {
            this.dash = null;
        } else {
            this.dash = new float[dash.length];
            System.arraycopy(dash, 0, this.dash, 0, dash.length);
        }
    }

    public float getDashPhase() {
        return this.dash_phase;
    }

    public void setDashPhase(float dash_phase) {
        this.dash_phase = dash_phase;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PenStroke)) {
            return false;
        }
        PenStroke bs = (PenStroke)obj;
        if (this.width != bs.width) {
            return false;
        }
        if (this.join != bs.join) {
            return false;
        }
        if (this.cap != bs.cap) {
            return false;
        }
        if (this.miterlimit != bs.miterlimit) {
            return false;
        }
        if (this.dash != null ? !this.dash.equals(bs.dash) : bs.dash != null) {
            return false;
        }
        return this.dash_phase == bs.dash_phase;
    }

    private class FillAdapter
    implements PathConsumer {
        boolean closed;
        GeneralPath path = new GeneralPath(1);

        public Shape getShape() {
            return this.path;
        }

        public void beginPath() {
        }

        public void beginSubpath(float x0, float y0) {
            if (this.closed) {
                this.path.closePath();
                this.closed = false;
            }
            this.path.moveTo(x0, y0);
        }

        public void appendLine(float x1, float y1) {
            this.path.lineTo(x1, y1);
        }

        public void appendQuadratic(float xm, float ym, float x1, float y1) {
            this.path.quadTo(xm, ym, x1, y1);
        }

        public void appendCubic(float xm, float ym, float xn, float yn, float x1, float y1) {
            this.path.curveTo(xm, ym, xn, yn, x1, y1);
        }

        public void closedSubpath() {
            this.closed = true;
        }

        public void endPath() {
            if (this.closed) {
                this.path.closePath();
                this.closed = false;
            }
        }

        public void useProxy(FastPathProducer proxy) throws PathException {
            proxy.sendTo((PathConsumer)this);
        }

        public long getCPathConsumer() {
            return 0L;
        }

        public void dispose() {
            this.path = null;
        }

        public PathConsumer getConsumer() {
            return null;
        }
    }
}

