/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util;

import com.highqsoft.util.Parse;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Properties;
import javax.swing.Icon;

public class PropDefaults
extends Properties {
    private static final Object PENDING = new String("Pending");
    private PropertyChangeSupport changeSupport;

    public PropDefaults() {
    }

    public PropDefaults(Object[] keyValueList) {
        for (int i = 0; i < keyValueList.length; i += 2) {
            super.put(keyValueList[i], keyValueList[i + 1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Object value = super.get(key);
        if (value != PENDING && !(value instanceof ActiveValue) && !(value instanceof LazyValue)) {
            return value;
        }
        PropDefaults propDefaults = this;
        synchronized (propDefaults) {
            value = super.get(key);
            if (value == PENDING) {
                do {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                } while ((value = super.get(key)) == PENDING);
                return value;
            }
            if (value instanceof LazyValue) {
                super.put(key, PENDING);
            } else if (!(value instanceof ActiveValue)) {
                return value;
            }
        }
        if (value instanceof LazyValue) {
            try {
                value = ((LazyValue)value).createValue(this);
            }
            finally {
                propDefaults = this;
                synchronized (propDefaults) {
                    if (value == null) {
                        super.remove(key);
                    } else {
                        super.put(key, value);
                    }
                    this.notify();
                }
            }
        }
        value = ((ActiveValue)value).createValue(this);
        return value;
    }

    public Object put(Object key, Object value) {
        Object oldValue;
        Object object = oldValue = value == null ? super.remove(key) : super.put(key, value);
        if (key instanceof String) {
            this.firePropertyChange((String)key, oldValue, value);
        }
        return oldValue;
    }

    public void putDefaults(Object[] keyValueList) {
        for (int i = 0; i < keyValueList.length; i += 2) {
            Object value = keyValueList[i + 1];
            if (value == null) {
                super.remove(keyValueList[i]);
                continue;
            }
            super.put(keyValueList[i], value);
        }
        this.firePropertyChange("PropDefaults", null, null);
    }

    public Font getFont(Object key) {
        Object value = this.get(key);
        if (value instanceof String) {
            return Parse.fontString((String)value);
        }
        if (value instanceof Font) {
            return (Font)value;
        }
        return null;
    }

    public Color getColor(Object key) {
        Object value = this.get(key);
        if (value instanceof String) {
            return Parse.colorString((String)value);
        }
        if (value instanceof Color) {
            return (Color)value;
        }
        return null;
    }

    public Icon getIcon(Object key) {
        Object value = this.get(key);
        return value instanceof Icon ? (Icon)value : null;
    }

    public String getString(Object key) {
        Object value = this.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return key instanceof String ? (String)key : null;
    }

    public boolean getBoolean(Object key) {
        Object value = this.get(key);
        if (value instanceof String) {
            return new Boolean((String)value);
        }
        return value instanceof Boolean ? (Boolean)value : false;
    }

    public int getInt(Object key) {
        Object value = this.get(key);
        if (value instanceof String) {
            return Parse.intString((String)value);
        }
        return value instanceof Integer ? (Integer)value : 0;
    }

    public long getLong(Object key) {
        Object value = this.get(key);
        if (value instanceof String) {
            return Parse.longString((String)value);
        }
        return value instanceof Long ? (Long)value : 0L;
    }

    public float getFloat(Object key) {
        Object value = this.get(key);
        if (value instanceof String) {
            try {
                return new Float((String)value).floatValue();
            }
            catch (Exception e) {
                return 0.0f;
            }
        }
        return value instanceof Float ? ((Float)value).floatValue() : 0.0f;
    }

    public double getDouble(Object key) {
        Object value = this.get(key);
        if (value instanceof String) {
            try {
                return new Double((String)value);
            }
            catch (Exception e) {
                return 0.0;
            }
        }
        return value instanceof Double ? (Double)value : 0.0;
    }

    public Class getPropClass(String propClassID, ClassLoader propClassLoader) {
        try {
            String className = (String)this.get(propClassID);
            Class<?> cls = (Class<?>)this.get(className);
            if (cls == null && (cls = propClassLoader == null ? Class.forName(className) : propClassLoader.loadClass(className)) != null) {
                this.put(className, cls);
            }
            return cls;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Class getPropClass(String propClassID) {
        return this.getPropClass(propClassID, null);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public static interface ActiveValue {
        public Object createValue(PropDefaults var1);
    }

    public static interface LazyValue {
        public Object createValue(PropDefaults var1);
    }
}

