/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util;

import com.highqsoft.util.BasicProperties;
import com.highqsoft.util.MultiPropDefaults;
import com.highqsoft.util.PropDefaults;
import java.awt.Color;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;

public class PropManager
implements Serializable {
    public static final String COLUMN_ACCESS_INTERFACE = "ColumnAccess";
    public static final String VALUE_MATRIX_INTERFACE = "AoValueMatrix";
    private static final Object propStateACKey = new StringBuffer("Property State");
    private static Hashtable contextTable = new Hashtable(2);
    private static final String userPropKey = "user.properties";
    private static final String systemPropKey = "system.properties";
    private static final String basicPropKey = "basic.properties";

    static Object contextGet(Object key) {
        return contextTable.get(key);
    }

    static void contextPut(Object key, Object value) {
        contextTable.put(key, value);
    }

    static void contextRemove(Object key) {
        contextTable.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropState getPropState() {
        PropState rv = (PropState)PropManager.contextGet(propStateACKey);
        if (rv != null) {
            return rv;
        }
        Class clazz = PropManager.class;
        synchronized (clazz) {
            rv = (PropState)PropManager.contextGet(propStateACKey);
            if (rv != null) {
                return rv;
            }
            rv = new PropState();
            PropManager.contextPut(propStateACKey, rv);
            return rv;
        }
    }

    private static String replaceSystemProperties(String value) {
        if (value != null) {
            int s = value.indexOf(60);
            int e = value.indexOf(62);
            while (s >= 0 && e >= 0 && e > s + 1) {
                String sysProp = System.getProperty(value.substring(s + 1, e));
                if (sysProp != null) {
                    value = sysProp + value.substring(e + 1);
                    e = 0;
                }
                s = value.indexOf(60, e);
                e = value.indexOf(62, e);
            }
        }
        return value;
    }

    private static String[] getPossibleFilenames(String file) {
        if (file != null) {
            String region = System.getProperty("user.region");
            String language = System.getProperty("user.language");
            String[] files = new String[]{file + ".properties", file + "_" + language + ".properties", file + "_" + region + ".properties", file + "_" + language + "_" + region + ".properties"};
            return files;
        }
        return null;
    }

    private static String[] getPropertyFilenames() {
        String commandLineArg = System.getProperty("highqsoft.property");
        if (commandLineArg == null) {
            final String[] homeDir = new String[]{"<java.home undefined>"};
            Runnable r = new Runnable(){

                public void run() {
                    homeDir[0] = System.getProperty("java.home", "<java.home undefined>");
                }
            };
            r.run();
            String sep = File.separator;
            return PropManager.getPossibleFilenames(homeDir[0] + sep + "lib" + sep + "highqsoft");
        }
        return PropManager.getPossibleFilenames(commandLineArg);
    }

    public static PropDefaults getDefaults() {
        PropManager.maybeInitialize();
        return PropManager.getPropState().multiPropDefaults;
    }

    public static Font getFont(Object key) {
        return PropManager.getDefaults().getFont(key);
    }

    public static Color getColor(Object key) {
        return PropManager.getDefaults().getColor(key);
    }

    public static String getString(Object key) {
        return PropManager.getDefaults().getString(key);
    }

    public static int getInt(Object key) {
        return PropManager.getDefaults().getInt(key);
    }

    public static boolean getBoolean(Object key) {
        return PropManager.getDefaults().getBoolean(key);
    }

    public static long getLong(Object key) {
        return PropManager.getDefaults().getLong(key);
    }

    public static float getFloat(Object key) {
        return PropManager.getDefaults().getFloat(key);
    }

    public static double getDouble(Object key) {
        return PropManager.getDefaults().getDouble(key);
    }

    public static DataFlavor getBusFlavor(String className) {
        return PropManager.getBusFlavor(PropManager.getString("InfoBus.ASAM.Flavor." + className), PropManager.getString("InfoBus.ASAM.Flavor.SubType"));
    }

    public static DataFlavor getBusFlavor(String className, String flavorSubtype) {
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor(PropManager.getString("InfoBus.ASAM.Flavor.PrimaryType") + "/x-" + flavorSubtype.toLowerCase() + ";class=" + className);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return dataFlavor;
    }

    public static Object get(Object key) {
        return PropManager.getDefaults().get(key);
    }

    public static Object put(Object key, Object value) {
        return PropManager.getDefaults().put(key, value);
    }

    public static synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        PropManager.getPropState().changeSupport.addPropertyChangeListener(listener);
    }

    public static synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        PropManager.getPropState().changeSupport.removePropertyChangeListener(listener);
    }

    private static Properties loadProperties() {
        final Properties props = new Properties();
        Runnable r = new Runnable(){

            public void run() {
                String[] fn = PropManager.getPropertyFilenames();
                for (int i = 0; fn != null && i < fn.length; ++i) {
                    try {
                        File file = new File(fn[i]);
                        BufferedInputStream ins = new BufferedInputStream(new FileInputStream(file));
                        props.load(ins);
                        ins.close();
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                PropManager.checkProperty(props, PropManager.basicPropKey);
                PropManager.checkProperty(props, PropManager.systemPropKey);
                PropManager.checkProperty(props, PropManager.userPropKey);
            }
        };
        r.run();
        return props;
    }

    static final void checkProperty(Properties props, String key) {
        try {
            String value = System.getProperty(key);
            if (value != null) {
                props.put(key, value);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static void initializeBasicDefaults(Properties props) {
        final PropDefaults pd = BasicProperties.getDefaults();
        String propVal = (String)props.get(basicPropKey);
        if (propVal != null) {
            propVal = PropManager.replaceSystemProperties(propVal);
            final String[] files = PropManager.getPossibleFilenames(propVal.replace('.', '/'));
            Runnable r = new Runnable(){

                public void run() {
                    for (int i = 0; files != null && i < files.length; ++i) {
                        try {
                            File file = new File(files[i]);
                            BufferedInputStream ins = new BufferedInputStream(new FileInputStream(file));
                            pd.load(ins);
                            ins.close();
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            };
            r.run();
        }
        PropManager.getPropState().setBasicDefaults(pd);
    }

    private static void initializeSystemDefaults(Properties props) {
        final PropDefaults pd = new PropDefaults();
        String propVal = (String)props.get(systemPropKey);
        if (propVal != null) {
            propVal = PropManager.replaceSystemProperties(propVal);
            final String[] files = PropManager.getPossibleFilenames(propVal.replace('.', '/'));
            Runnable r = new Runnable(){

                public void run() {
                    for (int i = 0; files != null && i < files.length; ++i) {
                        try {
                            File file = new File(files[i]);
                            BufferedInputStream ins = new BufferedInputStream(new FileInputStream(file));
                            pd.load(ins);
                            ins.close();
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            };
            r.run();
        }
        PropManager.getPropState().setSystemDefaults(pd);
    }

    private static void initializeUserDefaults(Properties props) {
        final PropDefaults pd = new PropDefaults();
        String propVal = (String)props.get(userPropKey);
        if (propVal != null) {
            propVal = PropManager.replaceSystemProperties(propVal);
            final String[] files = PropManager.getPossibleFilenames(propVal.replace('.', '/'));
            Runnable r = new Runnable(){

                public void run() {
                    for (int i = 0; files != null && i < files.length; ++i) {
                        try {
                            File file = new File(files[i]);
                            BufferedInputStream ins = new BufferedInputStream(new FileInputStream(file));
                            pd.load(ins);
                            ins.close();
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            };
            r.run();
        }
        PropManager.getPropState().setUserDefaults(pd);
    }

    public static void initialize(String[] args) {
        if (PropManager.getPropState().initialized) {
            return;
        }
        if (args != null && args.length != 0) {
            try {
                Properties p = new Properties(System.getProperties());
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].indexOf(45) != 0 || args[i].length() == 1) continue;
                    if (i < args.length - 1 && args[i + 1].indexOf(45) == -1 && args[i + 1].length() != 1) {
                        p.put(args[i].substring(1), args[i + 1]);
                        ++i;
                        continue;
                    }
                    p.put(args[i].substring(1), "true");
                }
                System.setProperties(p);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Properties props = PropManager.loadProperties();
        PropManager.initializeBasicDefaults(props);
        PropManager.initializeSystemDefaults(props);
        PropManager.initializeUserDefaults(props);
        PropManager.getPropState().props = props;
        PropManager.getPropState().initialized = true;
    }

    private static void initialize() {
        PropManager.initialize(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void maybeInitialize() {
        if (!PropManager.getPropState().initialized) {
            Class clazz = PropManager.class;
            synchronized (clazz) {
                PropManager.initialize();
            }
        }
    }

    private static class PropState {
        Properties props;
        private PropDefaults[] tables = new PropDefaults[3];
        boolean initialized = false;
        MultiPropDefaults multiPropDefaults = new MultiPropDefaults(this.tables);
        PropertyChangeSupport changeSupport = new PropertyChangeSupport(class$com$highqsoft$util$PropManager == null ? (class$com$highqsoft$util$PropManager = PropManager.class$("com.highqsoft.util.PropManager")) : class$com$highqsoft$util$PropManager);

        private PropState() {
        }

        PropDefaults getUserDefaults() {
            return this.tables[0];
        }

        void setUserDefaults(PropDefaults x) {
            this.tables[0] = x;
        }

        PropDefaults getSystemDefaults() {
            return this.tables[1];
        }

        void setSystemDefaults(PropDefaults x) {
            this.tables[1] = x;
        }

        PropDefaults getBasicDefaults() {
            return this.tables[2];
        }

        void setBasicDefaults(PropDefaults x) {
            this.tables[2] = x;
        }
    }
}

