/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util;

import com.highqsoft.util.EnhancedPropertyResource;
import com.highqsoft.util.PropManager;
import com.highqsoft.util.ResourceComponentFactoryable;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class PropertyBundle {
    private static boolean debugFlag = false;
    protected PropertyBundle parent = null;
    private static final Integer NOTFOUND = new Integer(-1);
    private static Hashtable cacheList = new Hashtable();

    public final String getString(String key) throws MissingResourceException {
        return (String)this.getObject(key);
    }

    public final String getStringValue(String key) {
        return this.getStringValue(key, key);
    }

    public final String getStringValue(String key, String theDefault) {
        try {
            return this.getString(key);
        }
        catch (Throwable t) {
            String ret = PropManager.getString(key);
            if (ret != null) {
                return ret;
            }
            return theDefault;
        }
    }

    public final int getIntValue(String key) {
        return this.getIntValue(key, 0);
    }

    public final int getIntValue(String key, int theDefault) {
        try {
            return new Integer(this.getString(key));
        }
        catch (Throwable t) {
            String ret = PropManager.getString(key);
            if (ret != null) {
                return new Integer(ret);
            }
            return theDefault;
        }
    }

    public final long getLongValue(String key) {
        return this.getLongValue(key, 0L);
    }

    public final long getLongValue(String key, long theDefault) {
        try {
            return new Long(this.getString(key));
        }
        catch (Throwable t) {
            String ret = PropManager.getString(key);
            if (ret != null) {
                return new Long(ret);
            }
            return theDefault;
        }
    }

    public final float getFloatValue(String key) {
        return this.getFloatValue(key, 0.0f);
    }

    public final float getFloatValue(String key, float theDefault) {
        try {
            return new Float(this.getString(key)).floatValue();
        }
        catch (Throwable t) {
            String ret = PropManager.getString(key);
            if (ret != null) {
                return new Float(ret).floatValue();
            }
            return theDefault;
        }
    }

    public final double getdoubleValue(String key) {
        return this.getDoubleValue(key, 0.0);
    }

    public final double getDoubleValue(String key, double theDefault) {
        try {
            return new Double(this.getString(key));
        }
        catch (Throwable t) {
            String ret = PropManager.getString(key);
            if (ret != null) {
                return new Double(ret);
            }
            return theDefault;
        }
    }

    public final byte getByteValue(String key) {
        return this.getByteValue(key, (byte)0);
    }

    public final byte getByteValue(String key, byte theDefault) {
        try {
            return (byte)new Integer(this.getString(key)).intValue();
        }
        catch (Throwable t) {
            String ret = PropManager.getString(key);
            if (ret != null) {
                return (byte)new Integer(ret).intValue();
            }
            return theDefault;
        }
    }

    public final boolean getBooleanValue(String key) {
        return this.getBooleanValue(key, false);
    }

    public final boolean getBooleanValue(String key, boolean theDefault) {
        try {
            return new Boolean(this.getString(key));
        }
        catch (Throwable t) {
            String ret = PropManager.getString(key);
            if (ret != null) {
                return new Boolean(this.getString(key));
            }
            return theDefault;
        }
    }

    public final String[] getStringArray(String key) throws MissingResourceException {
        return (String[])this.getObject(key);
    }

    public final Object getObject(String key) throws MissingResourceException {
        Object obj = this.handleGetObject(key);
        if (obj == null) {
            if (this.parent != null) {
                obj = this.parent.getObject(key);
            }
            if (obj == null) {
                throw new MissingResourceException("Can't find resource", this.getClass().getName(), key);
            }
        }
        return obj;
    }

    public static final PropertyBundle getBundle(String baseName) throws MissingResourceException {
        return PropertyBundle.getBundle(baseName, null, Locale.getDefault(), PropertyBundle.getLoader());
    }

    public static final PropertyBundle getBundle(String baseName, ResourceComponentFactoryable obj) throws MissingResourceException {
        return PropertyBundle.getBundle(baseName, obj, Locale.getDefault(), PropertyBundle.getLoader());
    }

    public static final PropertyBundle getBundle(String baseName, Locale locale) {
        return PropertyBundle.getBundle(baseName, null, locale, PropertyBundle.getLoader());
    }

    public static final PropertyBundle getBundle(String baseName, ResourceComponentFactoryable obj, Locale locale) {
        return PropertyBundle.getBundle(baseName, obj, locale, PropertyBundle.getLoader());
    }

    public Locale getLocale() {
        String className = this.getClass().getName();
        int pos = className.indexOf(95);
        if (pos == -1) {
            return new Locale("", "", "");
        }
        if ((pos = (className = className.substring(pos + 1)).indexOf(95)) == -1) {
            return new Locale(className, "", "");
        }
        String language = className.substring(0, pos);
        if ((pos = (className = className.substring(pos + 1)).indexOf(95)) == -1) {
            return new Locale(language, className, "");
        }
        String country = className.substring(0, pos);
        className = className.substring(pos + 1);
        return new Locale(language, country, className);
    }

    private static ClassLoader getLoader() {
        Integer i = new Integer(0);
        return i.getClass().getClassLoader();
    }

    private static synchronized PropertyBundle getBundle(String baseName, ResourceComponentFactoryable obj, Locale locale, ClassLoader loader) throws MissingResourceException {
        PropertyBundle lookup;
        StringBuffer localeName = new StringBuffer("_").append(locale.toString());
        if (locale.toString().equals("")) {
            localeName.setLength(0);
        }
        if ((lookup = PropertyBundle.findBundle(baseName, obj, localeName, loader, false)) == null) {
            localeName.setLength(0);
            localeName.append("_").append(Locale.getDefault().toString());
            lookup = PropertyBundle.findBundle(baseName, obj, localeName, loader, true);
            if (lookup == null) {
                throw new MissingResourceException("can't find resource for " + baseName + "_" + locale, baseName + "_" + locale, "");
            }
        }
        PropertyBundle child = lookup;
        while (child != null && child.parent == null) {
            int lastUnderbar = localeName.toString().lastIndexOf(95);
            if (lastUnderbar != -1) {
                localeName.setLength(lastUnderbar);
                try {
                    child.setParent(PropertyBundle.findBundle(baseName, obj, localeName, loader, true));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            child = child.parent;
        }
        return lookup;
    }

    protected void setParent(PropertyBundle parent) {
        this.parent = parent;
    }

    private static PropertyBundle findBundle(String baseName, ResourceComponentFactoryable obj, StringBuffer localeName, ClassLoader loader, boolean includeBase) {
        String localeStr = localeName.toString();
        String baseFileName = baseName.replace('.', '/');
        Object lookup = null;
        Vector<String> cacheCandidates = new Vector<String>();
        while (true) {
            String searchName = baseName + localeStr;
            String cacheName = loader != null ? "[" + Integer.toString(loader.hashCode()) + "]" : "";
            lookup = cacheList.get(cacheName = cacheName + searchName);
            if (lookup == NOTFOUND) {
                localeName.setLength(0);
                break;
            }
            if (lookup != null) {
                localeName.setLength(0);
                break;
            }
            cacheCandidates.addElement(cacheName);
            try {
                if (obj == null) {
                    if (loader != null) {
                        lookup = loader.loadClass(searchName).newInstance();
                        break;
                    }
                    lookup = Class.forName(searchName).newInstance();
                    break;
                }
                lookup = (ResourceBundle)((Object)obj);
            }
            catch (Exception e) {
                int lastUnderbar;
                searchName = baseFileName + localeStr + ".properties";
                InputStream stream = loader != null ? loader.getResourceAsStream(searchName) : ClassLoader.getSystemResourceAsStream(searchName);
                if (stream != null) {
                    stream = new BufferedInputStream(stream);
                    try {
                        lookup = new EnhancedPropertyResource(stream);
                        break;
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                if ((lastUnderbar = localeStr.lastIndexOf(95)) == 0 && !includeBase || lastUnderbar == -1) break;
                localeStr = localeStr.substring(0, lastUnderbar);
                localeName.setLength(lastUnderbar);
                continue;
            }
            break;
        }
        if (lookup != null) {
            for (int i = 0; i < cacheCandidates.size(); ++i) {
                cacheList.put(cacheCandidates.elementAt(i), lookup);
            }
        } else if (includeBase) {
            for (int i = 0; i < cacheCandidates.size(); ++i) {
                cacheList.put(cacheCandidates.elementAt(i), NOTFOUND);
            }
        }
        if (lookup == NOTFOUND || lookup == null) {
            return null;
        }
        return (PropertyBundle)lookup;
    }

    protected abstract Object handleGetObject(String var1) throws MissingResourceException;

    public abstract Enumeration getKeys();

    protected static void debug(String str) {
        if (debugFlag) {
            System.out.println("PropertyBundle: " + str);
        }
    }
}

