/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util;

import com.highqsoft.util.PropertyBundle;
import com.highqsoft.util.RangeSelectorDialogBox;
import com.highqsoft.util.RangeTracker;
import com.highqsoft.util.ResourceComponentFactoryable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RangeSelector
extends JComponent
implements FocusListener,
ResourceComponentFactoryable {
    public static final String SELECTEDRANGE_PROPERTY = "SelectedRange";
    public static final String SELECTEDAUTOSCALE_PROPERTY = "SelectedAutoScale";
    private String keySuffix = "RangeSelector";
    static PropertyBundle resources;
    protected double[] initialRange;
    protected double[] selectedRange;
    boolean selectedAutoRange;
    boolean initialAutoRange;
    protected static final double[] defaultRange;
    protected static final boolean defaultAutoRange;
    private JTextField startField;
    private JTextField endField;
    private JCheckBox autoRangeCB;

    public static double[] showDialog(Component component, double[] initialRange, boolean auto, ActionListener autoRangeListener, PropertyBundle resources, String keySuffix, boolean noBorder) {
        RangeSelector pane = new RangeSelector(initialRange, auto, autoRangeListener, resources, keySuffix, noBorder);
        RangeTracker ok = new RangeTracker(pane);
        JDialog dialog = RangeSelector.createDialog(component, resources, true, pane, ok, null);
        dialog.addWindowListener(new RangeSelectorDialogBox.Closer());
        dialog.addComponentListener(new RangeSelectorDialogBox.DisposeOnClose());
        dialog.setVisible(true);
        return ok.getRange();
    }

    public static JDialog createDialog(Component c, PropertyBundle resources, boolean modal, RangeSelector dialogPane, ActionListener okListener, ActionListener cancelListener) {
        return new RangeSelectorDialogBox(c, resources, modal, dialogPane, okListener, cancelListener);
    }

    public RangeSelector() {
        this(defaultRange, defaultAutoRange, null, null, null, false);
    }

    public RangeSelector(double[] range, boolean autoRange, ActionListener autoRangeListener, PropertyBundle resources, String keySuffix, boolean noBorder) {
        if (keySuffix != null) {
            this.keySuffix = keySuffix;
        }
        if (RangeSelector.resources == null) {
            try {
                RangeSelector.resources = PropertyBundle.getBundle("com.highqsoft.util.RangeSelector", this, Locale.getDefault());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.initialRange = (double[])range.clone();
        this.setSelectedRange(this.initialRange);
        this.initialAutoRange = autoRange;
        this.selectedAutoRange = autoRange;
        this.setLayout(new GridLayout(1, 1));
        if (!noBorder) {
            this.setBorder(BorderFactory.createTitledBorder(this.getResource(resources, "Text.Range_Title")));
        }
        JPanel settingsPane = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints cs = new GridBagConstraints();
        cs.weightx = 1.0;
        JLabel label = new JLabel(this.getResource(resources, "Text.Start") + ":");
        gbl.setConstraints(label, cs);
        settingsPane.add(label);
        this.startField = new JTextField(10);
        this.startField.addFocusListener(this);
        gbl.setConstraints(label, cs);
        settingsPane.add(this.startField);
        label = new JLabel(this.getResource(resources, "Text.End") + ":");
        gbl.setConstraints(label, cs);
        settingsPane.add(label);
        cs.gridwidth = 0;
        this.endField = new JTextField(10);
        this.endField.addFocusListener(this);
        gbl.setConstraints(label, cs);
        settingsPane.add(this.endField);
        this.autoRangeCB = new JCheckBox();
        this.autoRangeCB.setText(this.getResource(resources, "Text.Autorange"));
        this.autoRangeCB.setSelected(this.getSelectedAutoRange());
        if (autoRangeListener != null) {
            this.autoRangeCB.addActionListener(autoRangeListener);
        }
        this.autoRangeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                boolean state = checkBox.isSelected();
                RangeSelector.this.setSelectedAutoRange(state);
                RangeSelector.this.endField.setEnabled(!state);
                RangeSelector.this.startField.setEnabled(!state);
            }
        });
        gbl.setConstraints(this.autoRangeCB, cs);
        settingsPane.add(this.autoRangeCB);
        this.add(settingsPane);
        this.reset();
    }

    protected String getLocalKey(String key) {
        int i = key.indexOf(".");
        if (i != -1) {
            return key.substring(i + 1, key.length());
        }
        return key;
    }

    public String getResource(PropertyBundle resources, String key) {
        if (resources == null) {
            if (RangeSelector.resources == null) {
                return key;
            }
            return RangeSelector.resources.getStringValue(key);
        }
        try {
            return resources.getString(this.keySuffix + '.' + key);
        }
        catch (Throwable t) {
            if (RangeSelector.resources != null) {
                return RangeSelector.resources.getStringValue(key);
            }
            return this.keySuffix + '.' + key;
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.commit();
    }

    protected void recalc() {
    }

    public String toString() {
        return this.selectedRange.toString();
    }

    public boolean getSelectedAutoRange() {
        return this.selectedAutoRange;
    }

    public void setSelectedAutoRange(boolean auto) {
        if (auto != this.selectedAutoRange) {
            boolean oldState = this.selectedAutoRange;
            this.selectedAutoRange = auto;
            this.firePropertyChange(SELECTEDAUTOSCALE_PROPERTY, new Boolean(oldState), new Boolean(this.selectedAutoRange));
        }
    }

    public boolean getInitialAutoRange() {
        return this.initialAutoRange;
    }

    public void setInitialAutoRange(boolean auto) {
        if (auto != this.initialAutoRange) {
            this.initialAutoRange = auto;
        }
    }

    public double[] getSelectedRange() {
        return (double[])this.selectedRange.clone();
    }

    public void setSelectedRange(double[] range) {
        double[] oldRange = this.selectedRange;
        this.selectedRange = (double[])range.clone();
        this.firePropertyChange(SELECTEDRANGE_PROPERTY, oldRange, this.selectedRange);
    }

    protected void setIntialRange(double[] range) {
        this.initialRange = (double[])range.clone();
    }

    public double[] getInitialRange() {
        return (double[])this.initialRange.clone();
    }

    public void reset() {
        this.setSelectedRange(this.getInitialRange());
        this.setSelectedAutoRange(this.getInitialAutoRange());
        double[] range = this.getSelectedRange();
        this.startField.setText("" + range[0]);
        this.endField.setText("" + range[1]);
        boolean state = this.getSelectedAutoRange();
        this.autoRangeCB.setSelected(state);
        this.endField.setEnabled(!state);
        this.startField.setEnabled(!state);
    }

    public void commit() {
        Double start = new Double(this.startField.getText());
        Double end = new Double(this.endField.getText());
        double[] range = new double[]{start, end};
        if (range[1] < range[0]) {
            double tmp = range[1];
            range[1] = range[0];
            range[0] = tmp;
        }
        this.setSelectedRange(range);
    }

    public void addMenuItem(String itemKey, JMenuItem menuItem) {
    }

    public Action getAction(String cmdKey) {
        return null;
    }

    public PropertyChangeListener createActionChangeListener(JMenuItem menuItem) {
        return null;
    }

    static {
        defaultRange = new double[2];
        RangeSelector.defaultRange[0] = 0.0;
        RangeSelector.defaultRange[1] = 1.0;
        defaultAutoRange = true;
    }
}

