/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util;

import com.highqsoft.util.PropertyBundle;
import com.highqsoft.util.ResourceComponentFactoryable;
import java.awt.Insets;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class ResourceComponentFactory {
    public static Hashtable charKeyRelation = new Hashtable();
    public static final String menubarKeyword = "Menubar";
    public static final String popupKeyword = "PopupMenu";
    public static final String toolbarKeyword = "Toolbar";
    public static final String menuSuffix = "Menu";
    public static final String groupSuffix = "RadioGroup";
    public static final String mnemonicSuffix = "Mnemonic";
    public static final String acceleratorSuffix = "Accelerator";
    public static final String imageSuffix = "Image";
    public static final String labelSuffix = "Label";
    public static final String actionSuffix = "";
    public static final String tipSuffix = "Tooltip";
    public static final String toggleSuffix = "ToggleButton";
    public static final String selectSuffix = "Selected";
    public static final String altPrefix = "ALT-";
    public static final String ctrlPrefix = "CTRL-";
    public static final String metaPrefix = "META-";
    public static final String shiftPrefix = "SHIFT-";

    private ResourceComponentFactory() {
    }

    private static String[] tokenize(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.elementAt(i);
        }
        return cmd;
    }

    private static boolean getBoolean(String boolString) {
        char first = boolString.toUpperCase().charAt(0);
        return first == 'Y' || first == 'T' || first == 'J' || first == '1' || first == 'W';
    }

    private static KeyStroke getAccelerator(String accelString) {
        Integer key;
        if (accelString == null) {
            return null;
        }
        String upper = accelString.toUpperCase();
        int mask = 0;
        if (upper.startsWith(altPrefix)) {
            mask = 8;
            key = (Integer)charKeyRelation.get(accelString.substring(altPrefix.length()).trim());
        } else if (upper.startsWith(ctrlPrefix)) {
            mask = 2;
            key = (Integer)charKeyRelation.get(accelString.substring(ctrlPrefix.length()).trim());
        } else if (upper.startsWith(metaPrefix)) {
            mask = 4;
            key = (Integer)charKeyRelation.get(accelString.substring(metaPrefix.length()).trim());
        } else if (upper.startsWith(shiftPrefix)) {
            mask = 1;
            key = (Integer)charKeyRelation.get(accelString.substring(shiftPrefix.length()).trim());
        } else {
            key = (Integer)charKeyRelation.get(accelString.trim());
            mask = 0;
        }
        if (key != null) {
            return KeyStroke.getKeyStroke(key, mask);
        }
        return null;
    }

    public static JMenuBar createMenubar(ResourceComponentFactoryable obj, PropertyBundle properties) {
        String[] menuKeys;
        try {
            menuKeys = ResourceComponentFactory.tokenize(properties.getString(menubarKeyword));
        }
        catch (Throwable t) {
            return null;
        }
        JMenuBar mb = new JMenuBar();
        for (int i = 0; i < menuKeys.length; ++i) {
            JMenu m = ResourceComponentFactory.createMenu(obj, properties, menuKeys[i]);
            if (m == null) continue;
            mb.add(m);
        }
        return mb;
    }

    public static JPopupMenu createPopupMenu(ResourceComponentFactoryable obj, PropertyBundle properties) {
        String[] itemKeys;
        try {
            itemKeys = ResourceComponentFactory.tokenize(properties.getString(popupKeyword));
        }
        catch (Throwable t) {
            return null;
        }
        JPopupMenu pm = new JPopupMenu();
        String label = properties.getStringValue("PopupMenuLabel", null);
        if (label != null) {
            pm.setLabel(label);
            pm.setBorderPainted(true);
        }
        for (int i = 0; i < itemKeys.length; ++i) {
            if (itemKeys[i].equals("-")) {
                pm.addSeparator();
                continue;
            }
            try {
                String[] groupItems = ResourceComponentFactory.tokenize(properties.getString(itemKeys[i] + groupSuffix));
                ButtonGroup group = new ButtonGroup();
                for (int k = 0; k < groupItems.length; ++k) {
                    JRadioButtonMenuItem rb = ResourceComponentFactory.createRadioItem(obj, properties, groupItems[k]);
                    if (rb == null) continue;
                    pm.add(rb);
                    group.add(rb);
                }
                continue;
            }
            catch (Throwable t) {
                JComponent mi = ResourceComponentFactory.createMenuItem(obj, properties, itemKeys[i]);
                if (mi == null) continue;
                pm.add(mi);
            }
        }
        return pm;
    }

    private static JMenu createMenu(ResourceComponentFactoryable obj, PropertyBundle properties, String key) {
        String[] itemKeys;
        try {
            itemKeys = ResourceComponentFactory.tokenize(properties.getString(key));
        }
        catch (Throwable t) {
            try {
                itemKeys = ResourceComponentFactory.tokenize(properties.getString(key) + menuSuffix);
            }
            catch (Throwable t1) {
                return null;
            }
        }
        JMenu menu = new JMenu(properties.getStringValue(key + labelSuffix));
        String mnemonic = properties.getStringValue(key + mnemonicSuffix, null);
        if (mnemonic != null) {
            menu.setMnemonic(mnemonic.charAt(0));
        }
        for (int i = 0; i < itemKeys.length; ++i) {
            if (itemKeys[i].equals("-")) {
                menu.addSeparator();
                continue;
            }
            try {
                String[] groupItems = ResourceComponentFactory.tokenize(properties.getString(itemKeys[i] + groupSuffix));
                ButtonGroup group = new ButtonGroup();
                for (int k = 0; k < groupItems.length; ++k) {
                    JRadioButtonMenuItem rb = ResourceComponentFactory.createRadioItem(obj, properties, groupItems[k]);
                    if (rb == null) continue;
                    menu.add(rb);
                    group.add(rb);
                }
                continue;
            }
            catch (Throwable t) {
                JComponent mi = ResourceComponentFactory.createMenuItem(obj, properties, itemKeys[i]);
                if (mi == null) continue;
                menu.add(mi);
            }
        }
        return menu;
    }

    private static JComponent createMenuItem(ResourceComponentFactoryable obj, PropertyBundle properties, String key) {
        String[] itemKeys;
        try {
            itemKeys = ResourceComponentFactory.tokenize(properties.getString(key + menuSuffix));
        }
        catch (Throwable t) {
            itemKeys = null;
        }
        if (itemKeys == null) {
            String tooltip;
            KeyStroke accelerator;
            String mnemonic;
            JMenuItem mi;
            try {
                mi = new JCheckBoxMenuItem(properties.getString(key + toggleSuffix));
                try {
                    mi.setSelected(ResourceComponentFactory.getBoolean(properties.getString(key + selectSuffix)));
                }
                catch (Throwable t) {
                    mi.setSelected(false);
                }
            }
            catch (Throwable t) {
                mi = new JMenuItem(properties.getStringValue(key + labelSuffix));
            }
            URL url = obj.getClass().getResource(properties.getStringValue(key + imageSuffix));
            if (url != null) {
                mi.setHorizontalTextPosition(4);
                mi.setIcon(new ImageIcon(url));
            }
            if ((mnemonic = properties.getStringValue(key + mnemonicSuffix, null)) != null) {
                mi.setMnemonic(mnemonic.charAt(0));
            }
            if ((accelerator = ResourceComponentFactory.getAccelerator(properties.getStringValue(key + acceleratorSuffix, null))) != null) {
                mi.setAccelerator(accelerator);
            }
            if ((tooltip = properties.getStringValue(key + tipSuffix, null)) != null) {
                mi.setToolTipText(tooltip);
            }
            String astr = properties.getStringValue(key + actionSuffix, key);
            mi.setActionCommand(astr);
            Action a = obj.getAction(astr);
            if (a != null) {
                mi.addActionListener(a);
                a.addPropertyChangeListener(obj.createActionChangeListener(mi));
                mi.setEnabled(a.isEnabled());
            } else {
                mi.setEnabled(false);
            }
            obj.addMenuItem(key, mi);
            return mi;
        }
        JMenu menu = new JMenu(properties.getStringValue(key + labelSuffix));
        String mnemonic = properties.getStringValue(key + mnemonicSuffix, null);
        if (mnemonic != null) {
            menu.setMnemonic(mnemonic.charAt(0));
        }
        for (int i = 0; i < itemKeys.length; ++i) {
            if (itemKeys[i].equals("-")) {
                menu.addSeparator();
                continue;
            }
            JComponent mi = ResourceComponentFactory.createMenuItem(obj, properties, itemKeys[i]);
            if (mi == null) continue;
            menu.add(mi);
        }
        return menu;
    }

    private static JRadioButtonMenuItem createRadioItem(ResourceComponentFactoryable obj, PropertyBundle properties, String key) {
        String tooltip;
        KeyStroke accelerator;
        String mnemonic;
        JRadioButtonMenuItem rb = new JRadioButtonMenuItem(properties.getStringValue(key + labelSuffix));
        URL url = obj.getClass().getResource(properties.getStringValue(key + imageSuffix));
        if (url != null) {
            rb.setHorizontalTextPosition(4);
            rb.setIcon(new ImageIcon(url));
        }
        if ((mnemonic = properties.getStringValue(key + mnemonicSuffix, null)) != null) {
            rb.setMnemonic(mnemonic.charAt(0));
        }
        if ((accelerator = ResourceComponentFactory.getAccelerator(properties.getStringValue(key + acceleratorSuffix, null))) != null) {
            rb.setAccelerator(accelerator);
        }
        if ((tooltip = properties.getStringValue(key + tipSuffix, null)) != null) {
            rb.setToolTipText(tooltip);
        }
        String astr = properties.getStringValue(key + actionSuffix, key);
        rb.setActionCommand(astr);
        Action a = obj.getAction(astr);
        if (a != null) {
            rb.addActionListener(a);
            a.addPropertyChangeListener(obj.createActionChangeListener(rb));
            rb.setEnabled(a.isEnabled());
        } else {
            rb.setEnabled(false);
        }
        obj.addMenuItem(key, rb);
        rb.setSelected(false);
        if (key.compareTo("metal") == 0) {
            rb.setSelected(UIManager.getLookAndFeel().getID().equals("Metal"));
        } else if (key.compareTo("motif") == 0) {
            rb.setSelected(UIManager.getLookAndFeel().getID().equals("Motif"));
        } else if (key.compareTo("windows") == 0) {
            rb.setSelected(UIManager.getLookAndFeel().getID().equals("Windows"));
        }
        return rb;
    }

    public static JToolBar createToolbar(ResourceComponentFactoryable obj, PropertyBundle properties) {
        String[] toolKeys;
        try {
            toolKeys = ResourceComponentFactory.tokenize(properties.getString(toolbarKeyword));
        }
        catch (Throwable t) {
            return null;
        }
        JToolBar toolbar = new JToolBar();
        for (int i = 0; i < toolKeys.length; ++i) {
            if (toolKeys[i].equals("-")) {
                toolbar.add(Box.createHorizontalStrut(5));
                continue;
            }
            JButton jb = ResourceComponentFactory.createToolbarButton(obj, properties, toolKeys[i]);
            if (jb == null) continue;
            toolbar.add(jb);
        }
        toolbar.add(Box.createHorizontalGlue());
        return toolbar;
    }

    private static JButton createToolbarButton(ResourceComponentFactoryable obj, PropertyBundle properties, String key) {
        URL url = obj.getClass().getResource(properties.getStringValue(key + imageSuffix, null));
        if (url == null) {
            return null;
        }
        JButton b = new JButton(new ImageIcon(url)){

            public float getAlignmentY() {
                return 0.5f;
            }
        };
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(1, 1, 1, 1));
        String astr = properties.getStringValue(key + actionSuffix, key);
        Action a = obj.getAction(astr);
        if (a != null) {
            b.setActionCommand(astr);
            b.addActionListener(a);
        } else {
            b.setEnabled(false);
        }
        String tip = properties.getStringValue(key + tipSuffix, null);
        if (tip != null) {
            b.setToolTipText(tip);
        }
        return b;
    }

    static {
        charKeyRelation.put("0", new Integer(48));
        charKeyRelation.put("1", new Integer(49));
        charKeyRelation.put("2", new Integer(50));
        charKeyRelation.put("3", new Integer(51));
        charKeyRelation.put("4", new Integer(52));
        charKeyRelation.put("5", new Integer(53));
        charKeyRelation.put("6", new Integer(54));
        charKeyRelation.put("7", new Integer(55));
        charKeyRelation.put("8", new Integer(56));
        charKeyRelation.put("9", new Integer(57));
        charKeyRelation.put("F1", new Integer(112));
        charKeyRelation.put("F2", new Integer(113));
        charKeyRelation.put("F3", new Integer(114));
        charKeyRelation.put("F4", new Integer(115));
        charKeyRelation.put("F5", new Integer(116));
        charKeyRelation.put("F6", new Integer(117));
        charKeyRelation.put("F7", new Integer(118));
        charKeyRelation.put("F8", new Integer(119));
        charKeyRelation.put("F9", new Integer(120));
        charKeyRelation.put("F10", new Integer(121));
        charKeyRelation.put("F11", new Integer(122));
        charKeyRelation.put("F12", new Integer(123));
        charKeyRelation.put("ENTER", new Integer(10));
        charKeyRelation.put("BACK_SPACE", new Integer(8));
        charKeyRelation.put("TAB", new Integer(9));
        charKeyRelation.put("CANCEL", new Integer(3));
        charKeyRelation.put("CLEAR", new Integer(12));
        charKeyRelation.put("SHIFT", new Integer(16));
        charKeyRelation.put("CONTROL", new Integer(17));
        charKeyRelation.put("ALT", new Integer(18));
        charKeyRelation.put("PAUSE", new Integer(19));
        charKeyRelation.put("CAPS_LOCK", new Integer(20));
        charKeyRelation.put("ESCAPE", new Integer(27));
        charKeyRelation.put("SPACE", new Integer(32));
        charKeyRelation.put("PAGE_UP", new Integer(33));
        charKeyRelation.put("PAGE_DOWN", new Integer(34));
        charKeyRelation.put("END", new Integer(35));
        charKeyRelation.put("HOME", new Integer(36));
        charKeyRelation.put("LEFT", new Integer(37));
        charKeyRelation.put("UP", new Integer(38));
        charKeyRelation.put("RIGHT", new Integer(39));
        charKeyRelation.put("DOWN", new Integer(40));
        charKeyRelation.put("COMMA", new Integer(44));
        charKeyRelation.put(",", new Integer(44));
        charKeyRelation.put("PERIOD", new Integer(46));
        charKeyRelation.put(".", new Integer(46));
        charKeyRelation.put("SLASH", new Integer(47));
        charKeyRelation.put("/", new Integer(47));
        charKeyRelation.put("SEMICOLON", new Integer(59));
        charKeyRelation.put(";", new Integer(59));
        charKeyRelation.put("EQUALS", new Integer(61));
        charKeyRelation.put("=", new Integer(61));
        charKeyRelation.put("A", new Integer(65));
        charKeyRelation.put("B", new Integer(66));
        charKeyRelation.put("C", new Integer(67));
        charKeyRelation.put("D", new Integer(68));
        charKeyRelation.put("E", new Integer(69));
        charKeyRelation.put("F", new Integer(70));
        charKeyRelation.put("G", new Integer(71));
        charKeyRelation.put("H", new Integer(72));
        charKeyRelation.put("I", new Integer(73));
        charKeyRelation.put("J", new Integer(74));
        charKeyRelation.put("K", new Integer(75));
        charKeyRelation.put("L", new Integer(76));
        charKeyRelation.put("M", new Integer(77));
        charKeyRelation.put("N", new Integer(78));
        charKeyRelation.put("O", new Integer(79));
        charKeyRelation.put("P", new Integer(80));
        charKeyRelation.put("Q", new Integer(81));
        charKeyRelation.put("R", new Integer(82));
        charKeyRelation.put("S", new Integer(83));
        charKeyRelation.put("T", new Integer(84));
        charKeyRelation.put("U", new Integer(85));
        charKeyRelation.put("V", new Integer(86));
        charKeyRelation.put("W", new Integer(87));
        charKeyRelation.put("X", new Integer(88));
        charKeyRelation.put("Y", new Integer(89));
        charKeyRelation.put("Z", new Integer(90));
        charKeyRelation.put("OPEN_BRACKET", new Integer(91));
        charKeyRelation.put("BACK_SLASH", new Integer(92));
        charKeyRelation.put("CLOSE_BRACKET", new Integer(93));
        charKeyRelation.put("NUMPAD0", new Integer(96));
        charKeyRelation.put("NUMPAD1", new Integer(97));
        charKeyRelation.put("NUMPAD2", new Integer(98));
        charKeyRelation.put("NUMPAD3", new Integer(99));
        charKeyRelation.put("NUMPAD4", new Integer(100));
        charKeyRelation.put("NUMPAD5", new Integer(101));
        charKeyRelation.put("NUMPAD6", new Integer(102));
        charKeyRelation.put("NUMPAD7", new Integer(103));
        charKeyRelation.put("NUMPAD8", new Integer(104));
        charKeyRelation.put("NUMPAD9", new Integer(105));
        charKeyRelation.put("MULTIPLY", new Integer(106));
        charKeyRelation.put("ADD", new Integer(107));
        charKeyRelation.put("+", new Integer(107));
        charKeyRelation.put("SEPARATER", new Integer(108));
        charKeyRelation.put("SUBTRACT", new Integer(109));
        charKeyRelation.put("-", new Integer(109));
        charKeyRelation.put("DECIMAL", new Integer(110));
        charKeyRelation.put("DIVIDE", new Integer(111));
        charKeyRelation.put("DELETE", new Integer(127));
        charKeyRelation.put("NUM_LOCK", new Integer(144));
        charKeyRelation.put("SCROLL_LOCK", new Integer(145));
        charKeyRelation.put("PRINTSCREEN", new Integer(154));
        charKeyRelation.put("INSERT", new Integer(155));
        charKeyRelation.put("HELP", new Integer(156));
        charKeyRelation.put("META", new Integer(157));
        charKeyRelation.put("BACK_QUOTE", new Integer(192));
        charKeyRelation.put("QUOTE", new Integer(222));
        charKeyRelation.put("KP_UP", new Integer(224));
        charKeyRelation.put("KP_DOWN", new Integer(225));
        charKeyRelation.put("KP_LEFT", new Integer(226));
        charKeyRelation.put("KP_RIGHT", new Integer(227));
        charKeyRelation.put("DEAD_GRAVE", new Integer(128));
        charKeyRelation.put("DEAD_ACUTE", new Integer(129));
        charKeyRelation.put("DEAD_CIRCUMFLEX", new Integer(130));
        charKeyRelation.put("DEAD_TILDE", new Integer(131));
        charKeyRelation.put("DEAD_MACRON", new Integer(132));
        charKeyRelation.put("DEAD_BREVE", new Integer(133));
        charKeyRelation.put("DEAD_ABOVEDOT", new Integer(134));
        charKeyRelation.put("DEAD_DIAERESIS", new Integer(135));
        charKeyRelation.put("DEAD_ABOVERING", new Integer(136));
        charKeyRelation.put("DEAD_DOUBLEACUTE", new Integer(137));
        charKeyRelation.put("DEAD_CARON", new Integer(138));
        charKeyRelation.put("DEAD_CEDILLA", new Integer(139));
        charKeyRelation.put("DEAD_OGONEK", new Integer(140));
        charKeyRelation.put("DEAD_IOTA", new Integer(141));
        charKeyRelation.put("DEAD_VOICED_SOUND", new Integer(142));
        charKeyRelation.put("DEAD_SEMIVOICED_SOUND", new Integer(143));
        charKeyRelation.put("AMPERSAND", new Integer(150));
        charKeyRelation.put("ASTERISK", new Integer(151));
        charKeyRelation.put("QUOTEDBL", new Integer(152));
        charKeyRelation.put("LESS", new Integer(153));
        charKeyRelation.put("GREATER", new Integer(160));
        charKeyRelation.put("BRACELEFT", new Integer(161));
        charKeyRelation.put("BRACERIGHT", new Integer(162));
        charKeyRelation.put("FINAL", new Integer(24));
        charKeyRelation.put("CONVERT", new Integer(28));
        charKeyRelation.put("NONCONVERT", new Integer(29));
        charKeyRelation.put("ACCEPT", new Integer(30));
        charKeyRelation.put("MODECHANGE", new Integer(31));
        charKeyRelation.put("KANA", new Integer(21));
        charKeyRelation.put("KANJI", new Integer(25));
        charKeyRelation.put("CUT", new Integer(65489));
        charKeyRelation.put("COPY", new Integer(65485));
        charKeyRelation.put("PASTE", new Integer(65487));
        charKeyRelation.put("UNDO", new Integer(65483));
        charKeyRelation.put("AGAIN", new Integer(65481));
        charKeyRelation.put("FIND", new Integer(65488));
        charKeyRelation.put("PROPS", new Integer(65482));
        charKeyRelation.put("STOP", new Integer(65480));
    }
}

