/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Vector;

public class SortedVector
implements Cloneable,
Serializable {
    public static final char ASCENDING = 'a';
    public static final char DESCENDING = 'd';
    protected int capacityIncrement;
    private int size;
    char order = (char)97;
    boolean dup = false;
    Vector vector;

    public SortedVector(int initialCapacity, int capacityIncrement, char order) {
        this.order = order;
        this.capacityIncrement = capacityIncrement;
        this.vector = new Vector(initialCapacity, capacityIncrement);
    }

    public SortedVector(int initialCapacity, int capacityIncrement) {
        this(initialCapacity, capacityIncrement, 'a');
    }

    public SortedVector(int initialCapacity, char order) {
        this(initialCapacity, 0, order);
    }

    public SortedVector(int initialCapacity) {
        this(initialCapacity, 0, 'a');
    }

    public synchronized Object get(int index) {
        return this.vector.get(index);
    }

    public int size() {
        return this.vector.size();
    }

    public synchronized Object[] toArray() {
        return this.vector.toArray();
    }

    public SortedVector(char order) {
        this(10, order);
    }

    public SortedVector() {
        this(10);
    }

    public void setOrder(char order) {
        if (this.order != order) {
            Vector v = new Vector(this.vector.capacity(), this.capacityIncrement);
            int size = this.vector.size();
            for (int i = size - 1; i >= 0; --i) {
                v.insertElementAt(this.vector.elementAt(i), size - i - 1);
            }
            this.vector = v;
            v = null;
            this.order = order;
        }
    }

    public char getOrder() {
        return this.order;
    }

    public boolean getDuplicate() {
        return this.dup;
    }

    public void setDuplicate(boolean dup) {
        this.dup = dup;
    }

    public synchronized void addElement(Object obj) {
        this.add(obj);
    }

    public synchronized boolean add(Object obj) {
        this.vector.ensureCapacity(this.vector.size() + 1);
        this.size = this.vector.size();
        if (this.order == 'a') {
            this.insertAscend((Comparable)obj, this.size / 2);
        } else {
            this.insertDescend((Comparable)obj, this.size / 2);
        }
        return true;
    }

    public Comparable elementAt(int index) throws ArrayIndexOutOfBoundsException {
        return (Comparable)this.vector.elementAt(index);
    }

    public void print(PrintStream out) {
        int size = this.vector.size();
        for (int i = 0; i < size; ++i) {
            out.println(this.vector.elementAt(i));
        }
    }

    private synchronized void insertAscend(Comparable obj, int pos) {
        if (this.size == 0) {
            this.vector.addElement(obj);
        } else {
            int comp = ((Comparable)this.vector.get(pos)).compareTo(obj);
            if (comp == 0) {
                if (this.dup) {
                    this.vector.insertElementAt(obj, pos);
                }
            } else if (pos == 0) {
                if (comp < 0) {
                    this.vector.insertElementAt(obj, pos + 1);
                } else {
                    this.vector.insertElementAt(obj, pos);
                }
            } else if (pos == this.size - 1) {
                if (comp < 0) {
                    this.vector.addElement(obj);
                } else {
                    this.vector.insertElementAt(obj, pos);
                }
            } else if (comp < 0) {
                int comp_1 = ((Comparable)this.vector.get(pos + 1)).compareTo(obj);
                if (comp_1 >= 0) {
                    if (comp_1 > 0) {
                        this.vector.insertElementAt(obj, pos + 1);
                    } else if (this.dup) {
                        this.vector.insertElementAt(obj, pos);
                    }
                } else {
                    this.insertAscend(obj, (this.size + pos) / 2);
                }
            } else {
                int comp_1 = ((Comparable)this.vector.get(pos - 1)).compareTo(obj);
                if (comp_1 <= 0) {
                    if (comp_1 < 0) {
                        this.vector.insertElementAt(obj, pos);
                    } else if (this.dup) {
                        this.vector.insertElementAt(obj, pos);
                    }
                } else {
                    this.insertAscend(obj, pos / 2);
                }
            }
        }
    }

    private synchronized void insertDescend(Comparable obj, int pos) {
        if (this.size == 0) {
            this.vector.addElement(obj);
        } else {
            int comp = ((Comparable)this.vector.get(pos)).compareTo(obj);
            if (comp == 0) {
                if (this.dup) {
                    this.vector.insertElementAt(obj, pos);
                }
            } else if (pos == 0) {
                if (comp > 0) {
                    this.vector.insertElementAt(obj, pos + 1);
                } else {
                    this.vector.insertElementAt(obj, pos);
                }
            } else if (pos == this.size - 1) {
                if (comp > 0) {
                    this.vector.addElement(obj);
                } else {
                    this.vector.insertElementAt(obj, pos);
                }
            } else if (comp > 0) {
                int comp_1 = ((Comparable)this.vector.get(pos + 1)).compareTo(obj);
                if (comp_1 <= 0) {
                    if (comp_1 < 0) {
                        this.vector.insertElementAt(obj, pos + 1);
                    } else if (this.dup) {
                        this.vector.insertElementAt(obj, pos);
                    }
                } else {
                    this.insertDescend(obj, (this.size + pos) / 2);
                }
            } else {
                int comp_1 = ((Comparable)this.vector.get(pos - 1)).compareTo(obj);
                if (comp_1 >= 0) {
                    if (comp_1 > 0) {
                        this.vector.insertElementAt(obj, pos);
                    } else if (this.dup) {
                        this.vector.insertElementAt(obj, pos);
                    }
                } else {
                    this.insertDescend(obj, pos / 2);
                }
            }
        }
    }
}

