/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util;

import com.highqsoft.fwk.FwkException;

public class StringFormat {
    public static final String version = "$Revision: 1.4 $";
    protected static StringFormat instance = null;
    protected static String spaceString;
    private static final int spaceLength = 32;

    public static String getVersion() {
        return version;
    }

    private StringFormat() {
    }

    private static void resizeSpaceString(int length) {
        char[] arr = new char[length];
        for (int i = 0; i < length; ++i) {
            arr[i] = 32;
        }
        spaceString = new String(arr);
    }

    public static boolean isNumeric(char c) {
        return c >= '0' && c <= '9';
    }

    public static String printf(String format, String value) throws FwkException {
        int w = 0;
        int l = 0;
        if (format == null) {
            return "";
        }
        String ret = format;
        int idx = ret.indexOf(37);
        if (idx == -1) {
            return ret;
        }
        while (ret.charAt(idx + 1) == '%') {
            ret = ret.substring(0, idx) + ret.substring(idx + 1);
            idx = ret.indexOf(37, idx + 1);
        }
        if (idx == -1) {
            return ret;
        }
        int start = idx++;
        boolean left = false;
        if (ret.charAt(idx) == ' ') {
            ++idx;
        }
        if (ret.charAt(idx) == '-') {
            left = true;
            ++idx;
        }
        boolean dot = false;
        if (ret.charAt(idx) == '.') {
            dot = true;
            ++idx;
        }
        int lidx = idx;
        if (!dot) {
            while (StringFormat.isNumeric(ret.charAt(lidx))) {
                ++lidx;
            }
            if (lidx != idx) {
                w = new Integer(ret.substring(idx, lidx));
            }
            boolean bl = dot = ret.charAt(lidx) == '.';
            if (dot) {
                ++lidx;
            }
        }
        int sidx = lidx;
        while (StringFormat.isNumeric(ret.charAt(sidx))) {
            ++sidx;
        }
        if (sidx != lidx) {
            l = new Integer(ret.substring(lidx, sidx));
        }
        if (left) {
            w = -1 * w;
        }
        if (ret.charAt(sidx) != 's') {
            throw new FwkException(-2147461529, "$RCSfile: StringFormat.java,v $", StringFormat.getVersion(), "AH 1999-02-06 13:50", format, null, null);
        }
        try {
            ret = ret.substring(0, start) + StringFormat.format(value, w, l) + ret.substring(sidx + 1);
        }
        catch (Throwable t) {
            throw new FwkException(-2147461529, "$RCSfile: StringFormat.java,v $", StringFormat.getVersion(), "AH 1999-02-06 15:01", format, null, t);
        }
        idx = ret.indexOf(37, sidx + 1);
        if (idx >= 0) {
            while (ret.charAt(idx + 1) == '%') {
                ret = ret.substring(0, idx) + ret.substring(idx + 1);
                idx = ret.indexOf(37, idx + 1);
            }
        }
        return ret;
    }

    public static String printf(String format, Integer value) {
        return StringFormat.printf(format, (int)value);
    }

    public static String printf(String format, int value) {
        int w = 0;
        int l = 0;
        if (format == null) {
            return "";
        }
        String ret = format;
        int idx = ret.indexOf(37);
        while (ret.charAt(idx + 1) == '%') {
            ret = ret.substring(0, idx) + ret.substring(idx + 1);
            idx = ret.indexOf(37, idx + 1);
        }
        if (idx == -1) {
            return ret;
        }
        int didx = ret.indexOf(100, idx);
        if (didx == -1) {
            return ret;
        }
        if (didx > idx + 1) {
            String istr;
            if (ret.charAt(idx + 1) == '0') {
                String fstr = "%" + ret.substring(idx + 2, didx) + "s";
                istr = StringFormat.printf(fstr, "" + value).replace(' ', '0');
            } else {
                String fstr = ret.substring(idx, didx) + "s";
                istr = StringFormat.printf(fstr, "" + value);
            }
            return ret.substring(0, idx) + istr + ret.substring(didx + 1);
        }
        ret = ret.substring(0, idx) + StringFormat.format("" + value, w, l) + ret.substring(didx + 1);
        idx = ret.indexOf(37, didx + 1);
        while (ret.charAt(idx + 1) == '%') {
            ret = ret.substring(0, idx) + ret.substring(idx + 1);
            idx = ret.indexOf(37, idx + 1);
        }
        return ret;
    }

    private static String format(String s, int w, int l) {
        if (s == null) {
            s = "";
        }
        if (w == 0 && l == 0) {
            return s;
        }
        boolean left = w < 0;
        int width = Math.abs(w);
        int sLen = s.length();
        int retLen = width != 0 ? Math.max(sLen, width) : l;
        int n = sLen = l == 0 ? sLen : Math.min(l, sLen);
        if (sLen == retLen) {
            return s.substring(0, sLen);
        }
        if (spaceString.length() < width - sLen) {
            StringFormat.resizeSpaceString((int)(1.1 * (double)(width - sLen)));
        }
        if (left) {
            return s.substring(0, sLen) + spaceString.substring(0, width - sLen);
        }
        return spaceString.substring(0, width - sLen) + s.substring(0, sLen);
    }

    public static void main(String[] args) {
        System.out.println("\"12345678901234567890\"");
        System.out.println("\"" + StringFormat.printf("%10s", "Hello, world") + "\"");
        System.out.println("\"12345678901234567890\"");
        System.out.println("\"" + StringFormat.printf("%-10s", "Hello, world") + "\"");
        System.out.println("\"12345678901234567890\"");
        System.out.println("\"" + StringFormat.printf("%20s", "Hello, world") + "\"");
        System.out.println("\"12345678901234567890\"");
        System.out.println("\"" + StringFormat.printf("%-20s", "Hello, world") + "\"");
        System.out.println("\"12345678901234567890\"");
        System.out.println("\"" + StringFormat.printf("%20.10s", "Hello, world") + "\"");
        System.out.println("\"12345678901234567890\"");
        System.out.println("\"" + StringFormat.printf("%-20.10s", "Hello, world") + "\"");
        System.out.println("\"12345678901234567890\"");
        System.out.println("\"" + StringFormat.printf("%.10s", "Hello, world") + "\"");
        System.out.println("\"" + StringFormat.printf("", (String)null) + "\"");
        System.exit(0);
    }

    static {
        StringFormat.resizeSpaceString(32);
    }
}

