/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util;

import com.highqsoft.fwk.FwkPanel;
import com.highqsoft.fwk.FwkThread;
import com.highqsoft.util.graphics.RadialGradientPaint;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.plaf.PanelUI;

public class TrafficLight
extends FwkPanel {
    public static final int SHADOW = 2;
    public static final int RADIUS = 10;
    public static final int PAD = 5;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 0;
    Color shadowColor = Color.gray;
    protected int radius = 10;
    protected int pad = 5;
    protected int shadow = 2;
    protected int orientation = 0;
    protected Vector lights = new Vector();
    protected FlashLight flashLight = null;
    protected static final Object LOCK = new Object();

    public TrafficLight() {
        this.setUI(new TrafficLightUI());
    }

    public TrafficLight(int radius) {
        this();
        this.radius = radius;
        this.pad = radius / 2;
    }

    public void add(Color color) {
        this.add(color, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Color color, boolean on) {
        this.flashStop();
        Object object = LOCK;
        synchronized (object) {
            Light light = new Light(on, color);
            this.lights.add(light);
            int size = this.lights.size();
            if (this.orientation == 0) {
                this.setPreferredSize(new Dimension(2 * this.radius + 2 * this.pad, 2 * size * this.radius + (size + 1) * this.pad));
            } else {
                this.setPreferredSize(new Dimension(2 * size * this.radius + (size + 1) * this.pad, 2 * this.radius + 2 * this.pad));
            }
            this.setMinimumSize(this.getPreferredSize());
            this.revalidate();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnOn(int no) {
        this.flashStop();
        Object object = LOCK;
        synchronized (object) {
            if (no >= 0 && no < this.lights.size()) {
                Light light = (Light)this.lights.get(no);
                light.turnOn(true);
            }
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnOff(int no) {
        this.flashStop();
        Object object = LOCK;
        synchronized (object) {
            if (no >= 0 && no < this.lights.size()) {
                Light light = (Light)this.lights.get(no);
                light.turnOn(false);
            }
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColor(int no, Color color) {
        this.flashStop();
        Object object = LOCK;
        synchronized (object) {
            if (no >= 0 && no < this.lights.size()) {
                Light light = (Light)this.lights.get(no);
                light.setColor(color);
            }
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffColor(int no, Color color) {
        this.flashStop();
        Object object = LOCK;
        synchronized (object) {
            if (no >= 0 && no < this.lights.size()) {
                Light light = (Light)this.lights.get(no);
                light.setOffColor(color);
            }
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flashAll() {
        if (this.flashLight == null) {
            Object object = LOCK;
            synchronized (object) {
                BitSet mark = new BitSet(this.lights.size());
                for (int i = this.lights.size() - 1; i >= 0; --i) {
                    mark.set(i);
                }
                this.flashLight = new FlashLight(mark);
                this.flashLight.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flash(BitSet bitSet) {
        if (this.flashLight != null) {
            this.flashStop();
        }
        if (this.flashLight == null) {
            Object object = LOCK;
            synchronized (object) {
                this.flashLight = new FlashLight(bitSet);
                this.flashLight.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flash(int no) {
        if (this.flashLight != null) {
            this.flashStop();
        }
        if (this.flashLight == null) {
            Object object = LOCK;
            synchronized (object) {
                BitSet mark = new BitSet(this.lights.size());
                mark.set(no);
                this.flashLight = new FlashLight(mark);
                this.flashLight.start();
            }
        }
    }

    public void flashStop() {
        if (this.flashLight != null) {
            this.flashLight.stop();
            this.flashLight = null;
        }
    }

    public void setOrientation(int orientation) {
        int old = this.getOrientation();
        this.orientation = orientation == 0 ? 0 : 1;
        if (this.orientation != old) {
            int size = this.lights.size();
            if (this.getOrientation() == 0) {
                this.setPreferredSize(new Dimension(2 * this.radius + 2 * this.pad, 2 * size * this.radius + (size + 1) * this.pad));
            } else {
                this.setPreferredSize(new Dimension(2 * size * this.radius + (size + 1) * this.pad, 2 * this.radius + 2 * this.pad));
            }
            this.setMinimumSize(this.getPreferredSize());
            this.revalidate();
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("java.vm.version"));
        System.setProperty("java.vm.version", "andy");
        System.out.println(System.getProperty("java.vm.version"));
        JFrame frame = new JFrame();
        TrafficLight tl = new TrafficLight(16);
        tl.setOrientation(1);
        tl.add(Color.red.brighter(), true);
        tl.add(Color.orange, true);
        tl.add(Color.green, true);
        tl.add(new Color(0.5f, 0.7f, 0.9f), false);
        frame.setContentPane(tl);
        frame.pack();
        frame.setVisible(true);
        tl.flash(2);
        try {
            Thread.sleep(3000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        tl.turnOn(3);
        tl.setColor(1, Color.blue);
    }

    public class FlashLight
    extends FwkThread {
        BitSet marked;
        BitSet savedStatus;

        public FlashLight(BitSet marker) {
            this.marked = marker;
            int size = TrafficLight.this.lights.size();
            this.savedStatus = new BitSet(size);
            for (int i = 0; i < size; ++i) {
                Light light = (Light)TrafficLight.this.lights.get(i);
                if (!light.isOn()) continue;
                this.savedStatus.set(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = LOCK;
            synchronized (object) {
                try {
                    while (true) {
                        int size = this.marked.size();
                        for (int i = 0; i < size; ++i) {
                            if (!this.marked.get(i)) continue;
                            Light light = (Light)TrafficLight.this.lights.get(i);
                            if (light.isOn()) {
                                light.turnOn(false);
                                continue;
                            }
                            light.turnOn(true);
                        }
                        TrafficLight.this.repaint();
                        Thread.sleep(500L);
                    }
                }
                catch (Throwable t) {
                    int size = TrafficLight.this.lights.size();
                    for (int i = 0; i < size; ++i) {
                        Light light = (Light)TrafficLight.this.lights.get(i);
                        light.turnOn(this.savedStatus.get(i));
                    }
                }
            }
            TrafficLight.this.repaint();
        }
    }

    public class Light {
        Color color;
        Color offColor = Color.darkGray;
        boolean on;

        public Light(boolean on, Color color) {
            this.on = on;
            this.color = color;
        }

        public void turnOn(boolean on) {
            this.on = on;
        }

        public boolean isOn() {
            return this.on;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void setOffColor(Color color) {
            this.offColor = color;
        }

        public Color getColor() {
            return this.color;
        }

        public Color getOffColor() {
            return this.offColor;
        }

        public void paint(Graphics2D g) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(TrafficLight.this.shadowColor);
            g.fillOval(TrafficLight.this.shadow, TrafficLight.this.shadow, 2 * TrafficLight.this.radius, 2 * TrafficLight.this.radius);
            Rectangle bounds = new Rectangle(0, 0, 2 * TrafficLight.this.radius, 2 * TrafficLight.this.radius);
            Color col = this.on ? this.color : this.offColor;
            RadialGradientPaint paint = new RadialGradientPaint(bounds, col.brighter().brighter(), col.darker());
            g.setPaint(paint);
            g.fillOval(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    public class TrafficLightUI
    extends PanelUI {
        public void paint(Graphics gr, JComponent c) {
            super.paint(gr, c);
            Graphics2D g = (Graphics2D)gr.create();
            g.translate(TrafficLight.this.pad, TrafficLight.this.pad);
            int size = TrafficLight.this.lights.size();
            for (int i = 0; i < size; ++i) {
                Light light = (Light)TrafficLight.this.lights.get(i);
                light.paint((Graphics2D)g.create());
                if (TrafficLight.this.orientation == 0) {
                    g.translate(0, TrafficLight.this.pad + 2 * TrafficLight.this.radius);
                    continue;
                }
                g.translate(TrafficLight.this.pad + 2 * TrafficLight.this.radius, 0);
            }
        }
    }
}

