/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util.graphics;

import com.highqsoft.util.graphics.RadialGradientPaintContext;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public class RadialGradientPaint
implements Paint {
    Color color1;
    Color color2;
    Rectangle2D.Float gradientBounds;
    int transparency;

    public RadialGradientPaint(Rectangle2D bounds, Color color1, Color color2) {
        this.color1 = color1;
        this.color2 = color2;
        this.gradientBounds = new Rectangle2D.Float();
        this.gradientBounds.setRect((float)bounds.getX(), (float)bounds.getY(), (float)bounds.getWidth(), (float)bounds.getHeight());
        int a1 = color1.getAlpha();
        int a2 = color2.getAlpha();
        this.transparency = (a1 & a2) == 255 ? 1 : 3;
    }

    public Color getCenterColor() {
        return this.color1;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform transform, RenderingHints hints) {
        try {
            return new RadialGradientPaintContext(this.gradientBounds, this.color1, this.color2, transform);
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("transform should be invertible");
        }
    }

    public int getTransparency() {
        return this.transparency;
    }
}

