/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util.graphics;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

class RadialGradientPaintContext
implements PaintContext {
    static final int MAX_PRECISION = 256;
    static final float sqStep = 0.003937008f;
    static final float[] sqrtLut;
    static ColorModel xrgbmodel;
    Point2D.Float f1;
    Point2D.Float f2;
    float maInv;
    float e;
    double[] m;
    int[] gradient;
    WritableRaster working;
    ColorModel model;
    Rectangle bounds;
    boolean isCircular = false;
    float maxDistanceSq;

    public RadialGradientPaintContext(Rectangle2D.Float bounds, Color color1, Color color2, AffineTransform t) throws NoninvertibleTransformException {
        float w = bounds.width;
        float h = bounds.height;
        float x = bounds.x;
        float y = bounds.y;
        float a = 0.0f;
        float b = 0.0f;
        if (w > h) {
            a = w / 2.0f;
            b = h / 2.0f;
        } else {
            a = h / 2.0f;
            b = w / 2.0f;
        }
        this.e = (float)Math.sqrt(1.0f - b * b / (a * a));
        this.f1 = new Point2D.Float();
        this.f2 = new Point2D.Float();
        if (w > h) {
            this.f1.x = x + a * (1.0f + this.e);
            this.f1.y = y + b;
            this.f2.x = x + a * (1.0f - this.e);
            this.f2.y = y + b;
        } else {
            this.f1.x = x + b;
            this.f1.y = y + a * (1.0f + this.e);
            this.f2.x = x + b;
            this.f2.y = y + a * (1.0f - this.e);
        }
        this.maInv = 1.0f / (2.0f * a);
        boolean bl = this.isCircular = bounds.width == bounds.height;
        if (this.isCircular) {
            this.maInv = 1.0f / a;
        }
        this.bounds = t.createTransformedShape(bounds).getBounds();
        this.m = new double[6];
        AffineTransform tInv = t.createInverse();
        tInv.getMatrix(this.m);
        int rgb1 = color1.getRGB();
        int rgb2 = color2.getRGB();
        int a1 = rgb1 >> 24 & 0xFF;
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int da = (rgb2 >> 24 & 0xFF) - a1;
        int dr = (rgb2 >> 16 & 0xFF) - r1;
        int dg = (rgb2 >> 8 & 0xFF) - g1;
        int db = (rgb2 & 0xFF) - b1;
        this.model = (rgb1 & rgb2) >>> 24 == 255 ? xrgbmodel : ColorModel.getRGBdefault();
        this.gradient = new int[256];
        int rgb = 0;
        for (int i = 0; i <= 255; ++i) {
            float rel = (float)i / 255.0f;
            this.gradient[i] = rgb = (int)((float)a1 + (float)da * rel) << 24 | (int)((float)r1 + (float)dr * rel) << 16 | (int)((float)g1 + (float)dg * rel) << 8 | (int)((float)b1 + (float)db * rel);
        }
        int gradientMaxIndex = this.gradient.length - 1;
        this.maInv *= (float)gradientMaxIndex;
        Rectangle2D maxBounds = tInv.createTransformedShape(t.createTransformedShape(bounds).getBounds()).getBounds2D();
        this.maxDistanceSq = (float)this.f1.distanceSq(maxBounds.getX(), maxBounds.getY());
        float maxDistance = (float)Math.sqrt(this.maxDistanceSq);
        this.maInv *= maxDistance;
    }

    public void dispose() {
        this.working = null;
    }

    public ColorModel getColorModel() {
        return this.model;
    }

    public Raster getRaster(int x, int y, int w, int h) {
        if (this.working == null || this.working.getWidth() < w || this.working.getHeight() < h) {
            this.working = this.getColorModel().createCompatibleWritableRaster(w, h);
        }
        WritableRaster raster = this.working;
        DataBufferInt rasterDB = (DataBufferInt)raster.getDataBuffer();
        int[] pixels = rasterDB.getBankData()[0];
        int off = rasterDB.getOffset();
        int scanlineStride = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int adjust = scanlineStride - w;
        if (!this.isCircular) {
            this.fillRasterEllipse(pixels, off, adjust, x, y, w, h);
        } else {
            this.fillRasterDisc(pixels, off, adjust, x, y, w, h);
        }
        return raster;
    }

    void fillRasterEllipse(int[] pixels, int off, int adjust, int x, int y, int w, int h) {
        int rgb = 0;
        int x2 = this.bounds.x + this.bounds.width;
        int y2 = this.bounds.y + this.bounds.height;
        int rowLimit = x + w;
        int lLimit = 0;
        int rLimit = 0;
        int startOff = 0;
        float g = 0.0f;
        int j = 0;
        float X = 0.0f;
        float Y = 0.0f;
        float a00 = (float)this.m[0];
        float a10 = (float)this.m[1];
        float a01 = (float)this.m[2];
        float a11 = (float)this.m[3];
        float a02 = (float)this.m[4];
        float a12 = (float)this.m[5];
        float dX1 = 0.0f;
        float dY1 = 0.0f;
        float dX2 = 0.0f;
        float dY2 = 0.0f;
        float eComp = 1.0f - this.e;
        float maxGradientIndex = this.gradient.length - 1;
        float eMaxGradientIndex = this.e * maxGradientIndex;
        float sqrt1 = 0.0f;
        float sqrt2 = 0.0f;
        float d1Sq = 0.0f;
        float d2Sq = 0.0f;
        float iSq1 = 0.0f;
        float iSq2 = 0.0f;
        int iSq1Int = 0;
        int iSq2Int = 0;
        float p = 0.0f;
        for (int i = 0; i < h; ++i) {
            rowLimit = off + w;
            if (i + y < this.bounds.y || i + y > y2 || x + w < this.bounds.x || x > x2) {
                rgb = this.gradient[255];
                while (off < rowLimit) {
                    pixels[off++] = rgb;
                }
            } else {
                startOff = off;
                rgb = this.gradient[255];
                lLimit = off + this.bounds.x - x;
                rLimit = lLimit + this.bounds.width;
                int n = rLimit = rLimit > rowLimit ? rowLimit : rLimit;
                while (off < lLimit) {
                    pixels[off++] = rgb;
                }
                j = x + off - startOff;
                X = a00 * (float)j + a01 * (float)(y + i) + a02;
                Y = a10 * (float)j + a11 * (float)(y + i) + a12;
                dX1 = this.f1.x - X;
                dY1 = this.f1.y - Y;
                dX2 = this.f2.x - X;
                dY2 = this.f2.y - Y;
                while (off < rLimit) {
                    d1Sq = (dX1 * dX1 + dY1 * dY1) / this.maxDistanceSq;
                    d2Sq = (dX2 * dX2 + dY2 * dY2) / this.maxDistanceSq;
                    if (d1Sq < 0.003937008f) {
                        sqrt1 = (float)Math.sqrt(d1Sq);
                    } else {
                        iSq1 = d1Sq / 0.003937008f;
                        iSq1Int = (int)iSq1;
                        p = iSq1 - (float)iSq1Int;
                        sqrt1 = p * sqrtLut[iSq1Int + 1] + (1.0f - p) * sqrtLut[iSq1Int];
                    }
                    if (d2Sq < 0.003937008f) {
                        sqrt2 = (float)Math.sqrt(d2Sq);
                    } else {
                        iSq2 = d2Sq / 0.003937008f;
                        iSq2Int = (int)iSq2;
                        p = iSq2 - (float)iSq2Int;
                        sqrt2 = p * sqrtLut[iSq2Int + 1] + (1.0f - p) * sqrtLut[iSq2Int];
                    }
                    g = (this.maInv * (sqrt1 + sqrt2) - eMaxGradientIndex) / eComp;
                    g = g > maxGradientIndex ? maxGradientIndex : g;
                    g = g < 0.0f ? 0.0f : g;
                    pixels[off++] = this.gradient[(int)g];
                    dX1 -= a00;
                    dX2 -= a00;
                    dY1 -= a10;
                    dY2 -= a10;
                }
                rgb = this.gradient[255];
                while (off < rowLimit) {
                    pixels[off++] = rgb;
                }
            }
            off += adjust;
        }
    }

    void fillRasterDisc(int[] pixels, int off, int adjust, int x, int y, int w, int h) {
        int rgb = 0;
        int x2 = this.bounds.x + this.bounds.width;
        int y2 = this.bounds.y + this.bounds.height;
        int rowLimit = x + w;
        int lLimit = 0;
        int rLimit = 0;
        int startOff = 0;
        float g = 0.0f;
        int j = 0;
        float X = 0.0f;
        float Y = 0.0f;
        float a00 = (float)this.m[0];
        float a10 = (float)this.m[1];
        float a01 = (float)this.m[2];
        float a11 = (float)this.m[3];
        float a02 = (float)this.m[4];
        float a12 = (float)this.m[5];
        float dX = 0.0f;
        float dY = 0.0f;
        float maxGradientIndex = this.gradient.length - 1;
        float sqrt = 0.0f;
        float dSq = 0.0f;
        float iSq = 0.0f;
        int iSqInt = 0;
        float p = 0.0f;
        for (int i = 0; i < h; ++i) {
            rowLimit = off + w;
            if (i + y < this.bounds.y || i + y > y2 || x + w < this.bounds.x || x > x2) {
                rgb = this.gradient[(int)maxGradientIndex];
                while (off < rowLimit) {
                    pixels[off++] = rgb;
                }
            } else {
                startOff = off;
                rgb = this.gradient[(int)maxGradientIndex];
                lLimit = off + this.bounds.x - x;
                rLimit = lLimit + this.bounds.width;
                int n = rLimit = rLimit > rowLimit ? rowLimit : rLimit;
                while (off < lLimit) {
                    pixels[off++] = rgb;
                }
                j = x + off - startOff;
                X = a00 * (float)j + a01 * (float)(y + i) + a02;
                Y = a10 * (float)j + a11 * (float)(y + i) + a12;
                dX = this.f1.x - X;
                dY = this.f1.y - Y;
                while (off < rLimit) {
                    dSq = (dX * dX + dY * dY) / this.maxDistanceSq;
                    if (dSq < 0.003937008f) {
                        sqrt = (float)Math.sqrt(dSq);
                    } else {
                        iSq = dSq / 0.003937008f;
                        iSqInt = (int)iSq;
                        p = iSq - (float)iSqInt;
                        sqrt = p * sqrtLut[iSqInt + 1] + (1.0f - p) * sqrtLut[iSqInt];
                    }
                    g = this.maInv * sqrt;
                    g = g > maxGradientIndex ? maxGradientIndex : g;
                    g = g < 0.0f ? 0.0f : g;
                    pixels[off++] = this.gradient[(int)g];
                    dX -= a00;
                    dY -= a10;
                }
                rgb = this.gradient[(int)maxGradientIndex];
                while (off < rowLimit) {
                    pixels[off++] = rgb;
                }
            }
            off += adjust;
        }
    }

    static {
        int i;
        sqrtLut = new float[256];
        for (i = 0; i < 255; ++i) {
            RadialGradientPaintContext.sqrtLut[i] = (float)Math.sqrt((float)i * 0.003937008f);
        }
        RadialGradientPaintContext.sqrtLut[i] = sqrtLut[i - 1];
        xrgbmodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    }
}

