/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util.lmsascii;

import com.highqsoft.fwk.FwkColumnAccess;
import com.highqsoft.fwk.FwkColumnAccessGroup;
import com.highqsoft.fwk.FwkColumnAccessProducer;
import com.highqsoft.fwk.FwkColumnDataObserver;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkFileFilter;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkPropertyGroup;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkColumnDataObserverInterface;
import com.highqsoft.interfaces.fwk.FwkReadColumnsFromStreamInterface;
import com.highqsoft.util.lmsascii.FloatDataObserver;
import com.highqsoft.util.lmsascii.IntDataObserver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Iterator;

public class LMSAscii
extends FwkFileFilter
implements FwkReadColumnsFromStreamInterface {
    public static final String PSD_MIME = "application/x-vnd.lms-powerspectraldensity";
    public static final String FFT_MIME = "application/x-vnd.lms-fouriertransform";
    public static final String RFM_MIME = "application/x-vnd.lms-rainflowmatrix";
    public static final String TL_MIME = "application/x-vnd.lms-timelevel";
    public static final String MATAL_MIME = "application/x-vnd.lms-matal";
    public static final String TS_MIME = "application/x-vnd.lms-timeseries";
    public static final String MIME_KEY = "mimetype";
    String spec;
    String path;
    String name;
    FwkPropertyGroup group = new FwkPropertyGroup();

    public LMSAscii() {
    }

    public LMSAscii(String spec) throws IOException, FileNotFoundException {
        this();
        this.read(spec);
    }

    protected void read(String spec) throws IOException, FileNotFoundException {
        this.spec = spec;
        File file = new File(spec);
        if (!file.exists()) {
            URL url;
            InputStream is = null;
            try {
                url = new URL(spec);
                is = url.openStream();
            }
            catch (Throwable t) {
                url = LMSAscii.class.getResource(spec);
                is = url.openStream();
            }
            this.path = url.getPath();
            this.name = url.getFile();
            this.read(is);
        } else {
            this.path = file.getAbsolutePath();
            this.name = file.getName();
            this.read(new FileInputStream(file));
        }
        int index = this.name.lastIndexOf(46);
        if (index > 0) {
            this.name = this.name.substring(0, index);
        }
    }

    public FwkColumnAccessInterface[] read(InputStream is) throws IOException, FileNotFoundException {
        String[] units;
        String[] val;
        String line;
        LineNumberReader in = new LineNumberReader(new InputStreamReader(is));
        FwkColumnDataObserver[] arr = null;
        String[] columnNames = null;
        boolean insideHeader = true;
        int colCount = 0;
        int rowCount = 0;
        while ((line = in.readLine()) != null) {
            int i;
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#' || line.charAt(0) == ';') continue;
            if (insideHeader) {
                if (line.toUpperCase().startsWith("BEGIN")) {
                    this.group.setProperty("TYPE", "???");
                    continue;
                }
                if (line.compareToIgnoreCase("END") == 0) {
                    insideHeader = false;
                    continue;
                }
                int idx = line.indexOf(61);
                if (idx < 0) {
                    idx = line.indexOf(58);
                }
                if (idx > 0) {
                    this.group.setProperty(line.substring(0, idx).trim().toUpperCase(), line.substring(idx + 1, line.length()).trim());
                    continue;
                }
                if (line.compareToIgnoreCase("Rainflow") == 0) {
                    insideHeader = false;
                    this.group.setProperty(MIME_KEY, RFM_MIME);
                    continue;
                }
                System.err.println(this.name + ".asc Syntax error in line " + in.getLineNumber());
                continue;
            }
            val = line.split("\\s+");
            if (colCount == 0) {
                colCount = val.length;
                arr = new FwkColumnDataObserver[colCount];
                for (i = 0; i < colCount; ++i) {
                    arr[i] = val[i].indexOf(46) < 0 ? new IntDataObserver() : new FloatDataObserver();
                }
            }
            if (colCount != val.length) {
                int i2;
                if (this.group.getProperty(MIME_KEY, "").equals(RFM_MIME)) {
                    if (line.toUpperCase().indexOf("RESI") >= 0) {
                        FwkColumnDataObserver[] tmp = new FwkColumnDataObserver[colCount + 2];
                        System.arraycopy(arr, 0, tmp, 0, colCount);
                        arr = tmp;
                        arr[colCount] = new IntDataObserver();
                        arr[colCount + 1] = new IntDataObserver();
                        rowCount = 0;
                        String[] sTmp = new String[colCount + 2];
                        System.arraycopy(columnNames, 0, sTmp, 0, colCount);
                        columnNames = sTmp;
                        columnNames[colCount] = val[0] + "_from";
                        columnNames[colCount + 1] = val[0] + "_to";
                        continue;
                    }
                    try {
                        arr[colCount].setValueAt(rowCount++, Integer.parseInt(val[0].replace(';', ' ')));
                        arr[colCount + 1].setValueAt(rowCount++, Integer.parseInt(val[1].replace(';', ' ')));
                    }
                    catch (Throwable tNumber) {
                        System.err.println(this.name + ".asc wrong number format in line (" + line + ")" + in.getLineNumber());
                    }
                    continue;
                }
                int valSize = val.length;
                for (i2 = 0; i2 < valSize; ++i2) {
                    try {
                        arr[i2].setValueAt(rowCount, Float.parseFloat(val[i2].replace(';', ' ')));
                        continue;
                    }
                    catch (Throwable tFloat) {
                        arr[i2].setValueAt(rowCount, 0.0);
                        arr[i2].setFlagAt(rowCount, (short)0);
                    }
                }
                while (i2 < colCount) {
                    arr[i2].setValueAt(rowCount, 0.0);
                    arr[i2].setFlagAt(rowCount, (short)0);
                    ++i2;
                }
                ++rowCount;
                continue;
            }
            try {
                for (i = 0; i < colCount; ++i) {
                    arr[i].setValueAt(rowCount, Float.parseFloat(val[i].replace(';', ' ')));
                }
                ++rowCount;
            }
            catch (Throwable tFloat) {
                if (rowCount == 0) {
                    columnNames = val;
                    continue;
                }
                System.err.println(this.name + ".asc Syntax error in line " + in.getLineNumber());
            }
        }
        if (columnNames == null) {
            line = this.group.getProperty("CHANNELNAME", (String)null);
            if (line != null) {
                columnNames = line.substring(2, line.length() - 2).split("','");
            } else {
                columnNames = new String[arr.length];
                for (int i = 0; i < arr.length; ++i) {
                    columnNames[i] = "Column " + i;
                }
            }
        }
        if ((line = this.group.getProperty("UNIT", (String)null)) != null) {
            units = line.substring(2, line.length() - 2).split("','");
        } else {
            units = new String[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                units[i] = "Unit " + i;
            }
        }
        FwkColumnAccessInterface[] ret = new FwkColumnAccessInterface[arr.length];
        if (this.spec == null || this.spec.length() == 0) {
            this.spec = this.name;
        }
        for (int i = 0; i < arr.length; ++i) {
            ret[i] = new LMSAsciiColumn(this.spec + "[" + columnNames[i] + "]", columnNames[i], units[i], arr[i]);
        }
        Iterator<Object> it = this.group.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            line = this.group.getProperty(key, "");
            if (!line.startsWith("[") || !line.endsWith("]")) continue;
            val = line.substring(1, line.length() - 1).split(",");
            for (int j = 0; j < val.length; ++j) {
                ret[j].setProperty(key, val[j]);
            }
        }
        return ret;
    }

    public FwkColumnAccessInterface[] read(String spec, InputStream is) throws FwkException {
        try {
            FwkColumnAccessInterface[] ret;
            this.name = spec;
            this.spec = spec;
            int index = spec.lastIndexOf(46);
            if (index > 0) {
                this.name = spec.substring(0, index);
            }
            if ((ret = this.read(is)) != null && ret.length != 0) {
                FwkColumnAccessGroup colGroup = new FwkColumnAccessGroup(spec, this.name);
                Iterator<Object> it = this.group.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    colGroup.setProperty(key, this.group.getProperty(key));
                }
                String type = this.group.getProperty(MIME_KEY, (String)null);
                if (type == null || type.length() == 0 || type.equals("???")) {
                    if (ret.length == 2 && ret[0].getColumnName().toUpperCase().endsWith(".PHA") && ret[1].getColumnName().toUpperCase().endsWith(".AMP")) {
                        colGroup.setProperty(MIME_KEY, FFT_MIME);
                    } else if (ret.length == 1 && ret[0].getColumnName().toUpperCase().endsWith(".PSD")) {
                        colGroup.setProperty(MIME_KEY, PSD_MIME);
                    }
                } else {
                    colGroup.setProperty(MIME_KEY, type);
                }
                int count = ret.length;
                for (int i = 0; i < count; ++i) {
                    colGroup.addChild(ret[i]);
                    FwkColumnAccessProducer.add(colGroup);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new FwkException(-1073676289, "$RCSfile: LMSAscii.java,v $", "$revision$", "AH 2002-05-03 15:02", "Cannot read UB header " + spec, this, t);
        }
    }

    public boolean accept(File f) {
        boolean ret = false;
        if (f != null && !(ret = f.isDirectory())) {
            ret = "asc".compareToIgnoreCase(this.getExtension(f)) == 0 || "emtl".compareToIgnoreCase(this.getExtension(f)) == 0;
        }
        return ret;
    }

    public String getDescription() {
        return FwkPropertyBus.getProperty("LMSAscii.Text.Description") + " (*.asc)";
    }

    public String toString() {
        return this.group.toString();
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        try {
            LMSAscii lms = new LMSAscii("race1_tal_FORCE_vert.asc");
            System.out.println(lms);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.exit(0);
    }

    public class LMSAsciiColumn
    extends FwkColumnAccess {
        public LMSAsciiColumn(String name, String columnName, String unit, FwkColumnDataObserverInterface observer) {
            super(name, columnName, unit, observer);
        }

        public String getShortName() {
            return this.getColumnName();
        }
    }
}

