/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util.rpciii;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkColumnAccess;
import com.highqsoft.fwk.FwkColumnAccessGroup;
import com.highqsoft.fwk.FwkColumnDataObserverDouble;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataBus;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkInfoBusProducer;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.util.rpciii.RpcIIIColumnAccess;
import com.highqsoft.util.rpciii.RpcIIIDataObserver;
import com.highqsoft.util.rpciii.RpcIIIFileDataObserver;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.infobus.DataItem;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusItemRequestedEvent;

public class RpcIIIColumnProducer
extends FwkInfoBusProducer {
    public static final String version = "$Revision: 1.5 $";
    private static RpcIIIColumnProducer singleInstance;
    private HashMap elementHash = new HashMap();
    private HashMap columnHash = new HashMap();
    private HashMap vmHash = new HashMap();

    public String getVersion() {
        return version;
    }

    private RpcIIIColumnProducer() {
        super("RpcIIIColumnProducer@" + FwkDataBus.BUSNAME, FwkContainer.getFwkMimeTypes(FwkColumnAccessInterface.class));
    }

    public static synchronized RpcIIIColumnProducer getInstance() {
        if (singleInstance == null) {
            singleInstance = new RpcIIIColumnProducer();
        }
        return singleInstance;
    }

    public boolean revoke(String itemName, DataFlavor[] flavor) {
        if (itemName == null) {
            return true;
        }
        if (this.isAssignable(flavor)) {
            if (itemName.indexOf(63) == -1 && itemName.indexOf(42) == -1) {
                DataItem item = (DataItem)this.elementHash.remove(itemName);
                if (item != null) {
                    item.release();
                    this.fireItemRevoked(item);
                }
                if ((item = (DataItem)this.columnHash.remove(itemName)) != null) {
                    item.release();
                    this.fireItemRevoked(item);
                }
            } else {
                Object[] arr = this.findMultipleDataItems(itemName, flavor);
                if (arr != null && arr.length != 0) {
                    String name;
                    FwkArray vmArr = new FwkArray();
                    for (int i = arr.length; i >= 0; --i) {
                        DataItem item;
                        if (arr[i] instanceof ColumnGroup && this.elementHash.containsValue(arr[i])) {
                            Iterator it = this.elementHash.keySet().iterator();
                            boolean found = false;
                            while (!found && it.hasNext()) {
                                name = (String)it.next();
                                found = arr[i].equals(this.elementHash.get(name));
                                if (!found) continue;
                                vmArr.add(name);
                            }
                            continue;
                        }
                        if (!(arr[i] instanceof FwkColumnAccessInterface) || (item = (DataItem)this.columnHash.remove(name = ((FwkColumnAccessInterface)arr[i]).getName())) == null) continue;
                        item.release();
                        this.fireItemRevoked(item);
                    }
                    int size = vmArr.size();
                    for (int i = 0; i < size; ++i) {
                        name = (String)vmArr.get(i);
                        this.fireItemRevoked((DataItem)this.elementHash.remove(name));
                    }
                }
            }
        }
        return true;
    }

    public static FwkColumnAccessInterface readFile(String fileSpec) {
        return RpcIIIColumnProducer.getInstance().add(fileSpec, false);
    }

    public static FwkColumnAccessInterface addFile(String fileSpec) {
        return RpcIIIColumnProducer.getInstance().add(fileSpec, true);
    }

    public FwkColumnAccessInterface add(String fileSpec, boolean publish) {
        InfoBus ib = this.getInfoBus();
        ColumnGroup group = null;
        if (ib != null && fileSpec != null) {
            RpcIIIFileDataObserver observer = null;
            try {
                observer = new RpcIIIFileDataObserver(fileSpec);
                this.elementHash.put(fileSpec, observer);
            }
            catch (Throwable tHdr) {
                throw new FwkException(-1073676289, "$RCSfile: RpcIIIColumnProducer.java,v $", version, "AH 2003-10-06 13:10", "Cannot read header from file <" + fileSpec + ">.", this, tHdr);
            }
            try {
                File file = new File(fileSpec);
                group = new ColumnGroup(file);
                group.setProperty("InfoBusSource", this);
                this.vmHash.put(group.getName(), group);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                FwkColumnAccess column;
                int len = observer.getCHANNELS();
                for (int i = 0; i < len; ++i) {
                    column = new RpcIIIColumnAccess(this, observer, i);
                    if (publish) {
                        this.columnHash.put(column.getName(), column);
                        this.fireItemAvailable(column, FwkContainer.getDataFlavors(class$com$highqsoft$interfaces$fwk$FwkColumnAccessInterface == null ? RpcIIIColumnProducer.class$("com.highqsoft.interfaces.fwk.FwkColumnAccessInterface") : class$com$highqsoft$interfaces$fwk$FwkColumnAccessInterface));
                    }
                    if (group == null) continue;
                    group.addChild(column);
                }
                column = new TimeColumn(fileSpec);
                if (publish) {
                    this.columnHash.put(column.getName(), column);
                    this.fireItemAvailable(column, FwkContainer.getDataFlavors(FwkColumnAccessInterface.class));
                }
                if (group != null) {
                    group.addChild(column);
                }
                if (publish && group != null) {
                    this.fireItemAvailable(group, FwkContainer.getDataFlavors(FwkColumnAccessInterface.class));
                }
            }
            catch (Throwable e) {
                throw new FwkException(-1073676289, "$RCSfile: RpcIIIColumnProducer.java,v $", version, "AH 1999-14-04 11:55", null, this, e);
            }
        }
        return group;
    }

    public static String createDataItemName(String filename, String columnName, String columnNumber) {
        if (columnNumber != null) {
            return filename + "/" + columnName + "#" + columnNumber;
        }
        return filename + "/" + columnName;
    }

    public static String getItemShortName(String name) {
        String ret = name;
        int index = name.lastIndexOf(93);
        if (index > -1) {
            int crossIndex = name.indexOf(35, index);
            if (crossIndex < 0) {
                crossIndex = name.indexOf(41, index);
            }
            boolean isColumnName = crossIndex > 0;
            boolean isSM = false;
            try {
                if (isColumnName) {
                    Integer.parseInt(name.substring(index + 1, crossIndex));
                } else {
                    Integer.parseInt(name.substring(index + 1, name.length()));
                }
                isSM = true;
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (isSM) {
                int idx = name.lastIndexOf(91);
                name = name.substring(0, idx) + name.substring(index + 1, name.length());
                ret = RpcIIIColumnProducer.getItemShortName(name);
            } else {
                ret = name.indexOf("VM(") == 0 && name.endsWith(")") ? "VM(" + name.substring(index + 1, name.length()) : name.substring(index + 1, name.length());
            }
        }
        return ret;
    }

    public static String getColumnName(String dataItemName) {
        int sep1 = dataItemName.lastIndexOf(47);
        int sep2 = dataItemName.lastIndexOf(35);
        return sep1 >= 0 && sep2 > 0 ? dataItemName.substring(sep1 + 1, sep2) : null;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        System.out.println("%TestDataProducer: propertyChange(PropertyChangeEvent ev)");
        System.out.println(ev.toString());
    }

    public void dataItemRequested(InfoBusItemRequestedEvent ev) {
        String dataItemName;
        super.dataItemRequested(ev);
        if (ev.getDataItem() == null && (dataItemName = ev.getDataItemName()) != null && this.isAssignable(ev.getDataFlavors())) {
            if (dataItemName.indexOf(42) != -1 || dataItemName.indexOf(63) != -1) {
                Object dataItem;
                String itemName;
                FwkArray dataItemArray = new FwkArray();
                Iterator it = this.columnHash.keySet().iterator();
                while (it.hasNext()) {
                    itemName = (String)it.next();
                    if (!Pattern.match(itemName, dataItemName, true)) continue;
                    dataItem = this.columnHash.get(itemName);
                    if (dataItem != null) {
                        dataItemArray.add(dataItem);
                        continue;
                    }
                    FwkContainer.debug(5, "   RpcIIIColumnProducer: Requested data item not found: " + dataItemName);
                }
                it = this.vmHash.keySet().iterator();
                while (it.hasNext()) {
                    itemName = (String)it.next();
                    if (!Pattern.match(itemName, dataItemName, true)) continue;
                    dataItem = this.vmHash.get(itemName);
                    if (dataItem != null) {
                        dataItemArray.add(dataItem);
                        continue;
                    }
                    FwkContainer.debug(5, "   RpcIIIColumnProducer: Requested data item not found: " + dataItemName);
                }
                if (dataItemArray.size() > 0) {
                    ev.setDataItem((Object)dataItemArray.toArray(new FwkColumnAccessInterface[dataItemArray.size()]));
                }
            } else if (this.columnHash.containsKey(dataItemName)) {
                ev.setDataItem(this.columnHash.get(dataItemName));
            } else if (this.vmHash.containsKey(dataItemName)) {
                ev.setDataItem(this.vmHash.get(dataItemName));
            }
        }
    }

    public void remove(String fileSpec) {
        InfoBus ib = this.getInfoBus();
        if (ib != null && fileSpec != null) {
            RpcIIIFileDataObserver observer = null;
            try {
                observer = (RpcIIIFileDataObserver)this.elementHash.remove(fileSpec);
            }
            catch (Throwable tHdr) {
                throw new FwkException(-1073676289, "$RCSfile: RpcIIIColumnProducer.java,v $", version, "AH 2003-10-06 13:10", "Cannot read header from file <" + fileSpec + ">.", this, tHdr);
            }
            if (observer != null) {
                ColumnGroup group = null;
                try {
                    File file = new File(fileSpec);
                    group = new ColumnGroup(file);
                    this.vmHash.remove(group.getName());
                    if (group != null) {
                        this.fireItemAvailable(group, FwkContainer.getDataFlavors(FwkColumnAccessInterface.class));
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    int len = observer.getCHANNELS();
                    for (int i = 0; i < len; ++i) {
                        String dataItemName = RpcIIIColumnProducer.createDataItemName(observer.getIdent(), observer.getChannelName(i), observer.getChannelNumber(i));
                        RpcIIIColumnAccess column = (RpcIIIColumnAccess)this.columnHash.remove(dataItemName);
                        this.fireItemRevoked(column);
                    }
                }
                catch (Throwable e) {
                    throw new FwkException(-1073676289, "$RCSfile: RpcIIIColumnProducer.java,v $", version, "AH 1999-14-04 11:55", null, this, e);
                }
            }
        }
    }

    protected class TimeColumn
    extends FwkColumnAccess {
        public TimeColumn(String fileSpec) {
            super(RpcIIIColumnProducer.createDataItemName(fileSpec, "Time", null), "Time", "s", new Time(fileSpec));
            this.shortName = "Time";
            this.setTitleName(this.shortName);
        }

        public boolean isIndependent() {
            return true;
        }
    }

    protected class Time
    extends FwkColumnDataObserverDouble {
        String fileSpec;
        double dt;

        public Time(String fileSpec) {
            this.fileSpec = fileSpec;
            RpcIIIDataObserver observer = (RpcIIIDataObserver)RpcIIIColumnProducer.this.elementHash.get(fileSpec);
            this.dt = observer.getDELTA_T();
        }

        public int getCount() {
            try {
                RpcIIIDataObserver observer = (RpcIIIDataObserver)RpcIIIColumnProducer.this.elementHash.get(this.fileSpec);
                return observer.getChannelLength();
            }
            catch (Throwable t) {
                return 0;
            }
        }

        public short getFlagAt(int i) {
            return 15;
        }

        public short[] getFlags() {
            RpcIIIDataObserver observer = (RpcIIIDataObserver)RpcIIIColumnProducer.this.elementHash.get(this.fileSpec);
            try {
                short[] ret = new short[observer.getChannelLength()];
                Arrays.fill(ret, (short)15);
                return ret;
            }
            catch (Throwable t) {
                return new short[0];
            }
        }

        public double getValueAt(int i) {
            return this.dt * (double)i;
        }

        public double[] getValues() {
            double[] ret;
            RpcIIIDataObserver observer = (RpcIIIDataObserver)RpcIIIColumnProducer.this.elementHash.get(this.fileSpec);
            try {
                int len = observer.getChannelLength();
                ret = new double[len];
                for (int i = 0; i < len; ++i) {
                    ret[i] = this.getValueAt(i);
                }
            }
            catch (Throwable t) {
                ret = new double[]{};
            }
            return ret;
        }

        public void setFlagAt(int index, short flag) {
        }

        public void setValueAt(int index, double value) {
        }
    }

    protected class ColumnGroup
    extends FwkColumnAccessGroup {
        public ColumnGroup(File file) {
            super(file.getAbsolutePath(), file.getName());
            this.shortName = this.columnName;
        }
    }
}

