/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util.rpciii;

import com.highqsoft.util.rpciii.RpcIIIDataObserver;
import com.highqsoft.util.rpciii.RpcIIIHeader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.text.ParsePosition;
import java.util.Date;

public class RpcIIIFileDataObserver
extends RpcIIIDataObserver {
    private Object bufferLock = new Object();
    protected static final int VALUE_SIZE = 2;
    protected String filename;
    protected RpcIIIHeader hdr;
    protected RandomAccessFile raf;
    protected int position;
    protected int offset;
    protected int blockSize;
    protected int pts_per_frame;
    protected int pts_per_group;
    protected double[] scale;
    protected Object[] valScale;
    int channelLength;
    protected FileChannel fileChannel;
    protected MappedByteBuffer mappedByteBuffer;
    protected Buffer buffer;
    protected int currentBlockOffset;

    protected void finalize() throws Throwable {
        super.finalize();
        this.raf.close();
    }

    public RpcIIIFileDataObserver(String fileSpec) throws IOException {
        this.hdr = new RpcIIIHeader(fileSpec);
        this.filename = fileSpec;
        this.initializeFile();
        this.offset = Integer.parseInt(this.hdr.getNUM_HEADER_BLOCKS()) * 512;
        this.pts_per_frame = Integer.parseInt(this.hdr.getPTS_PER_FRAME());
        this.pts_per_group = Integer.parseInt(this.hdr.getPTS_PER_GROUP());
        this.blockSize = this.pts_per_group * this.getDataSizeInByte();
        this.position = -1;
        this.channelLength = -1;
        this.currentBlockOffset = -1;
    }

    public String getIdent() {
        return this.filename;
    }

    public boolean getBYPASS_FILTER() {
        char c = this.hdr.getBYPASS_FILTER().charAt(0);
        return c == '1' || c == 't' || c == 'w';
    }

    public int getCHANNELS() {
        try {
            return Integer.parseInt(this.hdr.getCHANNELS());
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public String getDATA_TYPE() {
        return RpcIIIHeader.DATA_TYPE[0];
    }

    public Date getDATE() {
        return RpcIIIHeader.DATE_FORMATTER.parse(this.hdr.getDATE(), new ParsePosition(0));
    }

    public double getDELTA_T() {
        try {
            return Double.parseDouble(this.hdr.getDELTA_T());
        }
        catch (Throwable t) {
            return 1.0;
        }
    }

    public String getFILE_TYPE() {
        return this.hdr.getFILE_TYPE();
    }

    public String getFORMAT() {
        return this.hdr.getFORMAT();
    }

    public int getFRAMES() {
        try {
            return Integer.parseInt(this.hdr.getFRAMES());
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public boolean getHALF_FRAMES() {
        char c = this.hdr.getHALF_FRAMES().charAt(0);
        return c == '1' || c == 't' || c == 'w';
    }

    public int getINT_FULL_SCALE() {
        try {
            return Integer.parseInt(this.hdr.getINT_FULL_SCALE());
        }
        catch (Throwable t) {
            return Short.MAX_VALUE;
        }
    }

    public String getOPERATION() {
        return this.hdr.getOPERATION();
    }

    public int getPARTITIONS() {
        try {
            return Integer.parseInt(this.hdr.getPARTITIONS());
        }
        catch (Throwable t) {
            return 1;
        }
    }

    public int getREPEATS() {
        try {
            return Integer.parseInt(this.hdr.getREPEATS());
        }
        catch (Throwable t) {
            return 1;
        }
    }

    public String getTIME_TYPE() {
        return this.hdr.getTIME_TYPE();
    }

    public int getPTS_PER_FRAME() {
        return this.pts_per_frame;
    }

    public int getPTS_PER_GROUP() {
        return this.pts_per_group;
    }

    public String[] getPARENT() {
        return this.hdr.getPARENT();
    }

    public String[] getDescription() {
        return this.hdr.getDescription();
    }

    public double[] getScale() {
        if (this.scale == null) {
            this.scale = this.hdr.getScale();
        }
        return this.scale;
    }

    public double getScale(int index) {
        return this.getScale()[index];
    }

    public double[] getLowerLimit() {
        return this.hdr.getLowerLimit();
    }

    public double getLowerLimit(int index) {
        return this.getLowerLimit()[index];
    }

    public double[] getUpperLimit() {
        return this.hdr.getUpperLimit();
    }

    public double getUpperLimit(int index) {
        return this.getUpperLimit()[index];
    }

    public String[] getChannelNumber() {
        return this.hdr.getChannelNumber();
    }

    public String getChannelNumber(int index) {
        return this.hdr.getChannelNumber(index);
    }

    public String[] getChannelName() {
        return this.hdr.getChannelName();
    }

    public String getChannelName(int index) {
        return this.hdr.getChannelName(index);
    }

    public String[] getUnit() {
        return this.hdr.getUnit();
    }

    public String getUnit(int channel) {
        return this.hdr.getUnit()[channel];
    }

    public String[] getPartitionChannel() {
        return this.hdr.getPartitionChannel();
    }

    public String[] getPartitionNChannel() {
        return this.hdr.getPartitionNChannel();
    }

    public String[] getChannelMap() {
        return this.hdr.getChannelMap();
    }

    public int getChannelLength() throws Exception {
        return (int)((this.raf.length() - (long)this.offset) / (long)this.getCHANNELS() / 2L);
    }

    protected void initializeFile() {
        if (this.raf == null) {
            try {
                this.raf = new RandomAccessFile(this.filename, "r");
                this.fileChannel = this.raf.getChannel();
                this.valScale = new Object[this.getCHANNELS()];
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new RuntimeException(t.getClass().getName() + ": " + this.filename + " " + t.getMessage(), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int seek(int channel, int index) throws Exception {
        int groupNum = index / this.pts_per_group;
        int blockOffset = this.offset + this.pts_per_group * (channel + this.getCHANNELS() * groupNum) * this.getDataSizeInByte();
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.buffer == null || blockOffset != this.currentBlockOffset || this.mappedByteBuffer == null) {
                this.currentBlockOffset = blockOffset;
                this.mappedByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, this.currentBlockOffset, this.pts_per_group * this.getDataSizeInByte());
                this.mappedByteBuffer.order(ByteOrder.nativeOrder());
                this.buffer = this.mappedByteBuffer.asShortBuffer();
            }
        }
        return index % this.pts_per_group;
    }

    protected int getDataSizeInByte() {
        return 2;
    }

    protected int getBlockSize() {
        return this.blockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getValueAt(int channel, int index) throws Exception {
        try {
            this.initializeFile();
            Object object = this.bufferLock;
            synchronized (object) {
                double[] s = (double[])this.valScale[channel];
                if (s == null) {
                    s = new double[2];
                    s[1] = this.getScale(channel);
                    s[0] = 0.0;
                    this.valScale[channel] = s;
                }
                int pos = this.seek(channel, index);
                return s[0] + s[1] * (double)((ShortBuffer)this.buffer).get(pos);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t.getClass().getName() + ": " + this.filename + " " + t.getMessage(), t);
        }
    }

    public double[] getValues(int channel) throws Exception {
        int len = this.getChannelLength();
        double[] ret = new double[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.getValueAt(channel, i);
        }
        return ret;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"D:/Testdaten_zeus/testkurz.rpc"};
        }
        try {
            int i;
            RpcIIIFileDataObserver observer = new RpcIIIFileDataObserver(args[0]);
            int channel = 0;
            System.out.println(observer.getDescription()[channel]);
            System.out.println("BlockSize in Bytes: " + observer.getBlockSize());
            System.out.println("Total Number Of Channels: " + observer.getCHANNELS());
            System.out.println("Length of Channel: " + observer.getChannelLength());
            System.out.println("Delta T: " + observer.getDELTA_T());
            for (i = 0; i < 6; ++i) {
                System.out.println("[" + i + "] " + observer.getValueAt(channel, i));
            }
            for (i = 1022; i < 1026; ++i) {
                System.out.println("[" + i + "] " + observer.getValueAt(channel, i));
            }
            for (i = 2046; i < 2050; ++i) {
                System.out.println("[" + i + "] " + observer.getValueAt(channel, i));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

