/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util.rpciii;

import com.highqsoft.fwk.Fwk;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyGroup;
import com.highqsoft.fwk.util.StringFormat;
import com.highqsoft.interfaces.fwk.FwkPropertyGroupInterface;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;

public class RpcIIIHeader
extends Fwk {
    static final double LOG10 = Math.log(10.0);
    public static final int MAXHEADERBLOCKS = 256;
    public static final int BLOCKSIZE = 512;
    public static final int RECORDSIZE = 128;
    public static final int KEYWORDSIZE = 32;
    public static final int VALUESIZE = 96;
    public static final int INT_FULL_SCALE = 32752;
    public static final int PARTITIONS = 1;
    public static final int REPEATS = 1;
    public static final int[] PTS_PER_FRAME = new int[]{256, 512, 1024, 2048};
    public static final String[] TIME_TYPES = new String[]{"CONFIG_DRIVE", "CONFIG_RESP", "DRIVE", "MULT_DRIVE", "MULT_RESP", "PEAK_PICK", "RESPONSE"};
    public static final String[] FORMATS = new String[]{"BINARY"};
    public static final String[] FILE_TYPE = new String[]{"TIME_HISTORY"};
    public static final String[] DATA_TYPE = new String[]{"SHORT_INTEGER"};
    public static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("dd.MM.yyyy_HH:mm:ss");
    public static final String version = "$Revision: 1.7 $";
    protected FwkPropertyGroupInterface propertyGroup = new FwkPropertyGroup();
    protected String spec;
    protected String name;
    protected String[] channelNumbers = null;
    protected String[] channelNames = null;

    public String getVersion() {
        return version;
    }

    protected RpcIIIHeader() {
    }

    public void init() {
        this.setBYPASS_FILTER(this.getBYPASS_FILTER());
        this.setDATE(new Date());
        this.setDATA_TYPE(this.getDATA_TYPE());
        this.setDELTA_T(this.getDELTA_T());
        this.setFILE_TYPE(this.getFILE_TYPE());
        this.setFORMAT(this.getFORMAT());
        this.setFRAMES(this.getFRAMES());
        this.setHALF_FRAMES(this.getHALF_FRAMES());
        this.setINT_FULL_SCALE(this.getINT_FULL_SCALE());
        this.setNUM_HEADER_BLOCKS(this.getNUM_HEADER_BLOCKS());
        this.setNUM_PARAMS(this.getNUM_PARAMS());
        this.setOPERATION(this.getOPERATION());
        this.setPARTITIONS(this.getPARTITIONS());
        this.setREPEATS(this.getREPEATS());
        this.setTIME_TYPE(this.getTIME_TYPE());
        this.setPTS_PER_FRAME(this.getPTS_PER_FRAME());
        this.setPTS_PER_GROUP(this.getPTS_PER_GROUP());
        this.propertyGroup.setProperty("CHANNELS", "0");
    }

    public RpcIIIHeader(String spec) throws IOException, FileNotFoundException {
        this();
        File file = new File(spec);
        if (!file.exists()) {
            URL url;
            InputStream is = null;
            try {
                url = new URL(spec);
                is = url.openStream();
            }
            catch (Throwable t) {
                url = RpcIIIHeader.class.getResource(spec);
                is = url.openStream();
            }
            this.read(is);
            file = new File(url.getPath());
            this.name = file.getName();
        } else {
            this.read(new FileInputStream(file));
            this.name = file.getName();
        }
        int index = this.name.lastIndexOf(46);
        if (index > 0) {
            this.name = this.name.substring(0, index);
        }
        this.spec = spec;
    }

    public String getFilename() {
        return this.name;
    }

    public void read(InputStream is) {
        byte[] buffer = new byte[512];
        int parCount = 0;
        int recordOffset = 0;
        BufferedInputStream bs = new BufferedInputStream(is, 512);
        boolean stop = false;
        try {
            while (!stop && bs.read(buffer, 0, 512) != -1) {
                for (recordOffset = 0; recordOffset < 512; recordOffset += 128) {
                    this.propertyGroup.setProperty(new String(buffer, recordOffset, 32).trim(), new String(buffer, recordOffset + 32, 96).trim());
                    ++parCount;
                }
                stop = parCount >= this.propertyGroup.getProperty("NUM_PARAMS", 256);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            is.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String getBYPASS_FILTER() {
        return this.propertyGroup.getProperty("BYPASS_FILTER", "0");
    }

    public void setBYPASS_FILTER(String flag) {
        char c = flag.trim().toUpperCase().charAt(0);
        this.setBYPASS_FILTER(c == 'y' || c == 't' || c == 'w' || c == '1');
    }

    public void setBYPASS_FILTER(boolean flag) {
        this.propertyGroup.setProperty("BYPASS_FILTER", flag ? "1" : "0");
    }

    public String getCHANNELS() {
        return this.propertyGroup.getProperty("CHANNELS", "0");
    }

    public void setCHANNELS(int num) {
        if (num < 1) {
            throw new RuntimeException("Unsupported CHANNELS value <" + num + ">");
        }
        this.propertyGroup.getProperty("CHANNELS", "" + num);
    }

    public void setCHANNELS(String val) {
        int iVal = 0;
        try {
            iVal = Integer.parseInt(val.trim());
        }
        catch (Throwable t) {
            throw new RuntimeException("Unsupported CHANNELS value <" + val + ">");
        }
        this.setCHANNELS(iVal);
    }

    public String getDATA_TYPE() {
        return this.propertyGroup.getProperty("DATA_TYPE", "SHORT_INTEGER");
    }

    public void setDATA_TYPE(String type) {
        int idx = Arrays.binarySearch(DATA_TYPE, type.toUpperCase());
        if (idx < 0) {
            throw new RuntimeException("Unsupported DATA_TYPE <" + type + ">");
        }
        this.propertyGroup.setProperty("DATA_TYPE", DATA_TYPE[idx]);
    }

    public String getDATE() {
        Date date = new Date();
        return this.propertyGroup.getProperty("DATE", DATE_FORMATTER.format(date));
    }

    public void setDATE(Date date) {
        this.propertyGroup.setProperty("DATE", DATE_FORMATTER.format(date));
    }

    public void setDATE(String date) {
        this.propertyGroup.setProperty("DATE", date);
    }

    public String getDELTA_T() {
        return this.propertyGroup.getProperty("DELTA_T", "1");
    }

    public void setDELTA_T(double delta) {
        long exp = Math.round(Math.floor(Math.log(delta) / LOG10));
        if (exp > 1L) {
            String eStr = "" + Math.abs(exp);
            if (eStr.length() == 1) {
                eStr = "0" + eStr;
            }
            if (exp < 0L) {
                eStr = "-" + eStr;
            }
        }
        this.propertyGroup.setProperty("DELTA_T", RpcIIIHeader.format(delta));
    }

    public void setDELTA_T(String delta) {
        double dVal = 0.0;
        try {
            dVal = Double.parseDouble(delta.trim());
        }
        catch (Throwable t) {
            throw new RuntimeException("Unsupported DELTA_T value <" + delta + ">");
        }
        this.setDELTA_T(dVal);
    }

    public String getFILE_TYPE() {
        return this.propertyGroup.getProperty("FILE_TYPE", FILE_TYPE[0]);
    }

    public void setFILE_TYPE(String type) {
        int idx = Arrays.binarySearch(FILE_TYPE, type.toUpperCase());
        if (idx < 0) {
            throw new RuntimeException("Unsupported FILE_TYPE <" + type + ">");
        }
        this.propertyGroup.setProperty("FILE_TYPE", FILE_TYPE[idx]);
    }

    public String getFORMAT() {
        return this.propertyGroup.getProperty("FORMAT", FORMATS[0]);
    }

    public void setFORMAT(String format) {
        int idx = Arrays.binarySearch(FORMATS, format.toUpperCase());
        if (idx < 0) {
            throw new RuntimeException("Unsupported FORMAT <" + format + ">");
        }
        this.propertyGroup.setProperty("FORMAT", FORMATS[idx]);
    }

    public String getFRAMES() {
        return this.propertyGroup.getProperty("FRAMES", "1");
    }

    public void setFRAMES(int val) {
        if (val < 1) {
            throw new RuntimeException("Unsupported FRAMES value <" + val + ">");
        }
        this.propertyGroup.getProperty("FRAMES", "" + val);
    }

    public void setFRAMES(String val) {
        int iVal = 0;
        try {
            iVal = Integer.parseInt(val.trim());
        }
        catch (Throwable t) {
            throw new RuntimeException("Unsupported FRAMES value <" + val + ">");
        }
        this.setFRAMES(iVal);
    }

    public String getHALF_FRAMES() {
        return this.propertyGroup.getProperty("HALF_FRAMES", "0");
    }

    public void setHALF_FRAMES(String flag) {
        char c = flag.trim().toUpperCase().charAt(0);
        this.setHALF_FRAMES(c == 'y' || c == 't' || c == 'w' || c == '1');
    }

    public void setHALF_FRAMES(boolean flag) {
        this.propertyGroup.setProperty("HALF_FRAMES", flag ? "1" : "0");
    }

    public String getINT_FULL_SCALE() {
        return this.propertyGroup.getProperty("INT_FULL_SCALE", "32752");
    }

    public void setINT_FULL_SCALE(int val) {
        if (val < 1 || val > Short.MAX_VALUE) {
            throw new RuntimeException("Unsupported INT_FULL_SCALE value <" + val + ">");
        }
        this.propertyGroup.getProperty("INT_FULL_SCALE", "" + val);
    }

    public void setINT_FULL_SCALE(String val) {
        int iVal = 0;
        try {
            iVal = Integer.parseInt(val.trim());
        }
        catch (Throwable t) {
            throw new RuntimeException("Unsupported INT_FULL_SCALE value <" + val + ">");
        }
        this.setINT_FULL_SCALE(iVal);
    }

    public String getNUM_HEADER_BLOCKS() {
        return this.propertyGroup.getProperty("NUM_HEADER_BLOCKS", "1");
    }

    public void setNUM_HEADER_BLOCKS(int val) {
        if (val < 1 || val > 256) {
            throw new RuntimeException("Unsupported NUM_HEADER_BLOCKS value <" + val + ">");
        }
        this.propertyGroup.getProperty("NUM_HEADER_BLOCKS", "" + val);
    }

    public void setNUM_HEADER_BLOCKS(String val) {
        int iVal = 0;
        try {
            iVal = Integer.parseInt(val.trim());
        }
        catch (Throwable t) {
            throw new RuntimeException("Unsupported NUM_HEADER_BLOCKS value <" + val + ">");
        }
        this.setNUM_HEADER_BLOCKS(iVal);
    }

    public String getNUM_PARAMS() {
        return this.propertyGroup.getProperty("NUM_PARAMS", "1");
    }

    public void setNUM_PARAMS(int val) {
        if (val < 1 || val > 1024) {
            throw new RuntimeException("Unsupported NUM_PARAMS value <" + val + ">");
        }
        this.propertyGroup.getProperty("NUM_PARAMS", "" + val);
    }

    public void setNUM_PARAMS(String val) {
        int iVal = 0;
        try {
            iVal = Integer.parseInt(val.trim());
        }
        catch (Throwable t) {
            throw new RuntimeException("Unsupported NUM_PARAMS value <" + val + ">");
        }
        this.setNUM_PARAMS(iVal);
    }

    public String getOPERATION() {
        return this.propertyGroup.getProperty("OPERATION", "");
    }

    public void setOPERATION(String val) {
        this.propertyGroup.setProperty("OPERATION", val);
    }

    public String getPARTITIONS() {
        return this.propertyGroup.getProperty("PARTITIONS", "1");
    }

    public void setPARTITIONS(int val) {
        if (val < 1 || val > 128) {
            throw new RuntimeException("Unsupported partitions value <" + val + ">");
        }
        this.propertyGroup.getProperty("PARTITIONS", "" + val);
    }

    public void setPARTITIONS(String val) {
        int iVal = 0;
        try {
            iVal = Integer.parseInt(val.trim());
        }
        catch (Throwable t) {
            throw new RuntimeException("Unsupported partitions value <" + val + ">");
        }
        this.setPARTITIONS(iVal);
    }

    public String getREPEATS() {
        return this.propertyGroup.getProperty("REPEATS", "1");
    }

    public void setREPEATS(int val) {
        this.setREPEATS("" + val);
    }

    public void setREPEATS(String val) {
        this.propertyGroup.getProperty("REPEATS", val);
    }

    public String getTIME_TYPE() {
        return this.propertyGroup.getProperty("TIME_TYPE", "RESPONSE");
    }

    public void setTIME_TYPE(String type) {
        int idx = Arrays.binarySearch(TIME_TYPES, type.toUpperCase());
        if (idx < 0) {
            throw new RuntimeException("Unsupported type <" + type + ">");
        }
        this.propertyGroup.setProperty("TIME_TYPE", TIME_TYPES[idx]);
    }

    public String getPTS_PER_FRAME() {
        return this.propertyGroup.getProperty("PTS_PER_FRAME", "" + PTS_PER_FRAME[0]);
    }

    public void setPTS_PER_FRAME(int num) {
        this.setPTS_PER_FRAME("" + num);
    }

    public void setPTS_PER_FRAME(String num) {
        this.propertyGroup.setProperty("PTS_PER_FRAME", num);
    }

    public String getPTS_PER_GROUP() {
        return this.propertyGroup.getProperty("PTS_PER_GROUP", "256");
    }

    public void setPTS_PER_GROUP(int num) {
        this.setPTS_PER_GROUP("" + num);
    }

    public void setPTS_PER_GROUP(String num) {
        this.propertyGroup.setProperty("PTS_PER_GROUP", "" + num);
    }

    public String[] getPARENT() {
        Vector<String> vec = new Vector<String>();
        int count = 1;
        String res = this.propertyGroup.getProperty("PARENT_" + count, null);
        while (res != null) {
            vec.add(res);
            res = this.propertyGroup.getProperty("PARENT_" + ++count, null);
        }
        return vec.toArray(new String[vec.size()]);
    }

    public void setPARENT(String[] parents) {
        int count = 1;
        String res = this.propertyGroup.getProperty("PARENT_" + count, null);
        while (res != null) {
            this.propertyGroup.remove("PARENT_" + count);
            res = this.propertyGroup.getProperty("PARENT_" + ++count, null);
        }
        for (int i = 0; i < parents.length; ++i) {
            this.propertyGroup.setProperty("PARENT_" + (i + 1), parents[i]);
        }
    }

    public String[] getDescription() {
        int count = Integer.parseInt(this.getCHANNELS());
        String[] ret = new String[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = this.getDescription(i + 1);
        }
        return ret;
    }

    public String getDescription(int index) {
        return this.propertyGroup.getProperty("DESC.CHAN_" + index, "");
    }

    public void setDescription(int index, String desc) {
        this.propertyGroup.setProperty("DESC.CHAN_" + index, desc);
    }

    public void setDescription(int index, String name, String no) {
        this.setDescription(index, "[" + no.trim() + "]" + name);
    }

    public void setDescription(int index, String[] name, String[] no) {
        Object[] tmp;
        int size = Integer.parseInt(this.getCHANNELS());
        int naLen = name.length;
        int noLen = no.length;
        if (noLen != size) {
            tmp = new String[size];
            Arrays.fill(tmp, "");
            System.arraycopy(no, 0, tmp, 0, noLen < size ? noLen : size);
            no = tmp;
        }
        if (naLen != size) {
            tmp = new String[size];
            Arrays.fill(tmp, "");
            System.arraycopy(name, 0, tmp, 0, naLen < size ? naLen : size);
            name = tmp;
        }
        for (int i = 0; i < size; ++i) {
            this.setDescription(index, "[" + no[i].trim() + "]" + (String)name[i]);
        }
    }

    public void setDescription(String[] desc) {
        int count = desc.length;
        for (int i = 0; i < count; ++i) {
            this.setDescription(i + 1, desc[i]);
        }
    }

    public double[] getScale() {
        int count = Integer.parseInt(this.getCHANNELS());
        double[] ret = new double[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = this.getScale(i + 1);
        }
        return ret;
    }

    public double getScale(int index) {
        return this.propertyGroup.getProperty("SCALE.CHAN_" + index, 1.0);
    }

    public void setScale(int index, double scale) {
        this.propertyGroup.setProperty("DESC.CHAN_" + index, RpcIIIHeader.format(scale));
    }

    public void setScale(double[] desc) {
        int count = desc.length;
        for (int i = 0; i < count; ++i) {
            this.setScale(i + 1, desc[i]);
        }
    }

    public double[] getLowerLimit() {
        int count = Integer.parseInt(this.getCHANNELS());
        double[] ret = new double[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = this.getLowerLimit(i + 1);
        }
        return ret;
    }

    public double getLowerLimit(int index) {
        return this.propertyGroup.getProperty("LOWER_LIMIT.CHAN_" + index, 1.0);
    }

    public void setLowerLimit(int index, double ll) {
        this.propertyGroup.setProperty("LOWER_LIMIT.CHAN_" + index, RpcIIIHeader.format(ll));
    }

    public void setLowerLimit(double[] ll) {
        int count = ll.length;
        for (int i = 0; i < count; ++i) {
            this.setLowerLimit(i + 1, ll[i]);
        }
    }

    public double[] getUpperLimit() {
        int count = Integer.parseInt(this.getCHANNELS());
        double[] ret = new double[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = this.getUpperLimit(i + 1);
        }
        return ret;
    }

    public double getUpperLimit(int index) {
        return this.propertyGroup.getProperty("UPPER_LIMIT.CHAN_" + index, 1.0);
    }

    public void setUpperLimit(int index, double ul) {
        this.propertyGroup.setProperty("UPPER_LIMIT.CHAN_" + index, RpcIIIHeader.format(ul));
    }

    public void setUpperLimit(double[] ul) {
        int count = ul.length;
        for (int i = 0; i < count; ++i) {
            this.setUpperLimit(i + 1, ul[i]);
        }
    }

    public String[] getUnit() {
        int count = Integer.parseInt(this.getCHANNELS());
        String[] ret = new String[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = this.getUnit(i + 1);
        }
        return ret;
    }

    public String getUnit(int index) {
        return this.propertyGroup.getProperty("UNITS.CHAN_" + index, "");
    }

    protected void initializeNumberNames() {
        if (this.channelNumbers == null) {
            String[] desc = this.getDescription();
            if (desc == null) {
                this.channelNumbers = new String[0];
                this.channelNames = new String[0];
            } else {
                this.channelNumbers = new String[desc.length];
                this.channelNames = new String[desc.length];
            }
            int len = this.channelNumbers.length;
            for (int i = 0; i < len; ++i) {
                int idxOpen = desc[i].indexOf(91);
                int idxClose = desc[i].indexOf(93);
                if (idxClose >= 0 && idxOpen >= 0) {
                    this.channelNumbers[i] = desc[i].substring(idxOpen + 1, idxClose).trim();
                    this.channelNames[i] = (desc[i].substring(0, idxOpen) + desc[i].substring(idxClose + 1, desc[i].length())).replace('_', ' ').trim();
                } else {
                    this.channelNames[i] = desc[i].replace('_', ' ').trim();
                    this.channelNumbers[i] = "0";
                }
                this.channelNumbers[i] = this.propertyGroup.getProperty("MAP.CHAN_" + i, "" + i);
            }
        }
    }

    public String[] getChannelNumber() {
        this.initializeNumberNames();
        return this.channelNumbers;
    }

    public String getChannelNumber(int index) {
        this.initializeNumberNames();
        return this.channelNumbers[index];
    }

    public String[] getChannelName() {
        this.initializeNumberNames();
        return this.channelNames;
    }

    public String getChannelName(int index) {
        this.initializeNumberNames();
        return this.channelNames[index];
    }

    public void setUnit(int index, String unit) {
        this.propertyGroup.setProperty("DESC.CHAN_" + index, unit);
    }

    public void setUnit(String[] unit) {
        int count = unit.length;
        for (int i = 0; i < count; ++i) {
            this.setUnit(i + 1, unit[i]);
        }
    }

    public String[] getPartitionChannel() {
        int count = Integer.parseInt(this.getPARTITIONS());
        String[] ret = new String[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = this.getPartitionChannel(i + 1);
        }
        return ret;
    }

    public String getPartitionChannel(int index) {
        return this.propertyGroup.getProperty("PART.CHAN_" + index, "");
    }

    public void setPartitionChannel(int index, int chan) {
        this.propertyGroup.setProperty("PART.CHAN_" + index, "" + chan);
    }

    public void setPartitionChannel(int[] chan) {
        int count = chan.length;
        for (int i = 0; i < count; ++i) {
            this.setPartitionChannel(i + 1, chan[i]);
        }
    }

    public String[] getPartitionNChannel() {
        int count = Integer.parseInt(this.getPARTITIONS());
        String[] ret = new String[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = this.getPartitionNChannel(i + 1);
        }
        return ret;
    }

    public String getPartitionNChannel(int index) {
        return this.propertyGroup.getProperty("PART.NCHAN_" + index, "0");
    }

    public void setPartitionNChannel(int index, int count) {
        this.propertyGroup.setProperty("PART.NCHAN_" + index, "" + count);
    }

    public void setPartitionNChannel(int[] counts) {
        int count = counts.length;
        for (int i = 0; i < count; ++i) {
            this.setPartitionNChannel(i + 1, counts[i]);
        }
    }

    public String[] getChannelMap() {
        int count = Integer.parseInt(this.getCHANNELS());
        String[] ret = new String[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = this.getChannelMap(i + 1);
        }
        return ret;
    }

    public String getChannelMap(int index) {
        return this.propertyGroup.getProperty("MAP.CHAN_" + index, "" + index);
    }

    public void setChannelMap(int index, int count) {
        this.propertyGroup.setProperty("MAP.CHAN_" + index, "" + count);
    }

    public void setChannelMap(int[] entries) {
        int count = entries.length;
        for (int i = 0; i < count; ++i) {
            this.setChannelMap(i + 1, entries[i]);
        }
    }

    public String toString() {
        return this.propertyGroup.toString();
    }

    public static String format(double val) {
        long exp = Math.round(Math.floor(Math.log(val) / LOG10));
        String ret = "";
        if (exp <= 1L) {
            ret = "" + StringFormat.format(val, 6);
        } else {
            String eStr = "" + Math.abs(exp);
            if (eStr.length() == 1) {
                eStr = "0" + eStr;
            }
            if (exp < 0L) {
                eStr = "-" + eStr;
            }
            ret = "" + StringFormat.format(val / Math.pow(10.0, exp), 6) + "E" + eStr;
        }
        return ret;
    }

    public static void main(String[] args) {
        String spec = "TESTKURZ.rpc";
        if (args.length > 0) {
            spec = args[0];
        }
        FwkContainer.initialize(args);
        try {
            RpcIIIHeader hdr = new RpcIIIHeader(spec);
            int totPoints = hdr.propertyGroup.getProperty("FRAMES", 0) * hdr.propertyGroup.getProperty("PTS_PER_FRAME", 0);
            double totTime = (double)totPoints * hdr.propertyGroup.getProperty("DELTA_T", 0.0);
            double pointsPerSec = (double)totPoints / totTime;
            System.out.println("Number of Header Blocks: " + hdr.propertyGroup.getProperty("NUM_HEADER_BLOCKS", ""));
            System.out.println("RPC File Type:           " + hdr.propertyGroup.getProperty("FILE_TYPE", ""));
            System.out.println("Time History Type:       " + hdr.propertyGroup.getProperty("TIME_TYPE", ""));
            System.out.println("Data Type:               " + hdr.propertyGroup.getProperty("DATA_TYPE", ""));
            System.out.println("Points per Frame:        " + hdr.propertyGroup.getProperty("PTS_PER_FRAME", 0));
            System.out.println("Points per Second:       " + (double)Math.round(pointsPerSec * 1000.0) / 1000.0 + " 1/sec");
            System.out.println("Number of Repeats:       " + hdr.propertyGroup.getProperty("REPEATS", 0));
            System.out.println("Total Frames:            " + hdr.propertyGroup.getProperty("FRAMES", 0));
            System.out.println("Total Time:              " + (double)Math.round(totTime * 1000.0) / 1000.0 + " sec");
            System.out.println("Total Points:            " + totPoints);
            System.out.println("Number of Channels:      " + hdr.propertyGroup.getProperty("CHANNELS", 0));
            System.out.println("Points per Group:        " + hdr.propertyGroup.getProperty("PTS_PER_GROUP", 0));
            System.out.println("Number of Partitions:    " + hdr.propertyGroup.getProperty("PARTITIONS", 0));
            System.out.println("Half Frames:             " + hdr.propertyGroup.getProperty("HALF_FRAMES", false));
            System.out.println(hdr);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.exit(0);
    }
}

