/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util.ubh;

import com.highqsoft.fwk.FwkColumnDataObserver;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.util.ubh.UBHInterface;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public abstract class ERGDataObserver
extends FwkColumnDataObserver {
    public static final String version = "$Revision: 1.6 $";
    UBHInterface ubh;
    int signal;
    protected RandomAccessFile file;
    protected FileChannel fileChannel;
    protected MappedByteBuffer mappedByteBuffer;
    protected Buffer buffer;
    protected String fileSpec;
    int count = -1;

    public String getVersion() {
        return version;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    public ERGDataObserver(UBHInterface ubh, int signal, String fileSpec) throws FileNotFoundException, IOException {
        this.ubh = ubh;
        this.signal = signal;
        this.fileSpec = fileSpec;
        this.file = new RandomAccessFile(fileSpec, "r");
        this.fileChannel = this.file.getChannel();
        this.releaseFile();
    }

    public void release() {
        this.releaseFile();
        super.release();
    }

    public void releaseFile() {
        try {
            if (this.fileChannel != null) {
                this.fileChannel.close();
            }
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.file = null;
        this.fileChannel = null;
        this.mappedByteBuffer = null;
        this.buffer = null;
        Runtime runtime = Runtime.getRuntime();
        long freeMem1 = runtime.freeMemory();
        runtime.runFinalization();
        runtime.gc();
        Thread.yield();
        long freeMem2 = runtime.freeMemory();
        if (FwkContainer.getDebugLevel() > 0) {
            System.out.println(this.getClass().getName() + ".release(): Reclaiming memory: " + freeMem1 + " --> " + freeMem2 + " bytes free. " + "Delta: " + (freeMem2 - freeMem1));
        }
    }

    public void setFlagAt(int index, short flag) {
        if (this.flags == null) {
            this.flags = new short[this.getCount()];
            Arrays.fill(this.flags, 0, this.getCount(), (short)15);
        }
        super.setFlagAt(index, flag);
    }

    public int getCount() {
        if (this.count < 0) {
            this.count = this.ubh.getCountPerSignal();
        }
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeFile() {
        UBHInterface uBHInterface = this.ubh;
        synchronized (uBHInterface) {
            if (this.file == null) {
                try {
                    this.file = new RandomAccessFile(this.fileSpec, "r");
                    this.fileChannel = this.file.getChannel();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new RuntimeException(t.getClass().getName() + ": " + this.fileSpec + " " + t.getMessage(), t);
                }
            }
        }
    }

    public abstract int getDataSizeInByte();

    protected abstract void createBuffer();

    protected int seek(int index) throws Exception {
        int pos = index % this.ubh.getBlocking();
        if (pos == 0 || this.mappedByteBuffer == null) {
            this.mappedByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, this.ubh.getBlockOffset(this.signal, this.getDataSizeInByte(), index), this.ubh.getBlocking() * this.getDataSizeInByte());
            this.mappedByteBuffer.order(ByteOrder.nativeOrder());
            this.createBuffer();
        }
        return pos;
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
    }
}

