/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util.ubh;

import com.highqsoft.util.ubh.ERGDataObserver;
import com.highqsoft.util.ubh.UBHInterface;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.FloatBuffer;

public class ERGFloatDataObserver
extends ERGDataObserver {
    public static final String version = "$Revision: 1.6 $";

    public String getVersion() {
        return version;
    }

    public ERGFloatDataObserver(UBHInterface ubh, int signal, String fileSpec) throws FileNotFoundException, IOException {
        super(ubh, signal, fileSpec);
    }

    public int getDataSizeInByte() {
        return 4;
    }

    public double getValueAt(int index) {
        return this.getNativeValueAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getNativeValueAt(int index) {
        UBHInterface uBHInterface = this.ubh;
        synchronized (uBHInterface) {
            float ret;
            try {
                this.initializeFile();
                int pos = this.seek(index);
                ret = ((FloatBuffer)this.buffer).get(pos);
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getClass().getName() + ": " + this.fileSpec + " " + t.getMessage(), t);
            }
            if (index == this.getCount() - 1) {
                this.releaseFile();
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(int index, double value) {
        UBHInterface uBHInterface = this.ubh;
        synchronized (uBHInterface) {
            try {
                this.initializeFile();
                int pos = this.seek(index);
                ((FloatBuffer)this.buffer).put(pos, (float)value);
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getClass().getName() + ": " + t.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createBuffer() {
        UBHInterface uBHInterface = this.ubh;
        synchronized (uBHInterface) {
            this.buffer = this.mappedByteBuffer.asFloatBuffer();
        }
    }

    public Class getNativeDatatype() {
        return Float.TYPE;
    }

    public Object getNativeValues() {
        float[] ret = new float[this.getCount()];
        int size = ret.length;
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getNativeValueAt(i);
        }
        return ret;
    }

    public Object getNativeValues(int lower, int upper) {
        float[] ret = new float[upper - lower + 1];
        int size = ret.length;
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getNativeValueAt(lower + i);
        }
        return ret;
    }
}

