/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util.ubh;

import com.highqsoft.util.ubh.ERGDataObserver;
import com.highqsoft.util.ubh.UBHInterface;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.IntBuffer;

public class ERGIntDataObserver
extends ERGDataObserver {
    public static final String version = "$Revision: 1.6 $";

    public String getVersion() {
        return version;
    }

    public ERGIntDataObserver(UBHInterface ubh, int signal, String fileSpec) throws FileNotFoundException, IOException {
        super(ubh, signal, fileSpec);
    }

    public int getDataSizeInByte() {
        return 4;
    }

    public double getValueAt(int index) {
        return this.getNativeValueAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNativeValueAt(int index) {
        UBHInterface uBHInterface = this.ubh;
        synchronized (uBHInterface) {
            int ret;
            try {
                this.initializeFile();
                int pos = this.seek(index);
                ret = ((IntBuffer)this.buffer).get(pos);
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getClass().getName() + ": " + this.fileSpec + " " + t.getMessage(), t);
            }
            if (index == this.getCount() - 1) {
                this.releaseFile();
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(int index, double value) throws RuntimeException {
        UBHInterface uBHInterface = this.ubh;
        synchronized (uBHInterface) {
            this.initializeFile();
            try {
                int pos = this.seek(index);
                ((IntBuffer)this.buffer).put(pos, (int)Math.round(value));
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getClass().getName() + " " + t.getMessage(), t);
            }
        }
    }

    protected void createBuffer() {
        this.buffer = this.mappedByteBuffer.asIntBuffer();
    }

    public Class getNativeDatatype() {
        return Integer.TYPE;
    }

    public Object getNativeValues() {
        int[] ret = new int[this.getCount()];
        int size = ret.length;
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getNativeValueAt(i);
        }
        return ret;
    }

    public Object getNativeValues(int lower, int upper) {
        int[] ret = new int[upper - lower + 1];
        int size = ret.length;
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getNativeValueAt(lower + i);
        }
        return ret;
    }
}

