/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util.ubh;

import com.highqsoft.util.ubh.ERGDataObserver;
import com.highqsoft.util.ubh.UBHInterface;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ShortBuffer;

public class ERGShortDataObserver
extends ERGDataObserver {
    public static final String version = "$Revision: 1.6 $";

    public String getVersion() {
        return version;
    }

    public ERGShortDataObserver(UBHInterface ubh, int signal, String fileSpec) throws FileNotFoundException, IOException {
        super(ubh, signal, fileSpec);
    }

    public int getDataSizeInByte() {
        return 2;
    }

    public double getValueAt(int index) throws RuntimeException {
        return this.getNativeValueAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getNativeValueAt(int index) throws RuntimeException {
        UBHInterface uBHInterface = this.ubh;
        synchronized (uBHInterface) {
            short ret;
            try {
                this.initializeFile();
                int pos = this.seek(index);
                ret = ((ShortBuffer)this.buffer).get(pos);
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getClass().getName() + ": " + this.fileSpec + " " + t.getMessage(), t);
            }
            if (index == this.getCount() - 1) {
                this.releaseFile();
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(int index, double value) throws RuntimeException {
        UBHInterface uBHInterface = this.ubh;
        synchronized (uBHInterface) {
            this.initializeFile();
            try {
                int pos = this.seek(index);
                ((ShortBuffer)this.buffer).put(pos, (short)Math.round(value));
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getClass().getName() + " " + t.getMessage(), t);
            }
        }
    }

    protected void createBuffer() {
        this.buffer = this.mappedByteBuffer.asShortBuffer();
    }

    public Class getNativeDatatype() {
        return Short.TYPE;
    }

    public Object getNativeValues() {
        short[] ret = new short[this.getCount()];
        int size = ret.length;
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getNativeValueAt(i);
        }
        return ret;
    }

    public Object getNativeValues(int lower, int upper) {
        short[] ret = new short[upper - lower + 1];
        int size = ret.length;
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getNativeValueAt(lower + i);
        }
        return ret;
    }
}

