/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util.ubh;

import com.highqsoft.util.ubh.ERGDataObserver;
import com.highqsoft.util.ubh.UBHInterface;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ERGUCharDataObserver
extends ERGDataObserver {
    public static final String version = "$Revision: 1.6 $";

    public String getVersion() {
        return version;
    }

    public ERGUCharDataObserver(UBHInterface ubh, int signal, String fileSpec) throws FileNotFoundException, IOException {
        super(ubh, signal, fileSpec);
    }

    public int getDataSizeInByte() {
        return 1;
    }

    public double getValueAt(int index) throws RuntimeException {
        return this.getNativeValueAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getNativeValueAt(int index) throws RuntimeException {
        UBHInterface uBHInterface = this.ubh;
        synchronized (uBHInterface) {
            short ret;
            try {
                this.initializeFile();
                int pos = this.seek(index);
                int ch1 = ((ByteBuffer)this.buffer).get(pos);
                if (ch1 < 0) {
                    ch1 = 255 + ch1 + 1;
                }
                ret = (short)ch1;
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getClass().getName() + ": " + this.fileSpec + " " + t.getMessage(), t);
            }
            if (index == this.getCount() - 1) {
                this.releaseFile();
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(int index, double value) throws RuntimeException {
        UBHInterface uBHInterface = this.ubh;
        synchronized (uBHInterface) {
            this.initializeFile();
            try {
                int pos = this.seek(index);
                ((ByteBuffer)this.buffer).put(pos, (byte)Math.round(value));
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getClass().getName() + " " + t.getMessage(), t);
            }
        }
    }

    protected void createBuffer() {
        this.buffer = this.mappedByteBuffer;
    }

    public Class getNativeDatatype() {
        return Short.TYPE;
    }

    public Object getNativeValues() {
        short[] ret = new short[this.getCount()];
        int size = ret.length;
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getNativeValueAt(i);
        }
        return ret;
    }

    public Object getNativeValues(int lower, int upper) {
        short[] ret = new short[upper - lower + 1];
        int size = ret.length;
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getNativeValueAt(lower + i);
        }
        return ret;
    }
}

