/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util.ubh;

import com.highqsoft.util.ubh.ERGDataObserver;
import com.highqsoft.util.ubh.UBHInterface;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.IntBuffer;

public class ERGUIntDataObserver
extends ERGDataObserver {
    public static final String version = "$Revision: 1.7 $";

    public String getVersion() {
        return version;
    }

    public ERGUIntDataObserver(UBHInterface ubh, int signal, String fileSpec) throws FileNotFoundException, IOException {
        super(ubh, signal, fileSpec);
    }

    public int getDataSizeInByte() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getValueAt(int index) throws RuntimeException {
        UBHInterface uBHInterface = this.ubh;
        synchronized (uBHInterface) {
            double ret;
            try {
                this.initializeFile();
                int pos = this.seek(index);
                long l = ((IntBuffer)this.buffer).get(pos);
                ret = l < 0L ? (double)(0xFFFFFFFFL + l + 1L & 0xFFFFFFFFL) : (double)l;
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getClass().getName() + ": " + this.fileSpec + " " + t.getMessage(), t);
            }
            if (index == this.getCount() - 1) {
                this.releaseFile();
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNativeValueAt(int index) throws RuntimeException {
        UBHInterface uBHInterface = this.ubh;
        synchronized (uBHInterface) {
            long ret;
            try {
                this.initializeFile();
                int pos = this.seek(index);
                long l = ((IntBuffer)this.buffer).get(pos);
                ret = l < 0L ? 0xFFFFFFFFL + l + 1L & 0xFFFFFFFFL : l;
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getClass().getName() + ": " + this.fileSpec + " " + t.getMessage(), t);
            }
            if (index == this.getCount() - 1) {
                this.releaseFile();
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(int index, double value) throws RuntimeException {
        UBHInterface uBHInterface = this.ubh;
        synchronized (uBHInterface) {
            this.initializeFile();
            try {
                int pos = this.seek(index);
                ((IntBuffer)this.buffer).put(pos, (int)Math.round(value));
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getClass().getName() + " " + t.getMessage(), t);
            }
        }
    }

    protected void createBuffer() {
        this.buffer = this.mappedByteBuffer.asIntBuffer();
    }

    public Class getNativeDatatype() {
        return Long.TYPE;
    }

    public Object getNativeValues() {
        long[] ret = new long[this.getCount()];
        int size = ret.length;
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getNativeValueAt(i);
        }
        return ret;
    }

    public Object getNativeValues(int lower, int upper) {
        long[] ret = new long[upper - lower + 1];
        int size = ret.length;
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getNativeValueAt(lower + i);
        }
        return ret;
    }
}

