/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util.ubh;

import com.highqsoft.util.ubh.ERGDataObserver;
import com.highqsoft.util.ubh.UBHInterface;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

public class ERGULongDataObserver
extends ERGDataObserver {
    public static final String version = "$Revision: 1.7 $";

    public String getVersion() {
        return version;
    }

    public ERGULongDataObserver(UBHInterface ubh, int signal, String fileSpec) throws FileNotFoundException, IOException {
        super(ubh, signal, fileSpec);
    }

    public int getDataSizeInByte() {
        return 8;
    }

    public double getValueAt(int index) throws RuntimeException {
        return this.getNativeValueAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNativeValueAt(int index) throws RuntimeException {
        UBHInterface uBHInterface = this.ubh;
        synchronized (uBHInterface) {
            long ret;
            try {
                this.initializeFile();
                int pos = this.seek(index);
                long c1 = ((IntBuffer)this.buffer).get(2 * pos);
                long c2 = ((IntBuffer)this.buffer).get(2 * pos + 1);
                ret = c2 | c1 << 32;
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getClass().getName() + ": " + this.fileSpec + " " + t.getMessage(), t);
            }
            if (index == this.getCount() - 1) {
                this.releaseFile();
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(int index, double value) throws RuntimeException {
        UBHInterface uBHInterface = this.ubh;
        synchronized (uBHInterface) {
            this.initializeFile();
            try {
                this.seek(index);
                ((LongBuffer)this.buffer).put(index, Math.round(value));
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getClass().getName() + " " + t.getMessage(), t);
            }
        }
    }

    protected void createBuffer() {
        this.buffer = this.mappedByteBuffer.asIntBuffer();
    }

    public Class getNativeDatatype() {
        return Long.TYPE;
    }

    public Object getNativeValues() {
        long[] ret = new long[this.getCount()];
        int size = ret.length;
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getNativeValueAt(i);
        }
        return ret;
    }

    public Object getNativeValues(int lower, int upper) {
        long[] ret = new long[upper - lower + 1];
        int size = ret.length;
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getNativeValueAt(lower + i);
        }
        return ret;
    }
}

