/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util.ubh;

import com.highqsoft.fwk.Fwk;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.util.StringUtilities;
import com.highqsoft.interfaces.fwk.FwkPropertyGroupInterface;
import com.highqsoft.util.ubh.SignalInterface;

public class Signal
extends Fwk
implements SignalInterface {
    public static final String version = "$Revision: 1.3 $";
    protected FwkPropertyGroupInterface propertyGroup;
    protected String defaultName;
    protected String name = null;
    protected int no;
    protected int datatype = -1;
    protected float scaleOffset;
    protected float scaleFactor;

    public String getVersion() {
        return version;
    }

    public Signal(FwkPropertyGroupInterface props, String defaultName, int no) {
        this.propertyGroup = props;
        this.defaultName = defaultName;
        this.no = no;
        this.scaleOffset = this.propertyGroup.getProperty("ScaleOffset", 0.0f);
        this.scaleFactor = this.propertyGroup.getProperty("ScaleFactor", 1.0f);
    }

    public String getName() {
        if (this.name == null) {
            String[] arr;
            String propName = this.propertyGroup.getName();
            this.name = propName.startsWith("ALL") ? this.propertyGroup.getProperty("Name", this.defaultName + "_" + this.no) : this.propertyGroup.getProperty("Name", propName);
            if (this.name.indexOf("%d") >= 0) {
                arr = StringUtilities.split(this.name, "%d", false);
                this.name = StringUtilities.concatenate(arr, this.defaultName, false);
            }
            if (this.name.indexOf("%n") >= 0) {
                arr = StringUtilities.split(this.name, "%n", false);
                this.name = StringUtilities.concatenate(arr, "" + this.no, false);
            }
        }
        return this.name;
    }

    public double getDelta() {
        return this.propertyGroup.getProperty("Delta", 1.0 / this.propertyGroup.getProperty("Rate", 1.0));
    }

    public double getRate() {
        return this.propertyGroup.getProperty("Rate", 1.0 / this.propertyGroup.getProperty("Delta", 1.0));
    }

    public int getBitMask() {
        return this.propertyGroup.getProperty("BitMask", -1);
    }

    public double getT0() {
        return this.propertyGroup.getProperty("T0", 0.0);
    }

    public int getDataType() {
        if (this.datatype < 0) {
            this.datatype = this.propertyGroup.getProperty("DataType", -1);
        }
        return this.datatype;
    }

    public String getDataTypeString() {
        return this.propertyGroup.getProperty("DataTypeString", "void");
    }

    public String getVehicle() {
        return this.propertyGroup.getProperty("Vehicle");
    }

    public int getSignalNo() {
        return this.propertyGroup.getProperty("SignalNo", this.no);
    }

    public String getSignalType() {
        return this.propertyGroup.getProperty("SignalType", "Analog");
    }

    public String getUnit() {
        return this.propertyGroup.getProperty("Unit", "");
    }

    public double getLowerScale() {
        return this.propertyGroup.getProperty("LowerScale", -1.0);
    }

    public double getUpperScale() {
        return this.propertyGroup.getProperty("UpperScale", 1.0);
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public double getScaleOffset() {
        return this.scaleOffset;
    }

    public String getTypeOfProbe() {
        return this.propertyGroup.getProperty("TypeOfProbe", this.getName());
    }

    public String toString() {
        return this.propertyGroup.toString();
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
    }
}

