/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util.ubh;

import com.highqsoft.fwk.FwkColumnAccess;
import com.highqsoft.fwk.FwkColumnAccessGroup;
import com.highqsoft.fwk.FwkColumnAccessProducer;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkFileFilter;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkPropertyGroup;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyGroupInterface;
import com.highqsoft.interfaces.fwk.FwkReadColumnsFromStreamInterface;
import com.highqsoft.util.ubh.BinaryFormat;
import com.highqsoft.util.ubh.BinaryFormatInterface;
import com.highqsoft.util.ubh.ERGCharDataObserver;
import com.highqsoft.util.ubh.ERGDataObserver;
import com.highqsoft.util.ubh.ERGDoubleDataObserver;
import com.highqsoft.util.ubh.ERGFloatDataObserver;
import com.highqsoft.util.ubh.ERGIntDataObserver;
import com.highqsoft.util.ubh.ERGLongDataObserver;
import com.highqsoft.util.ubh.ERGShortDataObserver;
import com.highqsoft.util.ubh.ERGUCharDataObserver;
import com.highqsoft.util.ubh.ERGUIntDataObserver;
import com.highqsoft.util.ubh.ERGULongDataObserver;
import com.highqsoft.util.ubh.ERGUShortDataObserver;
import com.highqsoft.util.ubh.Signal;
import com.highqsoft.util.ubh.SignalInterface;
import com.highqsoft.util.ubh.UBHInterface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class UBH
extends FwkFileFilter
implements UBHInterface,
FwkReadColumnsFromStreamInterface {
    public static final String[] C_DATATYPES = new String[10];
    public static final int DT_USHORT = 0;
    public static final int DT_SHORT = 1;
    public static final int DT_UCHAR = 2;
    public static final int DT_CHAR = 3;
    public static final int DT_INT = 4;
    public static final int DT_UINT = 5;
    public static final int DT_LONG = 6;
    public static final int DT_ULONG = 7;
    public static final int DT_FLOAT = 8;
    public static final int DT_DOUBLE = 9;
    public static final String COMMENT = "#%;";
    public static final String C_DATATYPENAME = "DataTypeString";
    public static final String DATATYPE = "DataType";
    public static final String C_DATATYPE_UNKNOWN = "void";
    protected FwkPropertyGroupInterface propertyGroup;
    protected BinaryFormat binaryFormat;
    protected SignalInterface[] signals;
    protected FwkColumnAccessInterface[] columns;
    protected long[] signalOffset;
    protected int signalCount;
    protected String dataFile;
    protected String ubhFile;
    protected String path;
    protected String name;
    protected int blocking = -1;
    protected int blockCount = -1;
    protected int sectionSize = -1;

    public UBH() {
    }

    public UBH(String spec) throws IOException, FileNotFoundException {
        int index = spec.toLowerCase().lastIndexOf(".erg");
        if (index > 0) {
            spec = spec.substring(0, index) + ".ub";
        }
        this.readHeader(spec);
    }

    protected void readHeader(String spec) throws IOException, FileNotFoundException {
        int index;
        FwkPropertyGroupInterface tmp;
        File file = new File(spec);
        if (!file.exists()) {
            URL url;
            InputStream is = null;
            try {
                url = new URL(spec);
                is = url.openStream();
            }
            catch (Throwable t) {
                url = UBH.class.getResource(spec);
                if (url != null) {
                    is = url.openStream();
                }
                try {
                    url = new URL(spec);
                    is = url.openStream();
                }
                catch (Throwable noURL) {
                    url = new URL("file", "localhost", spec);
                    is = url.openStream();
                }
            }
            tmp = this.read(is);
            try {
                is.close();
            }
            catch (Throwable closeT) {
                // empty catch block
            }
            this.path = url.getPath();
            this.name = url.getFile();
        } else {
            FileInputStream is = new FileInputStream(file);
            tmp = this.read(is);
            try {
                ((InputStream)is).close();
            }
            catch (Throwable closeT) {
                // empty catch block
            }
            this.path = file.getAbsolutePath();
            this.name = file.getName();
        }
        this.propertyGroup = new FwkPropertyGroup();
        if (tmp != null) {
            this.createDefaultPropertySet(this.name, tmp.getProperty("BinaryFormat.SignalCount", 0));
            this.propertyGroup.putAll(tmp);
        }
        if ((index = this.name.lastIndexOf(46)) > 0) {
            this.name = this.name.substring(0, index);
        }
        index = this.path.lastIndexOf(this.name);
        this.dataFile = this.path.substring(0, index) + this.name + ".erg";
        this.ubhFile = this.path;
        this.signalCount = -1;
        int count = this.getSignalCount();
        this.signals = new SignalInterface[count];
        this.columns = new FwkColumnAccessInterface[count];
        this.signalOffset = new long[count];
        this.blocking = this.propertyGroup.getProperty("BinaryFormat.Blocking", 1);
        this.blockCount = this.propertyGroup.getProperty("BinaryFormat.BlockCount", 1);
        this.sectionSize = 0;
        for (int no = 1; no <= count; ++no) {
            int dt = this.propertyGroup.getProperty("Signal_" + no + ".DataType", C_DATATYPES.length);
            this.signalOffset[no - 1] = this.sectionSize;
            this.sectionSize += UBH.getValueByteCount(dt) * this.blocking;
            if (dt < C_DATATYPES.length) {
                this.propertyGroup.setProperty("Signal_" + no + "." + C_DATATYPENAME, C_DATATYPES[dt]);
                continue;
            }
            this.propertyGroup.setProperty("Signal_" + no + "." + C_DATATYPENAME, C_DATATYPE_UNKNOWN);
        }
    }

    protected void createDefaultPropertySet(String spec, int numSignals) {
        this.propertyGroup = new FwkPropertyGroup();
        this.propertyGroup.setProperty("General.Version", "1");
        this.propertyGroup.setProperty("General.DebugLevel", "0");
        this.propertyGroup.setProperty("BinaryFormat.CreatedOnPlatform", "UNIX");
        this.propertyGroup.setProperty("BinaryFormat.ByteSwapIsNeeded", "0");
        this.propertyGroup.setProperty("BinaryFormat.ByteOrder", "MSB");
        this.propertyGroup.setProperty("BinaryFormat.WordOrder", "MSW");
        this.propertyGroup.setProperty("BinaryFormat.HeaderGlobalSize", "0");
        this.propertyGroup.setProperty("BinaryFormat.HeaderSignalSize", "0");
        this.propertyGroup.setProperty("BinaryFormat.HeaderFrameSize", "0");
        this.propertyGroup.setProperty("BinaryFormat.Blocking", "1");
        this.propertyGroup.setProperty("BinaryFormat.BlockCount", "0");
        this.propertyGroup.setProperty("BinaryFormat.SignalCount", "0");
        this.propertyGroup.setProperty("BinaryFormat.SignalType", "Analog");
        this.propertyGroup.setProperty("BinaryFormat.SignalCount", "0");
        this.propertyGroup.setProperty("ALL_Signals.Delta", "1");
        this.propertyGroup.setProperty("ALL_Signals.Rate", "1");
        this.propertyGroup.setProperty("ALL_Signals.BitMask", "-1");
        this.propertyGroup.setProperty("ALL_Signals.T0", "0");
        this.propertyGroup.setProperty("ALL_Signals.DataType", "1");
        this.propertyGroup.setProperty("ALL_Signals.Vehicle", "");
        this.propertyGroup.setProperty("ALL_Signals.Name", "%d_%n");
        FwkPropertyGroup all = new FwkPropertyGroup();
        all.putAll((Map<?, ?>)this.propertyGroup.getGroup("ALL_Signals"));
        for (int i = 1; i <= numSignals; ++i) {
            all.setProperty("Name", spec + "_" + i);
            FwkPropertyGroup signal = new FwkPropertyGroup();
            signal.putAll((Map<?, ?>)all);
            this.propertyGroup.put("Signal_" + i, signal);
            int index = this.propertyGroup.getProperty("Signal_" + i + ".DataType", 1);
            this.propertyGroup.setProperty("Signal_" + i + ".DataTypeString", C_DATATYPES[index]);
        }
    }

    public void release() {
        this.propertyGroup = null;
        this.binaryFormat = null;
        this.signals = null;
        this.columns = null;
        this.signalOffset = null;
        this.dataFile = null;
        this.ubhFile = null;
        this.path = null;
        this.name = null;
    }

    public boolean accept(File f) {
        boolean ret = false;
        if (f != null && !(ret = f.isDirectory())) {
            ret = "ub".compareToIgnoreCase(this.getExtension(f)) == 0;
        }
        return ret;
    }

    public String getDescription() {
        return FwkPropertyBus.getProperty("UBH.Text.Description") + " (*.ub)";
    }

    public long getOffset(int signal, int datatype, int index) {
        long ret = -1L;
        if (this.getCountPerSignal() > index) {
            ret = this.getBlocking() == 1 ? this.signalOffset[signal] + (long)(index * UBH.getValueByteCount(datatype)) : this.signalOffset[signal] + (long)(this.sectionSize * (index / this.getBlocking())) + (long)(index % this.getBlocking() * UBH.getValueByteCount(datatype));
        }
        return ret;
    }

    public long getBlockOffset(int signal, int datatype, int index) {
        long ret = -1L;
        if (this.getCountPerSignal() > index) {
            ret = this.getBlocking() == 1 ? this.signalOffset[signal] + (long)(index * UBH.getValueByteCount(datatype)) : this.signalOffset[signal] + (long)(this.sectionSize * (index / this.getBlocking()));
        }
        return ret;
    }

    public static int getValueByteCount(int dataType) {
        int ret = -1;
        switch (dataType) {
            case 0: {
                ret = 2;
                break;
            }
            case 1: {
                ret = 2;
                break;
            }
            case 2: {
                ret = 1;
                break;
            }
            case 3: {
                ret = 1;
                break;
            }
            case 4: {
                ret = 4;
                break;
            }
            case 5: {
                ret = 4;
                break;
            }
            case 6: {
                ret = 8;
                break;
            }
            case 7: {
                ret = 8;
                break;
            }
            case 8: {
                ret = 4;
                break;
            }
            case 9: {
                ret = 8;
                break;
            }
            default: {
                ret = -1;
            }
        }
        return ret;
    }

    public String getVersion() {
        return this.propertyGroup.getProperty("General.Version", "1");
    }

    public int getDebugLevel() {
        return this.propertyGroup.getProperty("General.DebugLevel", 0);
    }

    public BinaryFormatInterface getBinaryFormat() {
        if (this.binaryFormat == null) {
            this.binaryFormat = new BinaryFormat(this.propertyGroup.getGroup("BinaryFormat"));
        }
        return this.binaryFormat;
    }

    public int getSignalCount() {
        if (this.signalCount < 0) {
            this.signalCount = this.getBinaryFormat().getDataSignalCount();
        }
        return this.signalCount;
    }

    public SignalInterface getSignal(int no) {
        SignalInterface retSignal = null;
        if (++no > 0 && this.signals.length >= no) {
            if (this.signals[no - 1] == null) {
                FwkPropertyGroupInterface ret = null;
                if (this.getSignalCount() >= no) {
                    ret = this.propertyGroup.getGroup("Signal_" + no);
                }
                if (ret != null) {
                    this.signals[no - 1] = new Signal(ret, this.name, no);
                }
            }
            retSignal = this.signals[no - 1];
        }
        return retSignal;
    }

    public String toString() {
        if (this.propertyGroup != null) {
            return this.propertyGroup.toString();
        }
        return this.getClass().getName();
    }

    public FwkColumnAccessInterface getColumn(int no) {
        FwkColumnAccessInterface ret = null;
        if (no >= 0 && this.columns.length > no) {
            if (this.columns[no] == null) {
                String colName = this.propertyGroup.getProperty("Signal_" + (no + 1) + ".Name");
                String unit = this.propertyGroup.getProperty("Signal_" + (no + 1) + ".Unit");
                ERGDataObserver observer = null;
                try {
                    switch (this.getSignal(no).getDataType()) {
                        case 0: {
                            observer = new ERGShortDataObserver(this, no, this.dataFile);
                            break;
                        }
                        case 1: {
                            observer = new ERGUShortDataObserver(this, no, this.dataFile);
                            break;
                        }
                        case 2: {
                            observer = new ERGCharDataObserver(this, no, this.dataFile);
                            break;
                        }
                        case 3: {
                            observer = new ERGUCharDataObserver(this, no, this.dataFile);
                            break;
                        }
                        case 4: {
                            observer = new ERGIntDataObserver(this, no, this.dataFile);
                            break;
                        }
                        case 5: {
                            observer = new ERGUIntDataObserver(this, no, this.dataFile);
                            break;
                        }
                        case 6: {
                            observer = new ERGLongDataObserver(this, no, this.dataFile);
                            break;
                        }
                        case 7: {
                            observer = new ERGULongDataObserver(this, no, this.dataFile);
                            break;
                        }
                        case 8: {
                            observer = new ERGFloatDataObserver(this, no, this.dataFile);
                            break;
                        }
                        case 9: {
                            observer = new ERGDoubleDataObserver(this, no, this.dataFile);
                            break;
                        }
                        default: {
                            System.err.println("Unknown datatype " + this.getSignal(no).getDataType());
                        }
                    }
                    if (observer != null) {
                        this.columns[no] = new FwkColumnAccess(this.path + "[" + colName + "]" + colName, colName, unit, observer);
                    }
                    FwkPropertyGroupInterface channelGroup = this.propertyGroup.getGroup("Signal_" + (no + 1));
                    Iterator it = channelGroup.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        this.columns[no].setProperty(key, channelGroup.getProperty(key));
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            ret = this.columns[no];
        }
        return ret;
    }

    public String getCreatedOnPlatform() {
        return this.propertyGroup.getProperty("CreatedOnPlatform", "UNIX");
    }

    public FwkColumnAccessInterface[] getColumns() {
        int c = this.getSignalCount();
        for (int i = 0; i < c; ++i) {
            this.getColumn(i);
        }
        return this.columns;
    }

    public FwkColumnAccessInterface[] read(String spec, InputStream unused) throws RuntimeException {
        try {
            this.readHeader(spec);
            FwkColumnAccessInterface[] ret = this.getColumns();
            if (ret != null && ret.length != 0) {
                FwkColumnAccessGroup group = new FwkColumnAccessGroup(spec, this.name);
                int count = ret.length;
                for (int i = 0; i < count; ++i) {
                    group.addChild(ret[i]);
                    FwkColumnAccessProducer.add(group);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new FwkException(-1073676289, "$RCSfile: UBH.java,v $", "$revision$", "AH 2002-05-03 15:02", "Cannot read UB header " + spec, this, t);
        }
    }

    public int getBlocking() {
        return this.blocking;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public int getCountPerSignal() {
        return this.getBlocking() * this.getBlockCount();
    }

    public FwkPropertyGroupInterface read(InputStream is) throws IOException {
        FwkPropertyGroup ret = new FwkPropertyGroup();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader buf = new BufferedReader(isr);
        String line = buf.readLine();
        if (line != null) {
            line = line.trim();
        }
        String section = "";
        String keyword = "";
        String value = "";
        while (line != null) {
            if (line.length() > 0 && COMMENT.indexOf(line.charAt(0)) < 0) {
                String[] arr;
                if (line.charAt(0) == '[') {
                    int idx = line.indexOf(93);
                    if (idx > 0) {
                        section = line.substring(1, idx);
                    } else {
                        arr = line.split("=");
                        if (arr.length >= 2) {
                            keyword = arr[0].trim();
                            value = arr[1].trim();
                        }
                    }
                } else {
                    arr = line.split("=");
                    if (arr.length >= 2) {
                        keyword = arr[0].trim();
                        value = arr[1].trim();
                    }
                }
                if (keyword.length() > 0 && value.length() > 0) {
                    if (section.length() > 0) {
                        ret.setProperty(section + "." + keyword, value);
                    } else {
                        ret.setProperty(keyword, value);
                    }
                    value = "";
                    keyword = "";
                }
            }
            if ((line = buf.readLine()) == null) continue;
            line = line.trim();
        }
        try {
            buf.close();
            isr.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        return ret;
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        FwkContainer.openFrame("com.highqsoft.resourcemonitor.ResourceMonitor");
        try {
            Vector<UBH> vec = new Vector<UBH>();
            for (int i = 0; i < 1000; ++i) {
                UBH ubh = new UBH("file:/D:/DOKUME~1/andy/LOKALE~1/Temp/Kan001.ub");
                System.out.println(i + ": " + ubh.getColumn(0).getValues().length);
                vec.add(ubh);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        UBH.C_DATATYPES[0] = "singed short";
        UBH.C_DATATYPES[1] = "unsigned short";
        UBH.C_DATATYPES[2] = "signed char";
        UBH.C_DATATYPES[3] = "unsigned char";
        UBH.C_DATATYPES[4] = "signed int";
        UBH.C_DATATYPES[5] = "unsigned int";
        UBH.C_DATATYPES[6] = "signed long";
        UBH.C_DATATYPES[7] = "unsigned long";
        UBH.C_DATATYPES[8] = "float";
        UBH.C_DATATYPES[9] = "double";
    }
}

