/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.util.ubh;

import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkFileFilter;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkWriteColumnsToStreamInterface;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class UBHFileWriter
extends FwkFileFilter
implements FwkWriteColumnsToStreamInterface {
    public void write(String ref, OutputStream os, FwkColumnAccessInterface[] cols) throws FwkException {
        try {
            int size = cols.length;
            int[] len = new int[size];
            String name = ref;
            int index = ref.lastIndexOf(46);
            if (index > 0) {
                name = name.substring(0, index);
            }
            int maxLen = -1;
            for (int i = 0; i < size; ++i) {
                if (cols[i] == null) continue;
                len[i] = cols[i].getCount();
                maxLen = Math.max(maxLen, len[i]);
            }
            BufferedOutputStream ps = new BufferedOutputStream(new FileOutputStream(name + ".ub"));
            StringBuffer header = new StringBuffer(1024);
            header.append("[General]\n");
            header.append("Version=1\n");
            header.append("DebugLevel=0\n\n");
            header.append("[BinaryFormat]\n");
            header.append("CreatedOnPlatform=PC\n");
            header.append("; Groesse des Datei-Headers am Anfang der Datei\n");
            header.append("HeaderGlobalSize=0\n");
            header.append("; Groesse eines jeden Kanalheaders am Anfang der Datei\n");
            header.append("HeaderSignalSize=0\n");
            header.append("; Groesse eines zusammenhaengenden Datenblocks je Kanal\n");
            header.append("Blocking=" + maxLen);
            header.append("\n; Anzahl Bloecke insgesamt je Kanal\n");
            header.append("BlockCount=1\n");
            header.append("\n; Anzahl Kanaele in der Datei\n");
            header.append("SignalCount=" + cols.length + "\n\n");
            for (int i = 0; i < size; ++i) {
                if (cols[i] == null) continue;
                header.append("\n\n");
                header.append("[Signal_" + (i + 1));
                header.append("]\nSignalNo=" + (i + 1));
                header.append("\nDataType=8");
                header.append("\nName=" + cols[i].getColumnName());
                header.append("\nUnit=[" + cols[i].getUnitString());
                header.append("]\nScaleUpper=" + cols[i].getMaximum());
                header.append("\nScaleLower=" + cols[i].getMinimum());
            }
            header.append("\n");
            ps.write(header.toString().getBytes(), 0, header.length());
            header.delete(0, header.length());
            ps.close();
            BufferedOutputStream raf = new BufferedOutputStream(new FileOutputStream(name + ".erg"));
            for (int count = 0; count < size; ++count) {
                if (cols[count] == null) continue;
                for (int i = 0; i < maxLen; ++i) {
                    if (i < len[count] && cols[count].getFlagAt(i) == 15) {
                        UBHFileWriter.writeFloat(raf, (float)cols[count].getValueAt(i));
                        continue;
                    }
                    UBHFileWriter.writeFloat(raf, 0.0f);
                }
            }
            raf.close();
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: UBHFileWriter.java,v $", "$Revision", "AH 2001-10-29 11:38", FwkPropertyBus.getProperty("FwkContainer.Text.Error_ReadFile"), this, t);
        }
    }

    protected static void writeInt(OutputStream file, int v) throws IOException {
        file.write(v >>> 0 & 0xFF);
        file.write(v >>> 8 & 0xFF);
        file.write(v >>> 16 & 0xFF);
        file.write(v >>> 24 & 0xFF);
    }

    protected static void writeFloat(OutputStream file, float v) throws IOException {
        UBHFileWriter.writeInt(file, Float.floatToIntBits(v));
    }

    public boolean accept(File f) {
        boolean ret = false;
        if (f != null && !(ret = f.isDirectory())) {
            ret = "ub".compareToIgnoreCase(this.getExtension(f)) == 0;
        }
        return ret;
    }

    public String getDescription() {
        return FwkPropertyBus.getProperty("UBH.Text.Description") + " (*.ub)";
    }
}

