/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.uml;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.odsx.OdsxSession;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.asam.ods.AoException;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationAttribute;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationRelation;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.BaseRelation;
import org.asam.ods.EnumerationDefinition;
import org.asam.ods.RelationRange;

public class ODSdiff {
    public static final String version = "$Revision: 1.2 $";
    public static final String CLASSNAME = "UML2ODS ";
    public static final String AO_SERVICE_ATHOS = "com.highqsoft.ods.athos.AoService";
    public static final String AO_SERVICE_CORBA = "com.highqsoft.ods.corba.AoService";
    public static final String LOGON_USERPARM = "USER";
    public static final String LOGON_PASSWORDPARM = "PASSWORD";
    private static int IDX_ATT_NAME = 0;
    private static int IDX_ATT_BASE = 1;
    private static int IDX_ATT_DATATYPE = 2;
    private static int IDX_ATT_AUTOGEN = 3;
    private static int IDX_ATT_OBLIGATORY = 4;
    private static int IDX_ATT_UNIQUE = 5;
    private static int IDX_ATT_LENGTH = 6;
    private String[] attributeDescriptives = new String[]{"Name", "Base Type", "Data Type", "AutoGenerate", "Obligatory", "Unique", "Length"};
    private static int IDX_AR_NAME = 0;
    private static int IDX_AR_BASE = 1;
    private static int IDX_AR_TYPE = 2;
    private static int IDX_AR_FROM = 3;
    private static int IDX_AR_TO = 4;
    private static int IDX_AR_INVNAME = 5;
    private static int IDX_AR_RANGE = 6;
    private static int IDX_AR_FULL = 7;
    private String[] relationDescriptives = new String[]{"Name", "Base Relation", "Relation Type", "From", "Related To", "Inverse Name", "Relation Range", "Relation"};
    PrintWriter pw = null;
    private TreeMap tmCombined = new TreeMap();
    StringBuffer sbElements = new StringBuffer();
    StringBuffer sbEnums = new StringBuffer();
    private HashMap hmBaseTypesA = new HashMap();
    private HashMap hmBaseTypesB = new HashMap();
    String serviceNameA = "";
    String serviceTypeA = "athos";
    String atfFileNameA = "";
    String userNameA = "markq";
    String passwordA = "jane";
    String hostName = "localhost";
    String portName = "900";
    String serviceNameB = "";
    String serviceTypeB = "athos";
    String atfFileNameB = "";
    String userNameB = "markq";
    String passwordB = "jane";
    String htmlFileName = "c:/temp/odsdiff.html";
    private int intElementCountA = 0;
    private int intAttributeCountA = 0;
    private int intRelationsCountA = 0;
    private int intEnumerationsCountA = 0;
    private int intSecuredCountA = 0;
    private int intIdentElementCountA = 0;
    private int intIdentAttributeCountA = 0;
    private int intIdentRelationsCountA = 0;
    private int intIdentEnumerationsCountA = 0;
    private int intDiffElementCountA = 0;
    private int intDiffAttributeCountA = 0;
    private int intDiffRelationsCountA = 0;
    private int intDiffEnumerationsCountA = 0;
    private int intElementCountB = 0;
    private int intAttributeCountB = 0;
    private int intRelationsCountB = 0;
    private int intEnumerationsCountB = 0;
    private int intSecuredCountB = 0;
    private int intIdentElementCountB = 0;
    private int intIdentAttributeCountB = 0;
    private int intIdentRelationsCountB = 0;
    private int intIdentEnumerationsCountB = 0;
    private int intDiffElementCountB = 0;
    private int intDiffAttributeCountB = 0;
    private int intDiffRelationsCountB = 0;
    private int intDiffEnumerationsCountB = 0;

    public String getVersion() {
        return version;
    }

    public static void main(String[] args) {
        int i;
        String serviceNameA = "";
        String serviceTypeA = "athos";
        String atfFileNameA = "";
        String userNameA = "markq";
        String passwordA = "jane";
        String hostName = "localhost";
        String portName = "900";
        String serviceNameB = "";
        String serviceTypeB = "athos";
        String atfFileNameB = "";
        String userNameB = "markq";
        String passwordB = "jane";
        String htmlFileName = "c:/temp/odsdiff.html";
        for (i = 0; i < args.length; ++i) {
            System.out.println("UML2ODS Args" + i + " = " + args[i]);
        }
        for (i = 0; i < args.length - 1; ++i) {
            if (args[i].equalsIgnoreCase("-serviceA")) {
                System.out.println("serviceA is" + i + " = " + args[i + 1]);
                serviceNameA = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-atfA")) {
                System.out.println("atf A is" + i + " = " + args[i + 1]);
                atfFileNameA = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-typeA")) {
                System.out.println("typeA is" + i + " = " + args[i + 1]);
                serviceTypeA = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-pwdA")) {
                System.out.println("pwdA is" + i + " = " + args[i + 1]);
                passwordA = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-userA")) {
                System.out.println("user is" + i + " = " + args[i + 1]);
                userNameA = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-serviceB")) {
                System.out.println("serviceB is" + i + " = " + args[i + 1]);
                serviceNameB = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-atfB")) {
                System.out.println("atf B is" + i + " = " + args[i + 1]);
                atfFileNameB = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-typeB")) {
                System.out.println("typeB is" + i + " = " + args[i + 1]);
                serviceTypeB = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-pwdB")) {
                System.out.println("pwdB is" + i + " = " + args[i + 1]);
                passwordB = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-userB")) {
                System.out.println("user is" + i + " = " + args[i + 1]);
                userNameB = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-port")) {
                System.out.println("port is" + i + " = " + args[i + 1]);
                portName = args[i + 1];
            }
            if (!args[i].equalsIgnoreCase("-host")) continue;
            System.out.println("host is" + i + " = " + args[i + 1]);
            hostName = args[i + 1];
        }
        if (args.length < 3) {
            ODSdiff.usage();
            return;
        }
        ODSdiff diffTool = new ODSdiff();
        System.out.println("hostName  " + hostName);
        System.out.println("portName  " + portName);
        System.out.println("atfFileNameA " + atfFileNameA);
        System.out.println("asamOdsServiceA  " + serviceNameA);
        System.out.println("serviceTypeA  " + serviceTypeA);
        System.out.println("userNameA  " + userNameA);
        System.out.println("passwordA  " + passwordA);
        System.out.println("atfFileNameB " + atfFileNameB);
        System.out.println("asamOdsServiceB  " + serviceNameB);
        System.out.println("serviceTypeB  " + serviceTypeB);
        System.out.println("userNameB  " + userNameB);
        System.out.println("passwordB  " + passwordB);
        if (args[0].equalsIgnoreCase("ODSdiff")) {
            diffTool.publishAStoUML(serviceNameA, serviceTypeA, atfFileNameA, userNameA, passwordA, serviceNameB, serviceTypeB, atfFileNameB, userNameB, passwordB, hostName, portName, htmlFileName);
            System.out.println("ODSdiff completed ");
            return;
        }
        ODSdiff.usage();
    }

    private String publishAStoUML(String serviceNameA, String serviceTypeA, String atfFileNameA, String userNameA, String passwordA, String serviceNameB, String serviceTypeB, String atfFileNameB, String userNameB, String passwordB, String hostName, String portName, String htmlFileName) {
        this.serviceNameA = serviceNameA;
        this.serviceTypeA = serviceTypeA;
        this.atfFileNameA = atfFileNameA;
        this.userNameA = userNameA;
        this.passwordA = passwordA;
        this.hostName = hostName;
        this.portName = portName;
        this.serviceNameB = serviceNameB;
        this.serviceTypeB = serviceTypeB;
        this.atfFileNameB = atfFileNameB;
        this.userNameB = userNameB;
        this.passwordB = passwordB;
        this.htmlFileName = htmlFileName;
        System.out.println(" begin ODSdiff ");
        this.pw = this.openFile(htmlFileName);
        this.printHeader(this.pw, "ODSdiff Model Comparison Tool");
        ApplicationStructure asA = null;
        if (serviceTypeA.equalsIgnoreCase("ATF")) {
            System.out.println(" Process ATF file " + atfFileNameA);
            if (!ODSdiff.checkFileExists(atfFileNameA)) {
                System.out.println(" atfFileNameA " + atfFileNameA + " does not exist");
                return null;
            }
            System.out.println("UML2ODS obtaining app structure from " + atfFileNameA);
            asA = ODSdiff.getAppStructure(atfFileNameA, serviceNameA);
        } else {
            OdsxSession odsxSession = ODSdiff.CreateSession(userNameA, passwordA, serviceTypeA, serviceNameA, hostName, portName);
            if (odsxSession == null) {
                System.out.println("Connection failed ");
                return null;
            }
            try {
                asA = odsxSession.getSession().getApplicationStructure();
            }
            catch (Exception e) {
                System.out.println("UML2ODS Exception authenticating user " + e.toString());
            }
        }
        ApplicationStructure asB = null;
        if (serviceTypeB.equalsIgnoreCase("ATF")) {
            System.out.println(" Process ATF file " + atfFileNameB);
            if (!ODSdiff.checkFileExists(atfFileNameB)) {
                System.out.println(" atfFileNameB " + atfFileNameB + " does not exist");
                return null;
            }
            System.out.println("UML2ODS obtaining app structure from " + atfFileNameB);
            asB = ODSdiff.getAppStructure(atfFileNameB, serviceNameB);
        } else {
            OdsxSession odsxSession = ODSdiff.CreateSession(userNameB, passwordB, serviceTypeB, serviceNameB, hostName, portName);
            if (odsxSession == null) {
                System.out.println("Connection failed ");
                return null;
            }
            try {
                asB = odsxSession.getSession().getApplicationStructure();
            }
            catch (Exception e) {
                System.out.println("UML2ODS Exception obtaining App Structure for service B " + e.toString());
            }
        }
        try {
            this.compareModelElements(asA, asB);
        }
        catch (Exception e) {
            System.out.println("UML2ODS Exception comparing service A to service B " + e.toString());
        }
        try {
            this.compareModelEnums(asA, asB);
        }
        catch (Exception e) {
            System.out.println("UML2ODS Exception comparing enums " + e.toString());
        }
        this.genSummary();
        this.genTOC();
        this.pw.print(this.sbElements);
        this.pw.print(this.sbEnums);
        this.printFooter(this.pw);
        this.closeFile(this.pw);
        this.pw = null;
        return null;
    }

    public void compareModelElements(ApplicationStructure asA, ApplicationStructure asB) throws Exception {
        Object[] elems;
        ApplicationElement elemA = null;
        ApplicationElement elemB = null;
        this.sbElements.append("<table border=\"0\" width=\"100%\" cellpadding=\"1\" cellspacing=\"1\"><th colspan=\"2\"><h2>Application Elements</h2></th>");
        try {
            elems = asA.listElements("*");
            Arrays.sort(elems);
            for (int i = 0; i < elems.length; ++i) {
                elemB = null;
                try {
                    elemA = asA.getElementByName((String)elems[i]);
                }
                catch (Exception e) {
                    System.out.println(" elems [" + i + "] " + (String)elems[i] + " is not valid " + e.getMessage());
                }
                try {
                    elemB = asB.getElementByName((String)elems[i]);
                }
                catch (Exception e) {
                    this.tmCombined.put(elems[i], "onlyA");
                    this.compareElement((String)elems[i], elemA, null);
                }
                if (elemB == null) continue;
                boolean bAttCompare = this.compareElement((String)elems[i], elemA, elemB);
                if (bAttCompare) {
                    this.tmCombined.put(elems[i], "same");
                    ++this.intIdentElementCountA;
                    ++this.intIdentElementCountB;
                    continue;
                }
                this.tmCombined.put(elems[i], "diff");
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getMeasurementNames " + e.toString());
            e.printStackTrace();
            return;
        }
        try {
            elems = asB.listElements("*");
            if (elems == null) {
                System.out.println(" no elems ");
            } else {
                System.out.println(" elems " + elems.length);
            }
            Arrays.sort(elems);
            for (Object element : elems) {
                elemA = null;
                try {
                    elemB = asB.getElementByName((String)element);
                }
                catch (AoException e) {
                    // empty catch block
                }
                try {
                    elemA = asA.getElementByName((String)element);
                }
                catch (Exception e) {
                    this.compareElement((String)element, null, elemB);
                    this.tmCombined.put(element, "onlyB");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getMeasurementNames " + e.toString());
            e.printStackTrace();
            return;
        }
        this.sbElements.append("</table\">");
    }

    public void compareModelEnums(ApplicationStructure asA, ApplicationStructure asB) throws Exception {
        int i;
        Object[] enums;
        this.sbEnums.append("<table border=\"0\" width=\"100%\" cellpadding=\"1\" cellspacing=\"1\"><th colspan=\"2\"><h2>Application Enumerations</h2></th>");
        EnumerationDefinition enumA = null;
        EnumerationDefinition enumB = null;
        try {
            enums = asA.listEnumerations();
            this.intEnumerationsCountA = enums.length;
            Arrays.sort(enums);
            for (i = 0; i < enums.length; ++i) {
                enumB = null;
                try {
                    enumA = asA.getEnumerationDefinition((String)enums[i]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    enumB = asB.getEnumerationDefinition((String)enums[i]);
                }
                catch (Exception e) {
                    ++this.intDiffEnumerationsCountA;
                }
                if (enumB == null) continue;
                ++this.intIdentEnumerationsCountA;
                ++this.intIdentEnumerationsCountB;
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getMeasurementNames " + e.toString());
            e.printStackTrace();
            return;
        }
        try {
            enums = asB.listEnumerations();
            this.intEnumerationsCountB = enums.length;
            Arrays.sort(enums);
            for (i = 0; i < enums.length; ++i) {
                enumB = null;
                try {
                    enumA = asB.getEnumerationDefinition((String)enums[i]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    enumA = asA.getEnumerationDefinition((String)enums[i]);
                    continue;
                }
                catch (Exception e) {
                    ++this.intDiffEnumerationsCountB;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getMeasurementNames " + e.toString());
            e.printStackTrace();
            return;
        }
        this.sbEnums.append("</table\">");
    }

    private void genSummary() {
        this.intDiffRelationsCountA = this.intRelationsCountA - this.intIdentRelationsCountA;
        this.intDiffRelationsCountB = this.intRelationsCountB - this.intIdentRelationsCountB;
        this.intDiffAttributeCountA = this.intAttributeCountA - this.intIdentAttributeCountA;
        this.intDiffAttributeCountB = this.intAttributeCountB - this.intIdentAttributeCountB;
        this.intDiffElementCountA = this.intElementCountA - this.intIdentElementCountA;
        this.intDiffElementCountB = this.intElementCountB - this.intIdentElementCountB;
        this.pw.println("<table border=\"0\" width=\"100%\" cellpadding=\"1\" cellspacing=\"1\"><th colspan=\"3\"><h2>Summary</h2></th>");
        this.pw.println("<tr class=\"tableheader\"><td></td><td><h4>" + this.serviceNameA + "</h4></td><td><h4>" + this.serviceNameB + "</h4></td></tr>");
        this.pw.println("<tr ><td class=\"colheader\">Number of Elements:</td><td>" + this.intElementCountA + "</td><td>" + this.intElementCountB + "</td></tr>");
        this.pw.println("<tr ><td class=\"colheader\">&nbsp;&nbsp;Number of Identical Elements:</td><td>" + this.intIdentElementCountA + "</td><td>" + this.intIdentElementCountB + "</td></tr>");
        this.pw.println("<tr ><td class=\"colheader\">&nbsp;&nbsp;Number of Differing Elements:</td><td>" + this.intDiffElementCountA + "</td><td>" + this.intDiffElementCountB + "</td></tr>");
        this.pw.println("<tr ><td class=\"colheader\">Number of Attributes:</td><td>" + this.intAttributeCountA + "</td><td>" + this.intAttributeCountB + "</td></tr>");
        this.pw.println("<tr ><td class=\"colheader\">&nbsp;&nbsp;Number of Identical Attributes:</td><td>" + this.intIdentAttributeCountA + "</td><td>" + this.intIdentAttributeCountB + "</td></tr>");
        this.pw.println("<tr ><td class=\"colheader\">&nbsp;&nbsp;Number of Differing Attributes:</td><td>" + this.intDiffAttributeCountA + "</td><td>" + this.intDiffAttributeCountB + "</td></tr>");
        this.pw.println("<tr ><td class=\"colheader\">Number of Relations:</td><td>" + this.intRelationsCountA + "</td><td>" + this.intRelationsCountB + "</td></tr>");
        this.pw.println("<tr ><td class=\"colheader\">&nbsp;&nbsp;Number of Identical Relations:</td><td>" + this.intIdentRelationsCountA + "</td><td>" + this.intIdentRelationsCountB + "</td></tr>");
        this.pw.println("<tr ><td class=\"colheader\">&nbsp;&nbsp;Number of Differing Relations:</td><td>" + this.intDiffRelationsCountA + "</td><td>" + this.intDiffRelationsCountB + "</td></tr>");
        this.pw.println("<tr ><td class=\"colheader\">Number of Enumerations:</td><td>" + this.intEnumerationsCountA + "</td><td>" + this.intEnumerationsCountB + "</td></tr>");
        this.pw.println("<tr ><td class=\"colheader\">&nbsp;&nbsp;Number of Identical Enumerations:</td><td>" + this.intIdentEnumerationsCountA + "</td><td>" + this.intIdentEnumerationsCountB + "</td></tr>");
        this.pw.println("<tr ><td class=\"colheader\">&nbsp;&nbsp;Number of Differing Enumerations:</td><td>" + this.intDiffEnumerationsCountA + "</td><td>" + this.intDiffEnumerationsCountB + "</td></tr>");
        this.pw.println("<tr ><td class=\"colheader\">Number of Secured Elements:</td><td>" + this.intSecuredCountA + "</td><td>" + this.intSecuredCountB + "</td></tr>");
        this.pw.println("</table><br><br>");
    }

    private void genTOC() {
        this.pw.println("<table border=\"0\" width=\"100%\" cellpadding=\"1\" cellspacing=\"1\"><th colspan=\"2\"><h2>Element Comparison</h2></th>");
        this.pw.println("<tr class=\"tableheader\"><td><h4>" + this.serviceNameA + "</h4></td><td><h4>" + this.serviceNameB + "</h4></td></tr>");
        for (Map.Entry e : this.tmCombined.entrySet()) {
            System.out.println(e.getKey() + " is " + e.getValue());
            String result = (String)e.getValue();
            String imgA = null;
            String imgB = null;
            if (result.equalsIgnoreCase("onlyA")) {
                imgA = (String)this.hmBaseTypesA.get(e.getKey());
                this.pw.println("<tr><td class=\"only\"> <img src=\"images/" + imgA + ".gif\" border=\"0\">  <a href=\"#" + e.getKey() + "\">" + e.getKey() + "</a></td><td>&nbsp;</td>");
            } else if (result.equalsIgnoreCase("onlyB")) {
                imgB = (String)this.hmBaseTypesB.get(e.getKey());
                this.pw.println("<tr><td>&nbsp;</td><td class=\"only\"> <img src=\"images/" + imgB + ".gif\" border=\"0\">  <a href=\"#" + e.getKey() + "\"> " + e.getKey() + "</a></td>");
            } else {
                imgA = (String)this.hmBaseTypesA.get(e.getKey());
                imgB = (String)this.hmBaseTypesB.get(e.getKey());
                if (result.equalsIgnoreCase("diff")) {
                    this.pw.println("<tr><td class=\"diff\">  <img src=\"images/" + imgA + ".gif\" border=\"0\"> <a href=\"#" + e.getKey() + "\">" + e.getKey() + "</a></td><td class=\"diff\">  <img src=\"images/" + imgB + ".gif\" border=\"0\"> <a href=\"#" + e.getKey() + "\">" + e.getKey() + "</a></td>");
                } else {
                    this.pw.println("<tr><td> <img src=\"images/" + imgA + ".gif\" border=\"0\"> <a href=\"#" + e.getKey() + "\">" + e.getKey() + "</a></td><td> <img src=\"images/" + imgB + ".gif\" border=\"0\"> <a href=\"#" + e.getKey() + "\"> " + e.getKey() + "</a></td>");
                }
            }
            this.pw.println("</tr>");
        }
        this.pw.println("</table><br><br>");
    }

    private boolean compareElement(String elementName, ApplicationElement aeA, ApplicationElement aeB) throws Exception {
        String[] descriptivesB;
        int level;
        boolean bSame = true;
        String elementTypeA = "";
        String elementTypeB = "";
        String elementStatusA = "both";
        String elementStatusB = "both";
        String elementSecurityA = "";
        String elementSecurityB = "";
        ApplicationAttribute aaA = null;
        ApplicationAttribute aaB = null;
        HashMap<String, String> hmCombined = new HashMap<String, String>();
        if (aeA != null) {
            elementTypeA = aeA.getBaseElement().getType();
            this.hmBaseTypesA.put(elementName, aeA.getBaseElement().getType());
            ++this.intElementCountA;
        } else {
            elementStatusB = "only";
        }
        if (aeB != null) {
            elementTypeB = aeB.getBaseElement().getType();
            ++this.intElementCountB;
        } else {
            elementStatusA = "only";
        }
        try {
            level = aeA.getSecurityLevel();
            elementSecurityA = "" + level;
            if (level > 0) {
                ++this.intSecuredCountA;
            }
        }
        catch (RuntimeException e1) {
            // empty catch block
        }
        try {
            level = aeB.getSecurityLevel();
            elementSecurityB = "" + level;
            if (level > 0) {
                ++this.intSecuredCountB;
            }
        }
        catch (RuntimeException e1) {
            // empty catch block
        }
        this.sbElements.append("<tr class=\"pageheader\">");
        this.sbElements.append("<td><a name=\"" + elementName + "\"> </a>&nbsp;<a href=\"#top\">Top</a>&nbsp;&nbsp;<h2>ApplicationElement:" + elementName + "</h2></td>");
        this.sbElements.append("</tr>");
        this.sbElements.append("<tr class=\"tableheader\">");
        this.sbElements.append("<td  class=\"tableheader\" ><h3>Properties</h3></td>");
        this.sbElements.append("</tr>");
        this.sbElements.append("<tr>");
        this.sbElements.append("<td>");
        System.out.println("begin properties table 673");
        this.sbElements.append("<table width=\"100%\" border=\"0\" cellpadding=\"1\" cellspacing=\"1\">");
        this.sbElements.append("<tr class=\"colheader3\">");
        this.sbElements.append("<td colspan=\"2\"><h4> Property</h4></td>");
        this.sbElements.append("<td width=\"31%\"><h4>" + this.serviceNameA + "</h4></td>");
        this.sbElements.append("<td width=\"46%\"><h4>" + this.serviceNameB + "</h4></td>");
        this.sbElements.append("</tr>");
        this.sbElements.append("<tr><td width=\"5%\" class=\"colheader2\">&nbsp;</td>");
        this.sbElements.append("<td class=\"colheader2\">Base Element Type</td><td class=\"" + elementStatusA + "\"><img src=\"images/" + elementTypeA + ".gif\" border=\"0\">" + elementTypeA + "</td><td class=\"" + elementStatusB + "\"><img src=\"images/" + elementTypeB + ".gif\" border=\"0\">" + elementTypeB + "</td>");
        this.sbElements.append("</tr>");
        this.sbElements.append("<tr><td width=\"5%\" class=\"colheader2\">&nbsp;</td>");
        this.sbElements.append("<td class=\"colheader2\">Security Level</td><td class=\"" + elementStatusA + "\">" + elementSecurityA + "</td><td class=\"" + elementStatusB + "\">" + elementSecurityB + "</td>");
        this.sbElements.append("</tr>");
        this.sbElements.append("</table>");
        this.sbElements.append("</td>");
        this.sbElements.append("</tr>");
        this.sbElements.append("<tr>");
        this.sbElements.append("<td  class=\"tableheader\" ><h3>Attributes</h3></td>");
        this.sbElements.append("</tr>");
        this.sbElements.append("<tr>");
        this.sbElements.append("<td>");
        this.sbElements.append("<table width=\"100%\" border=\"0\" cellpadding=\"1\" cellspacing=\"1\">");
        if (aeA != null) {
            String[] attributesA;
            for (String element : attributesA = aeA.listAttributes("*")) {
                int j;
                ++this.intAttributeCountA;
                aaB = null;
                String[] descriptivesA = null;
                descriptivesB = null;
                try {
                    aaA = aeA.getAttributeByName(element);
                }
                catch (Exception e) {
                    bSame = false;
                }
                descriptivesA = this.getAttributeDescriptives(aaA);
                this.sbElements.append("<tr class=\"colheader3\">");
                this.sbElements.append("<td colspan=\"2\"><h4> Attribute: " + descriptivesA[0] + "</h4></td>");
                this.sbElements.append("<td width=\"31%\"><h4>" + this.serviceNameA + "</h4></td>");
                this.sbElements.append("<td width=\"46%\"><h4>" + this.serviceNameB + "</h4></td>");
                this.sbElements.append("</tr>");
                try {
                    aaB = aeB.getAttributeByName(element);
                }
                catch (Exception e) {
                    hmCombined.put(element, "onlyA");
                    for (j = 1; j < descriptivesA.length; ++j) {
                        this.sbElements.append("<tr><td width=\"5%\" class=\"colheader2\">&nbsp;</td>");
                        this.sbElements.append("<td class=\"colheader2\">" + this.attributeDescriptives[j] + "</td><td class=\"only\">" + descriptivesA[j] + "</td><td>&nbsp;</td>");
                        this.sbElements.append("</tr>");
                    }
                    bSame = false;
                }
                if (aaB == null) continue;
                descriptivesB = this.getAttributeDescriptives(aaB);
                hmCombined.put(element, "both");
                boolean bDescriptivesSame = true;
                for (j = 1; j < descriptivesA.length; ++j) {
                    this.sbElements.append("<tr><td width=\"5%\" class=\"colheader2\">&nbsp;</td>");
                    if (descriptivesA[j].equalsIgnoreCase(descriptivesB[j])) {
                        this.sbElements.append("<td class=\"colheader2\">" + this.attributeDescriptives[j] + "</td><td>" + descriptivesA[j] + "</td><td>" + descriptivesA[j] + "</td>");
                    } else {
                        this.sbElements.append("<td class=\"colheader2\">" + this.attributeDescriptives[j] + "</td><td class=\"diff\">" + descriptivesA[j] + "</td><td class=\"diff\">" + descriptivesB[j] + "</td>");
                        bSame = false;
                        bDescriptivesSame = false;
                    }
                    this.sbElements.append("</tr>");
                }
                if (!bDescriptivesSame) continue;
                ++this.intIdentAttributeCountA;
                ++this.intIdentAttributeCountB;
            }
        }
        if (aeB != null) {
            String[] attributesB = aeB.listAttributes("*");
            this.hmBaseTypesB.put(aeB.getName(), aeB.getBaseElement().getType());
            for (String element : attributesB) {
                ++this.intAttributeCountB;
                aaA = null;
                String[] descriptivesB2 = null;
                aaB = aeB.getAttributeByName(element);
                try {
                    aaA = aeA.getAttributeByName(element);
                }
                catch (Exception e) {
                    hmCombined.put(element, "onlyB");
                    descriptivesB2 = this.getAttributeDescriptives(aaB);
                    this.sbElements.append("<tr class=\"colheader3\">");
                    this.sbElements.append("<td colspan=\"2\"><h4> Attribute: " + descriptivesB2[0] + "</h4></td>");
                    this.sbElements.append("<td width=\"31%\"><h4>" + this.serviceNameA + "</h4></td>");
                    this.sbElements.append("<td width=\"46%\"><h4>" + this.serviceNameB + "</h4></td>");
                    this.sbElements.append("</tr>");
                    for (int j = 1; j < descriptivesB2.length; ++j) {
                        this.sbElements.append("<tr><td width=\"5%\" class=\"colheader2\">&nbsp;</td>");
                        this.sbElements.append("<td class=\"colheader2\">" + this.attributeDescriptives[j] + "</td><td>&nbsp;</td><td class=\"only\">" + descriptivesB2[j] + "</td>");
                        this.sbElements.append("</tr>");
                    }
                    bSame = false;
                }
            }
        }
        this.sbElements.append("</table>");
        this.sbElements.append("</td>");
        this.sbElements.append("</tr>");
        this.sbElements.append("<tr class=\"tableheader\">");
        this.sbElements.append("<td  class=\"tableheader\" ><h3>Relations</h3></td>");
        this.sbElements.append("</tr>");
        this.sbElements.append("<tr>");
        this.sbElements.append("<td>");
        this.sbElements.append("<table width=\"100%\" border=\"0\" cellpadding=\"1\" cellspacing=\"1\">");
        HashMap<String, ApplicationRelation> hmRelA = new HashMap<String, ApplicationRelation>();
        HashMap<String, ApplicationRelation> hmRelB = new HashMap<String, ApplicationRelation>();
        if (aeB != null) {
            ApplicationRelation[] arB = aeB.getAllRelations();
            this.intRelationsCountB += arB.length;
            for (ApplicationRelation ar : arB) {
                hmRelB.put(ar.getRelationName(), ar);
            }
        }
        if (aeA != null) {
            ApplicationRelation[] arA = aeA.getAllRelations();
            this.intRelationsCountA += arA.length;
            for (ApplicationRelation ar : arA) {
                String relationName = ar.getRelationName();
                hmRelA.put(relationName, ar);
                this.sbElements.append("<tr class=\"colheader3\">");
                this.sbElements.append("<td colspan=\"2\"><h4> Relation: " + relationName + "</h4></td>");
                this.sbElements.append("<td width=\"31%\"><h4>" + this.serviceNameA + "</h4></td>");
                this.sbElements.append("<td width=\"46%\"><h4>" + this.serviceNameB + "</h4></td>");
                this.sbElements.append("</tr>");
                String[] descriptivesA = this.getRelationDescriptives(ar);
                if (hmRelB.containsKey(relationName)) {
                    ApplicationRelation arB = (ApplicationRelation)hmRelB.get(relationName);
                    String[] descriptivesB3 = this.getRelationDescriptives(arB);
                    boolean bDescriptivesMatch = true;
                    for (int j = 1; j < descriptivesA.length; ++j) {
                        this.sbElements.append("<tr><td width=\"5%\" class=\"colheader2\">&nbsp;</td>");
                        if (descriptivesA[j].equalsIgnoreCase(descriptivesB3[j])) {
                            this.sbElements.append("<td class=\"colheader2\">" + this.relationDescriptives[j] + "</td><td>" + descriptivesA[j] + "</td><td>" + descriptivesA[j] + "</td>");
                        } else {
                            this.sbElements.append("<td class=\"colheader2\">" + this.relationDescriptives[j] + "</td><td class=\"diff\">" + descriptivesA[j] + "</td><td class=\"diff\">" + descriptivesB3[j] + "</td>");
                            bSame = false;
                            bDescriptivesMatch = false;
                        }
                        this.sbElements.append("</tr>");
                    }
                    if (!bDescriptivesMatch) continue;
                    ++this.intIdentRelationsCountA;
                    ++this.intIdentRelationsCountB;
                    continue;
                }
                for (int j = 1; j < descriptivesA.length; ++j) {
                    this.sbElements.append("<tr><td width=\"5%\" class=\"colheader2\">&nbsp;</td>");
                    this.sbElements.append("<td class=\"colheader2\">" + this.relationDescriptives[j] + "</td><td class=\"only\">" + descriptivesA[j] + "</td><td>&nbsp;</td>");
                    this.sbElements.append("</tr>");
                }
            }
        }
        for (Map.Entry e : hmRelB.entrySet()) {
            String arName = (String)e.getKey();
            if (hmRelA.containsKey(arName)) continue;
            ApplicationRelation arB = (ApplicationRelation)hmRelB.get(arName);
            descriptivesB = this.getRelationDescriptives(arB);
            this.sbElements.append("<tr class=\"colheader3\">");
            this.sbElements.append("<td colspan=\"2\"><h4> Relation: " + arName + "</h4></td>");
            this.sbElements.append("<td width=\"31%\"><h4>" + this.serviceNameA + "</h4></td>");
            this.sbElements.append("<td width=\"46%\"><h4>" + this.serviceNameB + "</h4></td>");
            this.sbElements.append("</tr>");
            for (int j = 1; j < descriptivesB.length; ++j) {
                this.sbElements.append("<tr><td width=\"5%\" class=\"colheader2\">&nbsp;</td>");
                this.sbElements.append("<td class=\"colheader2\">" + this.relationDescriptives[j] + "</td><td>&nbsp;</td><td class=\"only\">" + descriptivesB[j] + "</td>");
                this.sbElements.append("</tr>");
            }
        }
        this.sbElements.append("</table>");
        this.sbElements.append("</td>");
        this.sbElements.append("</tr>");
        return bSame;
    }

    private String[] getRelationDescriptives(ApplicationRelation ar) {
        String[] relValues = new String[8];
        try {
            relValues[ODSdiff.IDX_AR_NAME] = ar.getRelationName();
        }
        catch (Exception e) {
            relValues[ODSdiff.IDX_AR_NAME] = "";
        }
        try {
            relValues[ODSdiff.IDX_AR_TYPE] = ODSdiff.relationTypeToString(ar.getRelationType().value());
        }
        catch (Exception e) {
            relValues[ODSdiff.IDX_AR_TYPE] = "";
        }
        try {
            relValues[ODSdiff.IDX_AR_FROM] = ar.getElem1().getName();
        }
        catch (Exception e) {
            relValues[ODSdiff.IDX_AR_FROM] = "";
        }
        try {
            relValues[ODSdiff.IDX_AR_TO] = ar.getElem2().getName();
        }
        catch (Exception e) {
            relValues[ODSdiff.IDX_AR_TO] = "";
        }
        try {
            relValues[ODSdiff.IDX_AR_INVNAME] = ar.getInverseRelationName();
        }
        catch (Exception e) {
            relValues[ODSdiff.IDX_AR_INVNAME] = "";
        }
        try {
            relValues[ODSdiff.IDX_AR_RANGE] = ODSdiff.relationRangeToString(ar.getRelationRange());
        }
        catch (Exception e) {
            relValues[ODSdiff.IDX_AR_RANGE] = "";
        }
        try {
            relValues[ODSdiff.IDX_AR_FULL] = ODSdiff.relationshipToString(ar.getRelationship().value());
        }
        catch (Exception e) {
            relValues[ODSdiff.IDX_AR_FULL] = "";
        }
        try {
            BaseRelation br = ar.getBaseRelation();
            relValues[ODSdiff.IDX_AR_BASE] = br != null ? br.getRelationName() : "";
        }
        catch (Exception e) {
            relValues[ODSdiff.IDX_AR_BASE] = "";
        }
        return relValues;
    }

    private String[] getAttributeDescriptives(ApplicationAttribute aa) {
        String[] attValues = new String[7];
        try {
            attValues[ODSdiff.IDX_ATT_NAME] = aa.getName();
        }
        catch (Exception e) {
            attValues[ODSdiff.IDX_ATT_NAME] = "";
        }
        try {
            attValues[ODSdiff.IDX_ATT_BASE] = aa.getBaseAttribute().getName();
        }
        catch (Exception e) {
            attValues[ODSdiff.IDX_ATT_BASE] = "";
        }
        try {
            int dataType = aa.getDataType().value();
            attValues[ODSdiff.IDX_ATT_DATATYPE] = ODSdiff.dataTypeToString(dataType);
        }
        catch (Exception e) {
            attValues[ODSdiff.IDX_ATT_DATATYPE] = "";
        }
        try {
            boolean bVal = aa.isAutogenerated();
            attValues[ODSdiff.IDX_ATT_AUTOGEN] = bVal + "";
        }
        catch (Exception e) {
            attValues[ODSdiff.IDX_ATT_AUTOGEN] = "";
        }
        try {
            boolean bVal = aa.isObligatory();
            attValues[ODSdiff.IDX_ATT_OBLIGATORY] = bVal + "";
        }
        catch (Exception e) {
            attValues[ODSdiff.IDX_ATT_OBLIGATORY] = "";
        }
        try {
            boolean bVal = aa.isUnique();
            attValues[ODSdiff.IDX_ATT_UNIQUE] = bVal + "";
        }
        catch (Exception e) {
            attValues[ODSdiff.IDX_ATT_UNIQUE] = "";
        }
        try {
            int length = aa.getLength();
            attValues[ODSdiff.IDX_ATT_LENGTH] = length + "";
        }
        catch (Exception e) {
            attValues[ODSdiff.IDX_ATT_LENGTH] = "";
        }
        return attValues;
    }

    public static boolean checkFileExists(String fullFileName) {
        boolean exists = new File(fullFileName).exists();
        return exists;
    }

    public static ApplicationStructure getAppStructure(String fullFileName, String serviceName) {
        AoSession aoSession = ODSdiff.getATFSession(serviceName, fullFileName);
        try {
            return aoSession.getApplicationStructure();
        }
        catch (Exception e) {
            System.out.println("UML2ODS .getAppStructure Exception " + e.toString());
            return null;
        }
    }

    public static OdsxSession CreateSession(String username, String password, String servicetype, String service, String hostName, String portName) {
        try {
            String[] args = new String[]{"-Odsx.NewSession.AskForPassword", "false", "-BatchMode", "true", "-NameServiceHost", hostName, "-NameServicePort", portName};
            System.out.println("UML2ODS initializing framework with args ");
            for (int i = 0; i < args.length; ++i) {
                System.out.println("UML2ODS  framework arg " + i + " = " + args[i]);
            }
            FwkContainer.initialize((String[])args);
        }
        catch (Exception e) {
            System.out.println("UML2ODS  Framework initialization failed " + e.toString());
        }
        OdsxSession odsxSession = new OdsxSession();
        odsxSession.setServiceName(service);
        String plumname = AO_SERVICE_ATHOS;
        System.out.println("Requested service" + service + " servicetype " + servicetype);
        if (servicetype.equalsIgnoreCase("corba")) {
            plumname = AO_SERVICE_CORBA;
        }
        System.out.println("Plumname " + plumname + "- servicename " + service);
        odsxSession.setPlumName(plumname);
        String authstring = "USER=" + username + "," + LOGON_PASSWORDPARM + "=" + password;
        System.out.println("Setting authentication authstring " + authstring);
        odsxSession.setAuthentication(authstring);
        return odsxSession;
    }

    public static AoSession getATFSession(String serviceName, String fileName) {
        return ODSdiff.getATFSession(serviceName, fileName, "athos");
    }

    public static AoSession getATFSession(String serviceName, String fileName, String serviceType) {
        AoSession aoSession = null;
        try {
            OdsxSession session = new OdsxSession();
            session.setServiceName(serviceName);
            String plumName = serviceType.equalsIgnoreCase("corba") ? AO_SERVICE_CORBA : AO_SERVICE_ATHOS;
            session.setPlumName(plumName);
            session.setServiceOptions("INIFILE=ATHOS_INI");
            String authstring = "USER=karst, PASSWORD=pisoft, FILENAME=" + fileName;
            session.setAuthentication(authstring);
            aoSession = session.getSession();
        }
        catch (Exception aoException) {
            System.out.println(" getATFSession, newService failed:\n   " + aoException.toString());
            return null;
        }
        return aoSession;
    }

    public void printHeader(PrintWriter pw, String pageTitle) {
        pw.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\"");
        pw.println("        \"http://www.w3.org/TR/html4/frameset.dtd\">");
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        pw.println("<title>" + pageTitle + "</title>");
        pw.println("</head>");
        pw.println("<body bgcolor=\"#DBDBDB\"><font size=\"4\">");
        pw.println("<style>");
        pw.println(" .only{ background-color:#E6E6FA; } ");
        pw.println(" .diff{ background-color:#F0F8FF; } ");
        pw.println(" .pageheader { BACKGROUND-COLOR: #AEAEFF; COLOR: #003399; FONT-FAMILY: arial,helvetica; FONT-SIZE: 12px; FONT-WEIGHT: bold } ");
        pw.println(" .pagesubheader { line-height: 1.8em;\tBACKGROUND-COLOR: #3366FF; COLOR: #FFFFFF; FONT-FAMILY: arial,helvetica; FONT-SIZE: 12px; FONT-WEIGHT: bold; } ");
        pw.println(" .tableheader { BACKGROUND-COLOR: #3399CC; COLOR: #003399; FONT-FAMILY: arial,helvetica; FONT-SIZE: 12px; FONT-WEIGHT: bold } ");
        pw.println(" .colheader  { BACKGROUND-COLOR: #CCCCCC; COLOR: #003399; FONT-FAMILY: arial,helvetica; FONT-SIZE: 12px; FONT-WEIGHT: bold } ");
        pw.println(" .colheader2 { BACKGROUND-COLOR: #CCCCCC; COLOR: #0066FF; FONT-FAMILY: arial,helvetica; FONT-SIZE: 12px; FONT-WEIGHT: bold } ");
        pw.println(" .colheader3 { BACKGROUND-COLOR: #ffffe6; COLOR: #0066FF; FONT-FAMILY: arial, helvetica; FONT-SIZE: 12px; FONT-WEIGHT: bold } ");
        pw.println("</style>");
        pw.println("<a name=\"top\"></a>");
        pw.println("<hr align=\"left\" size=\"1\">");
        pw.println("<table border=\"0\" width=\"100%\" height=\"80\">");
        pw.println("<tr>");
        pw.println("<td width=\"13%\" height=\"54\"><img src=\"images/HQLogo.gif\" width=\"92\" height=\"89\">");
        pw.println("</td>");
        pw.println("<td align=\"right\" valign=\"top\" width=\"71%\" height=\"54\">");
        pw.println("<h1 align=\"center\">ASAM ODS Application Model Comparison</h1>");
        pw.println("</td>");
        pw.println("  </tr>");
        pw.println("</table>");
        pw.println("<hr align=\"left\" size=\"1\">");
    }

    public void printFooter(PrintWriter pw) {
        pw.println("</font></body>");
        pw.println("</html>");
    }

    public String nonBlank(String theString) {
        if (theString == null || theString.length() == 0) {
            theString = "&nbsp;";
        }
        return theString;
    }

    public void closeFile(PrintWriter pw) {
        pw.close();
    }

    public static String dataTypeToString(int dt) {
        String dtStr;
        switch (dt) {
            case 0: {
                dtStr = "DT_UNKNOWN";
                break;
            }
            case 1: {
                dtStr = "DT_STRING";
                break;
            }
            case 2: {
                dtStr = "DT_SHORT";
                break;
            }
            case 3: {
                dtStr = "DT_FLOAT";
                break;
            }
            case 4: {
                dtStr = "DT_BOOLEAN";
                break;
            }
            case 5: {
                dtStr = "DT_BYTE";
                break;
            }
            case 6: {
                dtStr = "DT_LONG";
                break;
            }
            case 7: {
                dtStr = "DT_DOUBLE";
                break;
            }
            case 8: {
                dtStr = "DT_LONGLONG";
                break;
            }
            case 9: {
                dtStr = "DT_ID";
                break;
            }
            case 10: {
                dtStr = "DT_DATE";
                break;
            }
            case 11: {
                dtStr = "DT_BYTESTR";
                break;
            }
            case 12: {
                dtStr = "DT_BLOB";
                break;
            }
            case 13: {
                dtStr = "DT_COMPLEX";
                break;
            }
            case 14: {
                dtStr = "DT_DCOMPLEX";
                break;
            }
            case 15: {
                dtStr = "DS_STRING";
                break;
            }
            case 16: {
                dtStr = "DS_SHORT";
                break;
            }
            case 17: {
                dtStr = "DS_FLOAT";
                break;
            }
            case 18: {
                dtStr = "DS_BOOLEAN";
                break;
            }
            case 19: {
                dtStr = "DS_BYTE";
                break;
            }
            case 20: {
                dtStr = "DS_LONG";
                break;
            }
            case 21: {
                dtStr = "DS_DOUBLE";
                break;
            }
            case 22: {
                dtStr = "DS_LONGLONG";
                break;
            }
            case 23: {
                dtStr = "DS_COMPLEX";
                break;
            }
            case 24: {
                dtStr = "DS_DCOMPLEX";
                break;
            }
            case 25: {
                dtStr = "DS_ID";
                break;
            }
            case 26: {
                dtStr = "DS_DATE";
                break;
            }
            case 27: {
                dtStr = "DS_BYTESTR";
                break;
            }
            case 28: {
                dtStr = "DT_EXTERNALREFERENCE";
                break;
            }
            case 29: {
                dtStr = "DS_EXTERNALREFERENCE";
                break;
            }
            case 30: {
                dtStr = "DT_ENUM";
                break;
            }
            case 31: {
                dtStr = "DS_ENUM";
                break;
            }
            default: {
                dtStr = "Not implemented: <" + dt + ">";
            }
        }
        return dtStr;
    }

    public static String relationRangeToString(RelationRange rr) {
        String rrStr = "[" + rr.min + ":";
        rrStr = rr.max != -1 ? rrStr + rr.max : rrStr + "?";
        rrStr = rrStr + "]";
        return rrStr;
    }

    public static String relationTypeToString(int rt) {
        String rtStr = "Unknown";
        switch (rt) {
            case 0: {
                rtStr = "FATHER_CHILD";
                break;
            }
            case 1: {
                rtStr = "INFO";
                break;
            }
            case 2: {
                rtStr = "INHERITANCE";
            }
        }
        return rtStr;
    }

    public static String relationshipToString(int rs) {
        String rsStr = "Unknown";
        switch (rs) {
            case 0: {
                rsStr = "FATHER";
                break;
            }
            case 1: {
                rsStr = "CHILD";
                break;
            }
            case 2: {
                rsStr = "INFO_TO";
                break;
            }
            case 3: {
                rsStr = "INFO_FROM";
                break;
            }
            case 4: {
                rsStr = "INFO_REL";
                break;
            }
            case 5: {
                rsStr = "SUPERTYPE";
                break;
            }
            case 6: {
                rsStr = "SUBTYPE";
                break;
            }
            case 7: {
                rsStr = "ALL_REL";
            }
        }
        return rsStr;
    }

    public PrintWriter openFile(String filename) {
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            pw = new PrintWriter(fos);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        return pw;
    }

    private static void usage() {
        System.out.println("UML2ODS converts UML XMI files into ODS application structures");
        System.out.println(" Usage: UML2ODS  command [command-options-and-arguments]");
        System.out.println(" where command is genuml or genods.");
        System.out.println("where command-options-and-arguments depend on the specific command");
        System.out.println(" -service  the service name from the athos.ini file");
    }
}

