/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.uml;

import com.highqsoft.uml.UMLAssociation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.asam.ods.AoException;
import org.asam.ods.ApplicationAttribute;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationRelation;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.BaseAttribute;
import org.asam.ods.BaseElement;
import org.asam.ods.BaseRelation;
import org.asam.ods.BaseStructure;
import org.asam.ods.DataType;
import org.asam.ods.InstanceElement;
import org.asam.ods.RelationRange;
import org.asam.ods.Relationship;
import org.asam.ods.T_LONGLONG;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class UMLBean {
    Logger log = Logger.getLogger(UMLBean.class);
    public static final String CLASSNAME = "UMLBean ";
    int idSeq = 0;
    int errCount = 0;
    int rc = 0;
    int rcOk = 0;
    int rcBadConfig = 10;
    int rcGenEx = 20;
    int tagValIdx = 0;
    InstanceElement instelem;
    private ArrayList alLogMessages = new ArrayList();
    private ArrayList alErrMessages = new ArrayList();
    private ApplicationStructure as = null;
    private BaseElement be = null;
    private BaseAttribute[] ba = null;
    private BaseStructure bs = null;
    T_LONGLONG aeId = null;
    private HashMap hmRelations = new HashMap();
    Namespace nsUML;
    Namespace nsUML2;
    Element root;
    Element elXMIcontent;
    Element elUMLModel;
    Element elNSOE;
    Document configDoc;
    Document inputDoc;
    Document outputDoc;
    Element elHeader = new Element("XMI.header");
    Element elDocumentation = new Element("XMI.documentation");
    Element elExporter = new Element("XMI.Exporter");
    Element elContent = new Element("XMI.content");
    Element elModel;
    Element elNsOwnElement;
    HashMap hmDataTypes = new HashMap();
    HashMap hmDefinedTags = new HashMap();
    HashMap hmAppElemStereotypes = new HashMap();
    HashMap hmAppElems = new HashMap();
    ArrayList alElements = new ArrayList();
    String[] baseElem = new String[]{"AoTest", "AoSubTest", "AoEnvironment", "AoNameMap", "AoAttributeMap", "AoTestEquipment", "AoTestEquipmentPart", "AoTestDevice", "AoUnitUnderTest", "AoUnitUnderTestPart", "AoTestSequence", "AoTestSequencePart", "AoTestEquipmentPart", "AoMeasurement", "AoMeasurementQuantity", "AoSubmatrix", "AoLocalColumn", "AoExternalComponent", "AoQuantity", "AoQuantityGroup", "AoUnit", "AoUnitGroup", "AoPhysicalDimension", "AoUser", "AoUserGroup", "AoAny", "AoLog", "AoParameter", "AoParameterSet"};
    String[] dataTypes = new String[]{"DT_UNKNOWN", "DT_STRING", "DT_SHORT", "DT_FLOAT", "DT_BOOLEAN", "DT_BYTE", "DT_LONG", "DT_DOUBLE", "DT_LONGLONG", "DT_ID", "DT_DATE", "DT_BYTESTR", "DT_BLOB", "DT_COMPLEX", "DT_DCOMPLEX", "DS_STRING", "DS_SHORT", "DS_FLOAT", "DS_BOOLEAN", "DS_BYTE", "DS_LONG", "DS_DOUBLE", "DS_LONGLONG", "DS_COMPLEX", "DS_DCOMPLEX", "DS_ID", "DS_DATE", "DS_BYTESTR", "DT_EXTERNALREFERENCE", "DS_EXTERNALREFERENCE"};
    HashMap hmBaseAttributes = new HashMap();
    HashMap hmBaseRelations = new HashMap();
    private static final String version = "$Revision: 1.2 $";

    public String getVersion() {
        return version;
    }

    public int genASfromUML(Document inputDoc, ApplicationStructure as) {
        this.as = as;
        this.inputDoc = inputDoc;
        long mSeconds = System.currentTimeMillis();
        this.nsUML = Namespace.getNamespace((String)"UML", (String)"org.omg.xmi.namespace.UML");
        this.root = inputDoc.getRootElement();
        this.elXMIcontent = this.root.getChild("XMI.content");
        this.elUMLModel = this.elXMIcontent.getChild("Model", this.nsUML);
        this.elNSOE = this.elUMLModel.getChild("Namespace.ownedElement", this.nsUML);
        try {
            this.bs = as.getSession().getBaseStructure();
        }
        catch (Exception e) {
            System.out.println("UMLBean  Exception obtaining base structure " + e.toString());
            e.printStackTrace();
        }
        this.rc = this.getElements(this.elNSOE);
        if (this.rc > 0) {
            return this.rc;
        }
        System.out.println("UMLBean begin processing packages ");
        try {
            List children = this.elNSOE.getChildren("Package", this.nsUML);
            for (Element elPack : children) {
                Element elPackNSOE = elPack.getChild("Namespace.ownedElement", this.nsUML);
                this.getElements(elPackNSOE);
            }
        }
        catch (Exception e) {
            System.out.println("UMLBean exception in  getDataTypes" + e.toString());
            e.printStackTrace();
            return this.rcGenEx;
        }
        return this.rcOk;
    }

    private int getElements(Element elParent) {
        this.rc = this.getDataTypes(elParent);
        if (this.rc > 0) {
            return this.rc;
        }
        this.rc = this.getDefinedTags(elParent);
        if (this.rc > 0) {
            return this.rc;
        }
        this.rc = this.getAppElemStereotypes(elParent);
        if (this.rc > 0) {
            return this.rc;
        }
        this.rc = this.getAppElems(elParent);
        if (this.rc > 0) {
            return this.rc;
        }
        this.rc = this.getAppRelations(elParent);
        if (this.rc > 0) {
            return this.rc;
        }
        return this.rcOk;
    }

    public int genUMLfromAS(ApplicationStructure as) {
        this.as = as;
        long mSeconds = System.currentTimeMillis();
        try {
            String modelName = as.getSession().getName();
            this.rc = this.genHeader(modelName);
            if (this.rc > 0) {
                return this.rc;
            }
            this.nsUML = Namespace.getNamespace((String)"UML", (String)"org.omg.xmi.namespace.UML");
            this.root.addNamespaceDeclaration(this.nsUML);
            this.outputDoc = new Document(this.root);
            this.rc = this.genODSElements();
            if (this.rc > 0) {
                return this.rc;
            }
            this.rc = this.genAssociationUML();
            if (this.rc > 0) {
                return this.rc;
            }
            this.rc = this.genDataType();
            if (this.rc > 0) {
                return this.rc;
            }
            this.genAttributePropertyTagDef("autogenerate");
            this.genAttributePropertyTagDef("unique");
            this.genAttributePropertyTagDef("length");
            this.rc = this.genStereotypeUML();
            if (this.rc > 0) {
                return this.rc;
            }
            this.elNsOwnElement.setContent((Collection)this.alElements);
            this.alLogMessages.add("Elapsed time : " + (double)(System.currentTimeMillis() - mSeconds) * 0.001 + " seconds");
        }
        catch (Throwable t) {
            this.log.error((Object)(".genUMLfromAS exception " + t.toString()));
            this.alErrMessages.add("genUMLfromAS exception:" + t.toString());
            t.printStackTrace();
            return this.rcGenEx;
        }
        return this.rc;
    }

    private int getDataTypes(Element parent) {
        System.out.println("UMLBean loading DataTypes");
        try {
            List children = parent.getChildren("DataType", this.nsUML);
            for (Element child : children) {
                this.hmDataTypes.put(child.getAttributeValue("xmi.id"), child.getAttributeValue("name"));
            }
        }
        catch (Exception e) {
            System.out.println("UMLBean exception in  getDataTypes" + e.toString());
            e.printStackTrace();
            return this.rcGenEx;
        }
        return this.rcOk;
    }

    private int getDefinedTags(Element parent) {
        System.out.println("UMLBean loading defined tags");
        try {
            List children = parent.getChildren("TagDefinition", this.nsUML);
            for (Element child : children) {
                this.hmDefinedTags.put(child.getAttributeValue("xmi.id"), child.getAttributeValue("name"));
            }
        }
        catch (Exception e) {
            System.out.println("UMLBean exception in  getDefinedTags" + e.toString());
            e.printStackTrace();
            return this.rcGenEx;
        }
        return this.rcOk;
    }

    private int getAppElemStereotypes(Element parent) {
        try {
            List children = parent.getChildren("Stereotype", this.nsUML);
            if (children != null) {
                for (Element child : children) {
                    System.out.println("UMLBean  Element base (Stereotype) = " + child.getAttributeValue("xmi.id") + " " + child.getAttributeValue("name"));
                    this.hmAppElemStereotypes.put(child.getAttributeValue("xmi.id"), child.getAttributeValue("name"));
                }
            }
        }
        catch (Exception e) {
            System.out.println("UMLBean exception in  getAppElemStereotypes" + e.toString());
            e.printStackTrace();
            return this.rcGenEx;
        }
        return this.rcOk;
    }

    private int getAppElems(Element parent) {
        System.out.println("UMLBean  Process Application Elements");
        int i = 0;
        try {
            List children = parent.getChildren("Class", this.nsUML);
            Iterator iterator = children.iterator();
            System.out.println("UMLBean  Elements to process = " + children.size());
            while (iterator.hasNext()) {
                Element child = (Element)iterator.next();
                if (child.getName().equalsIgnoreCase("Class")) {
                    this.addAppElem(child);
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("UMLBean exception in  getAppElemStereotypes" + e.toString());
            e.printStackTrace();
            return this.rcGenEx;
        }
        return this.rcOk;
    }

    private int getAppRelations(Element parent) {
        System.out.println("UMLBean Process Application Relations");
        try {
            List children = parent.getChildren("Association", this.nsUML);
            for (Element child : children) {
                System.out.println("UMLBean  process AppRelation " + child.getAttributeValue("name"));
                this.addAppRelation(child);
            }
        }
        catch (Exception e) {
            System.out.println("UMLBean exception in  getAppElemStereotypes" + e.toString());
            e.printStackTrace();
            return this.rcGenEx;
        }
        return this.rcOk;
    }

    private int addAppElem(Element elAppElem) {
        try {
            String aeName = elAppElem.getAttributeValue("name");
            this.hmAppElems.put(elAppElem.getAttributeValue("xmi.id"), aeName);
            System.out.println("UMLBean  Process Element " + elAppElem.getAttributeValue("name"));
            Element elModelElemStereo = elAppElem.getChild("ModelElement.stereotype", this.nsUML);
            Element elStereotype = elModelElemStereo.getChild("Stereotype", this.nsUML);
            String aeBaseIdref = elStereotype.getAttributeValue("xmi.idref");
            if (!this.hmAppElemStereotypes.containsKey(aeBaseIdref)) {
                System.out.println("UMLBean  " + aeName + " basetype " + aeBaseIdref + " hm is not in hm");
                return this.rcGenEx;
            }
            try {
                List children;
                this.be = this.bs.getElementByType((String)this.hmAppElemStereotypes.get(aeBaseIdref));
                ApplicationElement ae = this.as.createElement(this.be);
                ae.setName(aeName);
                ae.removeAttribute(ae.getAttributeByBaseName("id"));
                ae.removeAttribute(ae.getAttributeByBaseName("name"));
                Element elClassFeature = elAppElem.getChild("Classifier.feature", this.nsUML);
                if (elClassFeature != null && (children = elClassFeature.getChildren("Attribute", this.nsUML)) != null) {
                    for (Element attribute : children) {
                        int rc = this.genAppAttribute(ae, attribute);
                        if (rc == this.rcOk) continue;
                        System.out.println("UMLBean  unable to add attribute " + attribute.getAttributeValue("name"));
                    }
                }
            }
            catch (AoException e) {
                System.out.println("UMLBean exception in addAppElem" + e.reason);
                e.printStackTrace();
                return this.rcGenEx;
            }
        }
        catch (Exception e) {
            System.out.println("UMLBean exception in  addAppElem  " + e.toString());
            e.printStackTrace();
            return this.rcGenEx;
        }
        return this.rcOk;
    }

    private int genAppAttribute(ApplicationElement ae, Element attribute) {
        String attrName = attribute.getAttributeValue("name");
        ApplicationAttribute aa = null;
        try {
            aa = ae.createAttribute();
            aa.setName(attrName);
        }
        catch (AoException e) {
            e.printStackTrace();
            return this.rcGenEx;
        }
        Element elAttModelElemStereo = attribute.getChild("ModelElement.stereotype", this.nsUML);
        if (elAttModelElemStereo != null) {
            Element elAttStereotype = elAttModelElemStereo.getChild("Stereotype", this.nsUML);
            String aeAttBaseIdref = elAttStereotype.getAttributeValue("xmi.idref");
            if (this.hmAppElemStereotypes.containsKey(aeAttBaseIdref)) {
                String baseAttrName = (String)this.hmAppElemStereotypes.get(aeAttBaseIdref);
                try {
                    this.ba = this.be.getAttributes(baseAttrName);
                    if (this.ba.length <= 0) {
                        System.out.println("UMLBean  base element has no base attributes with Name = " + baseAttrName);
                        return this.rcGenEx;
                    }
                    aa.setBaseAttribute(this.ba[0]);
                }
                catch (AoException e) {
                    System.out.println("UMLBean  exception attempting to obtain baseAttr. Name is " + baseAttrName + " e:" + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                System.out.println("UMLBean  aeAttBaseIdref " + aeAttBaseIdref + " is not in hmAppElemStereotypes");
                return this.rcGenEx;
            }
        }
        try {
            Element elAttDataType;
            String dataTypeIdref;
            Element elStructFeatureType = attribute.getChild("StructuralFeature.type", this.nsUML);
            if (elStructFeatureType != null && this.hmDataTypes.containsKey(dataTypeIdref = (elAttDataType = elStructFeatureType.getChild("Datatype", this.nsUML)).getAttributeValue("xmi.idref"))) {
                String strDataType = (String)this.hmDataTypes.get(dataTypeIdref);
                DataType dataType = UMLBean.getDataType(strDataType);
                aa.setDataType(dataType);
            }
        }
        catch (AoException e) {
            System.out.println("UMLBean  exception attempting to obtain datatype. Name is " + attrName + " e:" + e.getMessage());
            e.printStackTrace();
        }
        try {
            Element elMultiplicity;
            Element elMultiplicityRange1;
            String lowerValue;
            Element elStructFeatureMult = attribute.getChild("StructuralFeature.multiplicity", this.nsUML);
            if (elStructFeatureMult != null && (lowerValue = (elMultiplicityRange1 = (elMultiplicity = elStructFeatureMult.getChild("Multiplicity", this.nsUML)).getChild("Multiplicity.range", this.nsUML)).getChild("MultiplicityRange", this.nsUML).getAttributeValue("lower")) != null && lowerValue.equalsIgnoreCase("1")) {
                aa.setIsObligatory(true);
            }
        }
        catch (Exception e) {
            System.out.println("UMLBean  exception attempting to obtain multiplicity. Name is " + attrName + " e:" + e.getMessage());
            e.printStackTrace();
        }
        Element elModElemTagValue = attribute.getChild("ModelElement.taggedValue", this.nsUML);
        List attrTags = elModElemTagValue.getChildren("TaggedValue", this.nsUML);
        for (Element elTaggedValue : attrTags) {
            String valueName = elTaggedValue.getAttributeValue("name");
            String dataValue = elTaggedValue.getChild("TaggedValue.dataValue", this.nsUML).getText();
            Element elTagDefinition = elTaggedValue.getChild("TaggedValue.type", this.nsUML).getChild("TagDefinition", this.nsUML);
            String tagDefId = elTagDefinition.getAttributeValue("xmi.idref");
            if (this.hmDefinedTags.containsKey(tagDefId)) {
                String tagDefName = (String)this.hmDefinedTags.get(tagDefId);
                if (tagDefName.equalsIgnoreCase("autogenerate")) {
                    boolean bVal = Boolean.parseBoolean(dataValue);
                    try {
                        aa.setIsAutogenerated(bVal);
                    }
                    catch (AoException e) {
                        System.out.println("UMLBean  Exception on set autogenerated value to " + dataValue + " e:" + e.getMessage());
                        e.printStackTrace();
                    }
                    continue;
                }
                if (tagDefName.equalsIgnoreCase("unique")) {
                    boolean bVal = Boolean.parseBoolean(dataValue);
                    try {
                        aa.setIsUnique(bVal);
                    }
                    catch (AoException e) {
                        System.out.println("UMLBean  Exception on setIsUnique value to " + dataValue + " e:" + e.getMessage());
                        e.printStackTrace();
                    }
                    continue;
                }
                if (tagDefName.equalsIgnoreCase("length")) {
                    try {
                        int iVal = Integer.parseInt(dataValue);
                        aa.setLength(iVal);
                    }
                    catch (Exception e) {
                        System.out.println("UMLBean  Exception on setLength value to " + dataValue + " e:" + e.getMessage());
                        e.printStackTrace();
                    }
                    continue;
                }
                System.out.println("UMLBean  tag: " + valueName + " with value " + dataValue + " is not expected and will be ignored");
                continue;
            }
            System.out.println("UMLBean  tag " + tagDefId + " is not defined");
        }
        return this.rcOk;
    }

    private int addAppRelation(Element elAppRelation) {
        String associationId = "";
        String sourceAeNameEP1 = "";
        String relNameEP1 = "";
        String relBaseNameEP1 = "";
        String relMinEP1 = "";
        String relMaxEP1 = "";
        String targetAeNameEP1 = "";
        String sourceAeNameEP2 = "";
        String relNameEP2 = "";
        String relBaseNameEP2 = "";
        String relMinEP2 = "";
        String relMaxEP2 = "";
        String targetAeNameEP2 = "";
        try {
            associationId = elAppRelation.getAttributeValue("xmi.id");
            Element elAsConn = elAppRelation.getChild("Association.connection", this.nsUML);
            List endpoints = elAsConn.getChildren("AssociationEnd", this.nsUML);
            Iterator iterator = endpoints.iterator();
            int epNbr = 1;
            while (iterator.hasNext()) {
                Element elEndPoint = (Element)iterator.next();
                String relName = elEndPoint.getAttributeValue("name");
                if (relName == null) {
                    relName = "";
                }
                Element elAeMult = elEndPoint.getChild("AssociationEnd.multiplicity", this.nsUML);
                Element elMult = elAeMult.getChild("Multiplicity", this.nsUML);
                Element elMultrange = elMult.getChild("Multiplicity.range", this.nsUML);
                Element elMultRange = elMultrange.getChild("MultiplicityRange", this.nsUML);
                String rangeMin = elMultRange.getAttributeValue("lower");
                String rangeMax = elMultRange.getAttributeValue("upper");
                String participantId = elEndPoint.getChild("AssociationEnd.participant", this.nsUML).getChild("Class", this.nsUML).getAttributeValue("xmi.idref");
                String participant = null;
                if (!this.hmAppElems.containsKey(participantId)) {
                    System.out.println("UMLBean  relation points to invalid element " + participant);
                    return this.rcGenEx;
                }
                participant = (String)this.hmAppElems.get(participantId);
                Element elAeStereo = elEndPoint.getChild("ModelElement.stereotype", this.nsUML);
                String relBaseId = "";
                if (elAeStereo != null) {
                    relBaseId = elAeStereo.getChild("Stereotype", this.nsUML).getAttributeValue("xmi.idref");
                }
                if (epNbr == 1) {
                    sourceAeNameEP1 = participant;
                    relNameEP1 = relName;
                    relBaseNameEP1 = relBaseId;
                    relMinEP1 = rangeMin;
                    relMaxEP1 = rangeMax;
                } else {
                    sourceAeNameEP2 = participant;
                    relNameEP2 = relName;
                    relBaseNameEP2 = relBaseId;
                    relMinEP2 = rangeMin;
                    relMaxEP2 = rangeMax;
                }
                ++epNbr;
            }
            if (relNameEP1.equalsIgnoreCase("")) {
                System.out.println(" setting relNameEP1 to " + sourceAeNameEP2);
                relNameEP1 = sourceAeNameEP2;
            }
            if (relNameEP2.equalsIgnoreCase("")) {
                System.out.println(" setting relNameEP2 to " + sourceAeNameEP1);
                relNameEP2 = sourceAeNameEP1;
            }
            System.out.println(" rel from " + sourceAeNameEP1 + " to " + sourceAeNameEP2);
            this.addRelation(sourceAeNameEP1, sourceAeNameEP2, relMinEP1, relMaxEP1, relNameEP1, relNameEP2, relBaseNameEP1);
        }
        catch (Exception e) {
            System.out.println("UMLBean exception in  getApp Relation" + e.toString());
            e.printStackTrace();
            return this.rcGenEx;
        }
        return this.rcOk;
    }

    private int addRelation(String sourceAeName, String targetAeName, String min, String max, String relationName, String invName, String relationBaseName) {
        try {
            int shMax;
            short shMin;
            ApplicationElement aeParent = this.as.getElementByName(sourceAeName);
            ApplicationElement aeChild = this.as.getElementByName(targetAeName);
            System.out.println(" create relation src: " + sourceAeName + " tgt: " + targetAeName + " relationName: " + relationName + " invName: " + invName + " min: " + min + " max: " + max + " base: " + relationBaseName);
            ApplicationRelation ar = this.as.createRelation();
            ar.setRelationName(relationName);
            ar.setElem2(aeParent);
            ar.setElem1(aeChild);
            ar.setInverseRelationName(invName);
            try {
                shMin = Short.parseShort(min.trim());
            }
            catch (NumberFormatException nfe) {
                System.out.println("NumberFormatException: " + nfe.getMessage());
                shMin = 0;
            }
            try {
                shMax = Short.parseShort(max.trim());
            }
            catch (NumberFormatException nfe) {
                System.out.println("NumberFormatException: " + nfe.getMessage());
                shMax = -1;
            }
            if (relationBaseName == null) {
                RelationRange rr = ar.getRelationRange();
                int iMin = Integer.parseInt(min);
                rr.max = (short)shMax;
                rr.min = shMin;
                System.out.println("UMLBean  setRelationRange min: " + shMin + " max: " + shMax);
                ar.setRelationRange(rr);
            } else {
                System.out.println("UMLBean  Use Default RelationRange ");
            }
        }
        catch (AoException aoE) {
            System.out.println("UMLBean  AoException creating relationship " + aoE.reason);
            return this.rcOk;
        }
        return this.rcOk;
    }

    private int genHeader(String modelName) {
        System.out.println("UMLBean begin gen header for " + modelName);
        this.nsUML = Namespace.getNamespace((String)"UML", (String)"org.omg.xmi.namespace.UML");
        this.root = new Element("XMI");
        this.root.setAttribute("xmi.version", "1.2");
        this.root.setAttribute("timestamp", "Mon Jun 13 14:37:55 PDT 2005");
        this.elExporter.setText("HighQSoft ODS-UML Exporter");
        this.elHeader.addContent((Content)this.elDocumentation);
        this.elDocumentation.addContent((Content)this.elExporter);
        this.root.addContent((Content)this.elHeader);
        this.root.addContent((Content)this.elContent);
        this.elModel = new Element("Model", this.nsUML);
        this.elModel.setAttribute("xmi.id", "model" + this.idSeq++);
        this.elModel.setAttribute("name", modelName);
        this.elModel.setAttribute("isSpecification", "false");
        this.elModel.setAttribute("isRoot", "false");
        this.elModel.setAttribute("isLeaf", "false");
        this.elModel.setAttribute("isAbstract", "false");
        this.elContent.addContent((Content)this.elModel);
        this.elNsOwnElement = new Element("Namespace.ownedElement", this.nsUML);
        this.elModel.addContent((Content)this.elNsOwnElement);
        return 0;
    }

    private int genJavaPackage() {
        Element elJavaPackage = new Element("Package", this.nsUML);
        elJavaPackage.setAttribute("xmi.id", "javapkg");
        elJavaPackage.setAttribute("name", "java");
        elJavaPackage.setAttribute("isSpecification", "false");
        elJavaPackage.setAttribute("isRoot", "false");
        elJavaPackage.setAttribute("isLeaf", "false");
        elJavaPackage.setAttribute("isAbstract", "false");
        Element elJavaNsOwnElement = new Element("Namespace.ownedElement", this.nsUML);
        Element elLangPackage = new Element("Package", this.nsUML);
        elLangPackage.setAttribute("xmi.id", "java");
        elLangPackage.setAttribute("name", "java");
        elLangPackage.setAttribute("isSpecification", "false");
        elLangPackage.setAttribute("isRoot", "false");
        elLangPackage.setAttribute("isLeaf", "false");
        elLangPackage.setAttribute("isAbstract", "false");
        Element elLangNsOwnElement = new Element("Namespace.ownedElement", this.nsUML);
        ArrayList<Element> alJavaItems = new ArrayList<Element>();
        Element elJavaIntElem = new Element("DataType", this.nsUML);
        elJavaIntElem.setAttribute("xmi.id", "DataType_int");
        elJavaIntElem.setAttribute("name", "DataType_int");
        elJavaIntElem.setAttribute("isSpecification", "false");
        elJavaIntElem.setAttribute("isRoot", "false");
        elJavaIntElem.setAttribute("isLeaf", "false");
        elJavaIntElem.setAttribute("isAbstract", "false");
        alJavaItems.add(elJavaIntElem);
        Element elJavaVoidElem = new Element("DataType", this.nsUML);
        elJavaVoidElem.setAttribute("xmi.id", "DataType_void");
        elJavaVoidElem.setAttribute("name", "DataType_void");
        elJavaVoidElem.setAttribute("isSpecification", "false");
        elJavaVoidElem.setAttribute("isRoot", "false");
        elJavaVoidElem.setAttribute("isLeaf", "false");
        elJavaVoidElem.setAttribute("isAbstract", "false");
        alJavaItems.add(elJavaVoidElem);
        Element elJavaStringElem = new Element("Class", this.nsUML);
        elJavaStringElem.setAttribute("xmi.id", "Java_String");
        elJavaStringElem.setAttribute("name", "Java_String");
        elJavaStringElem.setAttribute("isSpecification", "false");
        elJavaStringElem.setAttribute("isRoot", "false");
        elJavaStringElem.setAttribute("isLeaf", "false");
        elJavaStringElem.setAttribute("isAbstract", "false");
        elJavaStringElem.setAttribute("isActive", "false");
        alJavaItems.add(elJavaStringElem);
        elLangNsOwnElement.addContent(alJavaItems);
        elLangPackage.addContent((Content)elLangNsOwnElement);
        elJavaNsOwnElement.addContent((Content)elLangPackage);
        elJavaPackage.addContent((Content)elJavaNsOwnElement);
        this.alElements.add(elJavaPackage);
        return 0;
    }

    private int genDataType() {
        for (int i = 0; i < this.dataTypes.length; ++i) {
            Element elDt = new Element("DataType", this.nsUML);
            elDt.setAttribute("xmi.id", "dt" + i);
            elDt.setAttribute("name", this.dataTypes[i]);
            elDt.setAttribute("visibility", "private");
            elDt.setAttribute("isRoot", "false");
            elDt.setAttribute("isLeaf", "false");
            elDt.setAttribute("isAbstract", "false");
            this.alElements.add(elDt);
        }
        return this.rcOk;
    }

    private int genAttributePropertyTagDef(String tagName) {
        Element elTagDef = new Element("TagDefinition", this.nsUML);
        elTagDef.setAttribute("xmi.id", "ap_" + tagName);
        elTagDef.setAttribute("name", tagName);
        elTagDef.setAttribute("isSpecification", "false");
        Element elTDMult = new Element("TagDefinition.multiplicity", this.nsUML);
        Element elMult = new Element("Multiplicity", this.nsUML);
        elMult.setAttribute("xmi.id", "ap_m_" + tagName);
        Element elMultRange = new Element("Multiplicity.range", this.nsUML);
        Element elMult_Range = new Element("MultiplicityRange", this.nsUML);
        elMult_Range.setAttribute("xmi.id", "ap_r_" + tagName);
        elMult_Range.setAttribute("lower", "1");
        elMult_Range.setAttribute("upper", "1");
        elMultRange.addContent((Content)elMult_Range);
        elMult.addContent((Content)elMultRange);
        elTDMult.addContent((Content)elMult);
        elTagDef.addContent((Content)elTDMult);
        this.alElements.add(elTagDef);
        return this.rcOk;
    }

    private int genStereotypeUML() {
        Element elSt;
        String relatedElemValue;
        for (int i = 0; i < this.baseElem.length; ++i) {
            Element elSt2 = new Element("Stereotype", this.nsUML);
            elSt2.setAttribute("xmi.id", "be" + i);
            elSt2.setAttribute("name", this.baseElem[i]);
            elSt2.setAttribute("visibility", "public");
            elSt2.setAttribute("isSpecification", "false");
            elSt2.setAttribute("isRoot", "false");
            elSt2.setAttribute("isLeaf", "false");
            elSt2.setAttribute("isAbstract", "false");
            elSt2.addContent((Content)new Element("Stereotype.baseClass", this.nsUML).addContent("Class"));
            this.alElements.add(elSt2);
        }
        for (String key : this.hmBaseAttributes.keySet()) {
            relatedElemValue = (String)this.hmBaseRelations.get(key);
            elSt = new Element("Stereotype", this.nsUML);
            elSt.setAttribute("xmi.id", (String)this.hmBaseAttributes.get(key));
            elSt.setAttribute("name", key);
            elSt.setAttribute("visibility", "public");
            elSt.setAttribute("isSpecification", "false");
            elSt.setAttribute("isRoot", "false");
            elSt.setAttribute("isLeaf", "false");
            elSt.setAttribute("isAbstract", "false");
            elSt.addContent((Content)new Element("Stereotype.baseClass", this.nsUML).addContent("Attribute"));
            this.alElements.add(elSt);
        }
        for (String key : this.hmBaseRelations.keySet()) {
            relatedElemValue = (String)this.hmBaseRelations.get(key);
            elSt = new Element("Stereotype", this.nsUML);
            elSt.setAttribute("xmi.id", (String)this.hmBaseRelations.get(key));
            elSt.setAttribute("name", key);
            elSt.setAttribute("visibility", "public");
            elSt.setAttribute("isSpecification", "false");
            elSt.setAttribute("isRoot", "false");
            elSt.setAttribute("isLeaf", "false");
            elSt.setAttribute("isAbstract", "false");
            elSt.addContent((Content)new Element("Stereotype.baseClass", this.nsUML).addContent("AssociationEnd"));
            this.alElements.add(elSt);
        }
        return this.rcOk;
    }

    private int genODSElements() {
        try {
            ApplicationElement[] aeList = this.as.getElements("*");
            for (int i = 0; i < aeList.length; ++i) {
                this.rc = this.genAppElemUML(aeList[i]);
                if (this.rc <= 0) continue;
                return this.rc;
            }
        }
        catch (AoException e) {
            System.out.println("AoException in genODSElements " + e.reason);
            e.printStackTrace();
            return this.rcGenEx;
        }
        return this.rcOk;
    }

    private int genAppElemUML(ApplicationElement ae) {
        int aeId = 0;
        try {
            System.out.println("Begin processing element " + ae.getName());
            aeId = ae.getId().low;
            Element elAppElem1 = new Element("Class", this.nsUML);
            elAppElem1.setAttribute("xmi.id", "ae" + ae.getId().low);
            elAppElem1.setAttribute("visibility", "public");
            elAppElem1.setAttribute("name", ae.getName());
            elAppElem1.setAttribute("isSpecification", "false");
            elAppElem1.setAttribute("isRoot", "false");
            elAppElem1.setAttribute("isLeaf", "false");
            elAppElem1.setAttribute("isAbstract", "false");
            elAppElem1.setAttribute("isActive", "false");
            Element elAppElemMeSt1 = new Element("ModelElement.stereotype", this.nsUML);
            Element elAppElemSt1 = new Element("Stereotype", this.nsUML);
            elAppElemSt1.setAttribute("xmi.idref", "be" + this.getStereotypeId("element", ae.getBaseElement().getType()));
            elAppElemMeSt1.addContent((Content)elAppElemSt1);
            elAppElem1.addContent((Content)elAppElemMeSt1);
            this.alElements.add(elAppElem1);
            Element elClassifier = new Element("Classifier.feature", this.nsUML);
            elAppElem1.addContent((Content)elClassifier);
            ArrayList alAttrs = new ArrayList();
            ApplicationAttribute[] aa = ae.getAttributes("*");
            for (int i = 0; i < aa.length; ++i) {
                this.rc = this.genAppAttrUML(aa[i], alAttrs);
                if (this.rc <= 0) continue;
                return this.rc;
            }
            elClassifier.setContent(alAttrs);
        }
        catch (AoException e) {
            System.out.println("AoException in genAppElemUML " + e.reason);
            e.printStackTrace();
            return this.rcGenEx;
        }
        ApplicationRelation[] arList = null;
        UMLAssociation association = null;
        try {
            arList = ae.getAllRelations();
            for (int arIndex = 0; arIndex < arList.length; ++arIndex) {
                ApplicationRelation ar = arList[arIndex];
                Relationship rs = ar.getRelationship();
                ApplicationElement aeTarget = ar.getElem2();
                String aeName = ae.getName();
                String brName = "";
                String brId = "";
                int rfId = aeTarget.getId().low;
                String rfElem = aeTarget.getName();
                String rrange = "";
                String arName = ar.getRelationName();
                BaseRelation br = ar.getBaseRelation();
                if (br != null) {
                    brName = br.getRelationName();
                    if (this.hmBaseRelations.containsKey(brName)) {
                        brId = (String)this.hmBaseRelations.get(brName);
                        System.out.println("using baserelation name  " + brName + " id " + brId);
                    } else {
                        brId = "br" + this.idSeq++;
                        System.out.println("adding baserelation name  " + brName + " id " + brId);
                        this.hmBaseRelations.put(brName, brId);
                    }
                }
                RelationRange rr = ar.getRelationRange();
                String relatedElems = aeName.compareToIgnoreCase(rfElem) < 0 ? aeName + ":" + rfElem : rfElem + ":" + aeName;
                if (this.hmRelations.containsKey(relatedElems)) {
                    association = (UMLAssociation)this.hmRelations.get(relatedElems);
                    if (aeName.compareToIgnoreCase(rfElem) < 0) {
                        association.setEp2RoleName(arName);
                        association.setEp2Stereotype(brId);
                        association.setEp2Max("" + rr.max);
                        association.setEp2Min("" + rr.min);
                    } else {
                        association.setEp1RoleName(arName);
                        association.setEp1Stereotype(brId);
                        association.setEp1Max("" + rr.max);
                        association.setEp1Min("" + rr.min);
                    }
                } else {
                    association = new UMLAssociation();
                    if (aeName.compareToIgnoreCase(rfElem) < 0) {
                        association.setEp1ElemId("ae" + aeId);
                        association.setEp1ElemName(aeName);
                        association.setEp2ElemId("ae" + rfId);
                        association.setEp2ElemName(rfElem);
                        association.setEp2RoleName(arName);
                        association.setEp2Stereotype(brId);
                        association.setEp2Max("" + rr.max);
                        association.setEp2Min("" + rr.min);
                    } else {
                        association.setEp2ElemId("ae" + aeId);
                        association.setEp2ElemName(aeName);
                        association.setEp1ElemId("ae" + rfId);
                        association.setEp1ElemName(rfElem);
                        association.setEp1RoleName(arName);
                        association.setEp1Stereotype(brId);
                        association.setEp1Max("" + rr.max);
                        association.setEp1Min("" + rr.min);
                    }
                }
                this.hmRelations.put(relatedElems, association);
            }
        }
        catch (Throwable th) {
            arList = new ApplicationRelation[]{};
        }
        return this.rcOk;
    }

    private int genAssociationUML() {
        int idSeq = 0;
        try {
            Iterator it = this.hmRelations.keySet().iterator();
            Object UPNname = null;
            while (it.hasNext()) {
                ArrayList<Element> alEndPoint = new ArrayList<Element>();
                String relatedElems = (String)it.next();
                UMLAssociation association = (UMLAssociation)this.hmRelations.get(relatedElems);
                System.out.println("related elems " + relatedElems);
                System.out.println("  " + association.getEp1ElemId() + " " + association.getEp1ElemName() + " role " + association.getEp1RoleName() + " st " + association.getEp1Stereotype() + " min " + association.getEp1Min() + " max " + association.getEp1Max());
                System.out.println("  " + association.getEp2ElemId() + " " + association.getEp2ElemName() + " role " + association.getEp2RoleName() + " st " + association.getEp2Stereotype() + " min " + association.getEp2Min() + " max " + association.getEp2Max());
                Element elAs = new Element("Association", this.nsUML);
                elAs.setAttribute("xmi.id", "as" + idSeq++);
                elAs.setAttribute("name", relatedElems);
                elAs.setAttribute("visibility", "public");
                elAs.setAttribute("isSpecification", "false");
                elAs.setAttribute("isRoot", "false");
                elAs.setAttribute("isLeaf", "false");
                elAs.setAttribute("isAbstract", "false");
                Element elAsConn = new Element("Association.connection", this.nsUML);
                elAs.addContent((Content)elAsConn);
                Element elAsEnd1 = new Element("AssociationEnd", this.nsUML);
                elAsEnd1.setAttribute("xmi.id", "ep" + idSeq++);
                elAsEnd1.setAttribute("name", association.getEp1RoleName());
                elAsEnd1.setAttribute("visibility", "public");
                elAsEnd1.setAttribute("isSpecification", "false");
                elAsEnd1.setAttribute("isNavigable", "true");
                elAsEnd1.setAttribute("ordering", "unordered");
                elAsEnd1.setAttribute("aggregation", "none");
                elAsEnd1.setAttribute("targetScope", "instance");
                elAsEnd1.setAttribute("changeability", "changeable");
                Element elAsEndMult1 = new Element("AssociationEnd.multiplicity", this.nsUML);
                elAsEnd1.addContent((Content)elAsEndMult1);
                Element elAsMult1 = new Element("Multiplicity", this.nsUML);
                elAsMult1.setAttribute("xmi.id", "" + this.tagValIdx++);
                elAsEndMult1.addContent((Content)elAsMult1);
                Element elAsMultR1 = new Element("Multiplicity.range", this.nsUML);
                elAsMult1.addContent((Content)elAsMultR1);
                Element elAsMultRange1 = new Element("MultiplicityRange", this.nsUML);
                elAsMultRange1.setAttribute("xmi.id", "" + this.tagValIdx++);
                elAsMultRange1.setAttribute("lower", association.getEp1Min());
                elAsMultRange1.setAttribute("upper", association.getEp1Max());
                elAsMultR1.addContent((Content)elAsMultRange1);
                Element elAsPart1 = new Element("AssociationEnd.participant", this.nsUML);
                elAsEnd1.addContent((Content)elAsPart1);
                Element elAsPartC1 = new Element("Class", this.nsUML);
                elAsPartC1.setAttribute("xmi.idref", association.getEp1ElemId());
                elAsPart1.addContent((Content)elAsPartC1);
                if (!association.getEp1Stereotype().equalsIgnoreCase("")) {
                    Element elAsMeSt1 = new Element("ModelElement.stereotype", this.nsUML);
                    elAsEnd1.addContent((Content)elAsMeSt1);
                    Element elAsSt1 = new Element("Stereotype", this.nsUML);
                    elAsSt1.setAttribute("xmi.idref", association.getEp1Stereotype());
                    elAsMeSt1.addContent((Content)elAsSt1);
                }
                alEndPoint.add(elAsEnd1);
                Element elAsEnd2 = new Element("AssociationEnd", this.nsUML);
                elAsEnd2.setAttribute("xmi.id", "ep" + idSeq++);
                elAsEnd2.setAttribute("name", association.getEp2RoleName());
                elAsEnd2.setAttribute("visibility", "public");
                elAsEnd2.setAttribute("isSpecification", "false");
                elAsEnd2.setAttribute("isNavigable", "true");
                elAsEnd2.setAttribute("ordering", "unordered");
                elAsEnd2.setAttribute("aggregation", "none");
                elAsEnd2.setAttribute("targetScope", "instance");
                elAsEnd2.setAttribute("changeability", "changeable");
                Element elAsEndMult2 = new Element("AssociationEnd.multiplicity", this.nsUML);
                elAsEnd2.addContent((Content)elAsEndMult2);
                Element elAsMult2 = new Element("Multiplicity", this.nsUML);
                elAsMult2.setAttribute("xmi.id", "" + this.tagValIdx++);
                elAsEndMult2.addContent((Content)elAsMult2);
                Element elAsMultR2 = new Element("Multiplicity.range", this.nsUML);
                elAsMult2.addContent((Content)elAsMultR2);
                Element elAsMultRange2 = new Element("MultiplicityRange", this.nsUML);
                elAsMultRange2.setAttribute("xmi.id", "" + this.tagValIdx++);
                elAsMultRange2.setAttribute("lower", association.getEp2Min());
                elAsMultRange2.setAttribute("upper", association.getEp2Max());
                elAsMultR2.addContent((Content)elAsMultRange2);
                Element elAsPart2 = new Element("AssociationEnd.participant", this.nsUML);
                elAsEnd2.addContent((Content)elAsPart2);
                Element elAsPartC2 = new Element("Class", this.nsUML);
                elAsPartC2.setAttribute("xmi.idref", association.getEp2ElemId());
                elAsPart2.addContent((Content)elAsPartC2);
                if (!association.getEp2Stereotype().equalsIgnoreCase("")) {
                    Element elAsMeSt2 = new Element("ModelElement.stereotype", this.nsUML);
                    elAsEnd2.addContent((Content)elAsMeSt2);
                    Element elAsSt2 = new Element("Stereotype", this.nsUML);
                    elAsSt2.setAttribute("xmi.idref", association.getEp2Stereotype());
                    elAsMeSt2.addContent((Content)elAsSt2);
                }
                alEndPoint.add(elAsEnd2);
                elAsConn.setContent(alEndPoint);
                this.alElements.add(elAs);
            }
        }
        catch (Exception e) {
            System.out.println(" Exception in adding associations " + this.rcGenEx);
            e.printStackTrace();
            return this.rcGenEx;
        }
        return this.rcOk;
    }

    private int genAppAttrUML(ApplicationAttribute aa, ArrayList alAttrs) {
        try {
            Element elAppAttr = new Element("Attribute", this.nsUML);
            elAppAttr.setAttribute("xmi.id", "aa" + this.idSeq++);
            elAppAttr.setAttribute("name", aa.getName());
            elAppAttr.setAttribute("visibility", "private");
            elAppAttr.setAttribute("isSpecification", "false");
            elAppAttr.setAttribute("ownerScope", "instance");
            elAppAttr.setAttribute("changeability", "changeable");
            String baseAttrName = null;
            String baId = "";
            int attrLength = 0;
            boolean bAutogenerated = false;
            boolean bObligatory = false;
            boolean bUnique = false;
            try {
                baseAttrName = aa.getBaseAttribute().getName();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (baseAttrName != null) {
                if (this.hmBaseAttributes.containsKey(baseAttrName)) {
                    baId = (String)this.hmBaseAttributes.get(baseAttrName);
                } else {
                    baId = "ba" + this.idSeq++;
                    this.hmBaseAttributes.put(baseAttrName, baId);
                }
                Element elAppAttrMeSt = new Element("ModelElement.stereotype", this.nsUML);
                Element elAppAttrSt = new Element("Stereotype", this.nsUML);
                elAppAttrSt.setAttribute("xmi.idref", baId);
                elAppAttrMeSt.addContent((Content)elAppAttrSt);
                elAppAttr.addContent((Content)elAppAttrMeSt);
            }
            try {
                attrLength = aa.getLength();
                bAutogenerated = aa.isAutogenerated();
                bObligatory = aa.isObligatory();
                bUnique = aa.isUnique();
            }
            catch (Exception e) {
                System.out.println(" Exception obtaining attribute  " + e.getMessage());
                e.printStackTrace();
            }
            Element elModelElemTagValues = new Element("ModelElement.taggedValue", this.nsUML);
            ArrayList<Element> alPropertyTags = new ArrayList<Element>();
            alPropertyTags.add(this.genAttributePropertyTag("unique", bUnique + ""));
            alPropertyTags.add(this.genAttributePropertyTag("length", attrLength + ""));
            alPropertyTags.add(this.genAttributePropertyTag("autogenerate", bAutogenerated + ""));
            elModelElemTagValues.addContent(alPropertyTags);
            elAppAttr.addContent((Content)elModelElemTagValues);
            Element elAppAttrSF = new Element("StructuralFeature.type", this.nsUML);
            Element elAppAttrDt = new Element("Datatype", this.nsUML);
            elAppAttrDt.setAttribute("xmi.idref", "dt" + aa.getDataType().value());
            elAppAttrSF.addContent((Content)elAppAttrDt);
            elAppAttr.addContent((Content)elAppAttrSF);
            Element elSFmult = new Element("StructuralFeature.multiplicity", this.nsUML);
            Element elMultiplicity = new Element("Multiplicity", this.nsUML);
            elMultiplicity.setAttribute("xmi.id", "" + this.tagValIdx++);
            Element elMultRange1 = new Element("Multiplicity.range", this.nsUML);
            Element elMultRange2 = new Element("MultiplicityRange", this.nsUML);
            elMultRange2.setAttribute("xmi.id", "" + this.tagValIdx++);
            if (bObligatory) {
                elMultRange2.setAttribute("lower", "1");
            } else {
                elMultRange2.setAttribute("lower", "0");
            }
            elMultRange2.setAttribute("upper", "1");
            elMultRange1.addContent((Content)elMultRange2);
            elMultiplicity.addContent((Content)elMultRange1);
            elSFmult.addContent((Content)elMultiplicity);
            elAppAttr.addContent((Content)elSFmult);
            alAttrs.add(elAppAttr);
        }
        catch (AoException e) {
            e.printStackTrace();
            return this.rcGenEx;
        }
        return this.rcOk;
    }

    private Element genAttributePropertyTag(String tagName, String tagValue) {
        Element elTagDef = new Element("TaggedValue", this.nsUML);
        elTagDef.setAttribute("xmi.id", "tv_" + this.tagValIdx++);
        elTagDef.setAttribute("name", tagName);
        elTagDef.setAttribute("isSpecification", "false");
        elTagDef.addContent((Content)new Element("TaggedValue.dataValue", this.nsUML).addContent(tagValue));
        Element elType = new Element("TaggedValue.type", this.nsUML);
        Element elTagDefinition = new Element("TagDefinition", this.nsUML);
        elTagDefinition.setAttribute("xmi.idref", "ap_" + tagName);
        elType.addContent((Content)elTagDefinition);
        elTagDef.addContent((Content)elType);
        return elTagDef;
    }

    private ApplicationElement getElementByName(ApplicationStructure as, String Name) {
        try {
            ApplicationElement ae = as.getElementByName(Name);
            return ae;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ArrayList getMessages() {
        return this.alLogMessages;
    }

    public ArrayList getErrors() {
        return this.alErrMessages;
    }

    private int getStereotypeId(String type, String name) {
        if (type.equalsIgnoreCase("element")) {
            for (int i = 0; i < this.baseElem.length; ++i) {
                if (!this.baseElem[i].equalsIgnoreCase(name)) continue;
                return i;
            }
        }
        return 0;
    }

    public ArrayList getAlErrMessages() {
        return this.alErrMessages;
    }

    public ArrayList getAlLogMessages() {
        return this.alLogMessages;
    }

    public Document getOutputDoc() {
        return this.outputDoc;
    }

    public int getRc() {
        return this.rc;
    }

    public void setAs(ApplicationStructure as) {
        this.as = as;
    }

    public void setConfigFileName(String configFileName) {
    }

    public static DataType getDataType(String name) {
        if (name.equalsIgnoreCase("DT_BLOB")) {
            return DataType.DT_BLOB;
        }
        if (name.equalsIgnoreCase("DT_SHORT")) {
            return DataType.DT_SHORT;
        }
        if (name.equalsIgnoreCase("DT_FLOAT")) {
            return DataType.DT_FLOAT;
        }
        if (name.equalsIgnoreCase("DT_LONG")) {
            return DataType.DT_LONG;
        }
        if (name.equalsIgnoreCase("DT_STRING")) {
            return DataType.DT_STRING;
        }
        if (name.equalsIgnoreCase("DT_UNKNOWN")) {
            return DataType.DT_UNKNOWN;
        }
        if (name.equalsIgnoreCase("DT_LONGLONG")) {
            return DataType.DT_LONGLONG;
        }
        if (name.equalsIgnoreCase("DT_EXTERNALREFERENCE")) {
            return DataType.DT_EXTERNALREFERENCE;
        }
        if (name.equalsIgnoreCase("DT_DOUBLE")) {
            return DataType.DT_DOUBLE;
        }
        if (name.equalsIgnoreCase("DT_DCOMPLEX")) {
            return DataType.DT_DCOMPLEX;
        }
        if (name.equalsIgnoreCase("DT_DATE")) {
            return DataType.DT_DATE;
        }
        if (name.equalsIgnoreCase("DT_COMPLEX")) {
            return DataType.DT_COMPLEX;
        }
        if (name.equalsIgnoreCase("DT_BYTESTR")) {
            return DataType.DT_BYTESTR;
        }
        if (name.equalsIgnoreCase("DT_BYTE")) {
            return DataType.DT_BYTE;
        }
        if (name.equalsIgnoreCase("DT_BOOLEAN")) {
            return DataType.DT_BOOLEAN;
        }
        if (name.equalsIgnoreCase("DS_SHORT")) {
            return DataType.DS_SHORT;
        }
        if (name.equalsIgnoreCase("DS_FLOAT")) {
            return DataType.DS_FLOAT;
        }
        if (name.equalsIgnoreCase("DS_LONG")) {
            return DataType.DS_LONG;
        }
        if (name.equalsIgnoreCase("DS_STRING")) {
            return DataType.DS_STRING;
        }
        if (name.equalsIgnoreCase("DS_LONGLONG")) {
            return DataType.DS_LONGLONG;
        }
        if (name.equalsIgnoreCase("DS_EXTERNALREFERENCE")) {
            return DataType.DS_EXTERNALREFERENCE;
        }
        if (name.equalsIgnoreCase("DS_DOUBLE")) {
            return DataType.DS_DOUBLE;
        }
        if (name.equalsIgnoreCase("DS_DCOMPLEX")) {
            return DataType.DS_DCOMPLEX;
        }
        if (name.equalsIgnoreCase("DS_DATE")) {
            return DataType.DS_DATE;
        }
        if (name.equalsIgnoreCase("DS_COMPLEX")) {
            return DataType.DS_COMPLEX;
        }
        if (name.equalsIgnoreCase("DS_BYTESTR")) {
            return DataType.DS_BYTESTR;
        }
        if (name.equalsIgnoreCase("DS_BYTE")) {
            return DataType.DS_BYTE;
        }
        if (name.equalsIgnoreCase("DS_BOOLEAN")) {
            return DataType.DS_BOOLEAN;
        }
        return DataType.DT_UNKNOWN;
    }

    private static void listChildren(Element current, int depth) {
        UMLBean.printSpaces(depth);
        System.out.println(current.getName());
        List children = current.getChildren();
        for (Element child : children) {
            UMLBean.listChildren(child, depth + 1);
        }
    }

    private static void printSpaces(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(' ');
        }
    }
}

