/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.columndisplay;

import com.highqsoft.columndisplay.ColumnDisplay;
import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkColumnStatistics;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkPanel;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.factory.FwkDescriptionFactory;
import com.highqsoft.interfaces.fwk.FwkAppearanceInterface;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DTextInterface;
import com.highqsoft.p2d.P2DBoundingBox;
import com.highqsoft.p2d.P2DText;
import com.highqsoft.p2d.P2DTextModel;
import com.highqsoft.p2d.P2DTextView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColumnDisplayPanel
extends FwkPanel {
    public static final String version = "$Revision: 1.4 $";
    public static boolean deLang;
    protected static final FwkDescriptionInterface descriptor;
    JPanel controlPanel;
    JPanel labelPanel;
    JLabel[] labs;
    P2DTextInterface p2dText;
    FwkColumnStatistics stats;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return FwkDescriptionFactory.getDescriptor((Class)ColumnDisplayPanel.class, (FwkDescriptionInterface)descriptor);
    }

    public ColumnDisplayPanel(FwkControllerInterface controller) {
        ColumnDisplay cd = (ColumnDisplay)controller;
        this.setDescriptor(descriptor);
        this.setLayout(new BorderLayout());
        this.createPanel();
        this.text = null;
        this.setController((FwkControllerInterface)cd);
        this.initializeText();
    }

    protected JPanel createPanel() {
        if (this.labelPanel == null) {
            int width = 300;
            String prop = FwkPropertyBus.getProperty((String)"ColumnDisplayPanel.Canvas.Width");
            try {
                width = Integer.parseInt(prop);
            }
            catch (Throwable t) {
                // empty catch block
            }
            int height = 200;
            prop = FwkPropertyBus.getProperty((String)"ColumnDisplayPanel.Canvas.Height");
            try {
                height = Integer.parseInt(prop);
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.labelPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 2;
            if (deLang) {
                this.labelPanel.add((Component)new JLabel("Name: "), gbc);
                ++gbc.gridy;
                this.labelPanel.add((Component)new JLabel("Einheit: "), gbc);
                ++gbc.gridy;
                this.labelPanel.add((Component)new JLabel("L\u00e4nge: "), gbc);
                ++gbc.gridy;
                this.labelPanel.add((Component)new JLabel("Mittelwert: "), gbc);
                ++gbc.gridy;
                this.labelPanel.add((Component)new JLabel("Standardabweichung: "), gbc);
                ++gbc.gridy;
                this.labelPanel.add((Component)new JLabel("Varianz: "), gbc);
            } else {
                this.labelPanel.add((Component)new JLabel("Name: "), gbc);
                ++gbc.gridy;
                this.labelPanel.add((Component)new JLabel("Unit: "), gbc);
                ++gbc.gridy;
                this.labelPanel.add((Component)new JLabel("Count: "), gbc);
                ++gbc.gridy;
                this.labelPanel.add((Component)new JLabel("Average: "), gbc);
                ++gbc.gridy;
                this.labelPanel.add((Component)new JLabel("Standarddeviation: "), gbc);
                ++gbc.gridy;
                this.labelPanel.add((Component)new JLabel("Variance: "), gbc);
            }
            this.labs = new JLabel[6];
            gbc.gridx = 1;
            for (int i = 0; i < this.labs.length; ++i) {
                gbc.gridy = i;
                this.labs[i] = new JLabel("_");
                this.labelPanel.add((Component)this.labs[i], gbc);
            }
            this.labelPanel.setPreferredSize(new Dimension(width, height));
            this.add("Center", this.labelPanel);
        }
        return this.labelPanel;
    }

    protected void initializeText() {
        if (this.p2dText == null) {
            this.p2dText = new P2DText("ColumnDisplay");
            this.p2dText.setModel(new TextModel());
            this.p2dText.setView(new TextView());
            this.p2dText.setBoundingBox(new P2DBoundingBox(0.0, 0.0, 100.0, 100.0));
        }
    }

    public P2DTextInterface getText() {
        this.initializeText();
        return this.p2dText;
    }

    public void setColumn(FwkColumnAccessInterface col) {
        if (col != null) {
            this.stats = new FwkColumnStatistics(col);
            this.getText();
            this.labs[0].setText("" + this.stats.getName());
            this.labs[1].setText("" + this.stats.getUnitString());
            this.labs[2].setText("" + this.stats.getCount());
            this.labs[3].setText("" + (double)Math.round(this.stats.getAverage() * 10000.0) / 10000.0);
            this.labs[4].setText("" + (double)Math.round(this.stats.getStandardDeviation() * 10000.0) / 10000.0);
            this.labs[5].setText("" + (double)Math.round(this.stats.getVariance() * 10000.0) / 10000.0);
        } else {
            this.stats = null;
            this.labs[0].setText("");
            this.labs[1].setText("");
            this.labs[2].setText("");
            this.labs[3].setText("");
            this.labs[4].setText("");
            this.labs[5].setText("");
        }
    }

    static {
        Locale locale = FwkContainer.getLocale();
        deLang = locale.getLanguage().compareTo("de") == 0;
        descriptor = new FwkDescription();
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("The Column Display Panel");
        descriptor.setTitleName("ColumnDisplayPanel.Text.Title");
        descriptor.setName(ColumnDisplayPanel.class.getName());
        descriptor.setIconKey("Icon.ColumnDisplayPanel");
        descriptor.setCreationDate("$Date: 2007/06/28 06:56:36 $", null);
    }

    public static class TextView
    extends P2DTextView {
        public void draw(P2DComponentInterface component, P2DContainerInterface container, Graphics2D g) {
            FwkArrayInterface arr = ((P2DTextInterface)component).getAttributedText();
            if (arr != null && arr.size() != 0) {
                LineBreakMeasurer measurer;
                AttributedCharacterIterator iter;
                AttributedString str;
                int size = arr.size();
                int curY = 0;
                float wrappingWidth = (float)component.getWidth();
                double height = component.getHeight();
                TextLayout layout = null;
                FontRenderContext frc = new FontRenderContext(null, true, true);
                int i = 0;
                float valueOffset = 0.0f;
                while (i < size && (double)curY <= height) {
                    str = (AttributedString)arr.get(i);
                    i += 2;
                    iter = str.getIterator();
                    measurer = new LineBreakMeasurer(iter, frc);
                    while (measurer.getPosition() < iter.getEndIndex() && (double)curY <= height) {
                        layout = measurer.nextLayout(wrappingWidth);
                        if ((double)(curY = (int)((float)curY + layout.getAscent())) <= height) {
                            layout.draw(g, 0.0f, curY);
                        }
                        valueOffset = Math.max(valueOffset, layout.getAdvance());
                        curY = (int)((float)curY + (layout.getDescent() + layout.getLeading()));
                    }
                }
                i = 1;
                curY = 0;
                valueOffset += 10.0f;
                while (i < size && (double)curY <= height) {
                    str = (AttributedString)arr.get(i);
                    i += 2;
                    iter = str.getIterator();
                    measurer = new LineBreakMeasurer(iter, frc);
                    while (measurer.getPosition() < iter.getEndIndex() && (double)curY <= height) {
                        layout = measurer.nextLayout(wrappingWidth);
                        if ((double)(curY = (int)((float)curY + layout.getAscent())) <= height) {
                            layout.draw(g, valueOffset, curY);
                        }
                        curY = (int)((float)curY + (layout.getDescent() + layout.getLeading()));
                    }
                }
            }
        }
    }

    public class TextModel
    extends P2DTextModel {
        public FwkArrayInterface getTextArray(P2DTextInterface component) {
            if (this.text != null) {
                this.text.clear();
            } else {
                this.text = new FwkArray();
            }
            if (ColumnDisplayPanel.this.stats != null) {
                if (deLang) {
                    this.text.add((Object)("Name\t" + ColumnDisplayPanel.this.stats.getName()));
                    this.text.add((Object)("Einheit\t" + ColumnDisplayPanel.this.stats.getUnitString()));
                    this.text.add((Object)("L\u00e4nge\t" + ColumnDisplayPanel.this.stats.getCount()));
                    this.text.add((Object)("Mittelwert\t" + (double)Math.round(ColumnDisplayPanel.this.stats.getAverage() * 10000.0) / 10000.0));
                    this.text.add((Object)("Standardabweichung\t" + (double)Math.round(ColumnDisplayPanel.this.stats.getStandardDeviation() * 10000.0) / 10000.0));
                    this.text.add((Object)("Varianz\t" + (double)Math.round(ColumnDisplayPanel.this.stats.getVariance() * 10000.0) / 10000.0));
                } else {
                    this.text.add((Object)("Name\t" + ColumnDisplayPanel.this.stats.getName()));
                    this.text.add((Object)("Unit\t" + ColumnDisplayPanel.this.stats.getUnitString()));
                    this.text.add((Object)("Count\t" + ColumnDisplayPanel.this.stats.getCount()));
                    this.text.add((Object)("Average\t" + (double)Math.round(ColumnDisplayPanel.this.stats.getAverage() * 10000.0) / 10000.0));
                    this.text.add((Object)("Standarddeviation\t" + (double)Math.round(ColumnDisplayPanel.this.stats.getStandardDeviation() * 10000.0) / 10000.0));
                    this.text.add((Object)("Variance\t" + (double)Math.round(ColumnDisplayPanel.this.stats.getVariance() * 10000.0) / 10000.0));
                }
            }
            return super.getTextArray(component);
        }

        public FwkArrayInterface getAttributedText(P2DTextInterface component) {
            FwkArray ret = new FwkArray();
            this.getTextArray(component);
            if (this.text != null && this.attributor != null) {
                FwkAppearanceInterface ap = component.getAppearance();
                int size = this.text.size();
                if (size > 0) {
                    for (int i = 0; i < size; ++i) {
                        AttributedString as;
                        String line = (String)this.text.get(i);
                        int index = line.indexOf(9);
                        if (index > 0) {
                            as = new AttributedString(line.substring(0, index));
                            as.addAttribute(TextAttribute.FONT, ap.getFont());
                            as.addAttribute(TextAttribute.FOREGROUND, ap.getColor());
                            as.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                            ret.add((Object)as);
                            as = new AttributedString(line.substring(index + 1));
                            as.addAttribute(TextAttribute.FONT, ap.getFont());
                            as.addAttribute(TextAttribute.FOREGROUND, ap.getColor());
                            ret.add((Object)as);
                            continue;
                        }
                        as = new AttributedString(" ");
                        as.addAttribute(TextAttribute.FONT, ap.getFont());
                        as.addAttribute(TextAttribute.FOREGROUND, ap.getColor());
                        ret.add((Object)as);
                        if (line.length() != 0) {
                            as = line.startsWith("\t") ? (line.length() > 1 ? new AttributedString(line.substring(1)) : new AttributedString(" ")) : new AttributedString(line);
                            as.addAttribute(TextAttribute.FONT, ap.getFont());
                            as.addAttribute(TextAttribute.FOREGROUND, ap.getColor());
                            ret.add((Object)as);
                            continue;
                        }
                        as = new AttributedString(" ");
                        as.addAttribute(TextAttribute.FONT, ap.getFont());
                        as.addAttribute(TextAttribute.FOREGROUND, ap.getColor());
                        ret.add((Object)as);
                    }
                }
            }
            return ret;
        }
    }
}

