/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.interfaces.p2d.P2DAxisInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DRange1DInterface;
import com.highqsoft.p2d.P2DBoundingBox;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.BitSet;

public class P2D {
    public static String[] P2DObjectName = new String[]{"com.highqsoft.p2d.P2DAxis", "com.highqsoft.p2d.P2DChannel", "com.highqsoft.p2d.P2DImage", "com.highqsoft.p2d.P2DLayout", "com.highqsoft.p2d.P2DShape", "com.highqsoft.p2d.P2DText"};
    static final double log10 = Math.log(10.0);
    static final double MAX_FSCALE = 100000.0;
    static final double MIN_FSCALE = 1.0E-5;
    public static final float xScale = 1.0f;
    public static final float yScale = 1.0f;
    public static final float xOffset = 0.0f;
    public static final float yOffset = 0.0f;
    public static final double pt = 0.3528;
    public static final float FONT_FACTOR = 158.0f;
    public static final float LINEDIST_FACTOR = 1.19f;
    public static final float zThreshold = 0.05f;
    public static final String INFOBUSNAMEKEY = "P2DComponentBus.Name";
    public static final String INFOBUSDEFAULTNAME = "P2DComponentBus";
    public static final String MARKERINFOBUSNAMEKEY = "P2DMarkerBus.Name";
    public static final String MARKERINFOBUSDEFAULTNAME = "P2DMarkerBus";
    public static final double CENTER = 0.5;
    public static final double LEFT = 0.0;
    public static final double RIGHT = 1.0;
    public static final Color[] colors = new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(1.0f, 1.0f, 1.0f, 1.0f), new Color(1.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 1.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 1.0f, 1.0f), new Color(1.0f, 1.0f, 0.0f, 1.0f), new Color(1.0f, 0.0f, 1.0f, 1.0f), new Color(0.0f, 1.0f, 1.0f, 1.0f), new Color(0.7529412f, 0.7529412f, 0.7529412f, 1.0f), new Color(0.5f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.5f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.5f, 1.0f), new Color(0.5f, 0.5f, 0.0f, 1.0f), new Color(0.5f, 0.0f, 0.5f, 1.0f), new Color(0.0f, 0.5f, 0.5f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(1.0f, 0.64705884f, 0.0f, 1.0f), new Color(1.0f, 0.078431375f, 0.5764706f, 1.0f), new Color(0.78431374f, 0.49803922f, 0.0f, 1.0f), new Color(0.6901961f, 0.1882353f, 0.3764706f, 1.0f)};
    static int PRINTING = 0;
    public static String BUSNAME = FwkPropertyBus.getProperty((String)"P2DComponentBus.Name");
    public static String MARKERBUSNAME;
    public static BitSet flags;
    public static final int P2DCOMPONENT = 0;
    public static final int P2DAXIS = 1;
    public static final int P2DCHANNEL = 2;
    public static final int P2DTEXT = 3;
    public static final int P2DLINE = 4;
    public static final int P2DPLOT = 5;

    public static boolean getPrinting() {
        return flags.get(PRINTING);
    }

    public static void setPrinting(boolean flag) {
        if (flag) {
            flags.set(PRINTING);
        } else {
            flags.clear(PRINTING);
        }
    }

    public static Color black() {
        return colors[0];
    }

    public static Color white() {
        return colors[1];
    }

    public static Color red() {
        return colors[2];
    }

    public static Color green() {
        return colors[3];
    }

    public static Color blue() {
        return colors[4];
    }

    public static Color yellow() {
        return colors[5];
    }

    public static Color magenta() {
        return colors[6];
    }

    public static Color cyan() {
        return colors[7];
    }

    public static Color gray() {
        return colors[8];
    }

    public static Color darkred() {
        return colors[9];
    }

    public static Color darkgreen() {
        return colors[10];
    }

    public static Color darkblue() {
        return colors[11];
    }

    public static Color darkyellow() {
        return colors[12];
    }

    public static Color darkmagenta() {
        return colors[13];
    }

    public static Color darkcyan() {
        return colors[14];
    }

    public static Color darkgray() {
        return colors[15];
    }

    public static Color orange() {
        return colors[16];
    }

    public static Color pink() {
        return colors[17];
    }

    public static Color darkorange() {
        return colors[18];
    }

    public static Color maroon() {
        return colors[19];
    }

    public static Cursor getCursor(int handle) {
        switch (handle) {
            case 0: {
                return Cursor.getPredefinedCursor(4);
            }
            case 1: {
                return Cursor.getPredefinedCursor(9);
            }
            case 2: {
                return Cursor.getPredefinedCursor(5);
            }
            case 3: {
                return Cursor.getPredefinedCursor(10);
            }
            case 4: {
                return Cursor.getPredefinedCursor(12);
            }
            case 5: {
                return Cursor.getPredefinedCursor(11);
            }
            case 6: {
                return Cursor.getPredefinedCursor(6);
            }
            case 7: {
                return Cursor.getPredefinedCursor(8);
            }
            case 8: {
                return Cursor.getPredefinedCursor(7);
            }
        }
        return Cursor.getPredefinedCursor(0);
    }

    public static Color getInverseColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }

    public static AffineTransform getAxisTransformation(P2DAxisInterface xAxis, P2DAxisInterface yAxis, P2DBoundingBoxInterface bb) {
        AffineTransform ret = new AffineTransform();
        if (xAxis != null && yAxis != null) {
            boolean xLog = xAxis.getLog();
            boolean yLog = yAxis.getLog();
            P2DRange1DInterface xRange = xAxis.getRange();
            P2DRange1DInterface yRange = yAxis.getRange();
            if (xLog) {
                xRange.setLower(Math.log(xRange.getLower()) / log10);
                xRange.setUpper(Math.log(xRange.getUpper()) / log10);
            }
            if (yLog) {
                yRange.setLower(Math.log(yRange.getLower()) / log10);
                yRange.setUpper(Math.log(yRange.getUpper()) / log10);
            }
            if (xRange.getLower() == Double.NEGATIVE_INFINITY) {
                xRange.setLower(Math.log(1.4E-45f) / log10);
            }
            if (yRange.getLower() == Double.NEGATIVE_INFINITY) {
                yRange.setLower(Math.log(1.4E-45f) / log10);
            }
            if (xRange.getUpper() == Double.POSITIVE_INFINITY) {
                xRange.setUpper(Math.log(3.4028234663852886E38) / log10);
            }
            if (yRange.getUpper() == Double.POSITIVE_INFINITY) {
                yRange.setUpper(Math.log(3.4028234663852886E38) / log10);
            }
            ret.scale(bb.getWidth() / (xRange.getUpper() - xRange.getLower()), bb.getHeight() / (yRange.getUpper() - yRange.getLower()));
            ret.translate(-xRange.getLower(), yRange.getUpper());
            ret.scale(1.0, -1.0);
        }
        return ret;
    }

    public static P2DBoundingBoxInterface getAxisBoundingBox(P2DAxisInterface xAxis, P2DAxisInterface yAxis) {
        P2DBoundingBox ret = null;
        if (xAxis != null && yAxis != null) {
            P2DBoundingBoxInterface bx = xAxis.getBoundingBox();
            P2DBoundingBoxInterface by = yAxis.getBoundingBox();
            Point2D xLower = bx.getLower();
            Point2D xUpper = bx.getUpper();
            Point2D yLower = by.getLower();
            Point2D yUpper = by.getUpper();
            ret = new P2DBoundingBox(xLower.getX(), yLower.getY(), xUpper.getX(), yUpper.getY());
        }
        return ret;
    }

    public static void main(String[] args) {
        System.exit(0);
    }

    static {
        if (BUSNAME.compareTo(INFOBUSNAMEKEY) == 0) {
            BUSNAME = INFOBUSDEFAULTNAME;
        }
        if ((MARKERBUSNAME = FwkPropertyBus.getProperty((String)MARKERINFOBUSNAMEKEY)).compareTo(MARKERINFOBUSNAMEKEY) == 0) {
            MARKERBUSNAME = MARKERINFOBUSDEFAULTNAME;
        }
        flags = new BitSet();
        flags.clear(PRINTING);
    }
}

