/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.Fwk;
import com.highqsoft.fwk.FwkAppearance;
import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.util.StringFormat;
import com.highqsoft.interfaces.fwk.FwkAppearanceInterface;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.p2d.P2DAttributorInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.text.AttributedString;
import java.util.Hashtable;

public class P2DAttributorSupport
extends Fwk
implements P2DAttributorInterface {
    public static final String version = "$Revision: 1.5 $";
    protected static P2DAttributorInterface instance = null;

    public String getVersion() {
        return version;
    }

    public static P2DAttributorInterface getInstance() {
        if (instance == null) {
            instance = new P2DAttributorSupport();
        }
        return instance;
    }

    public FwkArrayInterface format(P2DComponentInterface component, FwkArrayInterface arr, Object obj, FwkAppearanceInterface ap) {
        return this.format(component, arr, "" + obj, ap);
    }

    public FwkArrayInterface format(P2DComponentInterface component, FwkArrayInterface arr, String s, FwkAppearanceInterface ap) {
        int index;
        if (arr == null) {
            arr = new FwkArray();
        }
        if (s == null) {
            s = "";
        }
        int start = 0;
        Hashtable<TextAttribute, Serializable> attrs = new Hashtable<TextAttribute, Serializable>();
        attrs.put(TextAttribute.FONT, ap.getFont());
        attrs.put(TextAttribute.FOREGROUND, ap.getColor());
        while ((index = s.indexOf(10, start)) != -1) {
            arr.add((Object)new AttributedString(s.substring(start, index), attrs));
            start = index + 1;
        }
        String val = s.substring(start, s.length());
        if (val.length() != 0) {
            arr.add((Object)new AttributedString(s.substring(start, s.length()), attrs));
        }
        return arr;
    }

    public FwkArrayInterface format(P2DComponentInterface component, FwkArrayInterface arr, int i, FwkAppearanceInterface ap) {
        return this.format(component, arr, (double)i, ap);
    }

    public FwkArrayInterface format(P2DComponentInterface component, FwkArrayInterface arr, boolean b, FwkAppearanceInterface ap) {
        return this.format(component, arr, "" + b, ap);
    }

    public FwkArrayInterface format(P2DComponentInterface component, FwkArrayInterface arr, char c, FwkAppearanceInterface ap) {
        return this.format(component, arr, "" + c, ap);
    }

    public FwkArrayInterface format(P2DComponentInterface component, FwkArrayInterface arr, long l, FwkAppearanceInterface ap) {
        return this.format(component, arr, (double)l, ap);
    }

    public FwkArrayInterface format(P2DComponentInterface component, FwkArrayInterface arr, float f, FwkAppearanceInterface ap) {
        if ((double)f < 100000.0) {
            long val = (long)(f * 10000.0f);
            f = (float)val / 10000.0f;
            return this.format(component, arr, "" + f, ap);
        }
        int exponent10 = (int)Math.floor(Math.log(f) / Math.log(10.0));
        double factor = Math.pow(10.0, exponent10);
        long val = (long)((double)f / factor * 10000.0);
        StringBuffer buf = new StringBuffer();
        buf.append((double)val / 10000.0).append("E").append(exponent10);
        return this.format(component, arr, buf.toString(), ap);
    }

    public FwkArrayInterface format(P2DComponentInterface component, FwkArrayInterface arr, double d, FwkAppearanceInterface ap) {
        double abs = Math.abs(d);
        if (abs < 1.0) {
            String val = StringFormat.format((double)d, (int)2);
            if (val.equals("0.00")) {
                val = "0";
            }
            return this.format(component, arr, val, ap);
        }
        if (abs < 100000.0) {
            String val = StringFormat.format((double)d, (int)2);
            return this.format(component, arr, val, ap);
        }
        int exponent10 = (int)Math.floor(Math.log(d) / Math.log(10.0));
        double factor = Math.pow(10.0, exponent10);
        long val = (long)(d / factor * 100000.0);
        StringBuffer buf = new StringBuffer();
        buf.append((double)val / 100000.0).append("E").append(exponent10);
        return this.format(component, arr, buf.toString(), ap);
    }

    public static void main(String[] args) {
        P2DAttributorSupport attr = new P2DAttributorSupport();
        attr.format(null, null, "Andreas Hofmann\n\nLimburger Stra\u00dfe 39a\n61479 Glash\u00fctten\n", (FwkAppearanceInterface)new FwkAppearance());
        System.exit(0);
    }
}

