/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkAppearance;
import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.command.FwkColorCommand;
import com.highqsoft.fwk.command.FwkFontCommand;
import com.highqsoft.fwk.command.FwkTextEditorCommand;
import com.highqsoft.fwk.command.FwkToggleCommand;
import com.highqsoft.fwk.dialog.FwkTextFieldDialogPane;
import com.highqsoft.interfaces.fwk.FwkAppearanceInterface;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.p2d.P2DAttributorInterface;
import com.highqsoft.interfaces.p2d.P2DAxisInterface;
import com.highqsoft.interfaces.p2d.P2DAxisModelInterface;
import com.highqsoft.interfaces.p2d.P2DAxisTypeInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DChannelInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DRange1DInterface;
import com.highqsoft.interfaces.p2d.P2DRange2DInterface;
import com.highqsoft.p2d.P2DAttributorSupport;
import com.highqsoft.p2d.P2DAxisType;
import com.highqsoft.p2d.P2DComponentModel;
import com.highqsoft.p2d.P2DRange1D;
import com.highqsoft.p2d.P2DRangeActionListener;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;

public class P2DAxisModel
extends P2DComponentModel
implements P2DAxisModelInterface {
    public static final String version = "$Revision: 1.4 $";
    public static final String TITLE_TEXT_KEY = "P2DAxis.Text.Caption";
    public static final String TITLE_TOOLTIP_KEY = "P2DAxis.Tooltip.Title";
    public static final String TEXT_FIELD_IDENT = "Text";
    public static final int WIDTH = 40;
    protected boolean valid;
    protected boolean gridFlag;
    protected P2DAxisTypeInterface type;
    protected double ticklen;
    protected String title;
    protected P2DAttributorInterface titleAttributor;
    protected P2DAttributorInterface tickvalueAttributor;
    protected P2DRange1DInterface range;
    protected P2DRange1DInterface aRange;
    protected boolean autoRange;
    protected double[] niceNumbers;
    P2DRange1DInterface nnCalculator;
    protected HashMap channels;
    protected double position;
    protected double base;
    protected FwkAppearanceInterface gridAppearance;
    protected int ticksRequested;

    public void release() {
        if (this.channels != null) {
            this.channels.clear();
            this.channels = null;
        }
        this.type = null;
        this.titleAttributor.release();
        this.titleAttributor = null;
        this.tickvalueAttributor.release();
        this.tickvalueAttributor = null;
        this.range.release();
        this.range = null;
        this.aRange.release();
        this.aRange = null;
        this.niceNumbers = null;
        this.nnCalculator = null;
        this.gridAppearance.release();
        this.gridAppearance = null;
        super.release();
    }

    public void initialize() {
        super.initialize();
        this.channels = new HashMap();
        this.type = P2DAxisType.X;
        this.gridFlag = true;
        this.base = 10.0;
        this.ticklen = 0.2;
        this.title = null;
        this.titleAttributor = P2DAttributorSupport.getInstance();
        this.tickvalueAttributor = P2DAttributorSupport.getInstance();
        this.revalidate(null, false);
        this.range = new P2DRange1D(0.0, 1.0);
        this.aRange = new P2DRange1D();
        this.niceNumbers = null;
        this.nnCalculator = new P2DRange1D();
        this.autoRange = false;
        this.position = 0.0;
        this.ticksRequested = 0;
        this.gridAppearance = new FwkAppearance();
        this.gridAppearance.setStroke((Stroke)P2DAxisInterface.DOT_DOT_DASH_GRID);
    }

    public boolean isValid(P2DComponentInterface component) {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FwkArrayInterface getTickvalues(P2DComponentInterface component) {
        FwkArray ret;
        P2DRange1DInterface p2DRange1DInterface;
        if (this.autoRange) {
            if (!this.isValid(component)) {
                this.aRange = this.getChannelRange(component);
                if (this.aRange.getLower() != -1.7976931348623157E308 && this.aRange.getUpper() != Double.MAX_VALUE) {
                    p2DRange1DInterface = this.nnCalculator;
                    synchronized (p2DRange1DInterface) {
                        this.nnCalculator.setRange(this.aRange.getLower(), this.aRange.getUpper());
                        this.nnCalculator.setMinPositiveValue(this.aRange.getMinPositiveValue());
                        this.niceNumbers = this.nnCalculator.getNiceNumbers(this.getBase(component), this.getLog(component), this.ticksRequested);
                    }
                }
            }
        } else if (!this.isValid(component) && this.range.getLower() != -1.7976931348623157E308 && this.range.getUpper() != Double.MIN_VALUE) {
            p2DRange1DInterface = this.nnCalculator;
            synchronized (p2DRange1DInterface) {
                this.nnCalculator.setRange(this.range.getLower(), this.range.getUpper());
                this.nnCalculator.setMinPositiveValue(this.range.getMinPositiveValue());
                this.niceNumbers = this.nnCalculator.getNiceNumbers(this.getBase(component), this.getLog(component), this.ticksRequested);
            }
        }
        if (this.niceNumbers != null) {
            this.valid = true;
            ret = new FwkArray(this.niceNumbers.length);
            for (int i = 0; i < this.niceNumbers.length; ++i) {
                ret.addElement((Object)new Double(this.niceNumbers[i]));
            }
        } else {
            this.valid = false;
            ret = new FwkArray(2);
            ret.addElement((Object)new Double(0.0));
            ret.addElement((Object)new Double(1.0));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FwkArrayInterface getAttributedTickvalues(P2DComponentInterface component) {
        FwkArray ret;
        P2DRange1DInterface p2DRange1DInterface;
        if (this.tickvalueAttributor == null) {
            return new FwkArray();
        }
        if (this.getAutoRange(component)) {
            if (!this.isValid(component)) {
                this.aRange = this.getChannelRange(component);
                if (this.aRange.getLower() != -1.7976931348623157E308 && this.aRange.getUpper() != Double.MAX_VALUE) {
                    p2DRange1DInterface = this.nnCalculator;
                    synchronized (p2DRange1DInterface) {
                        this.nnCalculator.setRange(this.aRange.getLower(), this.aRange.getUpper());
                        this.niceNumbers = this.nnCalculator.getNiceNumbers(this.getBase(component), this.getLog(component), this.ticksRequested);
                    }
                }
            }
        } else if (!this.isValid(component) && this.range.getLower() != -1.7976931348623157E308 && this.range.getUpper() != Double.MAX_VALUE) {
            p2DRange1DInterface = this.nnCalculator;
            synchronized (p2DRange1DInterface) {
                this.nnCalculator.setRange(this.range.getLower(), this.range.getUpper());
                this.niceNumbers = this.nnCalculator.getNiceNumbers(this.getBase(component), this.getLog(component), this.ticksRequested);
            }
        }
        FwkAppearanceInterface ap = component.getAppearance();
        if (this.niceNumbers != null) {
            this.valid = true;
            ret = new FwkArray(this.niceNumbers.length);
            for (int i = 0; i < this.niceNumbers.length; ++i) {
                this.tickvalueAttributor.format(component, (FwkArrayInterface)ret, this.niceNumbers[i], ap);
            }
        } else {
            this.valid = false;
            ret = new FwkArray(2);
            this.tickvalueAttributor.format(component, (FwkArrayInterface)ret, 0.0, ap);
            this.tickvalueAttributor.format(component, (FwkArrayInterface)ret, 1.0, ap);
        }
        return ret;
    }

    public void setTickvalueAttributor(P2DComponentInterface component, P2DAttributorInterface attributor) {
        this.tickvalueAttributor = attributor;
    }

    public P2DAttributorInterface getTickvalueAttributor(P2DComponentInterface component) {
        return this.tickvalueAttributor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P2DRange1DInterface getNiceNumberRange(P2DComponentInterface component) {
        P2DRange1DInterface p2DRange1DInterface = this.nnCalculator;
        synchronized (p2DRange1DInterface) {
            FwkArrayInterface nn = this.getTickvalues(component);
            return new P2DRange1D((Double)nn.get(0), (Double)nn.get(nn.size() - 1), this.nnCalculator.getMinPositiveValue());
        }
    }

    public P2DRange1DInterface getChannelRange(P2DComponentInterface component) {
        if (this.autoRange) {
            P2DRange1D ret = null;
            if (this.channels.size() != 0) {
                double min = Double.POSITIVE_INFINITY;
                double max = Double.NEGATIVE_INFINITY;
                double minPositiveValue = Double.POSITIVE_INFINITY;
                Iterator it = this.channels.keySet().iterator();
                if (this.type.getValue() == P2DAxisType.X.getValue()) {
                    while (it.hasNext()) {
                        P2DChannelInterface c = (P2DChannelInterface)it.next();
                        P2DRange2DInterface r = c.getRange();
                        P2DRange1DInterface range = r.getXRange();
                        min = Math.min(min, range.getLower());
                        max = Math.max(max, range.getUpper());
                        if (Double.isNaN(range.getMinPositiveValue())) continue;
                        minPositiveValue = Math.min(minPositiveValue, range.getMinPositiveValue());
                    }
                } else {
                    while (it.hasNext()) {
                        P2DChannelInterface c = (P2DChannelInterface)it.next();
                        P2DRange2DInterface r = c.getRange();
                        P2DRange1DInterface range = r.getYRange();
                        min = Math.min(min, range.getLower());
                        max = Math.max(max, range.getUpper());
                        if (Double.isNaN(range.getMinPositiveValue())) continue;
                        minPositiveValue = Math.min(minPositiveValue, range.getMinPositiveValue());
                    }
                }
                ret = new P2DRange1D(min, max, minPositiveValue);
            } else {
                ret = new P2DRange1D();
            }
            return ret;
        }
        return this.range;
    }

    public P2DRange1DInterface getRange(P2DComponentInterface component) {
        P2DRange1DInterface nr = this.getNiceNumberRange(component);
        P2DRange1DInterface cr = this.getChannelRange(component);
        P2DRange1D ret = null;
        if (this.getLog(component)) {
            double minPositiveValue = !Double.isNaN(cr.getMinPositiveValue()) && !Double.isNaN(nr.getMinPositiveValue()) ? Math.min(cr.getMinPositiveValue(), Math.pow(10.0, nr.getMinPositiveValue())) : (!Double.isNaN(nr.getMinPositiveValue()) ? Math.pow(10.0, nr.getMinPositiveValue()) : cr.getMinPositiveValue());
            ret = new P2DRange1D(Math.pow(10.0, nr.getLower()), Math.pow(10.0, nr.getUpper()), minPositiveValue);
        } else {
            double minPositiveValue = !Double.isNaN(cr.getMinPositiveValue()) && !Double.isNaN(nr.getMinPositiveValue()) ? Math.min(cr.getMinPositiveValue(), nr.getMinPositiveValue()) : (!Double.isNaN(nr.getMinPositiveValue()) ? nr.getMinPositiveValue() : cr.getMinPositiveValue());
            ret = new P2DRange1D(Math.min(cr.getLower(), nr.getLower()), Math.max(cr.getUpper(), nr.getUpper()), minPositiveValue);
        }
        return ret;
    }

    public void setRange(P2DComponentInterface component, P2DRange1DInterface newRange) {
        double minPositiveValue = this.getMinPositiveValue(component);
        if (!Double.isNaN(newRange.getMinPositiveValue()) && !Double.isNaN(minPositiveValue)) {
            minPositiveValue = Math.min(newRange.getMinPositiveValue(), minPositiveValue);
        } else if (!Double.isNaN(newRange.getMinPositiveValue())) {
            minPositiveValue = newRange.getMinPositiveValue();
        }
        this.range = new P2DRange1D(newRange, minPositiveValue);
        this.setAutoRange(component, false);
        this.revalidate(component, false);
        component.repaint();
    }

    public double getMinPositiveValue(P2DComponentInterface component) {
        P2DRange1DInterface range = this.getRange(component);
        return range.getMinPositiveValue();
    }

    public double getLowerLimit(P2DComponentInterface component) {
        P2DRange1DInterface range = this.getRange(component);
        return range.getLower();
    }

    public double getUpperLimit(P2DComponentInterface component) {
        P2DRange1DInterface range = this.getRange(component);
        return range.getUpper();
    }

    public void setLowerLimit(P2DComponentInterface component, double lower) {
        P2DRange1D range = new P2DRange1D(lower, this.getUpperLimit(component));
        this.setRange(component, range);
    }

    public void setUpperLimit(P2DComponentInterface component, double upper) {
        P2DRange1D range = new P2DRange1D(this.getLowerLimit(component), upper);
        this.setRange(component, range);
    }

    public boolean getAutoRange(P2DComponentInterface component) {
        return this.autoRange;
    }

    public void setAutoRange(P2DComponentInterface component, boolean flag) {
        if (flag != this.autoRange) {
            this.autoRange = flag;
            FwkCommandInterface cmd = component.getCommand("AutoRange");
            if (cmd != null) {
                cmd.setToggleState(flag);
            }
        }
    }

    public double getTicklen(P2DComponentInterface component) {
        return this.ticklen;
    }

    public void setTicklen(P2DComponentInterface component, double newTicklen) {
        if (newTicklen >= 0.0 && newTicklen <= 1.0) {
            this.ticklen = newTicklen;
        }
    }

    public P2DAxisTypeInterface getType(P2DComponentInterface component) {
        return this.type;
    }

    public void setType(P2DComponentInterface component, P2DAxisTypeInterface newType) {
        if (this.type == null) {
            if (this.type.getValue() != newType.getValue()) {
                this.type = newType;
            }
        } else {
            this.type = newType;
        }
    }

    public String getTitle(P2DComponentInterface component) {
        if (this.title == null || this.title.length() == 0) {
            String name = this.getShortName(component);
            if (name == null) {
                return this.getType(component).toString();
            }
            String unit = null;
            Iterator it = this.channels.keySet().iterator();
            while (unit == null && it.hasNext()) {
                P2DChannelInterface c = (P2DChannelInterface)it.next();
                FwkColumnAccessInterface col = null;
                col = this.type.getValue() == P2DAxisType.X.getValue() ? c.getXColumn() : c.getYColumn();
                if (col == null) continue;
                unit = col.getUnitString();
            }
            if (unit == null) {
                unit = "";
            }
            return name + " [" + unit + "]";
        }
        return this.title;
    }

    public void setTitle(P2DComponentInterface component, String newTitle) {
        this.title = newTitle;
    }

    public FwkArrayInterface getAttributedTitle(P2DComponentInterface component) {
        if (this.titleAttributor == null) {
            return new FwkArray();
        }
        return this.titleAttributor.format(component, null, this.getTitle(component), component.getAppearance());
    }

    public void setTitleAttributor(P2DComponentInterface component, P2DAttributorInterface attributor) {
        this.titleAttributor = attributor;
    }

    public P2DAttributorInterface getTitleAttributor(P2DComponentInterface component) {
        return this.titleAttributor;
    }

    public synchronized void addChannel(P2DComponentInterface component, P2DChannelInterface channel) {
        this.channels.put(channel, channel);
    }

    public synchronized void removeChannel(P2DComponentInterface component, P2DChannelInterface channel) {
        if (this.channels.get(channel) != null) {
            this.channels.remove(channel);
        }
    }

    public Iterator getChannels(P2DComponentInterface component) {
        return this.channels.keySet().iterator();
    }

    public Point2D getScalingVector(P2DComponentInterface component) {
        P2DRange1DInterface range = this.getRange(component);
        Point2D.Double ret = new Point2D.Double();
        ret.x = 1.0 / (range.getUpper() - range.getLower());
        ret.y = (float)(-range.getLower() * ret.x);
        return ret;
    }

    public double getPosition(P2DComponentInterface component) {
        return this.position;
    }

    public void setPosition(P2DComponentInterface component, double newPosition) {
        if (this.position != newPosition) {
            this.position = newPosition;
        }
    }

    public boolean getLog(P2DComponentInterface component) {
        return this.type.isLog();
    }

    public void setBase(P2DComponentInterface component, double base) {
        if (base != this.base) {
            this.base = base;
        }
    }

    public double getBase(P2DComponentInterface component) {
        return this.base;
    }

    public void setLog(P2DComponentInterface component, boolean flag) {
        if (this.getLog(component)) {
            if (this.type.getValue() == P2DAxisType.X.getValue()) {
                this.setType(component, P2DAxisType.X);
            } else {
                this.setType(component, P2DAxisType.Y);
            }
        } else if (this.type.getValue() == P2DAxisType.X.getValue()) {
            this.setType(component, P2DAxisType.LOG_X);
        } else {
            this.setType(component, P2DAxisType.LOG_Y);
        }
        FwkCommandInterface cmd = component.getCommand("Log");
        if (cmd != null) {
            cmd.setToggleState(flag);
        }
    }

    public void revalidateChannels(P2DComponentInterface component) {
        Iterator it = this.channels.keySet().iterator();
        while (it.hasNext()) {
            P2DChannelInterface c = (P2DChannelInterface)this.channels.get(it.next());
            c.revalidate(false);
        }
    }

    public void revalidate(P2DComponentInterface component, boolean recursive) {
        super.revalidate(component, recursive);
        this.revalidateChannels(component);
        this.valid = false;
    }

    public void setGrid(P2DComponentInterface component, boolean flag) {
        if (this.gridFlag != flag) {
            this.gridFlag = flag;
        }
    }

    public boolean getGrid(P2DComponentInterface component) {
        return this.gridFlag;
    }

    public void setGridAppearance(P2DComponentInterface component, FwkAppearanceInterface appearance) {
        this.gridAppearance = appearance;
    }

    public FwkAppearanceInterface getGridAppearance(P2DComponentInterface component) {
        return this.gridAppearance;
    }

    public void setGridColor(P2DComponentInterface component, Color color) {
        this.gridAppearance.setColor(color);
    }

    public Color getGridColor(P2DComponentInterface component) {
        return this.gridAppearance.getColor();
    }

    public void setGridTransparency(P2DComponentInterface component, float transparency) {
        this.gridAppearance.setTransparency(transparency);
    }

    public float getGridTransparency(P2DComponentInterface component) {
        return this.gridAppearance.getTransparency();
    }

    protected HashMap createDialogPanes(P2DComponentInterface component) {
        FwkTextFieldDialogPane pane = (FwkTextFieldDialogPane)this.getDialogPane(component, TEXT_FIELD_IDENT);
        if (pane == null) {
            pane = new FwkTextFieldDialogPane(40);
            pane.setIdent(TEXT_FIELD_IDENT);
            pane.setInitialText(((P2DAxisInterface)component).getTitle());
            pane.setTitle(FwkPropertyBus.getProperty((String)TITLE_TEXT_KEY));
            pane.setTip(FwkPropertyBus.getProperty((String)TITLE_TOOLTIP_KEY));
            staticPanes.put(pane.getIdent(), pane);
        }
        return this.getDialogPaneValues(component);
    }

    public HashMap getDialogPaneValues(P2DComponentInterface component) {
        if (staticPanes == null) {
            return this.createDialogPanes(component);
        }
        HashMap ret = super.getDialogPaneValues(component);
        FwkDialogPaneInterface pane = (FwkDialogPaneInterface)staticPanes.get(TEXT_FIELD_IDENT);
        if (pane != null) {
            FwkDialogPaneValueInterface value = pane.getSelectedValue();
            value.setProperty(TEXT_FIELD_IDENT, (Object)((P2DAxisInterface)component).getTitle());
            ret.put(value.getIdent(), value);
        }
        return ret;
    }

    public void setDialogPaneValues(P2DComponentInterface component, HashMap values) {
        super.setDialogPaneValues(component, values);
        FwkDialogPaneValueInterface paneValue = (FwkDialogPaneValueInterface)values.get(TEXT_FIELD_IDENT);
        if (paneValue != null) {
            try {
                String val = (String)paneValue.getProperty(TEXT_FIELD_IDENT);
                if (val != null) {
                    this.setTitle(component, val);
                }
                values.remove(paneValue.getIdent());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public HashMap getDialogPanes(P2DComponentInterface component) {
        HashMap ret = super.getDialogPanes(component);
        FwkTextFieldDialogPane pane = (FwkTextFieldDialogPane)staticPanes.get(TEXT_FIELD_IDENT);
        if (pane != null) {
            pane.setInitialText(((P2DAxisInterface)component).getTitle());
            pane.setSize(40);
            ret.put(TEXT_FIELD_IDENT, pane);
        }
        return ret;
    }

    public FwkCommandInterface[] getCommands(P2DComponentInterface component) {
        if (!this.commandsAvailable()) {
            super.getCommands(component);
            FwkCommandInterface parent = super.getCommand("Help");
            if (parent == null) {
                parent = new FwkCommand();
                parent.setCommandName("Help");
                parent.setTextKey("P2D.Text.Help");
                this.addCommand(0, parent);
            }
            FwkCommand cmd = new FwkCommand();
            cmd.setCommandName("AxisHelp");
            cmd.setTextKey("P2D.Text.AxisHelp");
            cmd.setIconKey("Icon.FwkHelpBroker");
            cmd.setHelpID("com.highqsoft.p2d.P2DAxis");
            parent.addCommand(0, (FwkCommandInterface)cmd);
            cmd = new FwkColorCommand((FwkControllerInterface)component);
            cmd.setTextKey("P2D.Text.GridColor");
            cmd.setCommandName("GridColor");
            component.addCommand(0, (FwkCommandInterface)cmd);
            cmd = new FwkToggleCommand((FwkControllerInterface)component);
            cmd.setTextKey("P2D.Text.Grid");
            cmd.setCommandName("Grid");
            cmd.setToggle(true);
            cmd.setToggleState(this.getGrid(component));
            component.addCommand(0, (FwkCommandInterface)cmd);
            cmd = new FwkToggleCommand((FwkControllerInterface)component);
            cmd.setTextKey("P2D.Text.Logarithmic");
            cmd.setCommandName("Log");
            cmd.setToggle(true);
            cmd.setToggleState(this.getLog(component));
            component.addCommand(0, (FwkCommandInterface)cmd);
            cmd = new FwkToggleCommand((FwkControllerInterface)component);
            cmd.setTextKey("P2D.Text.AutoRange");
            cmd.setCommandName("AutoRange");
            cmd.setToggle(true);
            cmd.setToggleState(this.getAutoRange(component));
            component.addCommand(0, (FwkCommandInterface)cmd);
            cmd = new FwkCommand((FwkControllerInterface)component);
            cmd.setTextKey("P2D.Text.Range");
            cmd.setCommandName("AxisRange");
            cmd.addActionListener((ActionListener)P2DRangeActionListener.getInstance());
            component.addCommand(0, (FwkCommandInterface)cmd);
            cmd = new FwkFontCommand((FwkControllerInterface)component);
            cmd.setTextKey("P2D.Text.Font");
            cmd.setCommandName("Font");
            component.addCommand(0, (FwkCommandInterface)cmd);
            cmd = new FwkTextEditorCommand((FwkControllerInterface)component);
            cmd.setTextKey(TITLE_TEXT_KEY);
            cmd.setCommandName("Title");
            component.addCommand(0, (FwkCommandInterface)cmd);
        }
        return super.getCommands();
    }

    public void zoomIn(P2DComponentInterface component) {
        P2DRange1DInterface r = this.getRange(component);
        double m = (r.getUpper() + r.getLower()) / 2.0;
        this.setRange(component, new P2DRange1D(m - r.getDistance() / 4.0, m + r.getDistance() / 4.0));
    }

    public void zoomOut(P2DComponentInterface component) {
        P2DRange1DInterface r = this.getRange(component);
        double m = (r.getUpper() + r.getLower()) / 2.0;
        this.setRange(component, new P2DRange1D(m - r.getDistance(), m + r.getDistance()));
    }

    public void toEndOfRange(P2DComponentInterface component) {
        P2DRange1DInterface r = this.getRange(component);
        this.autoRange = true;
        P2DRange1DInterface ar = this.getChannelRange(component);
        this.setRange(component, new P2DRange1D(ar.getUpper(), ar.getUpper() - r.getDistance()));
    }

    public void toBeginOfRange(P2DComponentInterface component) {
        P2DRange1DInterface r = this.getRange(component);
        this.autoRange = true;
        P2DRange1DInterface ar = this.getChannelRange(component);
        this.setRange(component, new P2DRange1D(ar.getLower(), ar.getLower() + r.getDistance()));
    }

    public void nextRangeWindow(P2DComponentInterface component) {
        P2DRange1DInterface r = this.getRange(component);
        this.setRange(component, new P2DRange1D(r.getUpper(), r.getUpper() + r.getDistance()));
    }

    public void prevRangeWindow(P2DComponentInterface component) {
        P2DRange1DInterface r = this.getRange(component);
        this.setRange(component, new P2DRange1D(r.getLower() - r.getDistance(), r.getLower()));
    }

    public void nextRangeStep(P2DComponentInterface component) {
        P2DRange1DInterface r = this.getRange(component);
        r.move(r.getDistance() * 0.1);
        this.setRange(component, r);
    }

    public void prevRangeStep(P2DComponentInterface component) {
        P2DRange1DInterface r = this.getRange(component);
        r.move(-r.getDistance() * 0.1);
        this.setRange(component, r);
    }

    public void setFullResolution(P2DComponentInterface component, P2DContainerInterface container) {
        P2DRange1DInterface r = this.getRange(component);
        double m = (r.getUpper() + r.getLower()) / 2.0;
        AffineTransform at = component.getTransform(container);
        P2DBoundingBoxInterface bb = this.getBoundingBox(component);
        Point2D.Double p = this.type.getValue() == P2DAxisType.X.getValue() ? new Point2D.Double(bb.getLower().getX(), bb.getUpper().getX()) : new Point2D.Double(bb.getLower().getY(), bb.getUpper().getY());
        Point2D.Double dst = new Point2D.Double();
        try {
            at.deltaTransform(p, dst);
            double dist = Math.abs(((Point2D)dst).getX() - ((Point2D)dst).getY());
            this.setRange(component, new P2DRange1D(m - dist / 2.0, m + dist / 2.0));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String getShortName(P2DComponentInterface component) {
        Iterator it = this.channels.keySet().iterator();
        if (it.hasNext()) {
            P2DChannelInterface c = (P2DChannelInterface)it.next();
            return c.getShortName();
        }
        return super.getShortName(component);
    }

    public int getTickCount(P2DComponentInterface component) {
        if (!this.isValid(component)) {
            this.getTickvalues(component);
        }
        if (this.niceNumbers != null) {
            return this.niceNumbers.length;
        }
        return 2;
    }

    public void setTickCount(P2DComponentInterface component, int ticks) {
        if (ticks != this.ticksRequested) {
            this.ticksRequested = ticks;
            this.revalidate(component, false);
            component.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNiceNumberCalculator(P2DComponentInterface component, P2DRange1DInterface calculator) {
        if (calculator != null) {
            P2DRange1DInterface p2DRange1DInterface = this.nnCalculator;
            synchronized (p2DRange1DInterface) {
                this.nnCalculator = calculator;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P2DRange1DInterface getNiceNumberCalculator(P2DComponentInterface component) {
        P2DRange1DInterface p2DRange1DInterface = this.nnCalculator;
        synchronized (p2DRange1DInterface) {
            return this.nnCalculator;
        }
    }
}

