/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.p2d.P2DAxisModelInterface;
import com.highqsoft.interfaces.p2d.P2DAxisViewInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DRange1DInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DAxisType;
import com.highqsoft.p2d.P2DComponentView;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class P2DAxisView
extends P2DComponentView
implements P2DAxisViewInterface {
    public static final String version = "$Revision: 1.5 $";

    public void draw(P2DComponentInterface component, P2DContainerInterface container, Graphics2D g2) {
        float ticklen;
        Graphics2D g = (Graphics2D)g2.create();
        P2DAxisModelInterface model = (P2DAxisModelInterface)component.getModel();
        FwkArrayInterface niceNumbers = model.getTickvalues(component);
        P2DRange1DInterface range = model.getRange(component);
        FwkArrayInterface tickStrings = model.getAttributedTickvalues(component);
        FwkArrayInterface titleString = model.getAttributedTitle(component);
        boolean log = model.getType(component).isLog();
        float layoutPos = ticklen = (float)model.getTicklen(component);
        int lower = 0;
        int upper = niceNumbers.size() - 1;
        GeneralPath ticklines = new GeneralPath();
        AttributedString as10 = new AttributedString("10");
        as10.addAttribute(TextAttribute.FONT, g.getFont());
        as10.addAttribute(TextAttribute.FOREGROUND, g.getColor());
        TextLayout l10 = new TextLayout(as10.getIterator(), g.getFontRenderContext());
        double pos = model.getPosition(component);
        double max = range.getUpper();
        double min = range.getLower();
        if (model.getLog(component)) {
            if (max > 0.0 && min > 0.0) {
                max = Math.log(max) / P2D.log10;
                min = Math.log(min) / P2D.log10;
            } else if (max > 0.0 && min <= 0.0 && !Double.isNaN(range.getMinPositiveValue())) {
                max = Math.log(max) / P2D.log10;
                min = Math.log(range.getMinPositiveValue()) / P2D.log10;
            } else {
                max = 1.0;
                min = 0.0;
            }
        }
        double dist = max - min;
        float width = (float)component.getWidth();
        float height = (float)component.getHeight();
        double[] minorTicks = null;
        double tickDelta = -1.0;
        if (niceNumbers.size() > 1) {
            double nn0 = (Double)niceNumbers.get(0);
            double nn1 = (Double)niceNumbers.get(1);
            tickDelta = nn1 - nn0;
            if (log) {
                minorTicks = new double[8];
                int count = 0;
                for (int i = 2; i <= 9; ++i) {
                    minorTicks[count++] = Math.log(i) / P2D.log10;
                }
            }
        }
        if (model.getType(component).getValue() == P2DAxisType.X.getValue()) {
            ticklen *= height;
            if (pos < 0.5) {
                TextLayout layout;
                AttributedCharacterIterator iter;
                float minorTick;
                int i;
                ticklines.moveTo(0.0f, 0.0f);
                float tickVal = width;
                ticklines.lineTo(tickVal, 0.0f);
                float previousEndPos = 0.0f;
                int actualLine = 0;
                int lineCount = 1;
                for (i = lower; i <= upper; ++i) {
                    if (minorTicks != null && minorTicks.length != 0) {
                        for (int minor = minorTicks.length - 1; minor >= 0; --minor) {
                            minorTick = (float)((double)tickVal - (1.0 - minorTicks[minor]) * tickDelta * (double)width / dist);
                            if (!(minorTick >= 0.0f) || !(minorTick <= width)) continue;
                            ticklines.moveTo(minorTick, 0.0f);
                            ticklines.lineTo(minorTick, ticklen / 2.0f);
                        }
                    }
                    if (!((tickVal = (float)(((double)((Double)niceNumbers.get(i)).floatValue() - min) * (double)width / dist)) <= width)) continue;
                    ticklines.moveTo(tickVal, 0.0f);
                    ticklines.lineTo(tickVal, ticklen);
                    try {
                        iter = ((AttributedString)tickStrings.get(i)).getIterator();
                        if (iter.getEndIndex() - iter.getBeginIndex() == 0) continue;
                        layout = new TextLayout(iter, g.getFontRenderContext());
                        if (!log) {
                            float xpos = (float)((double)tickVal - layout.getBounds().getWidth() / 2.0);
                            if (actualLine != 0) {
                                if (xpos < previousEndPos) {
                                    if (actualLine == 1) {
                                        if (++actualLine > lineCount) {
                                            lineCount = actualLine;
                                        }
                                    } else {
                                        --actualLine;
                                    }
                                } else if (actualLine > 1) {
                                    --actualLine;
                                }
                            } else {
                                actualLine = 1;
                                lineCount = 1;
                            }
                            float ypos = ticklen + (float)actualLine * (layout.getAscent() + layout.getDescent()) + (float)(actualLine - 1) * layout.getLeading();
                            previousEndPos = (float)((double)tickVal + layout.getBounds().getWidth() / 2.0);
                            layoutPos = ticklen + (float)lineCount * (layout.getAscent() + layout.getDescent() + layout.getLeading());
                            layout.draw(g, xpos, ypos);
                            continue;
                        }
                        Graphics2D gr = (Graphics2D)g.create();
                        gr.translate((double)tickVal - l10.getBounds().getWidth() / 2.0 - layout.getBounds().getWidth() / 3.0, ticklen + l10.getAscent() + l10.getDescent());
                        l10.draw(gr, 0.0f, 0.0f);
                        gr.translate(l10.getBounds().getWidth(), -l10.getBounds().getHeight() / 2.0);
                        gr.scale(0.6666666666666666, 0.6666666666666666);
                        layout.draw(gr, 0.0f, 0.0f);
                        layoutPos = ticklen + l10.getAscent() + l10.getDescent() + l10.getLeading();
                        gr.dispose();
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (minorTicks != null && minorTicks.length != 0) {
                    for (int minor = minorTicks.length - 1; minor >= 0; --minor) {
                        minorTick = (float)((double)tickVal - (1.0 - minorTicks[minor]) * tickDelta * (double)width / dist);
                        if (!(minorTick >= 0.0f) || !(minorTick <= width)) continue;
                        ticklines.moveTo(minorTick, 0.0f);
                        ticklines.lineTo(minorTick, ticklen / 2.0f);
                    }
                }
                for (i = 0; i < titleString.size(); ++i) {
                    iter = ((AttributedString)titleString.get(i)).getIterator();
                    if (iter.getEndIndex() - iter.getBeginIndex() == 0) continue;
                    layout = new TextLayout(iter, g.getFontRenderContext());
                    layout.draw(g, (float)((double)width - layout.getBounds().getWidth()) / 2.0f, layoutPos += layout.getAscent() + layout.getDescent() + layout.getLeading());
                }
            } else {
                TextLayout layout;
                AttributedCharacterIterator iter;
                float minorTick;
                int i;
                ticklines.moveTo(0.0f, height);
                float tickVal = width;
                ticklines.lineTo(tickVal, height);
                for (i = lower; i <= upper; ++i) {
                    if (minorTicks != null && minorTicks.length != 0) {
                        for (int minor = minorTicks.length - 1; minor >= 0; --minor) {
                            minorTick = (float)((double)tickVal - (1.0 - minorTicks[minor]) * tickDelta * (double)width / dist);
                            if (!(minorTick >= 0.0f) || !(minorTick <= width)) continue;
                            ticklines.moveTo(minorTick, height - ticklen / 2.0f);
                            ticklines.lineTo(minorTick, height);
                        }
                    }
                    if (!((tickVal = (float)(((double)((Double)niceNumbers.get(i)).floatValue() - min) * (double)width / dist)) <= width)) continue;
                    ticklines.moveTo(tickVal, height - ticklen);
                    ticklines.lineTo(tickVal, height);
                    try {
                        iter = ((AttributedString)tickStrings.get(i)).getIterator();
                        if (iter.getEndIndex() - iter.getBeginIndex() == 0) continue;
                        layout = new TextLayout(iter, g.getFontRenderContext());
                        if (!log) {
                            layout.draw(g, (float)((double)tickVal - layout.getBounds().getWidth() / 2.0), height - (ticklen + layout.getDescent()));
                        } else {
                            Graphics2D gr = (Graphics2D)g.create();
                            gr.translate((double)tickVal - l10.getBounds().getWidth() / 2.0 - layout.getBounds().getWidth() / 3.0, height - (ticklen + l10.getDescent()));
                            l10.draw(gr, 0.0f, 0.0f);
                            gr.translate(l10.getBounds().getWidth(), -l10.getBounds().getHeight() / 2.0);
                            gr.scale(0.6666666666666666, 0.6666666666666666);
                            layout.draw(gr, 0.0f, 0.0f);
                            gr.dispose();
                        }
                        layoutPos = height - (ticklen + layout.getAscent() + layout.getDescent() + layout.getLeading());
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (minorTicks != null && minorTicks.length != 0) {
                    for (int minor = minorTicks.length - 1; minor >= 0; --minor) {
                        minorTick = (float)((double)tickVal - (1.0 - minorTicks[minor]) * tickDelta * (double)width / dist);
                        if (!(minorTick >= 0.0f) || !(minorTick <= width)) continue;
                        ticklines.moveTo(minorTick, height - ticklen / 2.0f);
                        ticklines.lineTo(minorTick, height);
                    }
                }
                for (i = titleString.size() - 1; i >= 0; --i) {
                    iter = ((AttributedString)titleString.get(i)).getIterator();
                    if (iter.getEndIndex() - iter.getBeginIndex() == 0) continue;
                    layout = new TextLayout(iter, g.getFontRenderContext());
                    layout.draw(g, (float)((double)width - layout.getBounds().getWidth()) / 2.0f, layoutPos);
                    layoutPos -= layout.getAscent() + layout.getDescent() + layout.getLeading();
                }
            }
        } else {
            layoutPos = ticklen *= width;
            if (pos < 0.5) {
                TextLayout layout;
                AttributedCharacterIterator iter;
                ticklines.moveTo(width, 0.0f);
                float tickVal = height;
                ticklines.lineTo(width, tickVal);
                for (int i = lower; i <= upper; ++i) {
                    if (minorTicks != null && minorTicks.length != 0) {
                        for (int minor = minorTicks.length - 1; minor >= 0; --minor) {
                            float minorTick = (float)((double)tickVal + (1.0 - minorTicks[minor]) * tickDelta * (double)height / dist);
                            if (!(minorTick >= 0.0f) || !(minorTick <= height)) continue;
                            ticklines.moveTo(width, minorTick);
                            ticklines.lineTo(width - ticklen / 2.0f, minorTick);
                        }
                    }
                    if (!((tickVal = (float)((double)height - ((double)((Double)niceNumbers.get(upper - i)).floatValue() - min) * (double)height / dist)) <= height)) continue;
                    ticklines.moveTo(width, tickVal);
                    ticklines.lineTo(width - ticklen, tickVal);
                    try {
                        iter = ((AttributedString)tickStrings.get(upper - i)).getIterator();
                        if (iter.getEndIndex() - iter.getBeginIndex() == 0) continue;
                        layout = new TextLayout(iter, g.getFontRenderContext());
                        if (!log) {
                            layout.draw(g, (float)((double)width - ((double)ticklen + layout.getBounds().getWidth())), tickVal);
                            layoutPos = Math.max(layoutPos, (float)((double)ticklen + layout.getBounds().getWidth() + (double)layout.getDescent()));
                            continue;
                        }
                        Graphics2D gr = (Graphics2D)g.create();
                        gr.translate((double)width - ((double)ticklen + l10.getBounds().getWidth() + layout.getBounds().getWidth() / 2.0), tickVal);
                        layoutPos = Math.max(layoutPos, (float)((double)ticklen + layout.getBounds().getWidth() + (double)layout.getDescent() + l10.getBounds().getWidth() + (double)l10.getDescent()));
                        l10.draw(gr, 0.0f, 0.0f);
                        gr.translate(l10.getBounds().getWidth(), -l10.getBounds().getHeight() / 2.0);
                        gr.scale(0.6666666666666666, 0.6666666666666666);
                        layout.draw(gr, 0.0f, 0.0f);
                        gr.dispose();
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                Graphics2D gr = (Graphics2D)g.create();
                gr.rotate(-1.5707963267948966, width / 2.0f, height / 2.0f);
                layoutPos = (height + width) / 2.0f - layoutPos;
                for (int i = titleString.size() - 1; i >= 0; --i) {
                    iter = ((AttributedString)titleString.get(i)).getIterator();
                    if (iter.getEndIndex() - iter.getBeginIndex() == 0) continue;
                    layout = new TextLayout(iter, gr.getFontRenderContext());
                    layout.draw(gr, (float)((double)width - layout.getBounds().getWidth()) / 2.0f, layoutPos);
                    layoutPos -= layout.getAscent() + layout.getDescent() + layout.getLeading();
                }
                gr.dispose();
            } else {
                TextLayout layout;
                AttributedCharacterIterator iter;
                float minorTick;
                ticklines.moveTo(0.0f, 0.0f);
                float tickVal = height;
                ticklines.lineTo(0.0f, tickVal);
                for (int i = lower; i <= upper; ++i) {
                    tickVal = (float)((double)height - ((double)((Double)niceNumbers.get(upper - i)).floatValue() - min) * (double)height / dist);
                    if (!(tickVal <= height)) continue;
                    if (minorTicks != null && minorTicks.length != 0) {
                        for (int minor = minorTicks.length - 1; minor >= 0; --minor) {
                            minorTick = (float)((double)tickVal + (1.0 - minorTicks[minor]) * tickDelta * (double)height / dist);
                            if (!(minorTick >= 0.0f) || !(minorTick <= height)) continue;
                            ticklines.moveTo(0.0f, minorTick);
                            ticklines.lineTo(ticklen / 2.0f, minorTick);
                        }
                    }
                    ticklines.moveTo(0.0f, tickVal);
                    ticklines.lineTo(ticklen, tickVal);
                    try {
                        iter = ((AttributedString)tickStrings.get(upper - i)).getIterator();
                        if (iter.getEndIndex() - iter.getBeginIndex() == 0) continue;
                        layout = new TextLayout(iter, g.getFontRenderContext());
                        if (!log) {
                            layout.draw(g, ticklen, tickVal);
                            layoutPos = Math.max(layoutPos, (float)((double)ticklen + layout.getBounds().getWidth() + (double)layout.getDescent() + (double)layout.getAscent()));
                            continue;
                        }
                        Graphics2D gr = (Graphics2D)g.create();
                        gr.translate(ticklen, tickVal);
                        layoutPos = Math.max(layoutPos, (float)((double)ticklen + layout.getBounds().getWidth() + (double)layout.getDescent() + (double)layout.getAscent() + l10.getBounds().getWidth() / 2.0));
                        l10.draw(gr, 0.0f, 0.0f);
                        gr.translate(l10.getBounds().getWidth(), -l10.getBounds().getHeight() / 2.0);
                        gr.scale(0.6666666666666666, 0.6666666666666666);
                        layout.draw(gr, 0.0f, 0.0f);
                        gr.dispose();
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (minorTicks != null && minorTicks.length != 0) {
                    for (int minor = minorTicks.length - 1; minor >= 0; --minor) {
                        minorTick = (float)((double)tickVal + (1.0 - minorTicks[minor]) * tickDelta * (double)height / dist);
                        if (!(minorTick >= 0.0f) || !(minorTick <= height)) continue;
                        ticklines.moveTo(0.0f, minorTick);
                        ticklines.lineTo(ticklen / 2.0f, minorTick);
                    }
                }
                Graphics2D gr = (Graphics2D)g.create();
                gr.rotate(-1.5707963267948966, width / 2.0f, height / 2.0f);
                layoutPos = height / 2.0f - (width / 2.0f - layoutPos);
                for (int i = 0; i < titleString.size(); ++i) {
                    iter = ((AttributedString)titleString.get(i)).getIterator();
                    if (iter.getEndIndex() - iter.getBeginIndex() == 0) continue;
                    layout = new TextLayout(iter, gr.getFontRenderContext());
                    layout.draw(gr, (float)((double)width - layout.getBounds().getWidth()) / 2.0f, layoutPos);
                    layoutPos += layout.getAscent() + layout.getDescent() + layout.getLeading();
                }
                gr.dispose();
            }
        }
        g.setStroke(component.scaleStroke(g.getTransform()));
        g.draw(ticklines);
        g.dispose();
    }

    public void drawGrid(P2DComponentInterface component, Graphics2D g, P2DRange1DInterface range) {
        P2DAxisModelInterface model = (P2DAxisModelInterface)component.getModel();
        if (model.getGrid(component)) {
            Graphics2D g2d = (Graphics2D)g.create();
            Point2D.Float src = new Point2D.Float();
            Point2D.Float dst = new Point2D.Float();
            AffineTransform at = g2d.getTransform();
            FwkArrayInterface niceNumbers = model.getTickvalues(component);
            if (niceNumbers != null) {
                int size = niceNumbers.size();
                GeneralPath path = new GeneralPath();
                if (model.getType(component).getValue() == P2DAxisType.X.getValue()) {
                    for (int i = 0; i < size; ++i) {
                        src.x = ((Double)niceNumbers.get(i)).floatValue();
                        src.y = (float)range.getLower();
                        at.transform(src, dst);
                        path.moveTo(dst.x, dst.y);
                        src.y = (float)range.getUpper();
                        at.transform(src, dst);
                        path.lineTo(dst.x, dst.y);
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        src.y = ((Double)niceNumbers.get(i)).floatValue();
                        src.x = (float)range.getLower();
                        at.transform(src, dst);
                        path.moveTo(dst.x, dst.y);
                        src.x = (float)range.getUpper();
                        at.transform(src, dst);
                        path.lineTo(dst.x, dst.y);
                    }
                }
                g2d.setTransform(new AffineTransform());
                g2d.setStroke(model.getGridAppearance(component).getStroke());
                g2d.setColor(model.getGridAppearance(component).getColor());
                g2d.draw(path);
            }
            g2d.dispose();
        }
    }
}

