/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkAppearance;
import com.highqsoft.interfaces.fwk.FwkAppearanceInterface;
import com.highqsoft.interfaces.p2d.P2DBackgroundInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.p2d.P2DBoundingBox;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class P2DBackground
implements P2DBackgroundInterface {
    public static final String version = "$Revision: 1.3 $";
    Shape shape;
    P2DBoundingBoxInterface boundingBox;
    FwkAppearanceInterface appearance;

    public String getVersion() {
        return version;
    }

    public P2DBackground() {
        this((FwkAppearanceInterface)((FwkAppearance)null));
    }

    public P2DBackground(Color c) {
        this((FwkAppearanceInterface)new FwkAppearance(c));
    }

    public P2DBackground(FwkAppearanceInterface ap) {
        this.appearance = ap != null ? ap : new FwkAppearance();
        this.boundingBox = new P2DBoundingBox(new Point2D.Double(0.0, 0.0), new Point2D.Double(1.0, 1.0));
        this.updateGeometry();
    }

    public void release() {
    }

    public void paint(Graphics2D g2) {
        if (this.appearance.isVisible()) {
            Graphics2D g = (Graphics2D)g2.create();
            this.appearance.configure(g);
            g.fill(this.shape);
            g.dispose();
        }
    }

    public FwkAppearanceInterface getAppearance() {
        return this.appearance;
    }

    public void setAppearance(FwkAppearanceInterface ap) {
        this.appearance = ap;
    }

    public P2DBoundingBoxInterface getBoundingBox() {
        return new P2DBoundingBox(this.boundingBox);
    }

    public void setBoundingBox(P2DBoundingBoxInterface bb) {
        this.boundingBox = new P2DBoundingBox(bb);
        this.updateGeometry();
    }

    private void updateGeometry() {
        Point2D.Double lower = new Point2D.Double();
        Point2D.Double upper = new Point2D.Double();
        this.boundingBox.getScaledLower(lower);
        this.boundingBox.getScaledUpper(upper);
        this.shape = new Rectangle2D.Double(lower.x, lower.y, upper.x, upper.y);
    }

    public boolean isVisible() {
        return this.appearance.isVisible();
    }

    public void setVisible(boolean flag) {
        this.appearance.setVisible(flag);
    }

    public boolean getVisible() {
        return this.appearance.isVisible();
    }

    public void setColor(Color c) {
        this.appearance.setColor(c);
    }

    public Color getColor() {
        return this.appearance.getColor();
    }

    public void setTransparency(float t) {
        this.appearance.setTransparency(t);
    }

    public float getTransparency() {
        return this.appearance.getTransparency();
    }
}

