/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkAppearance;
import com.highqsoft.fwk.FwkTileSelectButton;
import com.highqsoft.interfaces.fwk.FwkTileInterface;
import com.highqsoft.p2d.P2DStrokeSelectableInterface;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;

public class P2DBasicStrokeSelectButton
extends FwkTileSelectButton
implements P2DStrokeSelectableInterface {
    public static final String version = "$Revision: 1.3 $";
    protected Stroke[] strokes;

    public String getVersion() {
        return version;
    }

    public P2DBasicStrokeSelectButton() {
        this(FwkAppearance.STROKES, new Dimension(60, 15), FwkAppearance.STROKES.length);
    }

    public P2DBasicStrokeSelectButton(int rowCount) {
        this(FwkAppearance.STROKES, new Dimension(15, 15), rowCount);
    }

    public P2DBasicStrokeSelectButton(Dimension tileSize, int rowCount) {
        this(FwkAppearance.STROKES, tileSize, rowCount);
    }

    public P2DBasicStrokeSelectButton(BasicStroke[] strokes) {
        this(strokes, (int)Math.round(Math.sqrt(strokes.length)));
    }

    public P2DBasicStrokeSelectButton(BasicStroke[] strokes, int rowCount) {
        this(strokes, new Dimension(15, 15), rowCount);
    }

    public P2DBasicStrokeSelectButton(BasicStroke[] strokes, Dimension tileSize, int rowCount) {
        super(P2DBasicStrokeSelectButton.createTiles(strokes, tileSize), rowCount < 1 ? 1 : rowCount);
        this.strokes = strokes;
    }

    public Stroke getSelectedStroke() {
        int index = this.getSelectedTileIndex();
        if (index >= 0 && index < this.strokes.length) {
            return this.strokes[index];
        }
        return null;
    }

    protected static FwkTileInterface[] createTiles(BasicStroke[] strokes, Dimension tileSize) {
        FwkTileInterface[] tiles = new FwkTileInterface[strokes.length];
        int size = strokes.length;
        for (int i = 0; i < size; ++i) {
            tiles[i] = new P2DStrokeTile(strokes[i], tileSize);
        }
        return tiles;
    }

    public static class P2DStrokeTile
    implements FwkTileInterface {
        BufferedImage image;
        Dimension size;
        Stroke stroke;

        public P2DStrokeTile(BasicStroke stroke, Dimension size) {
            this.stroke = stroke != null ? new BasicStroke(2.0f, stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), stroke.getDashArray(), stroke.getDashPhase()) : null;
            this.size = size;
            this.image = null;
        }

        public Dimension getTileSize() {
            return new Dimension(this.size);
        }

        public Object getValueAsObject() {
            return this.stroke;
        }

        public Image getImage() {
            if (this.image == null) {
                GeneralPath path = new GeneralPath();
                this.image = new BufferedImage(this.size.width, this.size.height, 2);
                Graphics2D g = this.image.createGraphics();
                g.setColor(tileBackground);
                g.fillRect(0, 0, this.size.width, this.size.height);
                g.setColor(Color.darkGray);
                if (this.stroke != null) {
                    path.moveTo(0.0f, (float)this.size.height / 2.0f);
                    path.lineTo(this.size.width, (float)this.size.height / 2.0f);
                    g.setStroke(this.stroke);
                    g.draw(path);
                }
                g.dispose();
            }
            return this.image;
        }
    }
}

