/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkAppearance;
import com.highqsoft.fwk.FwkTileSelectMenuItem;
import com.highqsoft.interfaces.fwk.FwkTileInterface;
import com.highqsoft.p2d.P2DBasicStrokeSelectButton;
import com.highqsoft.p2d.P2DStrokeSelectableInterface;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Stroke;

public class P2DBasicStrokeSelectMenuItem
extends FwkTileSelectMenuItem
implements P2DStrokeSelectableInterface {
    public static final String version = "$Revision: 1.3 $";
    protected Stroke[] strokes;

    public String getVersion() {
        return version;
    }

    public P2DBasicStrokeSelectMenuItem() {
        this(FwkAppearance.STROKES, new Dimension(60, 15), FwkAppearance.STROKES.length);
    }

    public P2DBasicStrokeSelectMenuItem(int rowCount) {
        this(FwkAppearance.STROKES, new Dimension(15, 15), rowCount);
    }

    public P2DBasicStrokeSelectMenuItem(Dimension tileSize, int rowCount) {
        this(FwkAppearance.STROKES, tileSize, rowCount);
    }

    public P2DBasicStrokeSelectMenuItem(BasicStroke[] strokes) {
        this(strokes, (int)Math.round(Math.sqrt(strokes.length)));
    }

    public P2DBasicStrokeSelectMenuItem(BasicStroke[] strokes, int rowCount) {
        this(strokes, new Dimension(15, 15), rowCount);
    }

    public P2DBasicStrokeSelectMenuItem(BasicStroke[] strokes, Dimension tileSize, int rowCount) {
        super(P2DBasicStrokeSelectMenuItem.createTiles(strokes, tileSize), rowCount < 1 ? 1 : rowCount);
        this.strokes = strokes;
    }

    public Stroke getSelectedStroke() {
        int index = this.getSelectedTileIndex();
        if (index >= 0 && index < this.strokes.length) {
            return this.strokes[index];
        }
        return null;
    }

    protected static FwkTileInterface[] createTiles(BasicStroke[] strokes, Dimension tileSize) {
        FwkTileInterface[] tiles = new FwkTileInterface[strokes.length];
        int size = strokes.length;
        for (int i = 0; i < size; ++i) {
            tiles[i] = new P2DBasicStrokeSelectButton.P2DStrokeTile(strokes[i], tileSize);
        }
        return tiles;
    }
}

