/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class P2DBoundingBox
implements P2DBoundingBoxInterface {
    public static final String version = "$Revision: 1.4 $";
    protected Point2D.Double lower = new Point2D.Double(-1.0, -1.0);
    protected Point2D.Double upper = new Point2D.Double(1.0, 1.0);
    protected double xFactor = 1.0;
    protected double yFactor = 1.0;
    protected double xOffset = 0.0;
    protected double yOffset = 0.0;

    public String getVersion() {
        return version;
    }

    public P2DBoundingBox() {
    }

    public void release() {
    }

    public boolean equals(Object obj) {
        if (obj instanceof P2DBoundingBoxInterface) {
            P2DBoundingBoxInterface box = (P2DBoundingBoxInterface)obj;
            Point2D boxLower = box.getLower();
            Point2D boxUpper = box.getUpper();
            return this.lower.x == boxLower.getX() && this.lower.y == boxLower.getY() && this.upper.x == boxUpper.getX() && this.upper.y == boxUpper.getY() && this.xFactor == box.getXFactor() && this.yFactor == box.getYFactor() && this.xOffset == box.getXOffset() && this.yOffset == box.getYOffset();
        }
        return false;
    }

    public P2DBoundingBox(Point2D lower, Point2D upper) {
        this();
        this.lower.x = Math.min(lower.getX(), upper.getX());
        this.upper.x = Math.max(lower.getX(), upper.getX());
        this.lower.y = Math.min(lower.getY(), upper.getY());
        this.upper.y = Math.max(lower.getY(), upper.getY());
    }

    public P2DBoundingBox(P2DBoundingBoxInterface box) {
        this(box.getLower(), box.getUpper());
        this.setXScale(box.getXOffset(), box.getXFactor());
        this.setYScale(box.getYOffset(), box.getYFactor());
    }

    public P2DBoundingBox(double lx, double ly, double ux, double uy) {
        this(new Point2D.Double(lx, ly), new Point2D.Double(ux, uy));
    }

    public Object clone() {
        return new P2DBoundingBox(this);
    }

    public P2DBoundingBoxInterface closestIntersection(P2DBoundingBoxInterface[] bounds) {
        int size = bounds.length;
        double closest = Double.MAX_VALUE;
        P2DBoundingBox result = new P2DBoundingBox();
        P2DBoundingBox newBoundBox = new P2DBoundingBox();
        newBoundBox.lower.x = 0.0;
        newBoundBox.lower.y = 0.0;
        newBoundBox.upper.x = 0.0;
        newBoundBox.upper.y = 0.0;
        for (int i = 0; i < size; ++i) {
            if (!this.intersects(bounds[i], (P2DBoundingBoxInterface)result)) continue;
            double value = Math.abs(this.lower.x - result.lower.x) + Math.abs(this.lower.y - result.lower.y) + Math.abs(this.upper.x - result.upper.x) + Math.abs(this.upper.y - result.upper.y);
            if (!(closest > (value = value * result.getArea() / bounds[i].getArea()))) continue;
            closest = value;
            newBoundBox.lower.x = result.lower.x;
            newBoundBox.lower.y = result.lower.y;
            newBoundBox.upper.x = result.upper.x;
            newBoundBox.upper.y = result.upper.y;
        }
        return newBoundBox;
    }

    public double getArea() {
        return (this.upper.x - this.lower.x) * (this.upper.x - this.lower.x) + (this.upper.y - this.lower.y) * (this.upper.y - this.lower.y);
    }

    public boolean intersects(P2DBoundingBoxInterface bounds) {
        return !(bounds.getUpper().getX() <= this.lower.x || bounds.getUpper().getY() <= this.lower.y || bounds.getLower().getX() >= this.upper.x || bounds.getLower().getY() >= this.upper.y);
    }

    public boolean intersects(P2DBoundingBoxInterface[] bounds) {
        boolean ret = false;
        int i = 0;
        int size = bounds.length;
        while (i < size && !ret) {
            ret = this.intersects(bounds[i]);
        }
        return ret;
    }

    public boolean intersects(P2DBoundingBoxInterface[] bounds, P2DBoundingBoxInterface newBoundBox) {
        int size = bounds.length;
        boolean ret = false;
        P2DBoundingBox result = new P2DBoundingBox();
        for (int i = 0; i < size; ++i) {
            if (!this.intersects(bounds[i], (P2DBoundingBoxInterface)result)) continue;
            Point2D l = newBoundBox.getLower();
            Point2D u = newBoundBox.getUpper();
            Point2D rl = result.getLower();
            Point2D ru = result.getUpper();
            if (ret) {
                l.setLocation(Math.min(l.getX(), rl.getX()), Math.min(l.getY(), rl.getY()));
                u.setLocation(Math.max(u.getX(), ru.getX()), Math.max(u.getY(), ru.getY()));
                continue;
            }
            ret = true;
            l.setLocation(rl.getX(), rl.getY());
            u.setLocation(ru.getX(), ru.getY());
        }
        if (!ret) {
            newBoundBox.setLower(new Point2D.Double(0.0, 0.0));
            newBoundBox.setUpper(new Point2D.Double(0.0, 0.0));
        }
        return ret;
    }

    public boolean intersects(P2DBoundingBoxInterface bounds, P2DBoundingBoxInterface newBoundBox) {
        boolean ret = false;
        ret = this.intersects(bounds);
        if (ret) {
            if (newBoundBox != null) {
                newBoundBox.setLower(new Point2D.Double(Math.max(bounds.getLower().getX(), this.lower.x), Math.max(bounds.getLower().getY(), this.lower.y)));
            }
        } else if (newBoundBox != null) {
            newBoundBox.setLower(new Point2D.Double(0.0, 0.0));
            newBoundBox.setUpper(new Point2D.Double(0.0, 0.0));
        }
        return ret;
    }

    public boolean intersects(Point2D v) {
        return v.getX() >= this.lower.x && v.getX() <= this.upper.x && v.getY() >= this.lower.y && v.getY() <= this.upper.y;
    }

    public boolean contains(Point2D p) {
        Point2D lower = this.getScaledLower();
        Point2D upper = this.getScaledUpper();
        return p.getX() >= lower.getX() && p.getX() <= upper.getX() && p.getY() >= lower.getY() && p.getY() <= upper.getY();
    }

    public boolean contains(P2DBoundingBoxInterface box) {
        return this.contains(box.getLower()) && this.contains(box.getUpper());
    }

    public Point2D getUpper() {
        return this.upper;
    }

    public Point2D getLower() {
        return this.lower;
    }

    public void getLower(Point2D lower) {
        lower.setLocation(this.lower.x, this.lower.y);
    }

    public void getUpper(Point2D upper) {
        upper.setLocation(this.upper.x, this.upper.y);
    }

    public void setLower(Point2D lower) {
        this.lower.x = lower.getX();
        this.lower.y = lower.getY();
    }

    public void setUpper(Point2D upper) {
        this.upper.x = upper.getX();
        this.upper.y = upper.getY();
    }

    public P2DBoundingBoxInterface getScaledBoundingBox() {
        return new P2DBoundingBox(this.getScaledLower(), this.getScaledUpper());
    }

    public Point2D getScaledUpper() {
        AffineTransform at = this.getInverseTransform();
        Point2D.Double ret = new Point2D.Double();
        return at.transform(this.upper, ret);
    }

    public Point2D getScaledLower() {
        AffineTransform at = this.getInverseTransform();
        Point2D.Double ret = new Point2D.Double();
        return at.transform(this.lower, ret);
    }

    public void getScaledUpper(Point2D upper) {
        AffineTransform at = this.getInverseTransform();
        at.transform(this.upper, upper);
    }

    public void getScaledLower(Point2D lower) {
        AffineTransform at = this.getInverseTransform();
        at.transform(this.lower, lower);
    }

    public double getWidth() {
        return this.upper.getX() - this.lower.getX();
    }

    public double getHeight() {
        return this.upper.getY() - this.lower.getY();
    }

    public double getScaledWidth() {
        return this.xFactor * this.getWidth();
    }

    public double getScaledHeight() {
        return this.yFactor * this.getHeight();
    }

    public void setWidth(double width) {
        this.upper.x = width + this.lower.x;
    }

    public void setHeight(double height) {
        this.lower.y = this.upper.y - height;
    }

    public Rectangle2D getRectangle() {
        return new Rectangle2D.Double(this.lower.x, this.lower.y, this.upper.x - this.lower.x, this.upper.y - this.lower.y);
    }

    public String toString() {
        return "P2DBoundingBox (" + this.lower.x + ", " + this.lower.y + ", " + this.upper.x + ", " + this.upper.y + ") scaled to " + "(" + this.xOffset + ", " + this.yOffset + ", " + (this.xOffset + this.getScaledWidth()) + ", " + (this.yOffset + this.getScaledHeight()) + ")";
    }

    public void move(double xDiff, double yDiff) {
        this.lower = new Point2D.Double(this.lower.x + xDiff, this.lower.y + yDiff);
        this.upper = new Point2D.Double(this.upper.x + xDiff, this.upper.y + yDiff);
    }

    public boolean isInside(P2DBoundingBoxInterface box) {
        return this.contains(box.getLower()) && this.contains(box.getUpper());
    }

    public void setScale(double xFactor, double yFactor) {
        this.xFactor = xFactor;
        this.yFactor = yFactor;
    }

    public void setOffset(double xOffset, double yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public void setXScale(double offset, double scale) {
        this.xOffset = offset;
        this.xFactor = scale;
    }

    public void setYScale(double offset, double scale) {
        this.yOffset = offset;
        this.yFactor = scale;
    }

    public double getXFactor() {
        return this.xFactor;
    }

    public double getYFactor() {
        return this.yFactor;
    }

    public double getXOffset() {
        return this.xOffset;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public AffineTransform getInverseTransform() {
        AffineTransform ret = new AffineTransform();
        ret.translate(this.xOffset, this.yOffset);
        ret.scale(this.xFactor, this.yFactor);
        ret.translate(-this.lower.x, -this.lower.y);
        return ret;
    }

    public AffineTransform getTransform() {
        AffineTransform ret = new AffineTransform();
        ret.translate(this.lower.x, this.lower.y);
        ret.scale(1.0 / this.xFactor, 1.0 / this.yFactor);
        ret.translate(-this.xOffset, -this.yOffset);
        return ret;
    }

    public AffineTransform getXTransform() {
        AffineTransform ret = new AffineTransform();
        ret.translate(this.lower.x, 0.0);
        ret.scale(1.0 / this.xFactor, 1.0);
        ret.translate(-this.xOffset, 0.0);
        return ret;
    }

    public AffineTransform getYTransform() {
        AffineTransform ret = new AffineTransform();
        ret.translate(0.0, this.lower.y);
        ret.scale(1.0, 1.0 / this.yFactor);
        ret.translate(0.0, -this.yOffset);
        return ret;
    }

    public Point2D inverseTransformPoint(Point2D p) {
        AffineTransform t = this.getInverseTransform();
        Point2D.Double dst = new Point2D.Double();
        return t.transform(p, dst);
    }

    public Point2D transformPoint(Point2D p) {
        AffineTransform t = this.getTransform();
        Point2D.Double dst = new Point2D.Double();
        return t.transform(p, dst);
    }

    public static void main(String[] args) {
        P2DBoundingBox bb = new P2DBoundingBox(1000.0, 1000.0, 2000.0, 2000.0);
        System.out.println(bb);
        bb.setXScale(20.0, 0.5);
        bb.setYScale(20.0, 0.5);
        System.out.println(bb.getScaledLower());
        Point2D.Double src = new Point2D.Double(220.0, 520.0);
        System.out.println(bb.getTransform());
        System.out.println(bb.transformPoint(src));
        src.setLocation(1500.0, 1500.0);
        System.out.println(bb.contains(src));
        src.setLocation(1000.0, 1500.0);
        System.out.println(src + " " + bb.getInverseTransform());
        System.out.println(bb.inverseTransformPoint(src));
        System.exit(0);
    }
}

