/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkAppearance;
import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkChangeRegistry;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDOMHandler;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPanel;
import com.highqsoft.fwk.FwkXmlInterpreter;
import com.highqsoft.fwk.command.FwkColorCommand;
import com.highqsoft.fwk.command.FwkPrintCommand;
import com.highqsoft.fwk.factory.FwkDescriptionFactory;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.fwk.listener.FwkPopupMenuUnregisterListener;
import com.highqsoft.interfaces.fwk.FwkAppearanceInterface;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDOMHandlerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkInfoBusMemberInterface;
import com.highqsoft.interfaces.fwk.FwkInterface;
import com.highqsoft.interfaces.fwk.FwkPrintableInterface;
import com.highqsoft.interfaces.fwk.FwkXmlDtdInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DCanvasInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DContainerListenerInterface;
import com.highqsoft.interfaces.p2d.P2DOrderEventInterface;
import com.highqsoft.interfaces.p2d.P2DOrderListenerInterface;
import com.highqsoft.interfaces.p2d.P2DRepaintListenerInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DAxis;
import com.highqsoft.p2d.P2DBoundingBox;
import com.highqsoft.p2d.P2DComponent;
import com.highqsoft.p2d.P2DComponentConsumer;
import com.highqsoft.p2d.P2DContainerEvent;
import com.highqsoft.p2d.P2DOrderEvent;
import com.highqsoft.p2d.P2DXmlInterpreter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Map;
import java.util.Vector;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusMemberSupport;
import javax.infobus.InfoBusMembershipException;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class P2DCanvas
extends FwkPanel
implements P2DCanvasInterface,
P2DRepaintListenerInterface,
MouseInputListener,
P2DOrderListenerInterface,
FwkPrintableInterface {
    public static final String version = "$Revision: 1.7 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    Image offScreenImage = null;
    int lastType = -1;
    protected MouseEvent lastMouseEvent;
    protected Point2D localMousePoint;
    FwkInfoBusMemberInterface infoBusMember;
    FwkAppearanceInterface appearance;
    protected P2DContainerInterface parent;
    protected P2DContainerInterface active;
    P2DBoundingBoxInterface boundingBox = null;
    boolean dragging;
    protected boolean selectable;
    protected FwkArray components;
    protected EventListenerList listenerList;
    protected InfoBusMemberSupport infoBusMemberSupport;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return FwkDescriptionFactory.getDescriptor((Class)P2DCanvas.class, (FwkDescriptionInterface)descriptor);
    }

    public void release() {
        this.removeAllP2D();
        this.offScreenImage = null;
        try {
            this.infoBusMemberSupport.leaveInfoBus();
            this.infoBusMemberSupport = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.parent = null;
        this.active = null;
        FwkChangeRegistry.unregister((Object)this);
        super.release();
    }

    public P2DCanvas() {
        this.setDescriptor(P2DCanvas.getDescriptor());
        this.init();
    }

    public P2DCanvas(String name) {
        this();
        this.setMemberName(name);
    }

    public String getTitle() {
        return super.getTitle() + " " + this.getShortName();
    }

    public void unregister() {
        try {
            int size = this.components.size();
            for (int i = 0; i < size; ++i) {
                try {
                    ((P2DComponentInterface)this.components.get(i)).unregisterContainer(this);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    ((P2DComponentInterface)this.components.get(i)).unregister();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                this.infoBusMemberSupport.leaveInfoBus();
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.getClass().getName() + " " + this.getName() + "\n");
        int size = this.components.size();
        for (int i = 0; i < size; ++i) {
            ret.append(this.components.get(i) + "\n");
        }
        return ret.toString();
    }

    protected void init() {
        this.setMinimumSize(new Dimension(1, 1));
        if (this.components == null) {
            try {
                this.selectable = true;
                this.infoBusMemberSupport = new InfoBusMemberSupport();
                this.listenerList = null;
                this.dragging = false;
                FwkContainer.addComponentProperties((String)"P2D", (Class)P2DCanvas.class);
                this.setSource((FwkInterface)this);
                this.setDescriptor(descriptor);
                this.appearance = new FwkAppearance();
                this.appearance.setTransform(new AffineTransform());
                this.components = new FwkArray();
                this.addMouseListener(this);
                this.addMouseMotionListener(this);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void printPanel(Graphics g) {
        P2D.setPrinting(true);
        this.paintChildren((Graphics2D)g);
        P2D.setPrinting(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintChildren(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        super.paintChildren((Graphics)g2);
        this.appearance.configure(g2);
        try {
            Object object = this.getTreeLock();
            synchronized (object) {
                int size = this.components.size();
                for (int i = 0; i < size; ++i) {
                    P2DComponentInterface comp = (P2DComponentInterface)this.components.get(i);
                    comp.paint(this, g2);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        g2.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revalidate(boolean recursive) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (recursive) {
                int size = this.components.size();
                for (int i = 0; i < size; ++i) {
                    P2DContainerInterface c = (P2DContainerInterface)this.components.get(i);
                    c.revalidate(recursive);
                }
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        int size = this.components.size();
        for (int i = 0; i < size; ++i) {
            P2DComponentInterface comp = (P2DComponentInterface)this.components.get(i);
            comp.unregisterContainer(this);
        }
    }

    public void setActiveComponent(P2DContainerInterface container, P2DContainerInterface component) {
        if (this.active != component) {
            boolean repaint = false;
            if (this.active != null) {
                this.active.setActive(this, false);
                repaint = true;
            }
            this.active = component;
            if (this.active != null) {
                this.active.setActive(this, true);
                repaint = true;
            }
            if (repaint) {
                this.repaint();
            }
        }
    }

    public P2DContainerInterface getActiveComponent(P2DContainerInterface container) {
        return this.active;
    }

    public boolean destroyController() {
        this.setVisible(false);
        return true;
    }

    public void setAppearance(FwkAppearanceInterface ap) {
        FwkAppearanceInterface old = this.appearance;
        this.appearance = ap;
        this.firePropertyChange("Appearance", old, ap);
        FwkChangeRegistry.register((Object)this, (String)"Appearance");
    }

    public FwkAppearanceInterface getAppearance() {
        return this.appearance;
    }

    public void setLineWidth(float w) {
        this.appearance.setLineWidth(w);
    }

    public float getLineWidth() {
        return this.appearance.getLineWidth();
    }

    public void setDashArray(float[] arr) {
        this.appearance.setDashArray(arr);
    }

    public float[] getDashArray() {
        return this.appearance.getDashArray();
    }

    public void setDashPhase(float phase) {
        this.appearance.setDashPhase(phase);
    }

    public float getDashPhase() {
        return this.appearance.getDashPhase();
    }

    public void setEndCap(int cap) {
        this.appearance.setEndCap(cap);
    }

    public int getEndCap() {
        return this.appearance.getEndCap();
    }

    public void setLineJoin(int join) {
        this.appearance.setLineJoin(join);
    }

    public int getLineJoin() {
        return this.appearance.getLineJoin();
    }

    public void setMiterLimit(float limit) {
        this.appearance.setMiterLimit(limit);
    }

    public float getMiterLimit() {
        return this.appearance.getMiterLimit();
    }

    public Font getFont() {
        if (this.appearance == null) {
            this.init();
        }
        return this.appearance.getFont();
    }

    public void setFont(Font newFont) {
        if (this.appearance == null) {
            this.init();
        }
        Font old = this.appearance.getFont();
        this.appearance.setFont(newFont);
        this.firePropertyChange("Font", old, newFont);
        FwkChangeRegistry.register((Object)this, (String)"Font");
    }

    public void setColor(Color color) throws FwkException {
        Color old = this.appearance.getColor();
        this.appearance.setColor(color);
        this.firePropertyChange("Color", old, color);
        FwkChangeRegistry.register((Object)this, (String)"Color");
    }

    public Color getColor() throws FwkException {
        return this.appearance.getColor();
    }

    public void setTransparency(float transparency) {
        Float old = new Float(this.appearance.getTransparency());
        this.appearance.setTransparency(transparency);
        this.firePropertyChange("Transparency", old, new Float(transparency));
        FwkChangeRegistry.register((Object)this, (String)"Transparency");
    }

    public float getTransparency() {
        return this.appearance.getTransparency();
    }

    public AffineTransform getTransform() {
        return this.boundingBox.getTransform();
    }

    public void setTransform(AffineTransform trans) {
        AffineTransform old = this.appearance.getTransform();
        this.appearance.setTransform(trans);
        this.firePropertyChange("Transform", old, trans);
        FwkChangeRegistry.register((Object)this, (String)"Transform");
    }

    public void setTranslation(Point2D translate) {
        this.appearance.setTranslation(((Point2D.Double)translate).x, ((Point2D.Double)translate).y);
    }

    public void setTranslation(double x, double y) {
        Point2D old = this.appearance.getTranslation();
        this.appearance.setTranslation(x, y);
        this.firePropertyChange("Transform", old, new Point2D.Double(x, y));
        FwkChangeRegistry.register((Object)this, (String)"Transform");
    }

    public Point2D getTranslation() {
        return this.appearance.getTranslation();
    }

    public void setClip(double x, double y, double width, double height) {
        this.setClip(new Rectangle2D.Double(x, y, width, height));
    }

    public void setClip(Shape clip) {
        Shape old = this.appearance.getClip();
        this.appearance.setClip(clip);
        this.firePropertyChange("Clip", old, clip);
        FwkChangeRegistry.register((Object)this, (String)"Clip");
    }

    public Shape getClip() {
        return this.appearance.getClip();
    }

    public void setStroke(Stroke s) {
        Stroke old = this.appearance.getStroke();
        this.appearance.setStroke(s);
        this.firePropertyChange("Stroke", old, s);
        FwkChangeRegistry.register((Object)this, (String)"Stroke");
    }

    public Stroke getStroke() {
        return this.appearance.getStroke();
    }

    public void setFill(Shape s) {
        Shape old = this.appearance.getFill();
        this.appearance.setFill(s);
        this.firePropertyChange("Fill", old, s);
        FwkChangeRegistry.register((Object)this, (String)"Fill");
    }

    public Shape getFill() {
        return this.appearance.getFill();
    }

    public boolean getVisible() {
        return this.appearance.getVisible();
    }

    public void setVisible(boolean flag) {
        Boolean old = new Boolean(this.appearance.getVisible());
        this.appearance.setVisible(flag);
        this.firePropertyChange("Visible", old, new Boolean(flag));
        FwkChangeRegistry.register((Object)this, (String)"Visible");
    }

    public void configure(Graphics2D g) {
        this.appearance.configure(g);
    }

    public void setScale(double sx, double sy) {
        this.appearance.setScale(sx, sy);
    }

    public void setBackgroundColor(Color color) {
        this.setBackground(color);
        Color old = this.appearance.getBackgroundColor();
        this.appearance.setBackgroundColor(color);
        this.firePropertyChange("BackgroundColor", old, color);
        FwkChangeRegistry.register((Object)this, (String)"BackgroundColor");
    }

    public Color getBackgroundColor() {
        return this.appearance.getBackgroundColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FwkArrayInterface getP2DComponents() {
        Object object = this.getTreeLock();
        synchronized (object) {
            FwkArray ret = new FwkArray();
            int size = this.components.size();
            for (int i = 0; i < size; ++i) {
                ret.add(this.components.get(i));
            }
            return ret;
        }
    }

    public FwkArrayInterface getP2DComponentArray() {
        return this.components;
    }

    public P2DContainerInterface addP2D(P2DContainerInterface comp) {
        return this.addP2DImpl(comp, null, -1);
    }

    public P2DContainerInterface addP2D(String name, int index) {
        P2DComponentInterface comp = P2DComponentConsumer.getInstanceByName(this.getInfoBusName()).findComponent(name, FwkContainer.getDataFlavor((Class)P2DContainerInterface.class));
        if (comp != null) {
            return this.addP2D(comp, index);
        }
        throw new FwkException(-2147461538, "$RCSfile: P2DCanvas.java,v $", version, "AH 2000-11-20 12:07", "Cannot find container named <" + name + ">", (Object)this, null);
    }

    public P2DContainerInterface addP2D(String name) {
        return this.addP2D(name, -1);
    }

    public P2DContainerInterface addP2D(P2DContainerInterface comp, int index) {
        return this.addP2DImpl(comp, null, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected P2DContainerInterface addP2DImpl(P2DContainerInterface comp, Object constraints, int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (index > this.components.size() || index < 0 && index != -1) {
                throw new IllegalArgumentException("illegal component position");
            }
            if (comp instanceof P2DContainerInterface) {
                for (P2DContainerInterface cn = this; cn != null; cn = cn.getParentContainer()) {
                    if (cn != comp) continue;
                    throw new IllegalArgumentException("adding container's parent to itself");
                }
            }
            if (index == -1) {
                this.components.add((Object)comp);
            } else {
                this.components.add(index, (Object)comp);
            }
            if (comp instanceof P2DComponentInterface) {
                ((P2DComponentInterface)comp).register();
            }
            comp.addRepaintListener(this);
            comp.addOrderListener(this);
            this.fireContainerAddedEvent(comp);
            this.repaint();
            return comp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P2DContainerInterface removeP2D(int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            P2DContainerInterface comp = (P2DContainerInterface)this.components.get(index);
            return this.removeP2D(comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P2DContainerInterface removeP2D(P2DContainerInterface comp) {
        Object object = this.getTreeLock();
        synchronized (object) {
            P2DContainerInterface parent = comp.getParentContainer();
            if (parent == null || parent.equals(this)) {
                this.components.remove((Object)comp);
                if (comp instanceof P2DComponentInterface) {
                    ((P2DComponentInterface)comp).unregister();
                }
                comp.setParentContainer(null);
                this.fireContainerRemovedEvent(comp);
                return comp;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P2DContainerInterface getP2D(int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            return (P2DContainerInterface)this.components.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P2DContainerInterface[] getP2D(Class clazz) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int size = this.components.size();
            P2DContainerInterface[] ret = new P2DContainerInterface[size];
            if (size > 0) {
                int count = 0;
                for (int i = 0; i < size; ++i) {
                    Object elem = this.components.get(i);
                    if (!clazz.isInstance(elem)) continue;
                    ret[count++] = (P2DContainerInterface)elem;
                }
                if (count < size) {
                    P2DContainerInterface[] tmp = new P2DContainerInterface[count];
                    System.arraycopy(ret, 0, tmp, 0, count);
                    ret = tmp;
                } else if (count == 0) {
                    ret = new P2DContainerInterface[]{};
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P2DContainerInterface[] getP2D(Class clazz, String name) {
        if (name == null) {
            return new P2DContainerInterface[0];
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            int size = this.components.size();
            P2DContainerInterface[] ret = new P2DContainerInterface[size];
            if (size > 0) {
                int count = 0;
                for (int i = 0; i < size; ++i) {
                    P2DContainerInterface elem = (P2DContainerInterface)this.components.get(i);
                    if (!clazz.isInstance(elem) || elem.getName().compareTo(name) != 0) continue;
                    ret[count++] = elem;
                }
                if (count < size) {
                    P2DContainerInterface[] tmp = new P2DContainerInterface[count];
                    System.arraycopy(ret, 0, tmp, 0, count);
                    ret = tmp;
                } else if (count == 0) {
                    ret = new P2DContainerInterface[]{};
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllP2D() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int size = this.components.size();
            if (size > 0) {
                P2DContainerInterface[] arr = (P2DContainerInterface[])this.components.toArray((Object[])new P2DContainerInterface[size]);
                for (int i = 0; i < size; ++i) {
                    this.removeP2D(arr[i]);
                }
            }
            this.components.clear();
        }
    }

    public void toFront() {
    }

    public void toFront(int index) {
        if (index >= 0 && index < this.components.size() - 1) {
            this.toFront((P2DContainerInterface)this.components.get(index));
        }
    }

    public void toFront(P2DContainerInterface container) {
        if (this.components.remove((Object)container)) {
            this.components.add((Object)container);
            this.repaint();
        }
    }

    public void toBack() {
    }

    public void toBack(int index) {
        if (index >= 1 && index < this.components.size()) {
            this.toBack((P2DContainerInterface)this.components.get(index));
        }
    }

    public void toBack(P2DContainerInterface container) {
        if (this.components.remove((Object)container)) {
            this.components.add(0, (Object)container);
            this.repaint();
        }
    }

    public void setParentContainer(P2DContainerInterface container) {
        this.parent = container;
    }

    public P2DContainerInterface getParentContainer() {
        return this.parent;
    }

    public void getAllArmedComponents(P2DContainerInterface container, Point2D p, FwkArrayInterface arr) {
        if (this.components != null && this.components.size() != 0) {
            int i = this.components.size() - 1;
            while (i >= 0) {
                P2DContainerInterface comp = (P2DContainerInterface)this.components.get(i--);
                comp.getAllArmedComponents(container, p, arr);
            }
        }
    }

    public void getAllArmedComponents(P2DContainerInterface container, double x, double y, FwkArrayInterface arr) {
        this.getAllArmedComponents(container, new Point2D.Double(x, y), arr);
    }

    public P2DContainerInterface getArmedComponent(double x, double y) {
        P2DContainerInterface armed = null;
        if (this.getSelectable() && this.components != null && this.components.size() != 0) {
            int i = this.components.size() - 1;
            while (armed == null && i >= 0) {
                P2DContainerInterface comp;
                if ((comp = (P2DContainerInterface)this.components.get(i--)) instanceof P2DComponentInterface) {
                    armed = ((P2DComponentInterface)comp).getChild(x, y);
                    continue;
                }
                armed = comp.getArmedComponent(x, y);
            }
        }
        return armed;
    }

    public void processFocusEvent(FocusEvent e) {
    }

    public void processMouseEvent(MouseEvent e) {
        this.saveLastMouseEvent(e);
        super.processMouseEvent(e);
        if (this.components != null && this.components.size() != 0) {
            FwkCommandInterface[] arr;
            int id = e.getID();
            String groupIdent = null;
            switch (id) {
                case 501: {
                    groupIdent = "MOUSE_PRESSED";
                    this.dragging = false;
                    break;
                }
                case 502: {
                    groupIdent = "MOUSE_RELEASED";
                    if ((e.getModifiers() & 0x10) != 0) {
                        if (e.getClickCount() == 1 && !this.dragging) {
                            P2DContainerInterface c;
                            P2DContainerInterface armed = this.getArmedComponent(e.getX(), e.getY());
                            if (armed != null) {
                                for (c = armed.getParentContainer(); c != null && c != this.active; c = c.getParentContainer()) {
                                    armed = c;
                                }
                                c = armed.getParentContainer();
                                if (c != null) {
                                    c.setActiveComponent(this, armed);
                                }
                                this.setActiveComponent(this, armed);
                            } else if (this.active != null) {
                                c = this.active.getParentContainer();
                                if (c != null) {
                                    c.setActiveComponent(this, null);
                                }
                                this.setActiveComponent(this, null);
                            }
                        }
                    } else if ((e.getModifiers() & 4) != 0) {
                        if (this.active != null) {
                            arr = new FwkArray();
                            P2DContainerInterface parent = this.active.getParentContainer();
                            if (parent != null) {
                                parent.getAllArmedComponents(this, new Point2D.Double(e.getX(), e.getY()), (FwkArrayInterface)arr);
                                if (arr.size() > 2 && parent.equals(arr.get(0))) {
                                    arr.remove(0);
                                }
                            } else {
                                this.getAllArmedComponents(this, new Point2D.Double(e.getX(), e.getY()), (FwkArrayInterface)arr);
                            }
                            if (arr.size() > 2) {
                                JPopupMenu popup = new JPopupMenu();
                                for (int i = 0; i < arr.size(); ++i) {
                                    P2DComponentInterface comp = (P2DComponentInterface)arr.get(i);
                                    FwkCommandInterface[] commands = comp.getCommands();
                                    if (commands == null || commands.length == 0) continue;
                                    JMenu menu = new JMenu(comp.getShortName());
                                    popup.add(menu);
                                    FwkGUIFactory.createSubMenu((JMenu)menu, (FwkCommandInterface[])commands, null, (boolean)false);
                                }
                                if (popup != null) {
                                    popup.addPopupMenuListener((PopupMenuListener)FwkPopupMenuUnregisterListener.getInstance());
                                    popup.show((Component)e.getSource(), e.getX(), e.getY());
                                }
                            } else {
                                this.active.openPopupMenu(e);
                            }
                        } else {
                            this.openPopupMenu(e);
                        }
                    }
                    this.dragging = false;
                    break;
                }
                case 500: {
                    groupIdent = "MOUSE_CLICKED";
                    this.dragging = false;
                    break;
                }
                case 505: {
                    break;
                }
            }
            if (this.active != null && groupIdent != null) {
                groupIdent = groupIdent + " " + e.getClickCount() + "-" + e.getModifiers();
                this.active.getCommands();
                arr = this.active.getGroup(groupIdent);
                if (arr != null) {
                    int size = arr.length;
                    for (int i = 0; i < size; ++i) {
                        if (arr[i] == null) continue;
                        arr[i].execute((EventObject)e);
                    }
                }
            }
        }
    }

    public FwkCommandInterface[] getCommands() {
        if (!this.commandsAvailable()) {
            super.getCommands();
            FwkCommandInterface parent = this.getCommand("Help");
            if (parent == null) {
                parent = new FwkCommand((FwkControllerInterface)this);
                parent.setCommandName("Help");
                parent.setTextKey("P2D.Text.Help");
                this.addCommand(0, parent);
            }
            FwkCommand cb = new FwkCommand((FwkControllerInterface)this);
            cb.setCommandName("CanvasHelp");
            cb.setTextKey("P2D.Text.CanvasHelp");
            cb.setIconKey("Icon.HelpBrokerBrick");
            cb.setHelpID("com.highqsoft.p2d.P2DCanvas");
            parent.addCommand(0, (FwkCommandInterface)cb);
            cb = new FwkColorCommand((FwkControllerInterface)this);
            cb.setTextKey("P2D.Text.BackgroundColor");
            cb.setCommandName("BackgroundColor");
            this.addCommand(0, (FwkCommandInterface)cb);
            cb = new FwkPrintCommand((FwkControllerInterface)this);
            cb.setCommandName("Print");
            cb.setTextKey("P2D.Text.Print");
            cb.setIconKey("Icon.Printer");
            this.addCommand(0, (FwkCommandInterface)cb);
        }
        return super.getCommands();
    }

    public P2DBoundingBoxInterface getBoundingBox() {
        if (this.boundingBox == null) {
            Dimension dim = this.getSize();
            return new P2DBoundingBox(0.0, 0.0, dim.width, dim.height);
        }
        return this.boundingBox;
    }

    public void setBoundingBox(P2DBoundingBoxInterface boundingBox) {
        Dimension dim = new Dimension((int)boundingBox.getWidth(), (int)boundingBox.getHeight());
        this.setSize(dim);
    }

    public void setPreferredSize(Dimension size) {
        super.setPreferredSize(size);
        this.setSize(size);
    }

    public void setSize(Dimension size) {
        super.setSize(size);
        FwkChangeRegistry.register((Object)this, (String)"BoundingBox");
    }

    public Dimension getPreferredSize() {
        if (this.boundingBox != null) {
            return new Dimension((int)this.boundingBox.getWidth(), (int)this.boundingBox.getHeight());
        }
        return new Dimension(10, 10);
    }

    public void paint(Graphics g) {
        Rectangle rect = g.getClipBounds();
        Dimension dim = this.getSize();
        if (rect == null || rect.width == dim.width && rect.height == dim.height) {
            this.offScreenImage = this.createImage(dim.width, dim.height);
            Graphics gos = this.offScreenImage.getGraphics();
            super.paint(gos);
            gos.dispose();
            g.drawImage(this.offScreenImage, 0, 0, (ImageObserver)((Object)this));
        } else {
            super.paint(g);
        }
    }

    public Image getOffScreenImage() {
        return this.offScreenImage;
    }

    public void repaint() {
        super.repaint();
        if (this.listenerList != null) {
            EventListener[] arr = this.listenerList.getListeners(P2DRepaintListenerInterface.class);
            for (int i = arr.length - 1; i >= 0; --i) {
                try {
                    P2DRepaintListenerInterface listener = (P2DRepaintListenerInterface)arr[i];
                    listener.repaint();
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public void setActive(P2DContainerInterface container, boolean flag) {
    }

    public boolean getActive(P2DContainerInterface container) {
        return true;
    }

    public void setBounds(int x, int y, int w, int h) {
        Dimension old = this.getSize();
        Dimension min = this.getMinimumSize();
        if (w < min.width) {
            w = min.width;
        }
        if (h < min.height) {
            h = min.height;
        }
        if (w < 1) {
            w = 1;
        }
        if (h < 1) {
            h = 1;
        }
        super.setBounds(x, y, w, h);
        P2DBoundingBoxInterface oldbb = this.getBoundingBox();
        this.boundingBox = new P2DBoundingBox(0.0, 0.0, w, h);
        this.firePropertyChange("BoundingBox", oldbb, this.boundingBox);
        FwkChangeRegistry.register((Object)this, (String)"BoundingBox");
        double xFac = (double)w / (double)old.width;
        double yFac = (double)h / (double)old.height;
        int size = this.components.size();
        Point2D.Double l = new Point2D.Double();
        Point2D.Double u = new Point2D.Double();
        for (int i = 0; i < size; ++i) {
            try {
                P2DBoundingBoxInterface bb = ((P2DComponentInterface)this.components.get(i)).getBoundingBox();
                bb.getLower(l);
                bb.getUpper(u);
                l.setLocation(l.getX() * xFac, l.getY() * yFac);
                u.setLocation(u.getX() * xFac, u.getY() * yFac);
                ((P2DComponentInterface)this.components.get(i)).setBoundingBox(new P2DBoundingBox(l, u));
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.revalidate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseClicked(MouseEvent e) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int size = this.components.size();
            Point2D.Double p = new Point2D.Double(e.getX(), e.getY());
            for (int i = 0; i < size; ++i) {
                Object o = this.components.get(i);
                if (!(o instanceof P2DComponent)) continue;
                ((P2DComponentInterface)this.components.get(i)).mouseClicked(p, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent e) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int size = this.components.size();
            Point2D.Double p = new Point2D.Double(e.getX(), e.getY());
            for (int i = 0; i < size; ++i) {
                Object o = this.components.get(i);
                if (!(o instanceof P2DComponent)) continue;
                ((P2DComponentInterface)this.components.get(i)).mousePressed(p, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int size = this.components.size();
            Point2D.Double p = new Point2D.Double(e.getX(), e.getY());
            for (int i = 0; i < size; ++i) {
                Object o = this.components.get(i);
                if (!(o instanceof P2DComponent)) continue;
                ((P2DComponentInterface)this.components.get(i)).mouseReleased(p, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseEntered(MouseEvent e) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int size = this.components.size();
            Point2D.Double p = new Point2D.Double(e.getX(), e.getY());
            for (int i = 0; i < size; ++i) {
                Object o = this.components.get(i);
                if (!(o instanceof P2DComponent)) continue;
                ((P2DComponentInterface)this.components.get(i)).mouseEntered(p, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseExited(MouseEvent e) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int size = this.components.size();
            Point2D.Double p = new Point2D.Double(e.getX(), e.getY());
            for (int i = 0; i < size; ++i) {
                Object o = this.components.get(i);
                if (!(o instanceof P2DComponent)) continue;
                ((P2DComponentInterface)this.components.get(i)).mouseExited(p, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseMoved(MouseEvent e) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int size = this.components.size();
            Point2D.Double p = new Point2D.Double(e.getX(), e.getY());
            for (int i = 0; i < size; ++i) {
                Object o = this.components.get(i);
                if (!(o instanceof P2DComponentInterface)) continue;
                ((P2DComponentInterface)this.components.get(i)).mouseMoved(p, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent e) {
        this.dragging = true;
        Object object = this.getTreeLock();
        synchronized (object) {
            int size = this.components.size();
            Point2D.Double p = new Point2D.Double(e.getX(), e.getY());
            for (int i = 0; i < size; ++i) {
                Object o = this.components.get(i);
                if (!(o instanceof P2DComponent)) continue;
                ((P2DComponentInterface)this.components.get(i)).mouseDragged(p, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popToFront(P2DOrderEventInterface event) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.components.remove((Object)event.getComponent())) {
                this.components.add((Object)event.getComponent());
                this.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushToBack(P2DOrderEventInterface event) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.components.remove((Object)event.getComponent())) {
                this.components.add(0, (Object)event.getComponent());
                this.repaint();
            }
        }
    }

    public String getMemberName() {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            return this.getName() + "@" + ib.getName();
        }
        return this.getName() + "@" + P2D.BUSNAME;
    }

    public synchronized void setMemberName(String dataItemName) throws FwkException {
        int idx = dataItemName.lastIndexOf(64);
        String infoBusName = "";
        String name = dataItemName;
        if (idx > 0 && idx < dataItemName.length() - 2) {
            infoBusName = dataItemName.substring(idx + 1).trim();
            name = dataItemName.substring(0, idx).trim();
        }
        if (infoBusName.length() != 0 && name.length() != 0) {
            this.setName(name);
            try {
                this.joinInfoBus(infoBusName);
                FwkChangeRegistry.register((Object)this, (String)"MemberName");
            }
            catch (Throwable t) {
                throw new FwkException(-2147460648, "FwkInfoBusMember.java", this.getVersion(), "AH 1999-12-04 16:32", infoBusName, (Object)this, t);
            }
        }
        if (name.length() == 0) {
            throw new FwkException(-2147462348, "FwkInfoBusMember.java", this.getVersion(), "AH 1999-12-04 16:26", dataItemName, (Object)this, null);
        }
        this.setName(name);
        FwkChangeRegistry.register((Object)this, (String)"MemberName");
    }

    public void joinInfoBus(String infoBusName) throws FwkException {
        if (infoBusName == null || infoBusName.length() == 0) {
            infoBusName = "<none>";
        }
        try {
            this.infoBusMemberSupport.leaveInfoBus();
        }
        catch (PropertyVetoException pve) {
            throw new FwkException(-2147460645, "$RCSfile: P2DCanvas.java,v $", this.getVersion(), "AH 1999-14-04 11:30", this.getInfoBus().getName(), (Object)this, (Throwable)pve);
        }
        catch (InfoBusMembershipException ime) {
            // empty catch block
        }
        if (infoBusName.compareTo("<none>") != 0) {
            try {
                this.infoBusMemberSupport.joinInfoBus(infoBusName);
            }
            catch (Throwable t) {
                throw new FwkException(-2147460648, "$RCSfile: P2DCanvas.java,v $", this.getVersion(), "AH 1999-12-04 16:24", infoBusName, (Object)this, t);
            }
        }
    }

    public boolean isConnected() {
        return this.getInfoBus() != null;
    }

    public String getInfoBusName() {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            return ib.getName();
        }
        return "<none>";
    }

    public void setInfoBusName(String newName) {
        this.joinInfoBus(newName);
    }

    public void addInfoBusPropertyListener(PropertyChangeListener pcl) {
        this.infoBusMemberSupport.addInfoBusPropertyListener(pcl);
    }

    public void addInfoBusVetoableListener(VetoableChangeListener vcl) {
        this.infoBusMemberSupport.addInfoBusVetoableListener(vcl);
    }

    public InfoBus getInfoBus() {
        return this.infoBusMemberSupport.getInfoBus();
    }

    public void removeInfoBusPropertyListener(PropertyChangeListener pcl) {
        this.infoBusMemberSupport.removeInfoBusPropertyListener(pcl);
    }

    public void removeInfoBusVetoableListener(VetoableChangeListener vcl) {
        this.infoBusMemberSupport.removeInfoBusVetoableListener(vcl);
    }

    public void setInfoBus(InfoBus newInfoBus) throws PropertyVetoException {
        this.infoBusMemberSupport.setInfoBus(newInfoBus);
    }

    public synchronized FwkArrayInterface getMouseMotionListenerArray() {
        return this.getListenerArray(MouseMotionListener.class);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        super.addMouseMotionListener(l);
        this.addListener(MouseMotionListener.class, l);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        super.removeMouseMotionListener(l);
        this.removeListener(MouseMotionListener.class, l);
    }

    public synchronized FwkArrayInterface getMouseListenerArray() {
        return this.getListenerArray(MouseListener.class);
    }

    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.addListener(MouseListener.class, l);
    }

    public synchronized void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.removeListener(MouseListener.class, l);
    }

    public synchronized FwkArrayInterface getFocusListenerArray() {
        return this.getListenerArray(FocusListener.class);
    }

    public synchronized void addFocusListener(FocusListener l) {
        super.addFocusListener(l);
        this.addListener(FocusListener.class, l);
    }

    public synchronized void removeFocusListener(FocusListener l) {
        super.removeFocusListener(l);
        this.removeListener(FocusListener.class, l);
    }

    public synchronized FwkArrayInterface getRepaintListenerArray() {
        return this.getListenerArray(P2DRepaintListenerInterface.class);
    }

    public void addRepaintListener(P2DRepaintListenerInterface listener) {
        this.addListener(P2DRepaintListenerInterface.class, listener);
    }

    public void removeRepaintListener(P2DRepaintListenerInterface listener) {
        this.removeListener(P2DRepaintListenerInterface.class, listener);
    }

    public synchronized FwkArrayInterface getContainerListenerArray() {
        return this.getListenerArray(P2DContainerListenerInterface.class);
    }

    public void addContainerListener(P2DContainerListenerInterface listener) {
        this.addListener(P2DContainerListenerInterface.class, listener);
    }

    public void removeContainerListener(P2DContainerListenerInterface listener) {
        this.removeListener(P2DContainerListenerInterface.class, listener);
    }

    protected void fireContainerAddedEvent(P2DContainerInterface container) {
        try {
            P2DContainerEvent event = new P2DContainerEvent(this, container);
            EventListener[] l = this.listenerList.getListeners(P2DContainerListenerInterface.class);
            for (int i = l.length - 1; i >= 0; --i) {
                ((P2DContainerListenerInterface)l[i]).componentAdded(event);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void fireContainerRemovedEvent(P2DContainerInterface container) {
        try {
            P2DContainerEvent event = new P2DContainerEvent(this, container);
            EventListener[] l = this.listenerList.getListeners(P2DContainerListenerInterface.class);
            for (int i = l.length - 1; i >= 0; --i) {
                ((P2DContainerListenerInterface)l[i]).componentRemoved(event);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public FwkArrayInterface getOrderListenerArray() {
        return this.getListenerArray(P2DOrderListenerInterface.class);
    }

    public void addOrderListener(P2DOrderListenerInterface l) {
        this.addListener(P2DOrderListenerInterface.class, l);
    }

    public void removeOrderListener(P2DOrderListenerInterface l) {
        this.removeListener(P2DOrderListenerInterface.class, l);
    }

    public void fireOrderEvent(boolean flag) {
        block8: {
            if (this.listenerList == null) break block8;
            EventListener[] arr = this.getListeners(P2DOrderListenerInterface.class);
            P2DOrderEvent ev = new P2DOrderEvent(this, flag);
            if (flag) {
                for (int i = arr.length - 1; i >= 0; --i) {
                    try {
                        P2DOrderListenerInterface listener = (P2DOrderListenerInterface)arr[i];
                        listener.popToFront(ev);
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            } else {
                for (int i = arr.length - 1; i >= 0; --i) {
                    try {
                        P2DOrderListenerInterface listener = (P2DOrderListenerInterface)arr[i];
                        listener.pushToBack(ev);
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public FwkArrayInterface getListenerArray(Class clazz) {
        EventListener[] arr = this.getListeners(clazz);
        FwkArray ret = new FwkArray();
        int size = arr.length;
        if (arr != null && size != 0) {
            for (int i = 0; i < size; ++i) {
                ret.add((Object)arr[i]);
            }
        }
        return ret;
    }

    public EventListener[] getListeners(Class clazz) {
        EventListener[] arr = super.getListeners(clazz);
        if (arr == null || arr.length == 0) {
            arr = this.listenerList.getListeners(clazz);
        }
        return arr;
    }

    public void addListener(Class clazz, EventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeListener(Class clazz, EventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listenerList != null) {
            this.listenerList.remove(clazz, listener);
        }
    }

    public void setSelectable(boolean flag) {
        if (this.selectable != flag) {
            this.selectable = flag;
            this.firePropertyChange("Selectable", !flag, flag);
            FwkChangeRegistry.register((Object)this, (String)"Selectable");
        }
    }

    public boolean getSelectable() {
        return this.selectable;
    }

    public Object readConstructor(Document document, Element node) {
        return FwkDOMHandler.readConstructor((Object)this, (Document)document, (Element)node);
    }

    public void readFromDOM(Document doc, Element element) {
        FwkDOMHandler.readFromDOM((Object)this, (Document)doc, (Element)element);
        if (element.hasChildNodes()) {
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                Element elem;
                String nodeName;
                if (child.getNodeType() != 1 || !(nodeName = (elem = (Element)child).getNodeName()).equals("Object")) continue;
                try {
                    P2DComponentInterface comp = (P2DComponentInterface)this.readConstructor(doc, elem);
                    comp.readFromDOM(doc, elem);
                    this.addP2D(comp);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public Element writeConstructor(Document document, FwkXmlDtdInterface dtd, Node node, Map classProperties) {
        return FwkDOMHandler.writeConstructor((Object)this, (String)"Object", (boolean)true, (Document)document, (FwkXmlDtdInterface)dtd, (Node)node, (Map)classProperties, (boolean)true);
    }

    public Element writeToDOM(Document document, FwkXmlDtdInterface dtd, Node node, Map classProperties) {
        Element thisNode = this.writeConstructor(document, dtd, node, classProperties);
        FwkDOMHandler.writeCommandsToDOM((FwkCommandInterface[])this.getCommands(), (Document)document, (FwkXmlDtdInterface)dtd, (Element)thisNode, null);
        FwkDOMHandler.writePropertiesToDOM((Object)this, (Document)document, (FwkXmlDtdInterface)dtd, (Element)thisNode, (Map)classProperties);
        int size = this.components.size();
        for (int i = 0; i < size; ++i) {
            P2DContainerInterface container = (P2DContainerInterface)this.components.get(i);
            container.writeToDOM(document, dtd, thisNode, classProperties);
        }
        return thisNode;
    }

    public boolean writeToXML(String filename, boolean validate) {
        return FwkDOMHandler.writeToXML((FwkDOMHandlerInterface)this, (String)filename, (Class[])new Class[]{FwkXmlInterpreter.class, P2DXmlInterpreter.class}, (boolean)validate);
    }

    public boolean openPopupMenu(MouseEvent ev) {
        JPopupMenu popup;
        this.saveLastMouseEvent(ev);
        if (this.getSelectable() && (popup = FwkGUIFactory.createPopupMenu((String)this.getName(), (FwkCommandInterface[])this.getCommands(), (boolean)false)) != null) {
            popup.addPopupMenuListener((PopupMenuListener)FwkPopupMenuUnregisterListener.getInstance());
            popup.show((Component)ev.getSource(), ev.getX(), ev.getY());
            return true;
        }
        return false;
    }

    public String getShortName() {
        return this.getName();
    }

    public void saveLastMouseEvent(MouseEvent ev) {
        this.lastMouseEvent = ev;
        this.localMousePoint = new Point2D.Double(ev.getX(), ev.getY());
    }

    public MouseEvent restoreLastMouseEvent() {
        return this.lastMouseEvent;
    }

    public void saveLocalMousePoint(Point2D p) {
        this.localMousePoint = new Point2D.Double(p.getX(), p.getY());
    }

    public Point2D restoreLocalMousePoint() {
        return this.localMousePoint;
    }

    public FwkCommandInterface[] getComponentCommands() {
        FwkCommand cmd;
        int size;
        Vector<Object> ret = new Vector<Object>();
        FwkCommandInterface[] arr = this.getCommands();
        if (arr != null && arr.length != 0) {
            size = arr.length;
            for (int i = 0; i < size; ++i) {
                ret.add(arr[i]);
            }
            cmd = new FwkCommand();
            cmd.setSeparator(true);
            ret.add(cmd);
        }
        size = this.components.size();
        for (int i = 0; i < size; ++i) {
            P2DContainerInterface container = (P2DContainerInterface)this.components.get(i);
            arr = container.getComponentCommands();
            if (arr == null || arr.length == 0) continue;
            cmd = new FwkCommand();
            cmd.setTextKey(container.getTitle());
            cmd.setIconKey(container.getIconKey());
            cmd.setCommandName(container.getClass().getName());
            cmd.setCommands(arr);
            ret.add(cmd);
        }
        arr = new FwkCommandInterface[ret.size()];
        return ret.toArray(arr);
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("The canvas of the p2d package");
        descriptor.setTitleName("P2DCanvas.Text.Title");
        descriptor.setName(P2DAxis.class.getName());
        descriptor.setIconKey("Icon.P2DCanvas");
        descriptor.setCreationDate("$Date: 2007/06/28 06:50:41 $", null);
    }
}

