/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkChangeRegistry;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataBus;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkInfoBusConsumer;
import com.highqsoft.fwk.factory.FwkDescriptionFactory;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.p2d.P2DAxisInterface;
import com.highqsoft.interfaces.p2d.P2DChannelInterface;
import com.highqsoft.interfaces.p2d.P2DChannelModelInterface;
import com.highqsoft.interfaces.p2d.P2DPointInterface;
import com.highqsoft.interfaces.p2d.P2DRange1DInterface;
import com.highqsoft.interfaces.p2d.P2DRange2DInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DComponent;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import javax.infobus.DataItemAddedEvent;
import javax.infobus.DataItemChangeListener;
import javax.infobus.DataItemDeletedEvent;
import javax.infobus.DataItemRevokedEvent;
import javax.infobus.DataItemValueChangedEvent;
import javax.infobus.InfoBusItemAvailableEvent;
import javax.infobus.InfoBusItemRevokedEvent;
import javax.infobus.RowsetCursorMovedEvent;

public class P2DChannel
extends P2DComponent
implements P2DChannelInterface {
    public static final String version = "$Revision: 1.3 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    static int counter;
    static /* synthetic */ Class class$com$highqsoft$interfaces$fwk$FwkColumnAccessInterface;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return FwkDescriptionFactory.getDescriptor((Class)P2DChannel.class, (FwkDescriptionInterface)descriptor);
    }

    public P2DChannel() {
        this("");
    }

    public P2DChannel(String channelName) {
        this.setDescriptor(descriptor);
        this.setProperty("ModelClassId", "P2DChannelModelId");
        this.setProperty("ViewClassId", "P2DChannelViewId");
        this.setProperty("ControlClassId", "P2DChannelControlId");
        try {
            this.updateModel();
            this.updateView();
            this.updateControl();
            if (channelName == null || channelName.length() == 0) {
                channelName = P2DChannel.getDescriptor().getName() + "[" + this.hashCode() + "]@" + P2D.BUSNAME;
            }
            this.setMemberName(channelName);
            this.register(FwkContainer.getDataFlavors(this.getClass()));
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: P2DChannel.java,v $", this.getVersion(), "AH 1999-04-06 13:51", "Cannot set channel defaults", (Object)this, t);
        }
    }

    public void unregister() {
        this.setXAxisName("");
        this.setYAxisName("");
        super.unregister();
    }

    public String getTitle() {
        return super.getTitle() + " " + this.getShortName();
    }

    public P2DRange2DInterface getRange() {
        return ((P2DChannelModelInterface)this.model).getRange(this);
    }

    public P2DRange1DInterface getXRange() {
        return ((P2DChannelModelInterface)this.model).getXRange(this);
    }

    public P2DRange1DInterface getYRange() {
        return ((P2DChannelModelInterface)this.model).getYRange(this);
    }

    public long getMinCount() {
        return ((P2DChannelModelInterface)this.model).getMinCount(this);
    }

    public long getMaxCount() {
        return ((P2DChannelModelInterface)this.model).getMaxCount(this);
    }

    public P2DPointInterface getPointAt(int index) {
        return ((P2DChannelModelInterface)this.model).getPointAt(this, index);
    }

    public Object findDataItem(String dataItemName) {
        return ((P2DChannelModelInterface)this.model).findDataItem(dataItemName, ((P2DChannelModelInterface)this.model).getDataFlavors());
    }

    public Object findDataItem(String dataItemName, DataFlavor[] flavors) {
        return ((P2DChannelModelInterface)this.model).findDataItem(dataItemName, flavors);
    }

    public Object[] findMultipleDataItems(String dataItemName) {
        return this.findMultipleDataItems(dataItemName, ((P2DChannelModelInterface)this.model).getDataFlavors());
    }

    public Object[] findMultipleDataItems(String dataItemName, DataFlavor[] flavors) {
        return ((P2DChannelModelInterface)this.model).findMultipleDataItems(dataItemName, flavors);
    }

    public P2DAxisInterface getXAxis() {
        return ((P2DChannelModelInterface)this.model).getXAxis(this);
    }

    public P2DAxisInterface getYAxis() {
        return ((P2DChannelModelInterface)this.model).getYAxis(this);
    }

    public void setXAxisName(String axisName) {
        String old = ((P2DChannelModelInterface)this.model).getXAxisName(this);
        if (old == null || old.compareTo(axisName) != 0) {
            ((P2DChannelModelInterface)this.model).setXAxisName(this, axisName);
            this.firePropertyChange("XAixsName", old, axisName);
            FwkChangeRegistry.register((Object)this, (String)"XAxisName");
        }
    }

    public String getXAxisName() {
        return ((P2DChannelModelInterface)this.model).getXAxisName(this);
    }

    public void setYAxisName(String axisName) {
        String old = ((P2DChannelModelInterface)this.model).getYAxisName(this);
        if (old == null || old.compareTo(axisName) != 0) {
            ((P2DChannelModelInterface)this.model).setYAxisName(this, axisName);
            this.firePropertyChange("YAixsName", old, axisName);
            FwkChangeRegistry.register((Object)this, (String)"YAxisName");
        }
    }

    public String getYAxisName() {
        return ((P2DChannelModelInterface)this.model).getYAxisName(this);
    }

    public String getXDataItemName() {
        return ((P2DChannelModelInterface)this.model).getXDataItemName(this);
    }

    public String getYDataItemName() {
        return ((P2DChannelModelInterface)this.model).getYDataItemName(this);
    }

    public void setXDataItemName(String dataItemName) {
        FwkColumnAccessInterface column = this.getXColumn();
        if (column != null) {
            column.removeDataItemChangeListener((DataItemChangeListener)this);
        }
        String old = ((P2DChannelModelInterface)this.model).getXDataItemName(this);
        ((P2DChannelModelInterface)this.model).setXDataItemName(this, dataItemName);
        this.firePropertyChange("XDataItemName", old, dataItemName);
        FwkChangeRegistry.register((Object)this, (String)"XDataItemName");
        column = this.getXColumn();
        if (column != null) {
            column.addDataItemChangeListener((DataItemChangeListener)this);
        }
    }

    public void setYDataItemName(String dataItemName) {
        FwkColumnAccessInterface column = this.getYColumn();
        if (column != null) {
            column.removeDataItemChangeListener((DataItemChangeListener)this);
        }
        String old = ((P2DChannelModelInterface)this.model).getYDataItemName(this);
        ((P2DChannelModelInterface)this.model).setYDataItemName(this, dataItemName);
        this.firePropertyChange("YDataItemName", old, dataItemName);
        FwkChangeRegistry.register((Object)this, (String)"YDataItemName");
        column = this.getYColumn();
        if (column != null) {
            column.addDataItemChangeListener((DataItemChangeListener)this);
        }
    }

    public void dataItemRevoked(InfoBusItemRevokedEvent event) {
        ((P2DChannelModelInterface)this.model).dataItemRevoked(event);
    }

    public void dataItemAvailable(InfoBusItemAvailableEvent ev) {
        ((P2DChannelModelInterface)this.model).dataItemAvailable(ev);
    }

    public boolean isAssignable(DataFlavor[] flavors) {
        return ((P2DChannelModelInterface)this.model).isAssignable(flavors);
    }

    public DataFlavor getDataFlavor(int index) throws FwkException {
        return ((P2DChannelModelInterface)this.model).getDataFlavor(index);
    }

    public DataFlavor[] getDataFlavors() throws FwkException {
        return ((P2DChannelModelInterface)this.model).getDataFlavors();
    }

    public void addMimeType(String type) {
        ((P2DChannelModelInterface)this.model).addMimeType(type);
    }

    public void removeMimeType(String type) {
        ((P2DChannelModelInterface)this.model).removeMimeType(type);
    }

    public String[] getMimeTypes() {
        return ((P2DChannelModelInterface)this.model).getMimeTypes();
    }

    public void initializeAxis() {
        ((P2DChannelModelInterface)this.model).initializeAxis(this);
    }

    public FwkColumnAccessInterface getXColumn() {
        return ((P2DChannelModelInterface)this.model).getXColumn(this);
    }

    public FwkColumnAccessInterface getYColumn() {
        return ((P2DChannelModelInterface)this.model).getYColumn(this);
    }

    public void setEnvelopeMeanLineVisible(boolean flag) {
        boolean old = ((P2DChannelModelInterface)this.model).getEnvelopeMeanLineVisible(this);
        ((P2DChannelModelInterface)this.model).setEnvelopeMeanLineVisible(this, flag);
        this.firePropertyChange("EnvelopeMeanLineVisible", old, flag);
        FwkChangeRegistry.register((Object)this, (String)"EnvelopeMeanLineVisible");
    }

    public boolean getEnvelopeMeanLineVisible() {
        return ((P2DChannelModelInterface)this.model).getEnvelopeMeanLineVisible(this);
    }

    public void setEnvelopeMaxLineVisible(boolean flag) {
        boolean old = ((P2DChannelModelInterface)this.model).getEnvelopeMaxLineVisible(this);
        ((P2DChannelModelInterface)this.model).setEnvelopeMaxLineVisible(this, flag);
        this.firePropertyChange("EnvelopeMaxLineVisible", old, flag);
        FwkChangeRegistry.register((Object)this, (String)"EnvelopeMaxLineVisible");
    }

    public boolean getEnvelopeMaxLineVisible() {
        return ((P2DChannelModelInterface)this.model).getEnvelopeMaxLineVisible(this);
    }

    public void setEnvelopeMinLineVisible(boolean flag) {
        boolean old = ((P2DChannelModelInterface)this.model).getEnvelopeMinLineVisible(this);
        ((P2DChannelModelInterface)this.model).setEnvelopeMinLineVisible(this, flag);
        this.firePropertyChange("EnvelopeMinLineVisible", old, flag);
        FwkChangeRegistry.register((Object)this, (String)"EnvelopeMinLineVisible");
    }

    public boolean getEnvelopeMinLineVisible() {
        return ((P2DChannelModelInterface)this.model).getEnvelopeMinLineVisible(this);
    }

    public void setShapeStroke(Stroke stroke) {
        Stroke old = ((P2DChannelModelInterface)this.model).getShapeStroke(this);
        ((P2DChannelModelInterface)this.model).setShapeStroke(this, stroke);
        this.firePropertyChange("ShapeStroke", old, stroke);
        FwkChangeRegistry.register((Object)this, (String)"ShapeStroke");
        this.repaint();
    }

    public Stroke getShapeStroke() {
        return ((P2DChannelModelInterface)this.model).getShapeStroke(this);
    }

    public void dataItemAdded(DataItemAddedEvent event) {
        this.revalidate(true);
        P2DAxisInterface axis = this.getXAxis();
        if (axis != null) {
            axis.revalidate(true);
        }
        if ((axis = this.getYAxis()) != null) {
            axis.revalidate(true);
        }
        this.repaint();
    }

    public void dataItemDeleted(DataItemDeletedEvent event) {
        this.revalidate(true);
        P2DAxisInterface axis = this.getXAxis();
        if (axis != null) {
            axis.revalidate(true);
        }
        if ((axis = this.getYAxis()) != null) {
            axis.revalidate(true);
        }
        this.repaint();
    }

    public void dataItemValueChanged(DataItemValueChangedEvent event) {
        this.revalidate(true);
        P2DAxisInterface axis = this.getXAxis();
        if (axis != null) {
            axis.revalidate(true);
        }
        if ((axis = this.getYAxis()) != null) {
            axis.revalidate(true);
        }
        this.repaint();
    }

    public void rowsetCursorMoved(RowsetCursorMovedEvent event) {
        this.revalidate(true);
        P2DAxisInterface axis = this.getXAxis();
        if (axis != null) {
            axis.revalidate(true);
        }
        if ((axis = this.getYAxis()) != null) {
            axis.revalidate(true);
        }
        this.repaint();
    }

    public void dataItemRevoked(DataItemRevokedEvent event) {
        ((FwkColumnAccessInterface)event.getSource()).removeDataItemChangeListener((DataItemChangeListener)this);
        this.revalidate(true);
        P2DAxisInterface axis = this.getXAxis();
        if (axis != null) {
            axis.revalidate(true);
        }
        if ((axis = this.getYAxis()) != null) {
            axis.revalidate(true);
        }
        this.repaint();
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("The channel component of the p2d package");
        descriptor.setTitleName("P2DChannel.Text.Title");
        descriptor.setName(P2DChannel.class.getName());
        descriptor.setIconKey("Icon.P2DChannel");
        descriptor.setCreationDate("$Date: 2005/02/03 14:51:12 $", null);
        counter = 0;
    }

    public class InfoBusDataConsumer
    extends FwkInfoBusConsumer {
        public InfoBusDataConsumer() {
            super("P2DChannelConsumer[" + counter++ + "]@" + FwkDataBus.BUSNAME, FwkContainer.getMimeType((Class)(class$com$highqsoft$interfaces$fwk$FwkColumnAccessInterface == null ? (class$com$highqsoft$interfaces$fwk$FwkColumnAccessInterface = P2DChannel.class$("com.highqsoft.interfaces.fwk.FwkColumnAccessInterface")) : class$com$highqsoft$interfaces$fwk$FwkColumnAccessInterface)));
        }

        public void dataItemAvailable(InfoBusItemAvailableEvent ev) {
            String name = ev.getDataItemName();
            if (this.isAssignable(ev.getDataFlavors()) && (name.compareTo(P2DChannel.this.getXDataItemName()) == 0 || name.compareTo(P2DChannel.this.getYDataItemName()) == 0)) {
                FwkColumnAccessInterface column = (FwkColumnAccessInterface)ev.requestDataItem((javax.infobus.InfoBusDataConsumer)this, this.getDataFlavors());
                column.addDataItemChangeListener((DataItemChangeListener)P2DChannel.this);
            }
        }

        public void dataItemRevoked(InfoBusItemRevokedEvent ev) {
        }
    }
}

