/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkAliasBus;
import com.highqsoft.fwk.FwkColumnAccess;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataBus;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkSortedArray;
import com.highqsoft.fwk.factory.FwkInfoBusConsumerFactory;
import com.highqsoft.interfaces.fwk.FwkAliasInterface;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkInfoBusConsumerInterface;
import com.highqsoft.interfaces.p2d.P2DAxisInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DChannelInterface;
import com.highqsoft.interfaces.p2d.P2DChannelModelInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DPointInterface;
import com.highqsoft.interfaces.p2d.P2DRange1DInterface;
import com.highqsoft.interfaces.p2d.P2DRange2DInterface;
import com.highqsoft.p2d.P2DBasicStrokeSelectCommand;
import com.highqsoft.p2d.P2DColumnDisplayCommand;
import com.highqsoft.p2d.P2DComponentConsumer;
import com.highqsoft.p2d.P2DComponentModel;
import com.highqsoft.p2d.P2DPoint;
import com.highqsoft.p2d.P2DRange1D;
import com.highqsoft.p2d.P2DRange2D;
import com.highqsoft.p2d.P2DShapeStrokeSelectCommand;
import com.highqsoft.p2d.P2DStrokeWidthSelectCommand;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataConsumer;
import javax.infobus.InfoBusItemAvailableEvent;
import javax.infobus.InfoBusItemRevokedEvent;

public class P2DChannelModel
extends P2DComponentModel
implements P2DChannelModelInterface {
    public static final String version = "$Revision: 1.4 $";
    protected FwkSortedArray mimeTypeList;
    protected String dataItemName;
    protected P2DRange1DInterface xRange;
    protected P2DRange1DInterface yRange;
    protected String xAxisName = null;
    protected String yAxisName = null;
    protected P2DAxisInterface xAxis = null;
    protected P2DAxisInterface yAxis = null;
    protected String xDataItemName = "";
    protected String yDataItemName = "";
    protected boolean envelopeMinLineVisible = true;
    protected boolean envelopeMaxLineVisible = true;
    protected boolean envelopeMeanLineVisible = false;
    protected FwkCommandInterface envMaxToggle = null;
    protected FwkCommandInterface envMeanToggle = null;
    protected FwkCommandInterface envMinToggle = null;
    protected Stroke shapeStroke;
    FwkControllerInterface controller = null;

    protected void finalize() throws Throwable {
        this.unregister();
        super.finalize();
    }

    public void release() {
        if (this.mimeTypeList != null) {
            this.mimeTypeList.clear();
        }
        this.dataItemName = null;
        if (this.xRange != null) {
            this.xRange.release();
        }
        this.xRange = null;
        if (this.yRange != null) {
            this.yRange.release();
        }
        this.yRange = null;
        this.xAxisName = null;
        this.yAxisName = null;
        this.xAxis = null;
        this.yAxis = null;
        this.xDataItemName = null;
        this.yDataItemName = null;
        this.shapeStroke = null;
        this.controller = null;
        this.unregister();
        super.release();
    }

    public void initialize() {
        super.initialize();
        this.frame.setHandle(0, false);
        this.frame.setHandle(1, false);
        this.frame.setHandle(2, false);
        this.frame.setHandle(3, false);
        this.frame.setHandle(4, false);
        this.frame.setHandle(5, false);
        this.frame.setHandle(6, false);
        this.frame.setHandle(7, false);
        this.frame.setHandle(8, false);
        this.mimeTypeList = new FwkSortedArray();
        this.mimeTypeList.add((Comparable)((Object)FwkContainer.getMimeType((Class)FwkColumnAccessInterface.class)));
        this.xDataItemName = "";
        this.yDataItemName = "";
        this.xRange = null;
        this.yRange = null;
        this.shapeStroke = null;
        this.dataItemName = "";
        this.setInfoBusName(FwkDataBus.BUSNAME);
        this.register();
    }

    public FwkControllerInterface getController() {
        return this.controller;
    }

    public void setController(FwkControllerInterface controller) {
        if (this.controller == null || !this.controller.equals(controller)) {
            this.unregister();
            this.controller = controller;
            this.register();
        }
    }

    public void unregister() {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            ib.removeDataConsumer((InfoBusDataConsumer)this);
        }
        FwkInfoBusConsumerFactory.getInstance().unregister((FwkInfoBusConsumerInterface)this);
    }

    public void register() {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            ib.addDataConsumer((InfoBusDataConsumer)this);
        }
        FwkInfoBusConsumerFactory.getInstance().register((FwkInfoBusConsumerInterface)this);
    }

    public boolean isAssignable(DataFlavor[] flavors) {
        boolean ret = false;
        int j = 0;
        int len = flavors.length;
        while (j < len && !ret) {
            ret = this.mimeTypeList.find((Comparable)((Object)flavors[j++].getMimeType())) != -1;
        }
        return ret;
    }

    public DataFlavor getDataFlavor(int index) throws FwkException {
        try {
            return new DataFlavor((String)this.mimeTypeList.get(index));
        }
        catch (ArrayIndexOutOfBoundsException exp) {
            throw new FwkException(-2147461535, "$RCSfile", this.getVersion(), "AH 1999-04-28 13:30", "" + index, null, (Throwable)exp);
        }
        catch (Throwable t) {
            throw new FwkException(-2147461535, "$RCSfile", this.getVersion(), "AH 1999-04-28 13:30", (String)this.mimeTypeList.get(index), null, t);
        }
    }

    public DataFlavor[] getDataFlavors() throws FwkException {
        try {
            DataFlavor[] ret = new DataFlavor[this.mimeTypeList.size()];
            int size = this.mimeTypeList.size();
            for (int i = size - 1; i >= 0; --i) {
                ret[i] = new DataFlavor((String)this.mimeTypeList.get(i));
            }
            return ret;
        }
        catch (Throwable t) {
            throw new FwkException(1073743324, "$RCSfile", this.getVersion(), "AH 1999-04-28 13:41", null, null, t);
        }
    }

    public void addMimeType(String type) {
        this.mimeTypeList.add((Comparable)((Object)type));
    }

    public void removeMimeType(String type) {
        this.mimeTypeList.remove((Object)type);
    }

    public String[] getMimeTypes() {
        String[] ret = new String[this.mimeTypeList.size()];
        System.arraycopy(this.mimeTypeList.toArray(), 0, ret, 0, this.mimeTypeList.size());
        return ret;
    }

    public P2DRange1DInterface getXRange(P2DComponentInterface component) {
        P2DRange1D ret = new P2DRange1D();
        if (this.xRange == null) {
            FwkColumnAccessInterface column;
            if (this.xDataItemName.length() != 0) {
                FwkColumnAccessInterface column2 = (FwkColumnAccessInterface)this.findDataItem(this.xDataItemName);
                if (column2 != null) {
                    this.xRange = new P2DRange1D(column2.getMinimum(), column2.getMaximum(), column2.getMinPositiveValue());
                } else if (this.yDataItemName.length() != 0 && (column2 = (FwkColumnAccessInterface)this.findDataItem(this.yDataItemName)) != null) {
                    this.xRange = new P2DRange1D(0.0, column2.getCount() - 1, 1.0);
                }
            } else if (this.yDataItemName.length() != 0 && (column = (FwkColumnAccessInterface)this.findDataItem(this.yDataItemName)) != null) {
                this.xRange = new P2DRange1D(0.0, column.getCount() - 1, 1.0);
            }
        }
        if (this.xRange != null) {
            ret = new P2DRange1D(this.xRange);
        }
        return ret;
    }

    public P2DRange1DInterface getYRange(P2DComponentInterface component) {
        P2DRange1D ret = new P2DRange1D();
        if (this.yRange == null) {
            FwkColumnAccessInterface column;
            if (this.yDataItemName.length() != 0) {
                FwkColumnAccessInterface column2 = (FwkColumnAccessInterface)this.findDataItem(this.yDataItemName);
                if (column2 != null) {
                    this.yRange = new P2DRange1D(column2.getMinimum(), column2.getMaximum(), column2.getMinPositiveValue());
                } else if (this.xDataItemName.length() != 0 && (column2 = (FwkColumnAccessInterface)this.findDataItem(this.xDataItemName)) != null) {
                    this.yRange = new P2DRange1D(0.0, column2.getCount() - 1, 1.0);
                }
            } else if (this.xDataItemName.length() != 0 && (column = (FwkColumnAccessInterface)this.findDataItem(this.xDataItemName)) != null) {
                this.yRange = new P2DRange1D(0.0, column.getCount() - 1, 1.0);
            }
        }
        if (this.yRange != null) {
            ret = new P2DRange1D(this.yRange);
        }
        return ret;
    }

    public P2DRange2DInterface getRange(P2DComponentInterface component) {
        return new P2DRange2D(this.getXRange(component), this.getYRange(component));
    }

    public long[] getCount(P2DComponentInterface component) {
        FwkColumnAccessInterface column;
        long[] ret = new long[2];
        if (this.xDataItemName.length() != 0 && (column = (FwkColumnAccessInterface)this.findDataItem(this.xDataItemName)) != null) {
            ret[0] = column.getCount();
        }
        if (this.yDataItemName.length() != 0 && (column = (FwkColumnAccessInterface)this.findDataItem(this.yDataItemName)) != null) {
            ret[1] = column.getCount();
        }
        return ret;
    }

    public long getMinCount(P2DComponentInterface component) {
        long[] count = this.getCount(component);
        long ret = 0L;
        if (count[0] != 0L) {
            ret = count[0];
        }
        if (count[1] != 0L) {
            ret = ret != 0L ? Math.min(ret, count[1]) : count[1];
        }
        if (count[2] != 0L) {
            ret = ret != 0L ? Math.min(ret, count[2]) : count[2];
        }
        return ret;
    }

    public long getMaxCount(P2DComponentInterface component) {
        long[] count = this.getCount(component);
        long ret = Math.max(count[0], count[1]);
        return Math.max(ret, count[3]);
    }

    public P2DPointInterface getPointAt(P2DComponentInterface component, int index) {
        P2DPoint ret;
        block16: {
            FwkColumnAccessInterface column;
            block15: {
                ret = new P2DPoint(0, 0, true);
                if (this.xDataItemName.length() != 0) {
                    column = (FwkColumnAccessInterface)this.findDataItem(this.xDataItemName);
                    if (column != null) {
                        try {
                            if (column.getFlagAt(index) == 15) {
                                ret.x = column.getValueAt(index);
                                break block15;
                            }
                            ret.xFlag = false;
                        }
                        catch (Throwable t) {}
                    } else {
                        ret.xFlag = false;
                    }
                }
            }
            if (this.yDataItemName.length() != 0) {
                column = (FwkColumnAccessInterface)this.findDataItem(this.yDataItemName);
                if (column != null) {
                    try {
                        if (column.getFlagAt(index) == 15) {
                            ret.y = column.getValueAt(index);
                            break block16;
                        }
                        ret.yFlag = false;
                    }
                    catch (Throwable t) {}
                } else {
                    ret.yFlag = false;
                }
            }
        }
        if (ret.xFlag || ret.yFlag) {
            if (!ret.xFlag && !ret.yFlag) {
                ret.x = index;
            }
            if (!ret.yFlag) {
                ret.y = index;
            }
        }
        return ret;
    }

    protected void getCoordinates(P2DComponentInterface component, String itemName, P2DPoint[] ret, int offset) {
        block15: {
            int count = ret.length;
            if (itemName.length() != 0) {
                FwkColumnAccessInterface column = (FwkColumnAccessInterface)this.findDataItem(itemName);
                if (column != null) {
                    try {
                        if (FwkColumnAccess.CONSIDER_FLAGS) {
                            if (column.getFlagAt(0) == 15) {
                                ret[0].x = offset;
                                ret[0].y = column.getValueAt(0);
                            } else {
                                ret[0].xFlag = false;
                            }
                            int size = count / 2;
                            for (int i = 1; i < size; ++i) {
                                int index = i * 2;
                                if (column.getFlagAt(i) == 15) {
                                    ret[index].x = offset;
                                    ret[index].y = column.getValueAt(i);
                                } else {
                                    ret[index].xFlag = false;
                                }
                                ret[index - 1] = new P2DPoint(ret[index]);
                            }
                            if (column.getFlagAt(count / 2 - 1) == 15) {
                                ret[count - 1].x = offset;
                                ret[count - 1].y = column.getValueAt(count / 2 - 1);
                            } else {
                                ret[count - 1].xFlag = false;
                            }
                            break block15;
                        }
                        ret[0].x = offset;
                        ret[0].y = column.getValueAt(0);
                        int size = count / 2;
                        for (int i = 1; i < size; ++i) {
                            int index = i * 2;
                            ret[index].x = offset;
                            ret[index].y = column.getValueAt(i);
                            ret[index - 1] = new P2DPoint(ret[index]);
                        }
                        ret[count - 1].x = offset;
                        ret[count - 1].y = column.getValueAt(count / 2 - 1);
                    }
                    catch (Throwable t) {}
                } else {
                    for (int i = 0; i < count; ++i) {
                        ret[i].xFlag = false;
                    }
                }
            }
        }
    }

    public void setXAxisName(P2DComponentInterface component, String axisName) {
        P2DAxisInterface newXAxis;
        P2DAxisInterface oldXAxis = this.xAxis;
        this.xAxisName = axisName;
        this.xAxis = newXAxis = (P2DAxisInterface)P2DComponentConsumer.getInstanceByName(component.getInfoBusName()).findComponent(axisName, FwkContainer.getDataFlavors((Class)P2DAxisInterface.class));
        if (oldXAxis != null) {
            oldXAxis.removeChannel((P2DChannelInterface)component);
        }
        if (newXAxis != null) {
            newXAxis.addChannel((P2DChannelInterface)component);
        }
        this.firePropertyChange("XAxisName", oldXAxis, newXAxis);
    }

    public String getXAxisName(P2DComponentInterface component) {
        if (this.xAxis == null) {
            this.getXAxis(component);
        }
        if (this.xAxis != null) {
            return this.xAxis.getName();
        }
        return null;
    }

    public P2DAxisInterface getXAxis(P2DComponentInterface component) {
        if (this.xAxis == null && this.xAxisName != null) {
            this.xAxis = (P2DAxisInterface)P2DComponentConsumer.getInstanceByName(component.getInfoBusName()).findComponent(this.xAxisName, FwkContainer.getDataFlavors((Class)P2DAxisInterface.class));
            if (this.xAxis != null) {
                this.xAxis.addChannel((P2DChannelInterface)component);
            }
        }
        return this.xAxis;
    }

    public void setYAxisName(P2DComponentInterface component, String axisName) {
        P2DAxisInterface newYAxis;
        P2DAxisInterface oldYAxis = this.yAxis;
        this.yAxisName = axisName;
        P2DComponentConsumer consumer = P2DComponentConsumer.getInstanceByName(component.getInfoBusName());
        this.yAxis = newYAxis = (P2DAxisInterface)consumer.findComponent(axisName, FwkContainer.getDataFlavor((Class)P2DAxisInterface.class));
        if (oldYAxis != null) {
            oldYAxis.removeChannel((P2DChannelInterface)component);
        }
        if (newYAxis != null) {
            newYAxis.addChannel((P2DChannelInterface)component);
        }
        if (oldYAxis != newYAxis) {
            this.firePropertyChange("YAxisName", oldYAxis, newYAxis);
        }
    }

    public String getYAxisName(P2DComponentInterface component) {
        if (this.yAxis != null) {
            return this.yAxis.getName();
        }
        return null;
    }

    public P2DAxisInterface getYAxis(P2DComponentInterface component) {
        if (this.yAxis == null && this.yAxisName != null) {
            this.yAxis = (P2DAxisInterface)P2DComponentConsumer.getInstanceByName(component.getInfoBusName()).findComponent(this.yAxisName, FwkContainer.getDataFlavors((Class)P2DAxisInterface.class));
            if (this.yAxis != null) {
                this.yAxis.addChannel((P2DChannelInterface)component);
            }
        }
        return this.yAxis;
    }

    public synchronized void dataItemRevoked(InfoBusItemRevokedEvent event) {
    }

    public synchronized void dataItemAvailable(InfoBusItemAvailableEvent ev) {
    }

    public Object findDataItem(String dataItemName) {
        return this.findDataItem(dataItemName, this.getDataFlavors());
    }

    public Object findDataItem(String dataItemName, DataFlavor[] flavors) {
        Object ret = null;
        InfoBus ib = null;
        FwkAliasInterface alias = FwkAliasBus.unalias((String)dataItemName, (DataFlavor[])flavors);
        if (alias != null) {
            ib = InfoBus.get((String)alias.getSourceBusName());
            if (ib != null) {
                ret = ib.findDataItem(alias.unalias(), flavors, (InfoBusDataConsumer)this);
            }
        } else {
            ib = InfoBus.get((String)this.getInfoBusName());
            if (ib != null) {
                ret = ib.findDataItem(dataItemName, flavors, (InfoBusDataConsumer)this);
            }
        }
        return ret;
    }

    public Object[] findMultipleDataItems(String dataItemName) {
        return this.findMultipleDataItems(dataItemName, this.getDataFlavors());
    }

    public Object[] findMultipleDataItems(String dataItemName, DataFlavor[] flavors) {
        Object[] ret = new Object[]{};
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            ret = ib.findMultipleDataItems(dataItemName, flavors, (InfoBusDataConsumer)this);
        }
        return ret;
    }

    public void setXDataItemName(P2DComponentInterface component, String dataItemName) {
        if (dataItemName == null) {
            dataItemName = "";
        }
        if (this.xDataItemName.compareTo(dataItemName) != 0) {
            String oldName = this.xDataItemName;
            this.xDataItemName = dataItemName;
            this.firePropertyChange("XDataItemName", oldName, dataItemName);
        }
        this.xRange = null;
    }

    public String getXDataItemName(P2DComponentInterface component) {
        return this.xDataItemName;
    }

    public void setYDataItemName(P2DComponentInterface component, String dataItemName) {
        if (dataItemName == null) {
            dataItemName = "";
        }
        if (this.yDataItemName.compareTo(dataItemName) != 0) {
            String oldName = this.yDataItemName;
            this.yDataItemName = dataItemName;
            this.firePropertyChange("YDataItemName", oldName, dataItemName);
        }
        this.yRange = null;
    }

    public String getYDataItemName(P2DComponentInterface component) {
        return this.yDataItemName;
    }

    public void initializeAxis(P2DComponentInterface component) {
        this.getXAxis(component);
        this.getYAxis(component);
    }

    public void propertyChange(PropertyChangeEvent ev) {
    }

    public FwkCommandInterface[] getCommands(P2DComponentInterface component) {
        if (!this.commandsAvailable()) {
            super.getCommands(component);
            FwkCommandInterface parent = this.getCommand("Help");
            if (parent == null) {
                parent = new FwkCommand();
                parent.setCommandName("Help");
                parent.setTextKey("P2D.Text.Help");
                this.addCommand(parent);
            }
            Object cb = new FwkCommand((FwkControllerInterface)component);
            cb.setCommandName("ChannelHelp");
            cb.setTextKey("P2D.Text.ChannelHelp");
            cb.setIconKey("Icon.FwkHelpBroker");
            cb.setHelpID("com.highqsoft.p2d.P2DChannel");
            parent.addCommand((FwkCommandInterface)cb);
            parent = new FwkCommand((FwkControllerInterface)component);
            parent.setTextKey("P2D.Text.ShapeStroke");
            parent.setCommandName("ShapeStrokeMenu");
            component.addCommand(0, parent);
            cb = new P2DShapeStrokeSelectCommand((FwkControllerInterface)component);
            parent.addCommand((FwkCommandInterface)cb);
            parent = new FwkCommand((FwkControllerInterface)component);
            parent.setTextKey("P2D.Text.BasicStroke");
            parent.setCommandName("BasicStrokeMenu");
            component.addCommand(0, parent);
            cb = new P2DBasicStrokeSelectCommand((FwkControllerInterface)component);
            parent.addCommand((FwkCommandInterface)cb);
            parent = new FwkCommand((FwkControllerInterface)component);
            parent.setTextKey("P2D.Text.StrokeWidth");
            parent.setCommandName("StrokeWidthMenu");
            component.addCommand(0, parent);
            cb = new P2DStrokeWidthSelectCommand((FwkControllerInterface)component);
            parent.addCommand((FwkCommandInterface)cb);
            cb = new P2DColumnDisplayCommand((FwkControllerInterface)component);
            component.addCommand((FwkCommandInterface)cb);
        }
        return super.getCommands();
    }

    public String getShortName(P2DComponentInterface component) {
        String ret = "";
        FwkColumnAccessInterface column = (FwkColumnAccessInterface)this.findDataItem(this.yDataItemName);
        if (column == null) {
            column = (FwkColumnAccessInterface)this.findDataItem(this.xDataItemName);
        }
        if (column != null) {
            ret = column.getColumnName();
            if (ret == null || ret.length() == 0) {
                ret = column.getShortName();
            }
        } else {
            ret = super.getShortName(component);
        }
        return ret;
    }

    public FwkColumnAccessInterface getXColumn(P2DComponentInterface component) {
        return (FwkColumnAccessInterface)this.findDataItem(this.xDataItemName);
    }

    public FwkColumnAccessInterface getYColumn(P2DComponentInterface component) {
        return (FwkColumnAccessInterface)this.findDataItem(this.yDataItemName);
    }

    public void setEnvelopeMeanLineVisible(P2DComponentInterface component, boolean flag) {
        this.envelopeMeanLineVisible = flag;
        if (this.envMeanToggle != null) {
            this.envMeanToggle.setToggleState(flag);
        }
        component.repaint();
    }

    public boolean getEnvelopeMeanLineVisible(P2DComponentInterface component) {
        return this.envelopeMeanLineVisible;
    }

    public void setEnvelopeMaxLineVisible(P2DComponentInterface component, boolean flag) {
        this.envelopeMaxLineVisible = flag;
        if (this.envMaxToggle != null) {
            this.envMaxToggle.setToggleState(flag);
        }
        component.repaint();
    }

    public boolean getEnvelopeMaxLineVisible(P2DComponentInterface component) {
        return this.envelopeMaxLineVisible;
    }

    public void setEnvelopeMinLineVisible(P2DComponentInterface component, boolean flag) {
        this.envelopeMinLineVisible = flag;
        if (this.envMinToggle != null) {
            this.envMinToggle.setToggleState(flag);
        }
        component.repaint();
    }

    public boolean getEnvelopeMinLineVisible(P2DComponentInterface component) {
        return this.envelopeMinLineVisible;
    }

    public void revalidate(P2DComponentInterface component, boolean recursive) {
        this.xRange = null;
        this.yRange = null;
    }

    public void setShapeStroke(P2DComponentInterface component, Stroke stroke) {
        this.shapeStroke = stroke;
        component.repaint();
    }

    public Stroke getShapeStroke(P2DComponentInterface component) {
        return this.shapeStroke;
    }

    public void setBoundingBox(P2DComponentInterface component, P2DBoundingBoxInterface boundingBox) {
        if (!this.boundingBox.equals(boundingBox)) {
            super.setBoundingBox(component, boundingBox);
            component.revalidate(true);
        }
    }
}

