/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.p2d.P2DAxisInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DChannelInterface;
import com.highqsoft.interfaces.p2d.P2DChannelModelInterface;
import com.highqsoft.interfaces.p2d.P2DChannelViewInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DRange1DInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DComponentView;
import com.highqsoft.p2d.P2DRange1D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class P2DChannelView
extends P2DComponentView
implements P2DChannelViewInterface {
    public static final String version = "$Revision: 1.4 $";
    public static final double log10 = Math.log(10.0);
    protected float meanFilterFactor = 5.0f;
    protected HashMap containerMap = new HashMap();
    protected Point2D.Double sourcePoint = new Point2D.Double();
    protected Point2D.Double destPoint = new Point2D.Double();

    public void release() {
        if (this.containerMap != null) {
            Iterator it = this.containerMap.keySet().iterator();
            while (it.hasNext()) {
                RegisterCard card = (RegisterCard)this.containerMap.get(it.next());
                if (card == null) continue;
                card.shape = null;
                card.meanShape = null;
            }
            this.containerMap.clear();
        }
        this.containerMap = null;
        this.sourcePoint = null;
        this.destPoint = null;
        super.release();
    }

    public void paint(P2DComponentInterface component, P2DContainerInterface container, Graphics2D g2) {
        P2DAxisInterface xAxis = ((P2DChannelInterface)component).getXAxis();
        P2DAxisInterface yAxis = ((P2DChannelInterface)component).getYAxis();
        if (xAxis != null && yAxis != null) {
            component.setBoundingBox(P2D.getAxisBoundingBox(xAxis, yAxis));
            super.paint(component, container, g2);
        }
    }

    public void draw(P2DComponentInterface component, P2DContainerInterface container, Graphics2D g2) {
        Graphics2D g = (Graphics2D)g2.create();
        RegisterCard card = this.getCard(component, container);
        if (card == null) {
            card = new RegisterCard();
            this.containerMap.put(container, card);
        }
        P2DAxisInterface xAxis = ((P2DChannelInterface)component).getXAxis();
        P2DAxisInterface yAxis = ((P2DChannelInterface)component).getYAxis();
        if (xAxis != null && yAxis != null) {
            AffineTransform at = P2D.getAxisTransformation(xAxis, yAxis, component.getBoundingBox());
            boolean xLog = xAxis.getLog();
            boolean yLog = yAxis.getLog();
            P2DRange1DInterface xRange = xAxis.getRange();
            P2DRange1DInterface yRange = yAxis.getRange();
            P2DRange1D xScaleRange = new P2DRange1D(xRange);
            P2DRange1D yScaleRange = new P2DRange1D(yRange);
            if (xLog) {
                if (xScaleRange.getLower() > 0.0 && xScaleRange.getUpper() > 0.0) {
                    xScaleRange.setLower(Math.log(xScaleRange.getLower()) / P2D.log10);
                    xScaleRange.setUpper(Math.log(xScaleRange.getUpper()) / P2D.log10);
                } else if (xScaleRange.getLower() <= 0.0 && xScaleRange.getUpper() > 0.0 && !Double.isNaN(xScaleRange.getMinPositiveValue())) {
                    xScaleRange.setLower(Math.log(xScaleRange.getMinPositiveValue()) / P2D.log10);
                    xScaleRange.setUpper(Math.log(xScaleRange.getUpper()) / P2D.log10);
                } else {
                    xScaleRange.setLower(0.0);
                    xScaleRange.setUpper(1.0);
                }
            }
            if (yLog) {
                if (yScaleRange.getLower() > 0.0 && yScaleRange.getUpper() > 0.0) {
                    yScaleRange.setLower(Math.log(yScaleRange.getLower()) / P2D.log10);
                    yScaleRange.setUpper(Math.log(yScaleRange.getUpper()) / P2D.log10);
                } else if (yScaleRange.getLower() <= 0.0 && yScaleRange.getUpper() > 0.0 && !Double.isNaN(yScaleRange.getMinPositiveValue())) {
                    yScaleRange.setLower(Math.log(yScaleRange.getMinPositiveValue()) / P2D.log10);
                    yScaleRange.setUpper(Math.log(yScaleRange.getUpper()) / P2D.log10);
                } else {
                    yScaleRange.setLower(0.0);
                    yScaleRange.setUpper(1.0);
                }
            }
            Graphics2D gridG = (Graphics2D)g.create();
            gridG.transform(at);
            xAxis.drawGrid(gridG, yScaleRange);
            gridG.dispose();
            gridG = (Graphics2D)g.create();
            gridG.transform(at);
            yAxis.drawGrid(gridG, xScaleRange);
            gridG.dispose();
            P2DBoundingBoxInterface bounds = component.getBoundingBox();
            double width = bounds.getWidth();
            double height = bounds.getHeight();
            Point2D.Double ptSrc = new Point2D.Double(width, height);
            Point2D visiblePoints = new Point2D.Double();
            visiblePoints = g.getTransform().deltaTransform(ptSrc, visiblePoints);
            if (!this.isValid(component, container)) {
                BasicStroke scaledStroke = component.scaleStroke(g.getTransform());
                if (scaledStroke != null) {
                    g.setStroke(scaledStroke);
                }
                FwkColumnAccessInterface xColumn = null;
                FwkColumnAccessInterface yColumn = null;
                String xItem = ((P2DChannelInterface)component).getXDataItemName();
                String yItem = ((P2DChannelInterface)component).getYDataItemName();
                int xLen = 0;
                int yLen = 0;
                if (xItem.length() != 0 && (xColumn = ((P2DChannelInterface)component).getXColumn()) != null) {
                    xLen = xColumn.getCount();
                }
                if (yItem.length() != 0 && (yColumn = ((P2DChannelInterface)component).getYColumn()) != null) {
                    yLen = yColumn.getCount();
                }
                boolean penUp = true;
                if (xColumn != null && yColumn != null) {
                    P2DRange1D indRange = new P2DRange1D(0.0, (double)(xLen - 1));
                    double xTolerance = 0.05 * Math.abs(xColumn.getValueAt(xLen - 1) - xColumn.getValueAt(0));
                    if (Math.abs(xRange.getLower() - xColumn.getValueAt(0)) > xTolerance || Math.abs(xRange.getUpper() - xColumn.getValueAt(xLen - 1)) > xTolerance) {
                        int xStart = xLen / 2;
                        int xLower = 0;
                        int xUpper = xLen;
                        while (xStart != xLower && xStart != xUpper && !xRange.contains(xColumn.getValueAt(xStart))) {
                            if (xRange.getLower() < xColumn.getValueAt(xStart)) {
                                xUpper = xStart;
                                xStart = (xStart + xLower) / 2;
                                continue;
                            }
                            xLower = xStart;
                            xStart = (xUpper + xStart) / 2;
                        }
                        if (xStart != xLower && xStart != xUpper) {
                            for (xLower = xStart; xLower >= 0 && xRange.contains(xColumn.getValueAt(xLower)); --xLower) {
                                indRange.setLower(xLower);
                            }
                            for (xUpper = xStart; xUpper < xLen && xRange.contains(xColumn.getValueAt(xUpper)); ++xUpper) {
                                indRange.setUpper(xUpper);
                            }
                        }
                    }
                    xLen = (int)(indRange.getDistance() + 1.0);
                    int i = (int)indRange.getLower();
                    int stepSize = (int)((double)xLen / visiblePoints.getX());
                    if (stepSize < 1) {
                        stepSize = 1;
                    }
                    int meanStepSize = stepSize;
                    if (this.meanFilterFactor >= 2.0f) {
                        meanStepSize = (int)((float)stepSize * this.meanFilterFactor);
                    }
                    int xLimit = (int)indRange.getUpper() + 1;
                    if (stepSize > 1) {
                        Dot dot;
                        card.shape = null;
                        Vector minVector = new Vector();
                        Vector maxVector = new Vector();
                        card.meanShape = new GeneralPath();
                        boolean minPenUp = true;
                        boolean maxPenUp = true;
                        boolean meanPenUp = true;
                        double maxYVal = -1.7976931348623157E308;
                        double minYVal = Double.MAX_VALUE;
                        double meanX = 0.0;
                        double meanY = 0.0;
                        double iMean = 0.0;
                        int stepCount = 0;
                        int meanStepCount = 0;
                        int meanCount = 0;
                        int iMeanCount = 0;
                        boolean validStep = false;
                        boolean validMeanStep = false;
                        while (i < yLen && i < xLimit) {
                            if (xColumn.getFlagAt(i) == 15 && yColumn.getFlagAt(i) == 15) {
                                double xVal = xColumn.getValueAt(i);
                                double yVal = yColumn.getValueAt(i);
                                if (!validStep) {
                                    minYVal = maxYVal = yVal;
                                    iMean = xVal;
                                } else {
                                    minYVal = Math.min(minYVal, yVal);
                                    maxYVal = Math.max(maxYVal, yVal);
                                    iMean += xVal;
                                }
                                if (!validMeanStep) {
                                    meanY = yVal;
                                    meanX = xVal;
                                } else {
                                    meanY += yVal;
                                    meanX += xVal;
                                }
                                ++iMeanCount;
                                ++meanCount;
                                validStep = true;
                                validMeanStep = true;
                            }
                            ++meanStepCount;
                            ++i;
                            if (++stepCount == stepSize) {
                                if (validStep) {
                                    minPenUp = this.setPoint(iMean / (double)iMeanCount, xScaleRange, xLog, minYVal, yScaleRange, yLog, minVector, minPenUp);
                                    maxPenUp = this.setPoint(iMean / (double)iMeanCount, xScaleRange, xLog, maxYVal, yScaleRange, yLog, maxVector, maxPenUp);
                                }
                                validStep = false;
                                stepCount = 0;
                                iMeanCount = 0;
                            }
                            if (meanStepCount != meanStepSize) continue;
                            if (validMeanStep) {
                                meanPenUp = this.setShapePoint(meanX / (double)meanCount, xScaleRange, xLog, meanY / (double)meanCount, yScaleRange, yLog, card.meanShape, meanPenUp);
                            }
                            validMeanStep = false;
                            meanStepCount = 0;
                            meanCount = 0;
                        }
                        int vSize = minVector.size();
                        card.shape = new GeneralPath();
                        if (vSize > 0) {
                            dot = (Dot)minVector.get(0);
                            card.shape.moveTo(dot.x, dot.y);
                        }
                        for (i = 1; i < vSize; ++i) {
                            dot = (Dot)minVector.get(i);
                            card.shape.lineTo(dot.x, dot.y);
                        }
                        for (i = maxVector.size() - 1; i >= 0; --i) {
                            dot = (Dot)maxVector.get(i);
                            card.shape.lineTo(dot.x, dot.y);
                        }
                        try {
                            card.shape.closePath();
                            card.shape.transform(at);
                        }
                        catch (Throwable t) {
                            card.shape = null;
                        }
                        minVector.clear();
                        maxVector.clear();
                        minVector = null;
                        maxVector = null;
                        card.meanShape.transform(at);
                    } else {
                        card.shape = new GeneralPath();
                        while (i < xLimit && i < yLen) {
                            if (xColumn.getFlagAt(i) == 15 && yColumn.getFlagAt(i) == 15) {
                                penUp = this.setShapePoint(xColumn.getValueAt(i), xScaleRange, xLog, yColumn.getValueAt(i), yScaleRange, yLog, card.shape, penUp);
                            }
                            ++i;
                        }
                        card.shape.transform(at);
                    }
                } else if (yColumn != null) {
                    int i;
                    int stepSize = (int)(xRange.getDistance() / visiblePoints.getX());
                    if (stepSize < 1) {
                        stepSize = 1;
                    }
                    int meanStepSize = stepSize;
                    if (this.meanFilterFactor >= 2.0f) {
                        meanStepSize = (int)((float)stepSize * this.meanFilterFactor);
                    }
                    if ((i = (int)xRange.getLower()) < 0) {
                        i = 0;
                    }
                    if ((yLen = (int)xRange.getUpper() + 1) > yColumn.getCount()) {
                        yLen = yColumn.getCount();
                    }
                    if (stepSize > 1) {
                        Dot dot;
                        card.shape = null;
                        Vector minVector = new Vector();
                        Vector maxVector = new Vector();
                        card.meanShape = new GeneralPath();
                        boolean minPenUp = true;
                        boolean maxPenUp = true;
                        boolean meanPenUp = true;
                        int stepCount = 0;
                        int meanStepCount = 0;
                        int meanCount = 0;
                        boolean validStep = false;
                        boolean validMeanStep = false;
                        double maxVal = -1.7976931348623157E308;
                        double minVal = Double.MAX_VALUE;
                        double meanY = 0.0;
                        while (i < yLen) {
                            if (yColumn.getFlagAt(i) == 15) {
                                double val = yColumn.getValueAt(i);
                                if (!validStep) {
                                    minVal = maxVal = val;
                                } else {
                                    minVal = Math.min(minVal, val);
                                    maxVal = Math.max(maxVal, val);
                                }
                                meanY = !validMeanStep ? val : (meanY += val);
                                validStep = true;
                                validMeanStep = true;
                                ++meanCount;
                            }
                            ++meanStepCount;
                            ++i;
                            if (++stepCount == stepSize) {
                                if (validStep) {
                                    minPenUp = this.setPoint(i, xScaleRange, xLog, minVal, yScaleRange, yLog, minVector, minPenUp);
                                    maxPenUp = this.setPoint(i, xScaleRange, xLog, maxVal, yScaleRange, yLog, maxVector, maxPenUp);
                                }
                                validStep = false;
                                stepCount = 0;
                            }
                            if (meanStepCount != meanStepSize) continue;
                            if (validMeanStep) {
                                meanPenUp = this.setShapePoint(i, xScaleRange, xLog, meanY / (double)meanCount, yScaleRange, yLog, card.meanShape, meanPenUp);
                            }
                            validMeanStep = false;
                            meanStepCount = 0;
                            meanCount = 0;
                        }
                        int vSize = minVector.size();
                        card.shape = new GeneralPath();
                        if (vSize > 0) {
                            dot = (Dot)minVector.get(0);
                            card.shape.moveTo(dot.x, dot.y);
                        }
                        for (i = 1; i < vSize; ++i) {
                            dot = (Dot)minVector.get(i);
                            card.shape.lineTo(dot.x, dot.y);
                        }
                        for (i = maxVector.size() - 1; i >= 0; --i) {
                            dot = (Dot)maxVector.get(i);
                            card.shape.lineTo(dot.x, dot.y);
                        }
                        if (card.shape.getCurrentPoint() != null) {
                            try {
                                card.shape.closePath();
                                card.shape.transform(at);
                            }
                            catch (Throwable t) {
                                card.shape = null;
                            }
                            card.meanShape.transform(at);
                        }
                        minVector.clear();
                        maxVector.clear();
                        minVector = null;
                        maxVector = null;
                    } else {
                        card.shape = new GeneralPath();
                        while (i < yLen) {
                            if (yColumn.getFlagAt(i) == 15) {
                                penUp = this.setShapePoint(i, xScaleRange, xLog, yColumn.getValueAt(i), yScaleRange, yLog, card.shape, penUp);
                            }
                            ++i;
                        }
                        card.shape.transform(at);
                    }
                } else if (xColumn != null) {
                    int i;
                    int stepSize = (int)(yRange.getDistance() / visiblePoints.getX());
                    if (stepSize < 1) {
                        stepSize = 1;
                    }
                    int meanStepSize = stepSize;
                    if (this.meanFilterFactor >= 2.0f) {
                        meanStepSize = (int)((float)stepSize * this.meanFilterFactor);
                    }
                    if ((i = (int)yRange.getLower()) < 0) {
                        i = 0;
                    }
                    if ((xLen = (int)yRange.getUpper() + 1) > xColumn.getCount()) {
                        xLen = xColumn.getCount();
                    }
                    if (stepSize > 1) {
                        Dot dot;
                        card.shape = null;
                        Vector minVector = new Vector();
                        Vector maxVector = new Vector();
                        card.meanShape = new GeneralPath();
                        boolean minPenUp = true;
                        boolean maxPenUp = true;
                        boolean meanPenUp = true;
                        double maxVal = -1.7976931348623157E308;
                        double minVal = Double.MAX_VALUE;
                        double mean = 0.0;
                        int stepCount = 0;
                        int meanStepCount = 0;
                        int meanCount = 0;
                        boolean validStep = false;
                        boolean validMeanStep = false;
                        while (i < xLen) {
                            if (xColumn.getFlagAt(i) == 15) {
                                double val = xColumn.getValueAt(i);
                                if (!validStep) {
                                    minVal = maxVal = val;
                                } else {
                                    minVal = Math.min(minVal, val);
                                    maxVal = Math.max(maxVal, val);
                                }
                                mean = !validMeanStep ? val : (mean += val);
                                validStep = true;
                                validMeanStep = true;
                                ++meanCount;
                            }
                            ++meanStepCount;
                            ++i;
                            if (++stepCount == stepSize) {
                                if (validStep) {
                                    minPenUp = this.setPoint(minVal, xScaleRange, xLog, i, yScaleRange, yLog, minVector, minPenUp);
                                    maxPenUp = this.setPoint(maxVal, xScaleRange, xLog, i, yScaleRange, yLog, maxVector, maxPenUp);
                                }
                                stepCount = 0;
                                validStep = false;
                            }
                            if (meanStepCount != meanStepSize) continue;
                            if (validMeanStep) {
                                meanPenUp = this.setShapePoint(mean / (double)meanCount, xScaleRange, xLog, i, yScaleRange, yLog, card.meanShape, meanPenUp);
                            }
                            validMeanStep = false;
                            meanStepCount = 0;
                            meanCount = 0;
                        }
                        int vSize = minVector.size();
                        card.shape = new GeneralPath();
                        if (vSize > 0) {
                            dot = (Dot)minVector.get(0);
                            card.shape.moveTo(dot.x, dot.y);
                        }
                        for (i = 1; i < vSize; ++i) {
                            dot = (Dot)minVector.get(i);
                            card.shape.lineTo(dot.x, dot.y);
                        }
                        for (i = maxVector.size() - 1; i >= 0; --i) {
                            dot = (Dot)maxVector.get(i);
                            card.shape.lineTo(dot.x, dot.y);
                        }
                        try {
                            card.shape.closePath();
                            card.shape.transform(at);
                        }
                        catch (Throwable t) {
                            card.shape = null;
                        }
                        card.meanShape.transform(at);
                        minVector.clear();
                        maxVector.clear();
                        minVector = null;
                        maxVector = null;
                    } else {
                        card.shape = new GeneralPath();
                        while (i < xLen) {
                            if (xColumn.getFlagAt(i) == 15) {
                                penUp = this.setShapePoint(xColumn.getValueAt(i), xScaleRange, xLog, i, yScaleRange, yLog, card.shape, penUp);
                            }
                            ++i;
                        }
                        card.shape.transform(at);
                    }
                } else {
                    card.shape = null;
                }
            }
        }
        if (this.isValid(component, container)) {
            P2DChannelModelInterface model = (P2DChannelModelInterface)component.getModel();
            Stroke lineStroke = component.getStroke();
            if (card.shape != null) {
                Stroke stroke;
                if (card.meanShape != null) {
                    g.fill(card.shape);
                }
                if (lineStroke != null) {
                    g.draw(card.shape);
                }
                if ((stroke = model.getShapeStroke(component)) != null) {
                    g.setStroke(stroke);
                    g.draw(card.shape);
                }
            }
            if (lineStroke != null) {
                Color meanColor = component.getColor();
                if (card.meanShape != null && model.getEnvelopeMeanLineVisible(component)) {
                    g.setColor(meanColor);
                    g.draw(card.meanShape);
                }
            }
        }
        g.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setPoint(double x, P2DRange1DInterface xRange, boolean xLog, double y, P2DRange1DInterface yRange, boolean yLog, Vector vector, boolean penUp) {
        Point2D.Double double_ = this.sourcePoint;
        synchronized (double_) {
            if (xLog && !Double.isNaN(x)) {
                x = x <= 0.0 ? Double.NaN : Math.log(x) / log10;
            }
            if (yLog && !Double.isNaN(y)) {
                y = y <= 0.0 ? Double.NaN : Math.log(y) / log10;
            }
            if (!Double.isNaN(x) && !Double.isNaN(y)) {
                if (xRange.contains(x) && yRange.contains(y)) {
                    if (penUp) {
                        if (vector.size() == 0) {
                            vector.add(new Dot((float)x, (float)y, 0));
                        } else {
                            vector.add(new Dot((float)x, (float)y, 1));
                        }
                    } else {
                        vector.add(new Dot((float)x, (float)y, 1));
                    }
                    return false;
                }
                if (x < xRange.getLower()) {
                    x = xRange.getLower();
                }
                if (x > xRange.getUpper()) {
                    x = xRange.getUpper();
                }
                if (y < yRange.getLower()) {
                    y = yRange.getLower();
                }
                if (y > yRange.getUpper()) {
                    y = yRange.getUpper();
                }
                if (!penUp) {
                    vector.add(new Dot((float)x, (float)y, 1));
                } else {
                    vector.add(new Dot((float)x, (float)y, 0));
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setShapePoint(double x, P2DRange1DInterface xRange, boolean xLog, double y, P2DRange1DInterface yRange, boolean yLog, GeneralPath shape, boolean penUp) {
        Point2D.Double double_ = this.sourcePoint;
        synchronized (double_) {
            if (xLog) {
                x = Math.log(x) / log10;
            }
            if (yLog) {
                y = Math.log(y) / log10;
            }
            if (!Double.isNaN(x) && !Double.isNaN(y)) {
                if (xRange.contains(x) && yRange.contains(y)) {
                    if (penUp) {
                        if (shape.getCurrentPoint() == null) {
                            shape.moveTo((float)x, (float)y);
                        } else {
                            shape.lineTo((float)x, (float)y);
                        }
                    } else {
                        shape.lineTo((float)x, (float)y);
                    }
                    return false;
                }
                if (x < xRange.getLower()) {
                    x = xRange.getLower();
                }
                if (x > xRange.getUpper()) {
                    x = xRange.getUpper();
                }
                if (y < yRange.getLower()) {
                    y = yRange.getLower();
                }
                if (y > yRange.getUpper()) {
                    y = yRange.getUpper();
                }
                if (!penUp) {
                    shape.lineTo((float)x, (float)y);
                } else {
                    shape.moveTo((float)x, (float)y);
                }
            }
            return true;
        }
    }

    public void revalidate(P2DComponentInterface component, boolean recursive) {
        if (this.containerMap != null) {
            Iterator it = this.containerMap.keySet().iterator();
            while (it.hasNext()) {
                RegisterCard card = (RegisterCard)this.containerMap.get(it.next());
                if (card == null) continue;
                card.shape = null;
                card.meanShape = null;
            }
        }
    }

    protected boolean isValid(P2DComponentInterface component, P2DContainerInterface container) {
        RegisterCard card;
        boolean ret = false;
        if (this.containerMap != null && (card = (RegisterCard)this.containerMap.get(container)) != null) {
            ret = card.shape != null;
        }
        return ret;
    }

    protected boolean isValidCard(P2DComponentInterface component, RegisterCard card) {
        boolean ret = false;
        if (card != null) {
            ret = card.shape != null;
        }
        return ret;
    }

    public RegisterCard getCard(P2DComponentInterface component, P2DContainerInterface container) {
        if (container != null && this.containerMap != null) {
            return (RegisterCard)this.containerMap.get(container);
        }
        return null;
    }

    public class Dot {
        public float x;
        public float y;
        public int function;

        public Dot(float x, float y, int function) {
            this.x = x;
            this.y = y;
            this.function = function;
        }
    }

    public class RegisterCard {
        public GeneralPath shape = null;
        public GeneralPath meanShape = null;
    }
}

