/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkChangeRegistry;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.factory.FwkDescriptionFactory;
import com.highqsoft.interfaces.fwk.FwkAppearanceInterface;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.p2d.P2DBackgroundInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DComponentControlInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DComponentModelInterface;
import com.highqsoft.interfaces.p2d.P2DComponentViewInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DControlInterface;
import com.highqsoft.interfaces.p2d.P2DFrameInterface;
import com.highqsoft.interfaces.p2d.P2DModelInterface;
import com.highqsoft.interfaces.p2d.P2DViewInterface;
import com.highqsoft.p2d.P2D;
import com.highqsoft.p2d.P2DBoundingBox;
import com.highqsoft.p2d.P2DComponentConsumer;
import com.highqsoft.p2d.P2DComponentProducer;
import com.highqsoft.p2d.P2DContainer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import javax.infobus.InfoBusEventListener;

public class P2DComponent
extends P2DContainer
implements P2DComponentInterface,
P2DComponentModelInterface,
P2DComponentViewInterface,
P2DComponentControlInterface {
    public static final String version = "$Revision: 1.4 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    protected P2DModelInterface model;
    protected P2DViewInterface view;
    protected P2DControlInterface control;
    protected int registerCounter;
    protected boolean mouseIsInside;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return FwkDescriptionFactory.getDescriptor((Class)P2DComponent.class, (FwkDescriptionInterface)descriptor);
    }

    public boolean isMVCValid() {
        return this.model != null && this.view != null && this.control != null;
    }

    public void initialize() {
        this.registerCounter = 0;
        this.mouseIsInside = false;
        this.setMemberName("Component[" + this.hashCode() + "]@" + P2D.BUSNAME);
        this.setProperty("ModelClassId", "P2DComponentModelId");
        this.setProperty("ViewClassId", "P2DComponentViewId");
        this.setProperty("ControlClassId", "P2DComponentControlId");
    }

    public void setMemberName(String memberName) {
        if (memberName.indexOf(64) < 0) {
            memberName = memberName + "@" + P2D.BUSNAME;
        }
        super.setMemberName(memberName);
    }

    public void paint(Graphics2D g2) {
        this.paint(null, g2);
    }

    public void paint(P2DContainerInterface container, Graphics2D g) {
        this.view.paint(this, container, g);
    }

    public void unregisterContainer(P2DContainerInterface container) {
        if (this.model != null) {
            this.model.unregisterContainer(this, container);
        }
    }

    public void registerContainer(P2DContainerInterface container, Graphics2D g) {
        this.model.registerContainer(this, container, g);
    }

    public AffineTransform getTransform(P2DContainerInterface container) {
        return this.model.getTransform(this, container);
    }

    public void setTransform(P2DContainerInterface container, AffineTransform trans) {
        this.model.setTransform(this, container, trans);
    }

    public Point2D transformPoint(P2DContainerInterface container, Point2D p) {
        return this.model.transformPoint(this, container, p);
    }

    public Point2D transformPoint(Point2D p) {
        return this.model.transformPoint(this, p);
    }

    public AffineTransform getTransform() {
        P2DBoundingBoxInterface bb = this.model.getBoundingBox(this);
        return bb.getTransform();
    }

    public void setActive(P2DContainerInterface container, boolean flag) {
        if (flag) {
            this.active.put(container, this);
        } else {
            this.active.remove(container);
        }
        if (this.model != null) {
            this.model.setActive(this, container, flag);
        }
    }

    public boolean getActive(P2DContainerInterface container) {
        Object aComp = this.active.get(container);
        return aComp != null && this.model.getActive(this, container);
    }

    public boolean hasActiveChild(P2DContainerInterface container) {
        return this.model.hasActiveChild(this, container);
    }

    public boolean isInside(P2DComponentInterface child, Point2D p) {
        return this.model.isInside((P2DComponentInterface)this, child, p);
    }

    public boolean isInside(P2DComponentInterface child, P2DBoundingBoxInterface box) {
        return this.model.isInside((P2DComponentInterface)this, child, box);
    }

    public boolean containsAllChildren(Point2D lower, Point2D upper) {
        return this.model.containsAllChildren(this, lower, upper);
    }

    public boolean containsAllChildren(P2DBoundingBoxInterface box) {
        return this.model.containsAllChildren(this, box);
    }

    public void register() {
        ++this.registerCounter;
    }

    protected void register(DataFlavor[] dataFlavors) {
        this.register();
        if (this.registerCounter == 1) {
            P2DComponentProducer.getInstanceByName(this.getInfoBusName()).addComponent(this, dataFlavors);
        }
    }

    public int getRegisterCounter() {
        return this.registerCounter;
    }

    public void unregister() {
        this.unregister(false);
    }

    public void unregister(boolean flag) {
        this.registerCounter = this.registerCounter > 0 ? --this.registerCounter : 0;
        if (this.registerCounter == 1) {
            this.unregister(flag);
        }
        if (this.registerCounter == 0) {
            this.release();
        }
    }

    public void suspendPropertyChangeEvents(boolean flag) {
        super.suspendPropertyChangeEvents(flag);
    }

    public void release() {
        try {
            if (this.registerCounter == 0) {
                P2DComponentProducer.getInstance().removeComponent(this);
                if (this.model != null) {
                    this.model.uninstall(this);
                    this.model = null;
                }
                if (this.view != null) {
                    this.view.uninstall(this);
                    this.view = null;
                }
                if (this.control != null) {
                    this.control.uninstall(this);
                    this.control = null;
                }
                super.release();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void update() {
        this.updateView();
        this.updateModel();
        this.updateControl();
    }

    public InfoBusEventListener getSource() {
        return P2DComponentProducer.getInstance();
    }

    public void updateView() throws FwkException {
        try {
            this.setView(this.loadView());
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: P2DComponent.java,v $", version, "AH 1999-02-10 15:40", "Cannot update view", (Object)this, t);
        }
    }

    public void setView(P2DViewInterface newView) {
        if (this.view != newView) {
            P2DViewInterface oldView = this.view;
            if (this.view != null) {
                this.view.uninstall(this);
            }
            this.view = newView;
            if (newView != null) {
                newView.install(this);
            }
            this.firePropertyChange("View", oldView, newView);
            FwkChangeRegistry.register((Object)this, (String)"View");
        }
    }

    public P2DViewInterface getView() {
        return this.view;
    }

    public String getViewClassId() {
        return (String)this.getProperty("ViewClassId");
    }

    public void setViewClassId(String viewId) {
        String thisViewId = this.getViewClassId();
        if (thisViewId != null) {
            if (viewId.compareTo(thisViewId) != 0) {
                String oldViewId = viewId;
                this.setProperty("ViewClassId", viewId);
                this.firePropertyChange("ViewClassId", oldViewId, viewId);
                FwkChangeRegistry.register((Object)this, (String)"ViewClassId");
            }
        } else {
            this.setProperty("ViewClassId", viewId);
        }
    }

    public P2DViewInterface loadView() throws FwkException {
        P2DViewInterface view;
        String className = FwkPropertyBus.getProperty((String)this.getViewClassId(), (String)null);
        if (className == null) {
            className = this.getViewClassId();
            className = "com.highqsoft.p2d." + className.substring(0, className.length() - 2);
        }
        try {
            view = (P2DViewInterface)FwkContainer.instantiate((String)className, (String)("Cannot load model <" + className + ">"));
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: P2DComponent.java,v $", version, "AH 1999-02-08 14:29", "Cannot load view: " + (className != null ? className : this.getViewClassId()), (Object)this, t);
        }
        return view;
    }

    public void updateModel() throws FwkException {
        try {
            this.setModel(this.loadModel());
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: P2DComponent.java,v $", version, "AH 1999-02-10 15:45", "Cannot update model.", (Object)this, t);
        }
    }

    public void setModel(P2DModelInterface newModel) {
        if (this.model != newModel) {
            P2DModelInterface oldModel = this.model;
            if (this.model != null) {
                this.model.uninstall(this);
            }
            this.model = newModel;
            if (newModel != null) {
                this.model.install(this);
            }
            this.firePropertyChange("Model", oldModel, newModel);
            FwkChangeRegistry.register((Object)this, (String)"Model");
        }
    }

    public P2DModelInterface getModel() {
        return this.model;
    }

    public String getModelClassId() {
        return (String)this.getProperty("ModelClassId");
    }

    public void setModelClassId(String modelId) {
        String thisModelId = this.getModelClassId();
        if (thisModelId != null) {
            if (modelId.compareTo(thisModelId) != 0) {
                String oldModelId = modelId;
                this.setProperty("ModelClassId", modelId);
                this.firePropertyChange("ModelClassId", oldModelId, modelId);
                FwkChangeRegistry.register((Object)this, (String)"ModelClassId");
            }
        } else {
            this.setProperty("ModelClassId", modelId);
        }
    }

    public P2DModelInterface loadModel() throws FwkException {
        P2DModelInterface model = null;
        String className = FwkPropertyBus.getProperty((String)this.getModelClassId(), (String)null);
        if (className == null) {
            className = this.getModelClassId();
            className = "com.highqsoft.p2d." + className.substring(0, className.length() - 2);
        }
        try {
            model = (P2DModelInterface)FwkContainer.instantiate((String)className, (String)("Cannot load model <" + className + ">"));
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: P2DComponent.java,v $", version, "AH 1999-02-08 14:30", "Cannot load model " + (className != null ? className : this.getModelClassId()), (Object)this, t);
        }
        return model;
    }

    public void updateControl() throws FwkException {
        try {
            this.setControl(this.loadControl());
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: P2DComponent.java,v $", version, "AH 1999-02-23 15:11", "Cannot update control", (Object)this, t);
        }
    }

    public void setControl(P2DControlInterface newControl) {
        if (this.control != newControl) {
            P2DControlInterface oldControl = this.control;
            if (this.control != null) {
                this.control.uninstall(this);
            }
            this.control = newControl;
            if (newControl != null) {
                newControl.install(this);
            }
            this.firePropertyChange("Control", oldControl, newControl);
            FwkChangeRegistry.register((Object)this, (String)"Control");
        }
    }

    public P2DControlInterface getControl() {
        FwkContainer.printStackTrace();
        return this.control;
    }

    public String getControlClassId() {
        return (String)this.getProperty("ControlClassId");
    }

    public void setControlClassId(String controlId) {
        String thisControlId = this.getControlClassId();
        if (thisControlId != null) {
            if (controlId.compareTo(thisControlId) != 0) {
                String oldControlId = controlId;
                this.setProperty("ControlClassId", controlId);
                this.firePropertyChange("ControlClassId", oldControlId, controlId);
                FwkChangeRegistry.register((Object)this, (String)"ControlClassId");
            }
        } else {
            this.setProperty("ControlClassId", controlId);
        }
    }

    public P2DControlInterface loadControl() throws FwkException {
        P2DControlInterface control;
        String className = FwkPropertyBus.getProperty((String)this.getControlClassId(), (String)null);
        if (className == null) {
            className = this.getControlClassId();
            className = "com.highqsoft.p2d." + className.substring(0, className.length() - 2);
        }
        try {
            control = (P2DControlInterface)FwkContainer.instantiate((String)className, (String)("Cannot load model <" + className + ">"));
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: P2DComponent.java,v $", version, "AH 1999-02-08 14:29", "Cannot load control " + (className != null ? className : this.getControlClassId()), (Object)this, t);
        }
        return control;
    }

    public void revalidate(boolean recursive) {
        super.revalidate(recursive);
        if (this.model != null) {
            this.model.revalidate(this, recursive);
        } else {
            this.setModel(this.loadModel());
        }
        if (this.view != null) {
            this.view.revalidate(this, recursive);
        } else {
            this.setView(this.loadView());
        }
        if (this.control != null) {
            this.control.revalidate(this, recursive);
        } else {
            this.setControl(this.loadControl());
        }
    }

    public void configure(Graphics2D g) {
        this.model.configure(this, g);
    }

    public P2DBoundingBoxInterface getBoundingBox() {
        if (this.model != null) {
            return this.model.getBoundingBox(this);
        }
        return new P2DBoundingBox();
    }

    public void setBoundingBox(P2DBoundingBoxInterface bb) {
        P2DBoundingBoxInterface old = null;
        if (!(this.model == null || (old = this.model.getBoundingBox(this)) != null && old.equals(bb))) {
            this.model.setBoundingBox(this, bb);
            this.firePropertyChange("BoundingBox", old, bb);
            FwkChangeRegistry.register((Object)this, (String)"BoundingBox");
        }
    }

    public double getWidth() {
        return this.model.getWidth(this);
    }

    public double getHeight() {
        return this.model.getHeight(this);
    }

    public HashMap getDialogPanes() {
        return this.model.getDialogPanes(this);
    }

    public FwkDialogPaneInterface getDialogPane(String ident) {
        return this.model.getDialogPane(this, ident);
    }

    public void addDialogPane(FwkDialogPaneInterface pane, String ident) {
        this.model.addDialogPane(this, pane, ident);
    }

    public void removeDialogPane(String ident) {
        this.model.removeDialogPane(this, ident);
    }

    public HashMap getDialogPaneValues() {
        return this.model.getDialogPaneValues(this);
    }

    public void setDialogPaneValues(HashMap values) {
        HashMap old = this.model.getDialogPaneValues(this);
        this.model.setDialogPaneValues(this, values);
        this.firePropertyChange("DialogPaneValues", old, values);
    }

    public FwkDialogPaneValueInterface getDialogPaneValue(String ident) {
        return this.model.getDialogPaneValue(this, ident);
    }

    public void resetActiveHandle() {
        this.model.resetActiveHandle(this);
    }

    public int getActiveHandle() {
        return this.model.getActiveHandle(this);
    }

    public P2DBoundingBoxInterface calculateBoundingBoxRelativeTo(P2DBoundingBoxInterface bb, Point2D p) {
        return this.model.calculateBoundingBoxRelativeTo(this, bb, p);
    }

    public void setClip(double x, double y, double width, double height) {
        this.setClip(new Rectangle2D.Double(x, y, width, height));
    }

    public void setClip(Shape clip) {
        FwkAppearanceInterface ap = this.model.getAppearance(this);
        Shape old = ap.getClip();
        ap.setClip(clip);
        this.firePropertyChange("Clip", old, clip);
        FwkChangeRegistry.register((Object)this, (String)"Clip");
    }

    public Shape getClip() {
        return this.model.getAppearance(this).getClip();
    }

    public void setStroke(Stroke s) {
        Stroke old = this.model.getAppearance(this).getStroke();
        this.model.getAppearance(this).setStroke(s);
        this.firePropertyChange("Stroke", old, s);
        FwkChangeRegistry.register((Object)this, (String)"Stroke");
        this.repaint();
    }

    public Stroke getStroke() {
        return this.model.getAppearance(this).getStroke();
    }

    public void setFill(Shape s) {
        Shape old = this.model.getAppearance(this).getFill();
        this.model.getAppearance(this).setFill(s);
        this.firePropertyChange("Fill", old, s);
        FwkChangeRegistry.register((Object)this, (String)"Fill");
    }

    public Shape getFill() {
        return this.model.getAppearance(this).getFill();
    }

    public void setAppearance(FwkAppearanceInterface ap) {
        FwkAppearanceInterface old = this.model.getAppearance(this);
        this.model.setAppearance(this, ap);
        this.firePropertyChange("Appearance", old, ap);
        FwkChangeRegistry.register((Object)this, (String)"Appearance");
    }

    public FwkAppearanceInterface getAppearance() {
        return this.model.getAppearance(this);
    }

    public P2DFrameInterface getFrame() {
        return this.model.getFrame(this);
    }

    public void setFrameVisible(boolean flag) {
        Boolean old = new Boolean(this.model.getFrameVisible(this));
        this.model.setFrameVisible(this, flag);
        this.firePropertyChange("FrameVisible", old, new Boolean(flag));
        FwkChangeRegistry.register((Object)this, (String)"FrameVisible");
    }

    public boolean getFrameVisible() {
        return this.model.getFrameVisible(this);
    }

    public void setFrameLinesVisible(boolean flag) {
        Boolean old = new Boolean(this.model.getFrameLinesVisible(this));
        this.model.setFrameLinesVisible(this, flag);
        this.firePropertyChange("FrameLinesVisible", old, new Boolean(flag));
        FwkChangeRegistry.register((Object)this, (String)"FrameLinesVisible");
    }

    public boolean getFrameLinesVisible() {
        return this.model.getFrameLinesVisible(this);
    }

    public void setFrameHandlesVisible(boolean flag) {
        Boolean old = new Boolean(this.model.getFrameHandlesVisible(this));
        this.model.setFrameHandlesVisible(this, flag);
        this.firePropertyChange("FrameHandlesVisible", old, new Boolean(flag));
        FwkChangeRegistry.register((Object)this, (String)"FrameHandlesVisible");
    }

    public boolean getFrameHandlesVisible() {
        return this.model.getFrameHandlesVisible(this);
    }

    public boolean frameHasHandles() {
        return this.model.frameHasHandles(this);
    }

    public Color getFrameColor() {
        return this.model.getFrameColor(this);
    }

    public void setFrameColor(Color color) {
        Color old = this.model.getFrameColor(this);
        this.model.setFrameColor(this, color);
        this.firePropertyChange("FrameColor", old, color);
        FwkChangeRegistry.register((Object)this, (String)"FrameColor");
        if (this.model.getFrame(this).isVisible()) {
            this.repaint();
        }
    }

    public void setFrameTransparency(float transparency) {
        Float old = new Float(this.model.getFrameTransparency(this));
        this.model.setFrameTransparency(this, transparency);
        FwkChangeRegistry.register((Object)this, (String)"FrameTransparency");
        this.firePropertyChange("FrameTransparency", old, new Float(transparency));
    }

    public float getFrameTransparency() {
        return this.model.getFrameTransparency(this);
    }

    public boolean getBackgroundVisible() {
        return this.model.getBackgroundVisible(this);
    }

    public void setBackgroundVisible(boolean flag) {
        Boolean old = new Boolean(this.model.getBackgroundVisible(this));
        this.model.setBackgroundVisible(this, flag);
        FwkChangeRegistry.register((Object)this, (String)"BackgroundVisible");
        this.firePropertyChange("BackgroundVisible", old, new Boolean(flag));
    }

    public void setBackgroundColor(Color color) {
        Color old = this.model.getBackgroundColor(this);
        this.model.setBackgroundColor(this, color);
        this.firePropertyChange("BackgroundColor", old, color);
        FwkChangeRegistry.register((Object)this, (String)"BackgroundColor");
        this.repaint();
    }

    public Color getBackgroundColor() {
        return this.model.getBackgroundColor(this);
    }

    public void setBackgroundTransparency(float transparency) {
        Float old = new Float(this.model.getBackgroundTransparency(this));
        this.model.setBackgroundTransparency(this, transparency);
        this.firePropertyChange("BackgroundTransparency", old, new Float(transparency));
        FwkChangeRegistry.register((Object)this, (String)"BackgroundTransparency");
    }

    public float getBackgroundTransparency() {
        return this.model.getBackgroundTransparency(this);
    }

    public void setLineWidth(float w) {
        float old = this.model.getAppearance(this).getLineWidth();
        this.model.getAppearance(this).setLineWidth(w);
        this.firePropertyChange("LineWidth", old, w);
        FwkChangeRegistry.register((Object)this, (String)"LineWidth");
        this.repaint();
    }

    public float getLineWidth() {
        return this.model.getAppearance(this).getLineWidth();
    }

    public void setDashArray(float[] arr) {
        float[] old = this.model.getAppearance(this).getDashArray();
        this.model.getAppearance(this).setDashArray(arr);
        this.firePropertyChange("DashArray", old, arr);
        FwkChangeRegistry.register((Object)this, (String)"DashArray");
    }

    public float[] getDashArray() {
        return this.model.getAppearance(this).getDashArray();
    }

    public void setDashPhase(float phase) {
        float old = this.model.getAppearance(this).getDashPhase();
        this.model.getAppearance(this).setDashPhase(phase);
        this.firePropertyChange("DashPhase", old, phase);
        FwkChangeRegistry.register((Object)this, (String)"DashPhase");
    }

    public float getDashPhase() {
        return this.model.getAppearance(this).getDashPhase();
    }

    public void setEndCap(int cap) {
        int old = this.model.getAppearance(this).getEndCap();
        this.model.getAppearance(this).setEndCap(cap);
        this.firePropertyChange("EndCap", old, cap);
        FwkChangeRegistry.register((Object)this, (String)"EndCap");
    }

    public int getEndCap() {
        return this.model.getAppearance(this).getEndCap();
    }

    public void setLineJoin(int join) {
        int old = this.model.getAppearance(this).getLineJoin();
        this.model.getAppearance(this).setLineJoin(join);
        this.firePropertyChange("LineJoin", old, join);
        FwkChangeRegistry.register((Object)this, (String)"LineJoin");
    }

    public int getLineJoin() {
        return this.model.getAppearance(this).getLineJoin();
    }

    public void setMiterLimit(float limit) {
        float old = this.model.getAppearance(this).getMiterLimit();
        this.model.getAppearance(this).setMiterLimit(limit);
        this.firePropertyChange("MiterLimit", old, limit);
        FwkChangeRegistry.register((Object)this, (String)"MiterLimit");
    }

    public float getMiterLimit() {
        return this.model.getAppearance(this).getMiterLimit();
    }

    public Font getFont() {
        return this.model.getAppearance(this).getFont();
    }

    public void setFont(Font newFont) {
        Font old = this.model.getAppearance(this).getFont();
        this.model.getAppearance(this).setFont(newFont);
        this.firePropertyChange("Font", old, newFont);
        FwkChangeRegistry.register((Object)this, (String)"Font");
        this.repaint();
    }

    public void setColor(Color color) throws FwkException {
        Color old = this.model.getAppearance(this).getColor();
        this.model.getAppearance(this).setColor(color);
        this.firePropertyChange("Color", old, color);
        FwkChangeRegistry.register((Object)this, (String)"Color");
        this.repaint();
    }

    public Color getColor() throws FwkException {
        return this.model.getAppearance(this).getColor();
    }

    public void setTransparency(float transparency) {
        Float old = new Float(this.model.getAppearance(this).getTransparency());
        this.model.getAppearance(this).setTransparency(transparency);
        this.firePropertyChange("Transparency", old, new Float(transparency));
        FwkChangeRegistry.register((Object)this, (String)"Transparency");
    }

    public float getTransparency() {
        return this.model.getAppearance(this).getTransparency();
    }

    public boolean isVisible() {
        return this.model.getAppearance(this).isVisible();
    }

    public boolean getVisible() {
        return this.model.getAppearance(this).getVisible();
    }

    public void setVisible(boolean flag) {
        Boolean old = new Boolean(this.model.getAppearance(this).getVisible());
        this.model.getAppearance(this).setVisible(flag);
        this.firePropertyChange("Visible", old, new Boolean(flag));
        FwkChangeRegistry.register((Object)this, (String)"Visible");
    }

    public synchronized void propertyChange(PropertyChangeEvent ev) {
    }

    public void getAllArmedComponents(P2DContainerInterface container, double x, double y, FwkArrayInterface arr) {
        this.model.getAllArmedComponents(this, container, x, y, arr);
    }

    public void getAllArmedComponents(P2DContainerInterface container, Point2D p, FwkArrayInterface arr) {
        this.model.getAllArmedComponents(this, container, p, arr);
    }

    public P2DComponentInterface getChild(Point2D p) {
        return this.model.getChild(this, p);
    }

    public P2DComponentInterface getChild(double x, double y) {
        return this.model.getChild(this, x, y);
    }

    public void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        P2DComponentInterface component = (P2DComponentInterface)this.active.get(e.getSource());
        if (component != null) {
            if (component != this) {
                component.processMouseEvent(e);
            } else {
                this.control.processMouseEvent(this, null, e);
            }
        }
    }

    public void processFocusEvent(FocusEvent e) {
        P2DComponentInterface component = (P2DComponentInterface)this.active.get(e.getSource());
        if (component != null) {
            if (component != this) {
                component.processFocusEvent(e);
            } else {
                this.control.processFocusEvent(this, null, e);
            }
        }
    }

    public FwkCommandInterface[] getCommands() {
        if (this.model != null) {
            return this.model.getCommands(this);
        }
        return new FwkCommandInterface[0];
    }

    public void addCommand(FwkCommandInterface command) {
        this.model.addCommand(command);
    }

    public void addCommand(int index, FwkCommandInterface command) {
        this.model.addCommand(index, command);
    }

    public FwkCommandInterface getCommand(String commandName) {
        return this.model.getCommand(commandName);
    }

    public void removeCommand(FwkCommandInterface command) {
        this.model.removeCommand(command);
    }

    public void setCommands(FwkCommandInterface[] commands) {
        this.model.setCommands(commands);
    }

    public boolean commandsAvailable() {
        return this.model.commandsAvailable();
    }

    public void addToGroup(int index, String groupIdent, String commandName) {
        this.model.addToGroup(index, groupIdent, commandName);
    }

    public void addToGroup(String groupIdent, String commandName) {
        this.model.addToGroup(groupIdent, commandName);
    }

    public void removeFromGroup(String groupIdent, String commandName) {
        this.model.removeFromGroup(groupIdent, commandName);
    }

    public void deleteGroup(String groupIdent) {
        this.model.deleteGroup(groupIdent);
    }

    public FwkCommandInterface[] getGroup(String groupIdent) {
        if (this.model != null) {
            return this.model.getGroup(groupIdent);
        }
        return new FwkCommandInterface[0];
    }

    public boolean groupExists(String groupIdent) {
        return this.model.groupExists(groupIdent);
    }

    public void setRatioFix(boolean flag) {
        boolean old = this.model.getRatioFix(this);
        if (old != flag) {
            this.model.setRatioFix(this, flag);
            this.firePropertyChange("RatioFix", old, flag);
            FwkChangeRegistry.register((Object)this, (String)"RatioFix");
        }
    }

    public boolean getRatioFix() {
        return this.model.getRatioFix(this);
    }

    public P2DBoundingBoxInterface closestIntersection(P2DBoundingBoxInterface[] bounds) {
        return this.model.getBoundingBox(this).closestIntersection(bounds);
    }

    public boolean intersects(P2DBoundingBoxInterface bounds) {
        return this.model.getBoundingBox(this).intersects(bounds);
    }

    public boolean intersects(P2DBoundingBoxInterface[] bounds) {
        return this.model.getBoundingBox(this).intersects(bounds);
    }

    public boolean intersects(P2DBoundingBoxInterface[] bounds, P2DBoundingBoxInterface newBoundBox) {
        return this.model.getBoundingBox(this).intersects(bounds, newBoundBox);
    }

    public boolean intersects(P2DBoundingBoxInterface bounds, P2DBoundingBoxInterface newBoundBox) {
        return this.model.getBoundingBox(this).intersects(bounds, newBoundBox);
    }

    public boolean contains(Point2D p) {
        return this.model.getBoundingBox(this).contains(p);
    }

    public boolean contains(P2DBoundingBoxInterface box) {
        return this.model.getBoundingBox(this).contains(box);
    }

    public void getUpper(Point2D upper) {
        this.model.getBoundingBox(this).getUpper(upper);
    }

    public void setLower(Point2D lower) {
        this.model.getBoundingBox(this).getLower(lower);
    }

    public void setUpper(Point2D upper) {
        this.model.getBoundingBox(this).setUpper(upper);
    }

    public double getArea() {
        return this.model.getBoundingBox(this).getArea();
    }

    public double getScaledWidth() {
        return this.model.getBoundingBox(this).getScaledWidth();
    }

    public double getScaledHeight() {
        return this.model.getBoundingBox(this).getScaledHeight();
    }

    public void setWidth(double width) {
        this.model.getBoundingBox(this).setWidth(width);
    }

    public void setHeight(double height) {
        this.model.getBoundingBox(this).setHeight(height);
    }

    public Rectangle2D getRectangle() {
        return this.model.getBoundingBox(this).getRectangle();
    }

    public void move(double xDiff, double yDiff) {
        this.model.getBoundingBox(this).move(xDiff, yDiff);
    }

    public boolean isInside(P2DBoundingBoxInterface box) {
        return this.model.getBoundingBox(this).isInside(box);
    }

    public void setScale(double xFactor, double yFactor) {
        this.model.getBoundingBox(this).setScale(xFactor, yFactor);
    }

    public void setOffset(double xOffset, double yOffset) {
        this.model.getBoundingBox(this).setOffset(xOffset, yOffset);
    }

    public void setXScale(double offset, double scale) {
        this.model.getBoundingBox(this).setXScale(offset, scale);
    }

    public void setYScale(double offset, double scale) {
        this.model.getBoundingBox(this).setYScale(offset, scale);
    }

    public double getXFactor() {
        return this.model.getBoundingBox(this).getXFactor();
    }

    public double getYFactor() {
        return this.model.getBoundingBox(this).getYFactor();
    }

    public double getXOffset() {
        return this.model.getBoundingBox(this).getXOffset();
    }

    public double getYOffset() {
        return this.model.getBoundingBox(this).getYOffset();
    }

    public AffineTransform getInverseTransform() {
        return this.model.getBoundingBox(this).getInverseTransform();
    }

    public Point2D inverseTransformPoint(Point2D p) {
        return this.model.getBoundingBox(this).inverseTransformPoint(p);
    }

    public void getLower(Point2D lower) {
        this.model.getBoundingBox(this).getLower(lower);
    }

    public Point2D getUpper() {
        return this.model.getBoundingBox(this).getUpper();
    }

    public Point2D getLower() {
        return this.model.getBoundingBox(this).getLower();
    }

    public Point2D getScaledUpper() {
        return this.model.getBoundingBox(this).getScaledUpper();
    }

    public Point2D getScaledLower() {
        return this.model.getBoundingBox(this).getScaledLower();
    }

    public void getScaledUpper(Point2D upper) {
        this.model.getBoundingBox(this).getScaledUpper(upper);
    }

    public void getScaledLower(Point2D lower) {
        this.model.getBoundingBox(this).getScaledLower(lower);
    }

    public void setActiveHandle(int index) {
        this.model.setActiveHandle(this, index);
    }

    public BasicStroke scaleStroke(AffineTransform at) {
        return this.model.scaleStroke(this, at);
    }

    public BasicStroke scaleStroke(AffineTransform at, float lw) {
        return this.model.scaleStroke(this, at, lw);
    }

    public void setTransform(AffineTransform t) {
    }

    public void setTranslation(double x, double y) {
    }

    public Point2D getTranslation() {
        return new Point2D.Double();
    }

    public HashMap getContainerMap() {
        return this.model.getContainerMap(this);
    }

    public void setContainerMap(HashMap map) {
        this.model.setContainerMap(this, map);
    }

    public P2DBackgroundInterface getBackground() {
        return this.model.getBackground(this);
    }

    public boolean isInternalMouseListenerActive() {
        return this.model.isInternalMouseListenerActive(this);
    }

    public void setInternalMouseListenerActive(boolean flag) {
        boolean old = this.model.isInternalMouseListenerActive(this);
        if (old != flag) {
            this.model.setInternalMouseListenerActive(this, flag);
            this.firePropertyChange("InternalMouseListenerActive", old, flag);
            FwkChangeRegistry.register((Object)this, (String)"InternalMouseListenerActive");
        }
    }

    public boolean getInternalMouseListenerActive() {
        return this.model.isInternalMouseListenerActive(this);
    }

    public boolean getSelectable() {
        return super.getSelectable() && this.isInternalMouseListenerActive();
    }

    public void mouseClicked(Point2D p, MouseEvent e) {
        Point2D mp = this.model.getBoundingBox(this).inverseTransformPoint(p);
        this.saveLocalMousePoint(mp);
        this.control.mouseClicked(this, mp, e);
    }

    public void mousePressed(Point2D p, MouseEvent e) {
        Point2D mp = this.model.getBoundingBox(this).inverseTransformPoint(p);
        this.saveLocalMousePoint(mp);
        this.control.mousePressed(this, mp, e);
    }

    public void mouseReleased(Point2D p, MouseEvent e) {
        Point2D mp = this.model.getBoundingBox(this).inverseTransformPoint(p);
        this.saveLocalMousePoint(mp);
        this.control.mouseReleased(this, mp, e);
    }

    public void mouseEntered(Point2D p, MouseEvent e) {
        Point2D mp = this.model.getBoundingBox(this).inverseTransformPoint(p);
        this.saveLocalMousePoint(mp);
        this.control.mouseEntered(this, mp, e);
    }

    public void mouseExited(Point2D p, MouseEvent e) {
        Point2D mp = this.model.getBoundingBox(this).inverseTransformPoint(p);
        this.saveLocalMousePoint(mp);
        this.control.mouseExited(this, mp, e);
    }

    public void mouseMoved(Point2D p, MouseEvent e) {
        P2DBoundingBoxInterface bb = this.model.getBoundingBox(this);
        Point2D mp = bb.inverseTransformPoint(p);
        this.saveLocalMousePoint(mp);
        boolean contains = bb.contains(mp);
        if (contains && !this.mouseIsInside) {
            this.mouseIsInside = true;
            this.control.mouseEntered(this, mp, e);
        } else if (!contains && this.mouseIsInside) {
            this.mouseIsInside = false;
            this.control.mouseExited(this, mp, e);
        }
        this.control.mouseMoved(this, mp, e);
    }

    public void mouseDragged(Point2D p, MouseEvent e) {
        Point2D mp = this.model.getBoundingBox(this).inverseTransformPoint(p);
        this.saveLocalMousePoint(mp);
        this.control.mouseDragged(this, mp, e);
    }

    public void focusGained(Point2D p, FocusEvent e) {
        Point2D mp = this.model.getBoundingBox(this).inverseTransformPoint(p);
        this.saveLocalMousePoint(mp);
        this.control.focusGained(this, mp, e);
    }

    public void focusLost(Point2D p, FocusEvent e) {
        Point2D mp = this.model.getBoundingBox(this).inverseTransformPoint(p);
        this.saveLocalMousePoint(mp);
        this.control.focusLost(this, mp, e);
    }

    public String askForName(Container parent, String title, String defaultValue) {
        return this.control.askForName(parent, this, title, defaultValue);
    }

    public boolean openPopupMenu(MouseEvent ev) {
        if (!super.openPopupMenu(ev)) {
            return this.control.openPopupMenu(this, ev);
        }
        return true;
    }

    public String getShortName() {
        return this.model.getShortName(this);
    }

    public void setName(String name) {
        boolean found = true;
        String usedName = name;
        int counter = 1;
        while (found) {
            P2DComponentInterface obj = P2DComponentConsumer.getInstanceByName(this.getInfoBusName()).findComponent(usedName);
            found = obj != null;
            if (!found) continue;
            if (!obj.equals(this)) {
                usedName = name + "_" + counter;
                ++counter;
                continue;
            }
            found = false;
        }
        super.setName(usedName);
    }

    public void saveLocalMousePoint(Point2D p) {
        this.localMousePoint = new Point2D.Double(p.getX(), p.getY());
    }

    public Point2D restoreLocalMousePoint() {
        return this.localMousePoint;
    }

    public boolean boundsAcceptable(Point2D lower, Point2D upper) {
        return this.model.boundsAcceptable(this, lower, upper);
    }

    public void setDecorated(boolean flag) {
        boolean old = this.model.getDecorated(this);
        if (old != flag) {
            this.model.setDecorated(this, flag);
            this.firePropertyChange("Decorated", old, flag);
            FwkChangeRegistry.register((Object)this, (String)"Decorated");
        }
    }

    public boolean getDecorated() {
        return this.model.getDecorated(this);
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("The P2D component");
        descriptor.setTitleName("P2DComponent.Text.Title");
        descriptor.setName(P2DComponent.class.getName());
        descriptor.setIconKey("Icon.P2DComponent");
        descriptor.setCreationDate("$Date: 2005/02/03 14:51:12 $", null);
    }
}

