/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.p2d;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkInfoBusConsumer;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.p2d.P2D;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataConsumer;
import javax.infobus.InfoBusItemAvailableEvent;
import javax.infobus.InfoBusItemRevokedEvent;

public class P2DComponentConsumer
extends FwkInfoBusConsumer {
    public static final String version = "$Revision: 1.3 $";
    protected static HashMap consumerMap = new HashMap();

    public String getVersion() {
        return version;
    }

    private P2DComponentConsumer() {
        this(P2D.BUSNAME);
    }

    private P2DComponentConsumer(String busName) {
        super("P2DComponentConsumer@" + busName, FwkContainer.getMimeTypes((Class)P2DComponentInterface.class));
    }

    public static P2DComponentConsumer getInstance() {
        return P2DComponentConsumer.getInstanceByName(P2D.BUSNAME);
    }

    public static P2DComponentConsumer getInstanceByName(String busName) {
        P2DComponentConsumer ret = null;
        if (busName == null) {
            ret = P2DComponentConsumer.getInstance();
        } else {
            ret = (P2DComponentConsumer)((Object)consumerMap.get(busName));
            if (ret == null) {
                ret = new P2DComponentConsumer(busName);
                consumerMap.put(busName, ret);
            }
        }
        return ret;
    }

    public static void removeInstance(String busName) {
        consumerMap.remove(busName);
    }

    public P2DComponentInterface findComponent(String dataItemName) {
        return this.findComponent(dataItemName, FwkContainer.getDataFlavor((Class)P2DComponentInterface.class));
    }

    public P2DComponentInterface findComponent(String dataItemName, DataFlavor[] flavors) {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            return (P2DComponentInterface)ib.findDataItem(dataItemName, flavors, (InfoBusDataConsumer)this);
        }
        return null;
    }

    public Object[] findMultipleComponents(String pattern, DataFlavor[] flavors) {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            Object[] list = ib.findMultipleDataItems(pattern, flavors, (InfoBusDataConsumer)this);
            if (list != null) {
                Vector<Object> vec = new Vector<Object>();
                int lSize = list.length;
                for (int i = 0; i < lSize; ++i) {
                    if (list[i] instanceof Object[]) {
                        Object[] arr = (Object[])list[i];
                        int kSize = arr.length;
                        for (int k = 0; k < kSize; ++k) {
                            vec.add(arr[k]);
                        }
                        continue;
                    }
                    vec.add(list[i]);
                }
                return vec.toArray();
            }
            return null;
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        this.firePropertyChange(ev);
    }

    public void dataItemAvailable(InfoBusItemAvailableEvent ev) {
        this.firePropertyChange("DataItemAvailable", null, ev.getDataItemName());
    }

    public void dataItemRevoked(InfoBusItemRevokedEvent ev) {
        this.firePropertyChange("DataItemRevoked", ev.getDataItemName(), null);
    }
}

